!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORNPC_MapKnown	[Z, GLULX]
! For NPCs that know their surroundings.  Decreases the likelyhood that the NPC will
! become "lost" and have to "wander".
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	ORPathMaker
!			ORNPC_Movement
!			ORObjectInitialise
!--------------------------------------------------------------------------------------
! NPComPri: 15 (NPC Componant Priority) 
! The lower the number, the further down the "class" line.  The greater the number, 
! the earlier it needs to come on the class line. Modules with the same priority can
! effectively be exchanged in order without effect.
!--------------------------------------------------------------------------------------
! This NPC componant class modifies the behavior of ORNPC_movement.  It is required 
! that NPCs which derive from this class also derive from ORNPC_movement.
!
! What does this module do?
! The ORNPC_movement class allows NPCs to follow a path.  There are requirements to this 
! path such as the rooms in the path need to be contiguous.  If the NPC ever arrives in 
! a room which is not adjacent to the next room in his path, the NPC can become "lost" 
! and wander around until he "recognizes" his location (wanders into a location that 
! appears in his path).  
!
! This module removes the need for rooms in the path to be contiguous. It leverages the
! ORPathMaker module to generate the shortest path between the NPC's current location
! and target location thereby enabling the NPC to arrive at his path and never wander
! around lost (assuming the destination is actually reachable and falls within the 
! limitations of the ORPathMaker object.)
!
! Other than adding the ORNPC_MapKnown class to the NPC's inheritence chain (and 
! prerequisits) no additional code need be implemented to make this functionality occur.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORNPC_MapKnown";					!Constant USE_ORNPC_MapKnown; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORNPC_MapKnown; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.09	Initial Creation
! 2002.02.26	Fit to new template
!--------------------------------------------------------------------------------------
#ifdef USE_ORNPC_MapKnown;message "          Processing library extension ORNPC_MapKnown...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORPathMaker; Constant USE_ORPathMaker; message "          ****Forcing inclusion of ORPathMaker****"; #include "ORPathMaker"; #endif; 
	#ifndef USE_ORNPC_Movement; Constant USE_ORNPC_Movement; message "          ****Forcing inclusion of ORNPC_Movement****"; #include "ORNPC_Movement"; #endif; 
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORNPC_MapKnown_DONEREPLACE; constant ORNPC_MapKnown_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORNPC_MapKnown_DONEMESSAGE; constant ORNPC_MapKnown_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORNPC_MapKnown requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORNPC_MapKnown_DONECODE;constant ORNPC_MapKnown_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	class ORNPC_MapKnown
		with missing_path[t; 
				self.path_ptr=self.path_ptr-self.path_ptr_inc;	!-- adjust pointer back to previous position
				t=self.&path-->(self.path_ptr);	
				t=ORPathMaker.Determine_Path(self,t);
				if(t>0){
					t=self.ajoining_room_to_direction(t);	
					return self.move_to(t); !-- found a way to the needed path, so DO NOT adjust pointer back again
				}
				self.path_ptr=self.path_ptr-self.path_ptr_inc;	!-- adjust pointer back to previous position
				return self.ORNPC_movement::missing_path(); !--do old stuff
			]
	,		object_initialise[; 
#ifdef DEBUG;
				if((self ofclass ORNPC_movement)==false) print "^[ERROR: ORNPC_MapKnown behavior requires ORNPC_movement behavior.]^";
#endif;
				rfalse;
			]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORNPC_MapKnown_DONEGRAMMAR; constant ORNPC_MapKnown_DONEGRAMMAR; #ifdef ORNPC_MapKnown_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;