!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.09.02 ORKnowledgeWeb [Z, GLULX]
! Used to create a network of interrelating knowledge topics
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! Derivitived from ORKnowledgeTopic, this class has the added support for NPCs
! which maintain an OptionList for possible conversation topics.
!--------------------------------------------------------------------------------------
! AutoDep:	ORKnowledgeTopic
!			OROptionList
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORKnowledgeWeb";					!Constant USE_ORKnowledgeWeb; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORKnowledgeWeb; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.03.23	Initial Creation
! 2002.03.31	Split out NPC class into its own module.
! 2002.04.03	Setup to leverage OROptionList 
! 2002.04.09	Added code to eliminate old topics if running out of room
! 2002.04.14	Fixed issue caused by .h removal.
! 2002.04.15	Fixed incorrect algorithm for adding topics
! 2002.04.17	Removed unused variable from TellAbout routine (and the associated warning)
! 2002.05.01	Modified comments.
! 2002.07.15	Modified the mechanism in which "asking" in stored.  Previously the "associations"
!				of an entry was "true" if the topic needed to be "asked" and "false" it it needed
!				to be "told". Now, "asked" topics are stored as negative numbers and "told" topics
!				are stored as positive one.  the actual number is the turn in which the topic was 
!				added, allowing more recent topics to be given greater priority.
! 2002.08.23	Fixed bug related to NPC's being talked to are present
!				but not in the same location (e.g. sitting on a chair)
! 2002.09.02	Converted attributes previously defined in this module to properties.
!--------------------------------------------------------------------------------------
#ifdef USE_ORKnowledgeWeb;message "          Processing library extension ORKnowledgeWeb...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include--- 
#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORDynaString; Constant USE_ORDynaString; message "          ****Forcing inclusion of ORDynaString****"; #include "ORDynaString"; #endif; 
	#ifndef USE_ORKnowledgeTopic; Constant USE_ORKnowledgeTopic; message "          ****Forcing inclusion of ORKnowledgeTopic****"; #include "ORKnowledgeTopic"; #endif; 
	#ifndef USE_OROptionList; Constant USE_OROptionList; message "          ****Forcing inclusion of OROptionList****"; #include "OROptionList"; #endif;   
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORKnowledgeWeb_DONEREPLACE; constant ORKnowledgeWeb_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORKnowledgeWeb_DONEMESSAGE; constant ORKnowledgeWeb_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORKnowledgeWeb requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class ORKnowledgeWeb
		class ORKnowledgeTopic
		with TellAbout[to from forcetellagain t rt o;
				!--clear all topics if needed
				if(valueorrun(self,ResetOptionList)==true){
					objectloop(o provides ClearOptionList && testscope(o,from) ) {
						if(valueorrun(self, nonspecifictarget)==true || o==from or to){ 
							o.ClearOptionList();
						}
					}
				}
				!--clear this specific topic
				objectloop(o provides removeoption && testscope(o,from) ) {
					if(((valueorrun(self,nonspecifictarget)==true) ) || o==from or to)
						o.removeoption(self);
				}
				!--add all related topics
				for(t=0:t<self.#RelatedTopics/WORDSIZE:t++){ !--for each related topic that the listener might think to ask
					rt=self.&RelatedTopics-->t;
					if(rt==0) continue;
					objectloop(o provides PushOption && testscope(o,from) ){
						if(((valueorrun(self,nonspecifictarget)==true) ) || o==from or to) {
							!--something to say?
							if(rt.IsKnownBy(o)==true && rt.hasBeenSpokenOfBy(o)==false && ((rt provides response)==false || valueorrun(rt,response)==false)){
								self.addtopic(o,rt,false); !--add as something to say
							}
							!--something to ask?
							if(rt.IsKnownBy(o)==false && rt provides query){
								self.addtopic(o,rt,true); !--add as something to ask
							}
						}
					}
				}
				self.ORKnowledgeTopic::TellAbout(to,from,forcetellagain);
			]
		,	AskAbout[askwho askby o;
				objectloop(o && testscope(o,askby) ){
					if(((valueorrun(self,nonspecifictarget)==true) ) || o==askwho){
						if(self.isknownby(o)==true && o provides PushOption && o~=askby) 
							o.PushOption(self,turns);					
					}
				}
				self.ORKnowledgeTopic::AskAbout(askwho,askby);
			]
		,	addtopic[po rt altval adj;
				if(rt==0)rt=self;
				adj=turns;
				if(altval==true) adj=adj*-1;
				if(po~=0){
					if(po.PushOption(rt,adj)==false){ !--generally adding an option fails because of a lack of room
						po.RemoveOptionByNumber(0); !--lets forget about older topics
						po.PushOption(rt,adj); !--and try to add it again
					}
				}
			]
		,	RelatedTopics
		,	Response false !--npc will not talk of this topic unless asked about it
		,	ResetOptionList false
		,	NonSpecificTarget false !--this topic effects everyone present, not just the character being talkied to
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORKnowledgeWeb_DONECODE;constant ORKnowledgeWeb_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORKnowledgeWeb_DONEGRAMMAR; constant ORKnowledgeWeb_DONEGRAMMAR; #ifdef ORKnowledgeWeb_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;