!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORDoor	[Z, GLULX]
!	This is a generic door.  It simply eases coding for the developer by utilizing generic 
!	reusable code for the door_to, door_dir properties.  In order use an object derived from
!	the ORDoor class, simply define it with the "found_in" property listing both rooms
!	that the door appears in.  Also reference the door in the direction definitions (as would
!	normally be done)																						 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	none
!--------------------------------------------------------------------------------------
!
!	sample conventional code:
!
!		Object RedDoor "red door"
!			 with	name "door" "red"
!			 ,     door_dir 
!					[; 
!						if (location == LivingRoom) 
!							return n_to; 
!						else
!							return s_to;
!					]
!	        ,     door_to 
!					[; 
!						if (location == LivingRoom) 
!							return DiningRoom; 
!						else 
!							return LivingRoom;
!					]
!	        ,     found_in LivingRoom DiningRoom
!			has openable door static scenery;
!
!	sample new code:
!
!		ORDoor RedDoor "red door"
!			with	name "door" "red"
!			,		found_in	LivingRoom DiningRoom ;
!
! Note that leveraging the ORDoorInit module eliminates the need to specify the 
! "found_in" property and the ORRecogName module eliminates the need to specify the 
! "name" property.  By including these modules, creating a working functional door 
! literally becomes one line of generic code:
!
!		ORDoor RedDoor "red door";
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORDoor";					!Constant USE_ORDoor; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORDoor; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2001.04.20	Initial Creation
! 2001.05.10	Made modifications to the door to look at the current actor's location
!				rather than player's location. This will make the doors work for NPCs as well.
! 2002.02.02	Made modification to default an empty found_in property for the benifit of 
!				programatic initialization.
! 2002.02.26	Fit to new template
!--------------------------------------------------------------------------------------
#ifdef USE_ORDoor;message "          Processing library extension ORDoor...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORDoor_DONEREPLACE; constant ORDoor_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORDoor_DONEMESSAGE; constant ORDoor_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORDoor requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	system_file;

	class ORDoor
		has static door openable scenery
		with	door_to 
				[;
					if((self.&found_in-->0)==parent(actor)) return self.&found_in-->1;
					return self.&found_in-->0;
				]
		,		door_dir
				[;
					if(parent(actor) provides n_to && parent(actor).n_to==self) return n_to;
					if(parent(actor) provides s_to && parent(actor).s_to==self) return s_to;
					if(parent(actor) provides e_to && parent(actor).e_to==self) return e_to;
					if(parent(actor) provides w_to && parent(actor).w_to==self) return w_to;
					if(parent(actor) provides ne_to && parent(actor).ne_to==self) return ne_to;
					if(parent(actor) provides se_to && parent(actor).se_to==self) return se_to;
					if(parent(actor) provides nw_to && parent(actor).nw_to==self) return nw_to;
					if(parent(actor) provides sw_to && parent(actor).sw_to==self) return sw_to;
					if(parent(actor) provides u_to && parent(actor).u_to==self) return u_to;
					if(parent(actor) provides d_to && parent(actor).d_to==self) return d_to;
					return self;
				]
		,		found_in 0 0
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORDoor_DONECODE;constant ORDoor_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORDoor_DONEGRAMMAR; constant ORDoor_DONEGRAMMAR; #ifdef ORDoor_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;