/* infocom.h
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef INFOCOM_H
#define INFOCOM_H

#ifdef ALPHALOCK
#define MIN_AMS 200
#endif

#ifndef CONTEXT
#define CONTEXT 2
#endif

#ifndef MAX_PAGE_ENTRIES
#define MAX_PAGE_ENTRIES    15 /* valeur maximale ( cause de la limitation des blocs  64k).
				  Plus c'est beaucoup plus le prg. utilise
				  de mmoire et moins il charge souvent depuis le fichier. */
#endif

#ifndef JEU_PAR_DEFAUT
#define JEU_PAR_DEFAUT "zork"
#endif

#ifndef FRENCH
#define FRENCH FALSE
#endif

#ifndef NO_V4_SUPPORT
#define VERSION_QUATRE
#endif

#ifdef VERSION_CINQ
#define VERSION_QUATRE
#define PLUS (data_head.z_version == 4)
#define ADVANCED (data_head.z_version == 5)
#else
#define ADVANCED FALSE
#define PLUS ENHANCED
#endif
#ifndef VERSION_QUATRE
#define ENHANCED FALSE
#else
#ifdef PAS_VERSION_TROIS
#define ENHANCED TRUE
#else
#define ENHANCED (data_head.z_version > 3)
#endif
#endif
#define STANDARD (!ENHANCED)

#include <stdlib.h>

/*
 * Universal Type Definitions.
 *
 *  'byte'                  - 8 bits       ; unsigned.
 *  'word'                  - 16 bits      ; unsigned.
 *  'signed_word'           - 16 bits      ; signed.
 *  'long_word'             - 32 bits      ; signed.
 */

typedef unsigned char byte;
typedef unsigned short word;
typedef signed short signed_word;

/*
 * Constants
 */

#define         LOCAL_VARS              0x10
/* #define         STACK_SIZE              0x0200 */
/* D'aprs les spcifs de la Z-machine la pile devrait faire 1k. On n'est quand mme pas 
   512 octets prs... */
#define         STACK_SIZE              0x400
/* #define         BLOCK_SIZE              0x0200 */
/* Comme les blocs sont compresss sparment il ne faut pas qu'ils soient trop petits
   (sinon le taux de compression devient pourri). 4k me semble un bon compromis.
   Si on change BLOCK_SIZE ne pas oublier de modifier les macros avec des << et >> plus bas
   ainsi que gosub dans jump.c et print2 dans print.c, et changer aussi decoupe.c
*/
#define         BLOCK_SIZE              0x1000

/*
 * Game State Codes
 */

#define         QUIT_GAME               0x00
#define         NOT_INIT                0x01
#define         INIT_GAME               0x02
#define         PLAY_GAME               0x03
#define         LOAD_GAME               0x04

/*
 * ANSI C compatibility stuff
 */

#if defined(__STDC__) || defined(__TURBOC__)

typedef void *  ptr_t;
#define P(s)    s

#define A1(t,v) (t v)
#define A2(t1,v1,t2,v2) \
                (t1 v1,t2 v2)
#define A3(t1,v1,t2,v2,t3,v3) \
                (t1 v1,t2 v2,t3 v3)
#define A4(t1,v1,t2,v2,t3,v3,t4,v4) \
                (t1 v1,t2 v2,t3 v3,t4 v4)
#define A5(t1,v1,t2,v2,t3,v3,t4,v4,t5,v5) \
                (t1 v1,t2 v2,t3 v3,t4 v4,t5 v5)
#define A6(t1,v1,t2,v2,t3,v3,t4,v4,t5,v5,t6,v6) \
                (t1 v1,t2 v2,t3 v3,t4 v4,t5 v5,t6 v6)

#else

typedef char *  ptr_t;

#if !defined(sun)
#define void    int
#endif

#define const
#define P(s)    ()

#define A1(t,v) (v) t v;
#define A2(t1,v1,t2,v2) \
                (v1,v2)t1 v1;t2 v2;
#define A3(t1,v1,t2,v2,t3,v3) \
                (v1,v2,v3)t1 v1;t2 v2;t3 v3;
#define A4(t1,v1,t2,v2,t3,v3,t4,v4) \
                (v1,v2,v3,v4)t1 v1;t2 v2;t3 v3;t4 v4;
#define A5(t1,v1,t2,v2,t3,v3,t4,v4,t5,v5) \
                (v1,v2,v3,v4,v5)t1 v1;t2 v2;t3 v3;t4 v4;t5 v5;
#define A6(t1,v1,t2,v2,t3,v3,t4,v4,t5,v5,t6,v6) \
                (v1,v2,v3,v4,v5,v6)t1 v1;t2 v2;t3 v3;t4 v4;t5 v5;t6 v6;

#endif

/*
 * Bitfield Macros:
 *
 * These macros modify the flag bits; they should be used instead of
 * direct bit-twiddling for the header flags fields.  They may only be
 * used after init() has been called.
 */
#define F1_IS_SET(_b)   (base_ptr[1]&(_b))
#define F1_SETB(_b)     (base_ptr[1]|=(_b))
#define F1_RESETB(_b)   (base_ptr[1]&=(~(_b)))

#define F2_IS_SET(_b)   (base_ptr[17]&(_b))
#define F2_SETB(_b)     (base_ptr[17]|=(_b))
#define F2_RESETB(_b)   (base_ptr[17]&=(~(_b)))

/* Tiens j'en rajoute une */
#define F1_CHANGEB(_b)  (base_ptr[1]^=(_b))
#define F2_CHANGEB(_b)  (base_ptr[17]^=(_b))
/* sais pas pourquoi elle n'y tait pas... */

/*
 * These are possible bits to be examine in header.flags_1:
 */
#define B_COLOUR        (0x01)              /* Colour available ? (V5)*/
#define B_USE_TIME      (0x02)              /* 0 -> score 1 -> time -- readonly */
#define B_BOLD          (0x04)              /* Boldface available ? (V4) */
#define B_TANDY         (0x08)              /* V3 only */
#define B_ITALIC        (0x08)              /* Italic available ? (V4) */
#define B_ALT_PROMPT    (0x10)              /* if statusbar not available (V3) */
#define B_STATUS_WIN    (0x20)              /* screen splitting available ?*/
#define B_VARIABLE_FONT (0x40)              /* is default font variable width ? */
#define B_TIMED_INPUT   (0x80)              /* timed input available ? (V4) */

/*
 * These are possible bits to examine in header.flags_2:
 */
#define B_SCRIPTING     (0x01)
#define B_FIXED_FONT    (0x02)
#define B_PICTURES      (0x08) /* V5 */
#define B_UNDO          (0x10) /* V5 */
#define B_MOUSE         (0x20) /* V5 */
#define B_SOUND         (0x80) /* V5 */


/*
 * Conversion Macros:
 *
 * These macros convert from data file info into the current machine's
 * byte order, etc.
 */
#define Z_TO_BYTE(_p)   ((byte)((_p)[0]))
#define Z_TO_WORD(_p)   ((word)((((_p)[0])<<8)|((_p)[1])))

#define Z_TO_BYTE_I(_p) ((byte)(*(_p++)))
#define Z_TO_WORD_I(_p) ((_p)+=2,((word)(((_p)[-2])<<8)|((_p)[-1])))

/*
 * Speed Macros:
 *
 * These macro-ize certain bottlenecks (discovered using the UNIX
 * utility prof(1)).  Use NEXT_BYTE() like a function returning void.
 */
#define NEXT_BYTE(_v) do{ (_v)=prog_block_ptr[pc_offset++];\
                          if(pc_offset & BLOCK_SIZE)fix_pc(); }while (0)

/*
 * Type Definitions
 */

typedef int     Bool;
typedef byte    *property;

/*
 * Global Flags Structure
 *
 * Contains flags and other information used globally by both the
 * interpreter and the terminal interface.
 */
typedef struct gflags
{
  int         game_state;                 /* Game state */
} gflags_t;

typedef struct object
{
    byte    attributes[4];
    byte    parent;
    byte    sibling;
    byte    child;
    byte    data[2];
} object_t;

typedef struct eobject
{
    byte    attributes[6];
    word    parent;
    word    sibling;
    word    child;
    byte    data[2];
} eobject_t;

/*
 * Print Buffer Structure
 *
 *  buf     Points to the buffer to be filled in
 *  len     Current length of filled-in data
 *  max     The maximum size of the buffer (not including the nul char)
 */
typedef struct print_buf
{
    byte    *buf;
    int     len;
    int     max;
} print_buf_t;

/*
 * Infocom Game Header Structure
 *
 *  The 'z_version' byte has the following meaning:
 *      00 : Game compiled for an early version of the interpreter
 *      01 : Game compiled for an early version of the interpreter
 *      02 : Game compiled for an early version of the interpreter
 *      03 : Standard Series Interpreter
 *      04 : Plus Series Interpreter
 *      05 : Solid Gold Interactive Fiction
 *      06 : Graphic Interactive Fiction
 *
 *  The 'flags_1' byte contains the following information:
 *      Bit #   Usage                   CLEAR       SET
 *      -----   ---------------------   -----       -----
 *        0     Colour display          NO          YES
 *        1     Status Bar display      SCORE       TIME
 *        2     Screen splitting        NO          YES
 *        5     Save file indicator      ??          ??
 *
 *  The 'flags_2' word is used by Z-CODE to set printing modes
 *  for use by the interpreter:
 *      Bit #   Usage                   CLEAR       SET
 *      -----   ---------------------   -----       -----
 *       0      Script mode             OFF         ON
 *       1      Font type               -any-       fixed-width
 *       4      Sound                   NO          YES
 */

typedef struct header
{
        byte    z_version;              /* Game's Z-CODE Version Number    */
        byte    flags_1;                /* Status indicator flags          */
        word    release;                /* Game Release Number             */
        word    resident_bytes;         /* No. bytes in the Resident Area  */
        word    game_o;                 /* Offset to Start of Game         */
        word    vocab_o;                /* Offset to Vocab List            */
        word    object_o;               /* Offset to Object/Room List      */
        word    variable_o;             /* Offset to Global Variables      */
        word    save_bytes;             /* No. bytes in the Save Game Area */
        word    flags_2;                /* Z-CODE printing modes           */
        char    serial_no[6];           /* Game's Serial Number            */
        word    common_word_o;          /* Offset to Common Word List      */
        word    verify_length;          /* No. words in the Game File      */
/* N.B. : en versions 4-5 c'est le nb. de mots longs (32-bit) et en V.6 encore deux fois moins */
        word    verify_checksum;        /* Game Checksum - used by Verify  */
        byte    interpreter_number;     /* V4 */
        byte    interpreter_version;    /* V4 */
        byte    screen_rows;            /* V4 */
        byte    screen_cols;            /* V4 */
        word    screen_width;           /* V5 */
        word    screen_height;          /* V5 */
        byte    font_width;             /* V5 -> width of '0' ; V6 -> font HEIGHT */
        byte    font_height;            /* V5 -> font height ; V6 -> width of '0' */
        word    routine_o;              /* V6 */
        word    string_o;               /* V6 */
        byte    default_bg_colour;      /* V5 */
        byte    default_fg_colour;      /* V5 */
        word    terminating_char_o;     /* V5 */
        word    line_width;             /* V6 */
        word    z_standard_revision_number; /* indique si on respecte les specs de G. Nelson */
        word    alphabet_o;             /* Offset of alternate alphabets   (V5) */
        word    ext_head_o;             /* Offset of header extension table (V5) */
        char    user_name[8];
} header_t;

/*
 * Global Variables
 */

/* Pour viter au maximum les variables globales j'en remplace certaines par des macros. */

#define data_head (*(header_t*)base_ptr)
#define objd_obj_base (base_ptr + data_head.object_o)
#define objd_obj_size (ENHANCED ? 14 : 9)
#define objd_obj_offset (ENHANCED ? 0x70 : 0x35)
#define objd_is_eobj ENHANCED
#define file_info_pages (data_head.verify_length >> (ENHANCED ? 10 : 11))
#define file_info_offset ((data_head.verify_length << (ENHANCED ? 2 : 1)) & 0xFFF)
#define resident_blocks (data_head.resident_bytes / BLOCK_SIZE)
#define global_ptr (base_ptr + data_head.variable_o)
#define common_word_ptr (base_ptr + data_head.common_word_o)
#define wsbf_strt ((byte*)stack_base)
#define vocab (base_ptr + data_head.vocab_o)
#define num_vocab_words (Z_TO_WORD(strt_vocab_table - 2))
#define vocab_entry_size (Z_TO_BYTE(strt_vocab_table - 3))
#define end_vocab_table (strt_vocab_table + (vocab_entry_size * (num_vocab_words-1)))

/*
 * Function Prototypes
 */

#define E static

/*
 * file.c
 */
E int          open_file P((const char *));
E void          load_page P((word, byte *));
E void          save P((void));
E void          restore P((void));
/*
 * funcs.c
 */
E void          plus P((word, word));
E void          minus P((word, word));
E void          multiply P((word, word));
E void          divide P((word, word));
E void          mod P((word, word));
E void          pi_random P((word));
E void          LTE P((word, word));
E void          GTE P((word, word));
E void          bit P((word, word));
E void          or P((word, word));
E void          not P((word));
E void          and P((word, word));
E void          compare P((word, const word *));
E void          cp_zero P((word));
/*
 * init.c
 */
E Bool          init P((int, int));
/*
 * input.c
 */
E void          input P((word, word));
/*
 * interp.c
 */
E void          interp P((void));
/*
 * jump.c
 */
E void          gosub P((word, const word *));
E void          rtn P((word));
E void          jump P((word));
E void          rts P((void));
E void          pop_stack P((void));
/*
 * object.c
 */
E void          transfer P((word, word));
E void          test_attr P((word, word));
E void          set_attr P((word, word));
E void          clr_attr P((word, word));
E void          get_loc P((word));
E void          get_holds P((word));
E void          get_link P((word));
E void          check_loc P((word, word));
/* E object_t *    obj_addr P((word)); */
/*
 * page.c
 */
E Bool          pg_init P((void));
E byte *        fetch_page P((word));
E void          fix_pc P((void));
/*
 * print.c
 */
E Bool          print_init P((void));
E void          print_num P((word));
E void          print_str P((const char *));
E void          print2 P((word));
E void          print1 P((word));
E void          p_obj P((word));
E void          wrt P((void));
E void          writeln P((void));
E void          flush_text_buffer P((void));
E void          new_line P((void));
E void          print_char P((word));
E void          prt_coded P((unsigned long));
E void          decode P((word));
E void          set_score P((void));
/*
 * property.c
 */
E void          next_prop P((word, word));
E void          put_prop P((word, word, word));
E void          get_prop P((word, word));
E void          get_prop_addr P((word, word));
E void          get_prop_len P((word));
E void          load_word_array P((word, word));
E void          load_byte_array P((word, word));
E void          save_word_array P((word, word, word));
E void          save_byte_array P((word, word, word));
/*
 * support.c
 */
E void          null P((void));
E void          change_status P((void));
E void          restart P((void));
E __attribute__ ((noreturn)) void quit P((void));
E void          verify P((void));
E void          store P((word));
E void          ret_value P((word));
E __attribute__ ((noreturn)) void error P((const char *, int));
E byte          get_byte P((unsigned long));
E word          get_word P((unsigned long));
E word          get_aligned_word P((unsigned long));
E word          next_word P((void));
/*
 * variable.c
 */
E void          get_var P((word));
E word          load_var P((word));
E void          put_var P((word, word));
E void          push P((word));
E void          pop P((word));
E void          inc_var P((word));
E void          dec_var P((word));
E void          inc_chk P((word, word));
E void          dec_chk P((word, word));
E word          load P((int));
/*
 * Terminal interface functions
 */
E void          scr_setup P((void));
E void          scr_putline P((const char *));
E void          scr_putscore P((void));
E void          scr_putsound P((int, int, int, int));
E int           scr_getline P((const char *, int, char *));
E void          scr_window P((int));
E void          scr_set_win P((int));

#undef E
#endif /* INFOCOM_H */
