//---------------------------------------------------------------------------
#include <vcl.h>
#include <algorithm.h>                                         
#include <mmsystem.hpp>

#pragma hdrstop

#include "zclass.h"
#include "glkthread.h"
#include "globals.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

//Contents of the header
#define VERSION 0
#define FLAGS1 1
#define RELEASE 2
#define HIGH_MEM 4             
#define EXE_POINT 6
#define DICTIONARY 8
#define OBJECT_TABLE 10
#define GLOBALS 12
#define STATIC_MEM 14
#define FLAGS2 17
#define SERIAL_NUM 18
#define ABBREVIATIONS 24
#define FILE_LENGTH 26
#define CHECKSUM 28
#define INTERPRETER_NUM 30
#define INTERPRETER_VER 31
#define HEIGHT_CHARS 32
#define WIDTH_CHARS 33
#define WIDTH_UNITS 34
#define HEIGHT_UNITS 36
#define FONT_WIDTH 38
#define FONT_HEIGHT 39
#define BKGND_COLOR 44
#define FGND_COLOR 45
#define TERM_CHARS 46
#define REVISION1 50
#define REVISION2 51
#define ALPHABET 52
#define EXT_TABLE 54

//0OP opcodes
#define RTRUE 0
#define RFALSE 1
#define PRINT 2
#define PRINT_RET 3
#define NOP 4
#define SAVE 5
#define RESTORE 6
#define RESTART 7
#define RET_POPPED 8
#define POP 9
#define QUIT 10
#define NEW_LINE 11
#define SHOW_STATUS 12
#define VERIFY 13
#define EXT 14

//1OP opcodes
#define JZ 0
#define GET_SIBLING 1
#define GET_CHILD 2
#define GET_PARENT 3
#define GET_PROP_LEN 4
#define INC 5
#define DEC 6
#define PRINT_ADDR 7
#define CALL_1S 8
#define REMOVE_OBJ 9
#define PRINT_OBJ 10
#define RET 11
#define JUMP 12
#define PRINT_PADDR 13
#define LOAD 14
#define NOT 15
                                                                    
//2OP opcodes
#define JE 1
#define JL 2
#define JG 3
#define DEC_CHK 4
#define INC_CHK 5
#define JIN 6
#define TEST 7
#define OR 8
#define AND 9
#define TEST_ATTR 10
#define SET_ATTR 11
#define CLEAR_ATTR 12
#define STORE 13                                                          
#define INSERT_OBJ 14
#define LOADW 15
#define LOADB 16
#define GET_PROP 17
#define GET_PROP_ADDR 18
#define GET_NEXT_PROP 19
#define ADD 20
#define SUB 21
#define MUL 22
#define DIV 23
#define MOD 24
#define CALL_2S 25
#define CALL_2N 26
#define SET_COLOR 27
#define THROW 28

//VAR opcodes
#define CALL 32
#define STOREW 33
#define STOREB 34
#define PUT_PROP 35
#define READ 36
#define PRINT_CHAR 37
#define PRINT_NUM 38
#define RANDOM 39
#define PUSH 40
#define PULL 41
#define SPLIT_WINDOW 42
#define SET_WINDOW 43
#define CALL_VS2 44
#define ERASE_WINDOW 45
#define SET_CURSOR 47
#define SET_TEXT_STYLE 49
#define BUFFER_MODE 50
#define OUTPUT_STREAM 51
#define INPUT_STREAM 52
#define SOUND_EFFECT 53
#define READ_CHAR 54
#define SCAN_TABLE 55
#define NOT2 56
#define CALL_VN 57
#define CALL_VN2 58
#define TOKENISE 59
#define ENCODE_TEXT 60
#define COPY_TABLE 61
#define PRINT_TABLE 62
#define CHECK_ARG_COUNT 63


//EXT OPCODES
#define SAVE2 0
#define RESTORE2 1
#define LOG_SHIFT 2
#define ART_SHIFT 3
#define SET_FONT 4
#define SAVE_UNDO 9
#define RESTORE_UNDO 10
#define PRINT_UNICODE 11
#define CHECK_UNICODE 12
#define SET_TRUE_COLOR 13

//TEXT STYLES
#define ROMAN 0
#define REVERSE 1
#define BOLD 2
#define ITALIC 4
#define FIXED 8

//FONTS
#define NORMAL_FONT 1
#define PICTURE_FONT 2
#define CHAR_GRAPHICS_FONT 3
#define FIXED_FONT 4

//COLORS
#define DEFAULT 1
#define BLACK 2
#define RED 3
#define GREEN 4
#define YELLOW 5
#define BLUE 6
#define MAGENTA 7
#define CYAN 8
#define WHITE 9
#define LIGHT_GRAY 10
#define MEDIUM_GRAY 11
#define DARK_GRAY 12

const TColor colorBlack=0x00000000;
const TColor colorRed=0x000000ef;
const TColor colorGreen=0x0000d600;
const TColor colorYellow=0x0000efef;
const TColor colorBlue=0x00b56b00;
const TColor colorMagenta=0x00ff00ff;
const TColor colorCyan=0x00efef00;
const TColor colorWhite=0x00ffffff;
const TColor colorLtGray=0x00b5b5b5;
const TColor colorMdGray=0x008c8c8c;
const TColor colorDkGray=0x005a5a5a;

const unsigned char flags[8]={128,64,32,16,8,4,2,1};

const char alpha_const[3][26]=
{{'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
'p','q','r','s','t','u','v','w','x','y','z'},
{'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O',
'P','Q','R','S','T','U','V','W','X','Y','Z'},
{' ','\n','0','1','2','3','4','5','6','7','8','9','.',',','!',
'?','_','#','\'','\"','/','\\','-',':','(',')'}};

const wchar_t uni_const[69]={228,246,252,196,214,220,223,187,171,235,239,255,203,207, //umlauts
  225,233,237,243,250,253,193,201,205,211,218,221,  //acutes
  224,232,236,242,249,192,200,204,210,217,  //grave
  226,234,238,244,251,194,202,206,212,219,  //circumflex
  229,197,248,216,227,241,245,195,209,213,230,198,231,199,
  254,240,222,208,163,339,338,161,191};

const unsigned char vk_code[27]={144,143,142,141,140,139,138,137,136,135,134,133,
  0,0,0,0,0,0,0,0,27,8,13,130,129,132,131};

const unsigned char argc_mask[8]={1,2,4,8,16,32,64,128};

const bool lurking_sound_repeat[16]={false,true,false,false,false,false,false,true,false,false,true,false,true,true,true,true};

extern GLK *glk;

//----------------------------------------------------------------------------

void ZMACHINE::run_story()
{
glk->blank_reverse=false;
glk->char_cursor=true;
glk->borders=false;
glk->input_style=false;

randomize();

dynamic_size=read_word(STATIC_MEM);
dynamic=new unsigned char[dynamic_size];
memcpy(dynamic,story,dynamic_size);

for (int i=0;i<10;i++)
  undo_stream[i]=new TMemoryStream();

switch(version){
  case 3:
    pack=2;
    break;
  case 4:
  case 5:
    pack=4;
    break;
  case 8:
    pack=8;
    break;};

dict=read_word(DICTIONARY);

if (version>4&&read_word(ALPHABET)!=0){
  int loc=read_word(ALPHABET);
  for (int i=0;i<3;i++){
    for (int j=0;j<26;j++){                                 
      alpha[i][j]=story[loc];
      if (alpha[i][j]=='^')
        alpha[i][j]='\n';
      loc++;};};}
else{
  memcpy(alpha,alpha_const,78);};

for (int i=0;i<96;i++)
  unicode_table[i]='?';
int ext_loc=read_word(EXT_TABLE);
if ((ext_loc>0)&&(read_word(ext_loc)>2)&&(read_word(ext_loc+6)>0)){
  int loc=read_word(ext_loc+6);
  unicode_table_size=story[loc];
  loc++;
  for (int i=0;i<unicode_table_size;i++){
    unicode_table[i]=read_word(loc);
    loc+=2;};}
else{
  memcpy (unicode_table,uni_const,138);
  unicode_table_size=69;};
if ((ext_loc>0)&&(read_word(ext_loc)>4)){
  TColor color=color_from_srgb(read_word(ext_loc+10));
  glk->stylehint_set(WINTYPE_TEXTBUFFER,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
  glk->stylehint_set(WINTYPE_TEXTGRID,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
  if ((read_word(ext_loc)>5)){
    TColor color=color_from_srgb(read_word(ext_loc+12));
    glk->stylehint_set(WINTYPE_TEXTBUFFER,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
    glk->stylehint_set(WINTYPE_TEXTGRID,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
  }
}
                                    
if (version<5)
  glk->more_clear=true;

if (story[FLAGS2]&8)
  glk->char_graphics=true;

glk->stylehint_set(WINTYPE_TEXTGRID,STYLE_USER1,STYLEHINT_REVERSECOLOR,true);
glk->window_open(0,0,0,WINTYPE_TEXTBUFFER,0);
if (version==3){
  glk->window_open(1,WINMETHOD_FIXED|WINMETHOD_ABOVE,1,WINTYPE_TEXTGRID,0);
  upper_win=5;
  upper_stream=3;}
else{
  upper_win=3;
  upper_stream=2;};
glk->window_open(1,WINMETHOD_FIXED|WINMETHOD_ABOVE,0,WINTYPE_TEXTGRID,0);

glk->schannel_create(0);

mouse_active=false;
prepare_header();

init_exe();

main_loop();

if (stream2)
  delete scriptf;

delete dynamic;

for (int i=0;i<10;i++)
  delete undo_stream[i];
};
//----------------------------------------------------------------------------

void ZMACHINE::prepare_header()
{
if (story[VERSION]==3)
  story[FLAGS1]|=96;
else
  story[FLAGS1]|=253;

story[FONT_WIDTH]=1;
story[FONT_HEIGHT]=1;
story[INTERPRETER_NUM]=4;
story[INTERPRETER_VER]='F';
story[BKGND_COLOR]=1;
story[FGND_COLOR]=1;
story[REVISION1]=1;
story[REVISION2]=1;

if (version>4&&read_word(TERM_CHARS)!=0){
  int loc=read_word(TERM_CHARS);
  unsigned int keycode;
  while (story[loc]!=0){
    if (story[loc]>=129&&story[loc]<=154){
      switch (story[loc]){
        case 129:
          keycode=KEYCODE_UP;
          break;
        case 130:
          keycode=KEYCODE_DOWN;
          break;
        case 131:
          keycode=KEYCODE_LEFT;
          break;
        case 132:
          keycode=KEYCODE_RIGHT;
          break;
        case 133:
          keycode=KEYCODE_FUNC1;
          break;
        case 134:
          keycode=KEYCODE_FUNC2;
          break;
        case 135:
          keycode=KEYCODE_FUNC3;
          break;
        case 136:
          keycode=KEYCODE_FUNC4;
          break;
        case 137:
          keycode=KEYCODE_FUNC5;
          break;
        case 138:
          keycode=KEYCODE_FUNC6;
          break;
        case 139:
          keycode=KEYCODE_FUNC7;
          break;
        case 140:
          keycode=KEYCODE_FUNC8;
          break;
        case 141:
          keycode=KEYCODE_FUNC9;
          break;
        case 142:
          keycode=KEYCODE_FUNC10;
          break;
        case 143:
          keycode=KEYCODE_FUNC11;
          break;
        case 144:
          keycode=KEYCODE_FUNC12;
          break;
        case 145:
          keycode=KEYCODE_NUMPAD0;
          break;
        case 146:
          keycode=KEYCODE_NUMPAD1;
          break;
        case 147:
          keycode=KEYCODE_NUMPAD2;
          break;
        case 148:
          keycode=KEYCODE_NUMPAD3;
          break;
        case 149:
          keycode=KEYCODE_NUMPAD4;
          break;
        case 150:
          keycode=KEYCODE_NUMPAD5;
          break;
        case 151:
          keycode=KEYCODE_NUMPAD6;
          break;
        case 152:
          keycode=KEYCODE_NUMPAD7;
          break;
        case 153:
          keycode=KEYCODE_NUMPAD8;
          break;
        case 154:
          keycode=KEYCODE_NUMPAD9;
          break;};
      glk->set_terminators_line_event(1,&keycode,1);}
    else{
      if (story[loc]==254){
        mouse_active=true;}
      else{
        if (story[loc]==255){
          for (keycode=0xfffffffe;keycode>=0xffffffd6;keycode--){
            glk->set_terminators_line_event(1,&keycode,1);};};};};
    loc++;};};

adjust_screen_size();
};
//---------------------------------------------------------------------------

void ZMACHINE::adjust_screen_size()
{
int old_height;
glk->window_get_size(upper_win,NULL,old_height);

int width,height;
glk->window_set_arrangement(upper_win-1,WINMETHOD_PROPORTIONAL|WINMETHOD_ABOVE,100);
glk->window_get_size(upper_win,width,height);
glk->window_set_arrangement(upper_win-1,WINMETHOD_FIXED|WINMETHOD_ABOVE,old_height);

story[HEIGHT_CHARS]=(unsigned char)height;
story[WIDTH_CHARS]=(unsigned char)width;
write_word((unsigned short)width,WIDTH_UNITS);
write_word((unsigned short)height,HEIGHT_UNITS);
};
//----------------------------------------------------------------------------

void ZMACHINE::main_loop()
{
while (!quitting){

  op_base = exe_loc;
  String add = IntToStr(op_base);

  if (story[exe_loc]&128)
    if (story[exe_loc]&64)
      var_opcode();
    else
      short_opcode();
  else
    long_opcode();};
};
//-----------------------------------------------------------------------------
void ZMACHINE::var_opcode()
{
unsigned char opcode=story[exe_loc]-192;
unsigned char argc=0;
unsigned short argv[4];
if ((opcode!=CALL_VS2)&&(opcode!=CALL_VN2))
  argc=get_var_args(argv);

switch (opcode){
  case JE:
    Z_je(argc,argv);
    break;
  case JL:
    Z_jl(argv[0],argv[1]);
    break;
  case JG:
    Z_jg(argv[0],argv[1]);
    break;
  case DEC_CHK:
    Z_dec_chk(argv[0],argv[1]);
    break;    
  case INC_CHK:
    Z_inc_chk(argv[0],argv[1]);
    break;
  case JIN:
    Z_jin(argv[0],argv[1]);
    break;      
  case TEST:
    Z_test(argv[0],argv[1]);
  case OR:
    Z_or(argv[0],argv[1]);           
    break;
  case AND:
    Z_and(argv[0],argv[1]);
    break;
  case TEST_ATTR:
    Z_test_attr(argv[0],argv[1]);
    break;
  case SET_ATTR:
    Z_set_attr(argv[0],argv[1]);
    break;
  case CLEAR_ATTR:
    Z_clear_attr(argv[0],argv[1]);
    break;
  case STORE:
    Z_store(argv[0],argv[1]);
    break;
  case INSERT_OBJ:
    Z_insert_obj(argv[0],argv[1]);
    break;
  case LOADW:
    Z_loadw(argv[0],argv[1]);
    break;
  case LOADB:
    Z_loadb(argv[0],argv[1]);
    break;
  case GET_PROP:
    Z_get_prop(argv[0],argv[1]);
    break;
  case GET_PROP_ADDR:
    Z_get_prop_addr(argv[0],argv[1]);
    break;
  case GET_NEXT_PROP:
    Z_get_next_prop(argv[0],argv[1]);
    break;
  case ADD:
    Z_add(argv[0],argv[1]);
    break;
  case SUB:
    Z_sub(argv[0],argv[1]);
    break;
  case MUL:
    Z_mul(argv[0],argv[1]);
    break;
  case DIV:
    Z_div(argv[0],argv[1]);
    break;
  case MOD:
    Z_mod(argv[0],argv[1]);
    break;
  case CALL_2S:

    Z_call_2s(argv[0],argv[1]);
    break;
  case CALL_2N:
    Z_call_2n(argv[0],argv[1]);
    break;  
  case SET_COLOR:
    Z_set_color(argv[0],argv[1]);
    break;
  case THROW:
    Z_throw(argv[0],argv[1]);
    break;
  case CALL:
    Z_call(argv[0],argc-1,&argv[1]);
    break;
  case STOREW:
    Z_storew(argv[0],argv[1],argv[2]);
    break;
  case STOREB:
    Z_storeb(argv[0],argv[1],argv[2]);
    break;
  case PUT_PROP:
    Z_put_prop(argv[0],argv[1],argv[2]);
    break;
  case READ:
    Z_read(argc,argv[0],argv[1],argv[2],argv[3]);
    break;   
  case PRINT_CHAR:
    Z_print_char(argv[0]);
    break;
  case PRINT_NUM:                    
    Z_print_num(argv[0]);
    break;
  case RANDOM:
    Z_random(argv[0]);
    break;  
  case PUSH:
    Z_push(argv[0]);
    break;
  case PULL:
    Z_pull(argv[0]);
    break;
  case SPLIT_WINDOW:
    Z_split_window(argv[0]);
    break;
  case SET_WINDOW:
    Z_set_window(argv[0]);
    break;
  case CALL_VS2:
    Z_call_vs2();
    break;   
  case ERASE_WINDOW:
    Z_erase_window(argv[0]);
    break;
  case SET_CURSOR:
    Z_set_cursor(argv[0],argv[1]);
    break;
  case SET_TEXT_STYLE:
    Z_set_text_style(argv[0]);
    break;
  case BUFFER_MODE:
    Z_buffer_mode(argv[0]);
    break;
  case OUTPUT_STREAM:
    Z_output_stream(argv[0],argv[1]);
    break;
  case INPUT_STREAM:
    Z_input_stream(argv[0]);
    break;
  case SOUND_EFFECT:
    Z_sound_effect(argc,argv[0],argv[1],argv[2],argv[3]);
    break;     
  case READ_CHAR:
    Z_read_char((argc>1),argv[1],argv[2]);
    break;
  case SCAN_TABLE:
    Z_scan_table(argc,argv[0],argv[1],argv[2],argv[3]);
    break;
  case NOT2:
    Z_not(argv[0]);
    break;      
  case CALL_VN:
    Z_call_vn(argv[0],argc-1,&argv[1]);
    break;
  case CALL_VN2:
    Z_call_vn2();
    break;
  case TOKENISE:
    Z_tokenise(argc,argv[0],argv[1],argv[2],argv[3]);
    break;
  case ENCODE_TEXT:
    Z_encode_text(argv[0],argv[1],argv[2],argv[3]);
    break;
  case COPY_TABLE:
    Z_copy_table(argv[0],argv[1],argv[2]);
    break;
  case PRINT_TABLE:
    Z_print_table(argc,argv[0],argv[1],argv[2],argv[3]);
    break;
  case CHECK_ARG_COUNT:
    Z_check_arg_count(argv[0]);
    break;
  default:
//    Application->MessageBox("Illegal opcode!","Fatal Error",MB_OK);
    quitting=true;};
};
//-----------------------------------------------------------------------------

unsigned char ZMACHINE::get_var_args(unsigned short *argv)
{
unsigned char argc;
exe_loc++;
unsigned char op_type=story[exe_loc];
exe_loc++;


for (argc=0;argc<4;argc++){
  if (op_type&128)
    if (op_type&64)
      break;
    else{
      argv[argc]=read_var(story[exe_loc]);
      exe_loc++;}
  else
    if (op_type&64){
      argv[argc]=story[exe_loc];
      exe_loc++;}
    else{
      argv[argc]=read_word(exe_loc);
      exe_loc+=2;};
  op_type<<=2;};

return (argc);
};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::read_var(unsigned char var)
{
if (var==0)
  return (pop_stack());
else
  if (var<16)
    return (read_local(var-1));
  else
    return (read_global(var-16));};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::pop_stack()
{
stack[frame_count].stack_count--;
return (stack[frame_count].stack[stack[frame_count].stack_count]);

};                        
//----------------------------------------------------------------------------
unsigned short ZMACHINE::read_stack()
{
return (stack[frame_count].stack[stack[frame_count].stack_count-1]);

};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::read_local(unsigned char num)
{
return (stack[frame_count].local[num]);
};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::read_global(unsigned char num)
{
return (read_word(read_word(GLOBALS)+(num*2)));

};
//----------------------------------------------------------------------------
void ZMACHINE::short_opcode()
{
unsigned short argv;

bool op1=true;

unsigned char opcode=story[exe_loc]<<2;
exe_loc++;
if (opcode&128){
  if (!(opcode&64)){
    argv=read_var(story[exe_loc]);
    exe_loc++;}
  else{
    op1=false;};}
else
  if (opcode&64){
    argv=story[exe_loc];
    exe_loc++;}
  else{
    argv=read_word(exe_loc);
    exe_loc+=2;};
opcode<<=2;
opcode>>=4;

if (op1){
  switch (opcode){
    case JZ:
      Z_jz(argv);
      break;
    case GET_SIBLING:
      Z_get_sibling(argv);
      break;
    case GET_CHILD:
      Z_get_child(argv);
      break;
    case GET_PARENT:
      Z_get_parent(argv);
      break;
    case GET_PROP_LEN:
      Z_get_prop_len(argv);
      
      break;
    case INC:
      Z_inc(argv);
      break;
    case DEC:
      Z_dec(argv);
      break;
    case PRINT_ADDR:
      Z_print_addr(argv);
      break;
    case CALL_1S:
      Z_call_1s(argv);
      break;
    case REMOVE_OBJ:
      Z_remove_obj(argv);
      break;  
    case PRINT_OBJ:
      Z_print_obj(argv);
      break;
    case RET:
      Z_ret(argv);
      break;
    case JUMP:
      Z_jump(argv);
      break;
    case PRINT_PADDR:
      Z_print_paddr(argv);
      break;
    case LOAD:
      Z_load(argv);
      break;
    case NOT:
      if (story[VERSION]<5)
        Z_not(argv);
      else
        Z_call_1n(argv);
      break;
    default:
//      Application->MessageBox("Illegal opcode!","Fatal Error",MB_OK);
      quitting=true;};}

else{
  switch (opcode){
    case RTRUE:
      Z_rtrue();
      break;
    case RFALSE:
      Z_rfalse();
      break;
    case PRINT:
      Z_print();
      break;
    case PRINT_RET:
      Z_print_ret();
      break;
    case NOP:
      Z_nop();
      break;
    case SAVE:
      Z_save();
      break;
    case RESTORE:
      Z_restore();
      break;
    case RESTART:
      Z_restart();
      break; 
    case RET_POPPED:
      Z_ret_popped();
      break;
    case POP:
      if (version < 5)
        Z_pop();
      else
        Z_catch();
      break;
    case QUIT:
      Z_quit();
      break; 
    case NEW_LINE:
      Z_new_line();
      break;
    case SHOW_STATUS:
      Z_show_status();
      break;
    case VERIFY:
      Z_verify();
      break;
    case EXT:
      Z_ext();
      break; 
    default:
//      Application->MessageBox("Illegal opcode!","Fatal Error",MB_OK);
      quitting=true;};};
};
//----------------------------------------------------------------------------
void ZMACHINE::long_opcode()
{
unsigned short argv[2];
unsigned char opcode=story[exe_loc]<<1;
exe_loc++;
for (int i=0;i<2;i++){
  if (opcode&128)
    argv[i]=read_var(story[exe_loc]);
  else{
  
    argv[i]=story[exe_loc];};

  opcode<<=1;
  exe_loc++;};

opcode>>=3;

switch (opcode){
  case JE:
    Z_je(2,argv);
    break;
  case JL:
    Z_jl(argv[0],argv[1]);
    break;
  case JG:
    Z_jg(argv[0],argv[1]);
    break; 
  case DEC_CHK:
    Z_dec_chk(argv[0],argv[1]);
    break;
  case INC_CHK:
    Z_inc_chk(argv[0],argv[1]);
    break;
  case JIN:
    Z_jin(argv[0],argv[1]);
    break;
  case TEST:
    Z_test(argv[0],argv[1]);
    break;
  case OR:
    Z_or(argv[0],argv[1]);
    break;  
  case AND:
    Z_and(argv[0],argv[1]);
    break;
  case TEST_ATTR:
    Z_test_attr(argv[0],argv[1]);
    break;
  case SET_ATTR:
    Z_set_attr(argv[0],argv[1]);
    break;
  case CLEAR_ATTR:
    Z_clear_attr(argv[0],argv[1]);
    break;
  case STORE:
    Z_store(argv[0],argv[1]);
    break;
  case INSERT_OBJ:
    Z_insert_obj(argv[0],argv[1]);
    break;
  case LOADW:
    Z_loadw(argv[0],argv[1]);
    break;
  case LOADB:
    Z_loadb(argv[0],argv[1]);
    break;
  case GET_PROP:
    Z_get_prop(argv[0],argv[1]);
    break;
  case GET_PROP_ADDR:
    Z_get_prop_addr(argv[0],argv[1]);
    break;
  case GET_NEXT_PROP:
    Z_get_next_prop(argv[0],argv[1]);
    break;
  case ADD:
    Z_add(argv[0],argv[1]);
    break;
  case SUB:
    Z_sub(argv[0],argv[1]);
    break;
  case MUL:
    Z_mul(argv[0],argv[1]);
    break;
  case DIV:
    Z_div(argv[0],argv[1]);
    break;
  case MOD:
    Z_mod(argv[0],argv[1]);
    break;
  case CALL_2S:
    Z_call_2s(argv[0],argv[1]);
    break;
  case CALL_2N:
    Z_call_2n(argv[0],argv[1]);
    break;
  case SET_COLOR:
    Z_set_color(argv[0],argv[1]);
    break;
  case THROW:
    Z_throw(argv[0],argv[1]);
    break;
  default:
//    Application->MessageBox("Illegal opcode!","Fatal Error",MB_OK);
    quitting=true;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call(unsigned short routine,unsigned char argc,unsigned short *argv)
{
call(routine,argc,argv,true,false);
};
//----------------------------------------------------------------------------

void ZMACHINE::call(unsigned short routine,unsigned char argc,unsigned short *argv,bool write_result,bool int_call)
{
if (routine==0){
  if (write_result){
    write_var(0,story[exe_loc]);
    exe_loc++;};}

else{
  frame_count++;
  if (frame_count>=500){
    Application->MessageBox("Z-Machine stack overflow!  Halting.","Error.",MB_OK);
    quitting=true;
    return;};
  stack[frame_count].return_pc=exe_loc;
  stack[frame_count].args=255;
  stack[frame_count].args<<=argc;
  stack[frame_count].args=~stack[frame_count].args;
  stack[frame_count].stack_count=0;

  if (write_result){
    stack[frame_count].return_pc++;;
    stack[frame_count].result_var=story[exe_loc];
    stack[frame_count].local_count=0;}
  else{
    stack[frame_count].result_var=0;
    stack[frame_count].local_count=16;};

  if (int_call)
    stack[frame_count].local_count+=32;

  exe_loc=routine*pack;
  stack[frame_count].local_count+=story[exe_loc];
  exe_loc++;
  if (story[VERSION]<5){
    for (int i=0;i<(stack[frame_count].local_count);i++){
      stack[frame_count].local[i]=read_word(exe_loc);
      exe_loc+=2;};}
  else
    memset(stack[frame_count].local,0,30);
  for (int i=0;i<argc;i++)
    stack[frame_count].local[i]=argv[i];};
};
//----------------------------------------------------------------------------
void ZMACHINE::write_var(unsigned short value, unsigned char var)
{
if (var==0)
  push_stack(value);
else
  if (var<16)
    write_local(value,var-1);
  else
    write_global(value,var-16);
};
//----------------------------------------------------------------------------
void ZMACHINE::push_stack(unsigned short value)
{
stack[frame_count].stack[stack[frame_count].stack_count]=value;
stack[frame_count].stack_count++;
};
//----------------------------------------------------------------------------
void ZMACHINE::write_stack(unsigned short value)
{
stack[frame_count].stack[stack[frame_count].stack_count-1]=value;
};
//----------------------------------------------------------------------------
void ZMACHINE::write_local(unsigned short value, unsigned char num)
{
stack[frame_count].local[num]=value;
};
//----------------------------------------------------------------------------
void ZMACHINE::write_global(unsigned short value, unsigned char num)
{
write_word(value,read_word(GLOBALS)+(num*2));
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_add(short a, short b)
{
short result=a+b;
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_je(unsigned char argc, unsigned short num[])
{
bool result=false;
for (int i=1;i<argc;i++)
  if (num[0]==num[i])
    result=true;
branch(result);
};
//----------------------------------------------------------------------------
void ZMACHINE::branch(bool result)
{
bool cond=story[exe_loc]&128;

if (story[exe_loc]&64){
    unsigned char offset=story[exe_loc]<<2;
    offset>>=2;
    exe_loc++;
    if (cond==result){
      if (offset==0||offset==1){
        ret_routine(offset);            
        return;};
      exe_loc=exe_loc+offset-2;};}      
else{        
  short offset=read_word(exe_loc);
  offset<<=2;
  offset>>=2;
  exe_loc+=2;
  if (cond==result){
    if (offset==0||offset==1){
      ret_routine(offset);
      return;};
    exe_loc=exe_loc+offset-2;};};};
//---------------------------------------------------------------------------
void ZMACHINE::ret_routine(unsigned short result)
{
exe_loc=stack[frame_count].return_pc;
frame_count--;
if (stack[frame_count+1].local_count&32){
//  int_result=stack[frame_count+1].result_var;
  int_result=result;
  quitting=true;
  return;};
if (!(stack[frame_count+1].local_count&16))
  write_var(result,stack[frame_count+1].result_var);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_sub(short a, short b)
{
short result=a-b;
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_jz(unsigned short a)
{
branch(a==0);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_storew(unsigned short array, unsigned short index, unsigned short value)
{
write_word(value,array+(2*index));
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_ret(unsigned short result)
{
ret_routine(result);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_loadw(unsigned short array, unsigned short index)
{
unsigned short result=read_word(array+(2*index));
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_jump(short offset)
{
exe_loc=op_base+offset+1;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_put_prop(unsigned short obj, unsigned char prop, unsigned short value)
{
unsigned short address=prop_addr(obj,prop);

if (story[VERSION]==3)
  if (story[address]/32==1)
    write_word(value,address+1);
  else
    story[address+1]=value;
else
  if (story[address]&64)
    write_word(value,address+1);
  else
    story[address+1]=value;
};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::prop_addr(unsigned short obj,unsigned char prop)
{
unsigned short address=obj_props(obj);
address+=(story[address]*2+1);

while(story[address]){
  if (story[VERSION]==3)
    if (prop==(story[address]%32))
      return (address);
    else
      address+=(story[address]/32+2);
  else{
    unsigned char prop_num=story[address]<<2;
    prop_num=prop_num>>2;
    if (prop_num==prop)
      return (address);
    else
      if (story[address]&128){
        address++;
        unsigned char len=story[address]<<2;
        len=len>>2;
        if (len==0)
          len=64;
        address+=(len+1);}
      else
        if (story[address]&64)
          address+=3;
        else
          address+=2;};};

return (0);
};
//----------------------------------------------------------------------------
unsigned short ZMACHINE::obj_props(unsigned short obj)
{
int address=obj_address(obj);
if (story[VERSION]==3)
  address+=7;
else
  address+=12;
return (read_word(address));
};
//----------------------------------------------------------------------------
int ZMACHINE::obj_address(unsigned short obj)
{
int address=read_word(OBJECT_TABLE);
if (story[VERSION]==3){
  address+=62;
  address+=(9*(obj-1));}
else{
  address+=126;
  address+=(14*(obj-1));};
return (address);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_store(unsigned char var, unsigned short value)
{
if (var == 0)
  write_stack(value);
else
  write_var(value,var);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_test_attr(unsigned short obj, unsigned char attr)
{
int address=obj_address(obj);
address+=(attr/8);
branch(story[address]&flags[attr%8]);
};
//----------------------------------------------------------------------------
String ZMACHINE::read_text(int address,bool jump)
{
String text="";
bool done;
bool abbrev=false;
bool zscii1=false;
bool zscii2=false;
unsigned short word;
unsigned char letter;
unsigned char previous;
unsigned char charset=0;
unsigned char zscii_char;

do{
  word=read_word(address);
  address+=2;
  done=word&32768;
  for (int i=10;i>=0;i-=5){
    letter=word>>i;
    letter<<=3;
    letter>>=3;
    if (abbrev){
      text+=read_text(read_word(read_word(ABBREVIATIONS)+((32*(previous-1)+letter)*2))*2,false);
      charset=0;
      abbrev=false;
      continue;};
    if (zscii2){
      zscii_char<<=5;
      zscii_char+=letter;
      text+=(char)zscii_char;
      charset=0;
      zscii1=false;
      zscii2=false;
      continue;};
    if (zscii1){
      zscii_char=letter;
      zscii2=true;
      continue;};
    if (letter<6){
      switch (letter){
        case 0:
          text+=' ';
          break;
        case 1:
        case 2:
        case 3:
          previous=letter;
          abbrev=true;
          break;
        case 4:
          charset=1;
          break;
        case 5:
          charset=2;
          break;};
      continue;};
      if (charset==2&&letter==6){
        zscii1=true;
        continue;};
    text+=alpha[charset][letter-6];
    charset=0;};}
while (!done);

if (jump)
  exe_loc=address;
//text=zscii_to_uni(text);
return (text);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print()
{
do_print(read_text(exe_loc,true));
};
//----------------------------------------------------------------------------
void ZMACHINE::do_print(String text)
{
if (!fixed_font2&&!fixed_font3&&((story[FLAGS2]&2)!=fixed_font1)){
  if (story[FLAGS2]&2){
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,false);
    fixed_font1=true;}
  else{
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,true);
    fixed_font1=false;};};

if (stream3){
  stream3_text[stream3_level]+=text;
  stream3_text[stream3_level]=StringReplace(stream3_text[stream3_level],"\n","\r",TReplaceFlags()<<rfReplaceAll);
  write_word(stream3_text[stream3_level].Length(),stream3_loc[stream3_level]);
  unsigned char tmp = story[stream3_loc[stream3_level]+2 +  stream3_text[stream3_level].Length()];
  strcpy(&story[stream3_loc[stream3_level]+2],stream3_text[stream3_level].c_str());
  story[stream3_loc[stream3_level]+2 +  stream3_text[stream3_level].Length()] = tmp;
  return;};

if (stream2!=(story[FLAGS2]&1))
  toggle_script();

WideString wide_text=zscii_to_uni(text);

if (stream1){
  glk->put_string(wide_text.c_bstr());
  if (!buffering&&(glk->stream_get_current()==1))
    glk->flush_output();};

if (glk->stream_get_current()==1){
  output+=text;
  if (stream2){
    wide_text=StringReplace(text,"\n","\r\n",TReplaceFlags()<<rfReplaceAll);
    char *write_text=(char *)malloc(wide_text.Length());
    WideCharToMultiByte(CP_UTF8,NULL,wide_text.c_bstr(),-1,write_text,wide_text.Length(),NULL,NULL);
    scriptf->Write(write_text,wide_text.Length());
    free(write_text);};};
};
//----------------------------------------------------------------------------
WideString ZMACHINE::zscii_to_uni(String in)
{
wchar_t *out;
(void *)out=malloc((in.Length()*2)+2);
wchar_t next_char;
for (int i=1;i<=in.Length();i++){
  next_char=(unsigned char)in[i];
  if (next_char>154){         
    next_char=unicode_table[next_char-155];};
  out[i-1]=next_char;};
out[in.Length()]=0;
return ((WideString)out);
};
//-----------------------------------------------------------------------------
void ZMACHINE::Z_new_line()
{
do_print("\n");
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_loadb(unsigned short array, unsigned short index)
{
unsigned short result=story[array+index];
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_and(unsigned short a, unsigned short b)
{
unsigned short result=(a&b);
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_num(short num)
{
do_print(num);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_inc_chk(unsigned char var,short value)
{
short num=read_var(var);
num++;
write_var(num,var);

branch(num>value);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_char(char zscii)
{
if (zscii != 0)
  do_print(zscii);
};         
//----------------------------------------------------------------------------
void ZMACHINE::Z_rtrue()
{
ret_routine(1);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_insert_obj(unsigned short obj, unsigned short dest)
{
object a=read_obj(obj);

if (a.parent){
  object c=read_obj(a.parent);
  if (c.child==a.num)
    c.child=a.sibling;
  else{
    c=read_obj(c.child);
    while (c.sibling!=a.num)
      c=read_obj(c.sibling);
    c.sibling=a.sibling;};
  write_obj(c);};

object b=read_obj(dest);
a.sibling=b.child;
a.parent=b.num;
b.child=a.num;
write_obj(a);
write_obj(b);
};
//----------------------------------------------------------------------------
object ZMACHINE::read_obj(unsigned short obj)
{
object result;
int address=obj_address(obj);
result.num=obj;
if (story[VERSION]==3){
  address+=4;
  result.parent=story[address];
  address++;
  result.sibling=story[address];
  address++;
  result.child=story[address];}
else{
  address+=6;
  result.parent=read_word(address);
  address+=2;
  result.sibling=read_word(address);
  address+=2;
  result.child=read_word(address);};
return (result);
};
//----------------------------------------------------------------------------
void ZMACHINE::write_obj(object obj)
{
int address=obj_address(obj.num);
if (story[VERSION]==3){
  address+=4;
  story[address]=obj.parent;
  address++;
  story[address]=obj.sibling;
  address++;
  story[address]=obj.child;}
else{
  address+=6;
  write_word(obj.parent,address);
  address+=2;
  write_word(obj.sibling,address);
  address+=2;
  write_word(obj.child,address);};
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_push(unsigned short value)
{
push_stack(value);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_pull(unsigned char var)
{
if (var == 0)
  write_stack(pop_stack());
else
  write_var(pop_stack(),var);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_set_attr(unsigned short obj, unsigned char attr)
{
if (attr>47)
  return;

int address=obj_address(obj);
address+=(attr/8);
if (!(story[address]&flags[attr%8]))
  story[address]+=flags[attr%8];
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_jin(unsigned short a, unsigned short b)
{
object obj=read_obj(a);
branch(obj.parent==b);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_obj(unsigned short obj)
{
int address=obj_props(obj);
address++;
do_print(read_text(address,false));
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_parent(unsigned short a)
{
object obj=read_obj(a);
write_var(obj.parent,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_prop(unsigned short obj, unsigned char prop)
{
unsigned short result=0;
unsigned short address=prop_addr(obj,prop);

if (obj)

  if (address)
    if (story[VERSION]==3)
      if (story[address]/32==1)
        result=read_word(address+1);
      else
        result=story[address+1];
    else
      if (story[address]&64)
        result=read_word(address+1);
      else
        result=story[address+1];

  else
    result=read_word(read_word(OBJECT_TABLE)+((prop-1)*2));

write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_child(unsigned short a)
{
object obj=read_obj(a);
write_var(obj.child,story[exe_loc]);
exe_loc++;
branch(obj.child);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_sibling(unsigned short a)
{
object obj=read_obj(a);
write_var(obj.sibling,story[exe_loc]);
exe_loc++;
branch(obj.sibling);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_inc(unsigned char var)
{
short num=read_var(var);
num++;
write_var(num,var);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_jl(short a, short b)
{
branch(a<b);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_rfalse()
{
ret_routine(0);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_ret_popped()
{
ret_routine(pop_stack());
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_read(int argc,unsigned short text, unsigned short parse,unsigned short time,unsigned short routine)
{
wchar_t *buffer;

if (!fixed_font2&&!fixed_font3&&((story[FLAGS2]&2)!=fixed_font1)){
  if (story[FLAGS2]&2){
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,false);
    fixed_font1=true;}
  else{
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,true);
    fixed_font1=false;};};

int limit=story[text];
int start_count;
buffer=(wchar_t *)malloc((limit+1)*4);
if ((story[VERSION]>4)&&(story[text+1]>0)){
  int loc=(text+1);
  start_count=story[text+1];
  for (int i=0;i<start_count;i++){
    loc++;
    buffer[i]=story[loc];};
  buffer[start_count]=0;}
else{
  start_count=0;
  buffer[0]=0;};

if (version==3)
  update_status();

unsigned int timeout;
if ((argc==4)&&time&&routine)
  timeout=(time*100);
else
  timeout=0;

String prompt=output.SubString(LastDelimiter("\n",output),output.Length());
output="";

check_playback(buffer,limit);

unsigned char term_char=13;
if (playback){
  glk->flush_output();}
else{
  EVENT event;
  glk->request_line_event(glk->window_get_current(),buffer,limit,start_count);
  glk->request_timer_events(timeout);
  if (mouse_active)
    glk->request_mouse_event(upper_win);
  while (!quitting){
    glk->select(&event);
    if (event.type==EVTYPE_LINEINPUT){
      term_char=translate_term_char(event.val2);
      break;};
    if (event.type==EVTYPE_TIMER){
      call(routine,0,NULL,true,true);
      main_loop();
      quitting=false;
      if (int_result){
        story[text]=0;
        free(buffer);
        write_var(0,story[exe_loc-1]);
        return;}
      else{
        if (output.Length()){
          do_print(prompt);
          output="";
          glk->put_string(glk->window_get_input(glk->window_get_current()));};
        exe_loc--;
        continue;};};
    if (event.type==EVTYPE_SOUNDNOTIFY){
      call(sound_routine,0,NULL,false,true);
      main_loop();
      quitting=false;
      continue;};
    if (event.type==EVTYPE_MOUSEINPUT){
      int address=read_word(EXT_TABLE);
      if (address!=0&&read_word(address)>=2){
        address+=2;
        write_word(event.val1+1,address);
        address+=2;
        write_word(event.val2+1,address);
        term_char=254;
        break;};};
    if (event.type==EVTYPE_ARRANGE){
      adjust_screen_size();
      if (version==3)
        update_status();};};};

glk->request_timer_events(0);
glk->cancel_mouse_event(upper_win);

if (quitting)
  return;

if (split_before){
  glk->window_set_arrangement(upper_win-1,WINMETHOD_ABOVE|WINMETHOD_FIXED,last_split);
  split_before=false;};

WideString input=buffer;
free(buffer);
input=WideLowerCase(input);
String write_text=uni_to_zscii(input);

text++;
if (story[VERSION]>4){
  story[text]=write_text.Length();
  text++;
  for (int i=0;i<write_text.Length();i++)
    story[text+i]=write_text[i+1];}
else{
  for (int i=0;i<write_text.Length();i++)
    story[text+i]=write_text[i+1];
  story[text+write_text.Length()]=0;};

if (stream2){
  scriptf->Write(write_text.c_str(),write_text.Length());
  scriptf->Write("\r\n",2);};

if (stream4){
  recordf->Write(write_text.c_str(),write_text.Length());
  recordf->Write("\r\n",2);};

if ((argc>1)&&(parse>0))
  parse_text(write_text,parse,read_word(DICTIONARY),false);

if (story[VERSION]>4){                
  write_var(term_char,story[exe_loc]);
  exe_loc++;};
};
//----------------------------------------------------------------------------

String ZMACHINE::uni_to_zscii(WideString in)
{  
String out="";            
wchar_t next_char;
bool found=true;
for (int i=1;i<=in.Length();i++){
  next_char=in[i];
  if (next_char>155){
    found=false;
    for (int i=0;i<unicode_table_size;i++){
      if (next_char==unicode_table[i]){
        next_char=i+155;
        found=true;
        break;};};};
  if (!found)
    next_char='?';
  out+=(char)next_char;};
return (out);
};
//-----------------------------------------------------------------------------

void ZMACHINE::parse_text(String input,unsigned short parse,unsigned short dictionary,bool skip_unknown)
{
int max_word_len;
if (story[VERSION]==3)
  max_word_len=6;
else
  max_word_len=9;

unsigned short loc=dictionary;
unsigned char sep_count=story[loc];
char *separator=new char[sep_count];
loc++;
for (int i=0;i<sep_count;i++){
  separator[i]=(char)story[loc];
  loc++;};
unsigned char entry_length=story[loc];
loc++;
unsigned short entry_count=abs((short)read_word(loc));
loc+=2;
int start_point=loc;
int max_words=story[parse];
int parse_loc=parse+2;
unsigned short first_letter;

int text_loc=1;
int word_count=0;
while (text_loc<=input.Length()){
  String word="";
  while (text_loc<=input.Length()&&input[text_loc]==' ')
    text_loc++;
  unsigned short first_letter=text_loc;
  if (text_loc<=input.Length()&&word_sep(input[text_loc],separator,sep_count)){
    word=input[text_loc];
    text_loc++;}
  else{
    for (;text_loc<=input.Length()&&!word_sep(input[text_loc],separator,sep_count);text_loc++){
      word+=input[text_loc];};};

  if (word=="")
    continue;
  else{
    word_count++;
    if (word_count>max_words)
      break;
    unsigned char char_len=word.Length();
    while (get_text_length(word)>max_word_len)
      word=word.SetLength(word.Length()-1);
    bool found=false;
    for (int i=0;i<entry_count&&!found;i++){
      if (word==read_text(loc,false)){
        found=true;
        write_word(loc,parse_loc);
        parse_loc+=2;};
      loc+=entry_length;};
    if (skip_unknown){
      parse_loc+=4;}
    else{
      if (!found){
          write_word(0,parse_loc);
        parse_loc+=2;};
      story[parse_loc]=char_len;
      parse_loc++;
      if (story[VERSION]>4)
        first_letter++;
      story[parse_loc]=first_letter;
      parse_loc++;};
    loc=start_point;};};

  story[parse+1]=min(word_count,max_words);
};
//----------------------------------------------------------------------------

bool ZMACHINE::word_sep(char letter, char separator[], unsigned char sep_count)
{
if (letter==' ')
  return (true);
for (int i=0;i<sep_count;i++)
  if (letter==separator[i])
    return (true);
return (false);
};
//----------------------------------------------------------------------------

int ZMACHINE::get_text_length(WideString text)
{
int len=0;

for (int i=0;i<text.Length();i++){
  bool found=false;
  wchar_t next_comp=text[i+1];
  if (next_comp>160){
    for (int i=0;i<unicode_table_size;i++){
      if (next_comp==unicode_table[i]){
        next_comp=(i+155);
        break;};};};  
  for (int j=0;j<26;j++){
    if (next_comp==alpha[0][j]){
      len++;
      found=true;
      break;};};
  if (!found){
    for (int j=0;j<26;j++){
      if (next_comp==alpha[1][j]){
        len+=2;
        found=true;
        break;};};};
  if (!found){
    for (int j=0;j<26;j++){
      if (next_comp==alpha[2][j]){
        len+=2;
        found=true;
        break;};};};
  if (!found){
    len+=4;};};


return (len);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_dec_chk(unsigned char var,short value)
{
short num=read_var(var);
num--;
write_var(num,var);

branch(num<value);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_test(unsigned short bitmap, unsigned short flags)
{
branch((bitmap&flags)==flags);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_jg(short a, short b)
{
branch(a>b);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_mul(short a, short b)
{
short result=a*b;
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_storeb(unsigned short array, unsigned short index, unsigned char value)
{
story[array+index]=value;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_clear_attr(unsigned short obj, unsigned char attr)
{
if (attr>47)
  return;

int address=obj_address(obj);
address+=(attr/8);
if (story[address]&flags[attr%8])
  story[address]-=flags[attr%8];
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_ret()
{
do_print(read_text(exe_loc,false)+'\n');
ret_routine(1);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_or(unsigned short a, unsigned short b)
{
unsigned short result=(a|b);
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_prop_addr(unsigned short obj, unsigned char prop)
{
unsigned short result=prop_addr(obj,prop);
if (result){
  if (story[VERSION]>3&&story[result]&128)
    result++;
  result++;};
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_next_prop(unsigned short obj, unsigned char prop)
{
if (prop==0)
  if (story[VERSION]==3)
    prop=32;
  else
    prop=64;

for (prop--;prop>0;prop--)
  if (prop_addr(obj,prop))
    break;

write_var(prop,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_div(short a, short b)
{
short result=(a/b);
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_mod(short a, short b)
{
short result=a%b;
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_random(short range)
{
unsigned short result=0;

if (range<0)
  srand(-range);
else
  if (range==0)
    randomize();
  else
    result=random(range)+1;

write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_get_prop_len(unsigned short address)
{
unsigned char result;

if (address == 0) {
  result = 0;
}
else {
  address--;
  if (story[VERSION]==3) {
    result=story[address]/32+1;
  }
  else{
    if (story[address]&128){
      result=story[address]<<2;
      result=result>>2;
      if (result==0)
        result=64;}
    else
      if (story[address]&64)
        result=2;
      else
        result=1;
  }
}

write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_dec(unsigned char var)
{
short num=read_var(var);
num--;
write_var(num,var);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_addr(unsigned short address)
{
do_print(read_text(address,false));
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_remove_obj(unsigned short obj)
{
object a=read_obj(obj);

if (a.parent){
  object b=read_obj(a.parent);
  if (b.child==a.num)
    b.child=a.sibling;
  else{
    b=read_obj(b.child);
    while (b.sibling!=a.num)
      b=read_obj(b.sibling);
    b.sibling=a.sibling;};
  write_obj(b);
  a.parent=0;
  a.sibling=0;
  write_obj(a);};
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_print_paddr(unsigned short address)
{
do_print(read_text(address*pack,false));
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_load(unsigned char var)
{
unsigned short result=(var == 0 ? read_stack() : read_var(var));
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_not(unsigned short num)
{
unsigned short result=~num;
write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_nop()
{
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_save(bool aux_file,unsigned short table,unsigned short bytes,unsigned short name)
{
bool written=false;

if (aux_file){
  String filename="";
  int count=story[name];
  name++;
  for (int i=0;i<count;i++){
    filename+=(char)story[name];
    name++;};
  filename=filename.UpperCase();
  if (ExtractFileExt(filename)=="")
    filename+=".AUX";
  written=true;
  try{
    TFileStream *aux_file=new TFileStream(filename,fmCreate);
    aux_file->Write(&story[table],bytes);
    delete aux_file;}
  catch (TObject *EFCreateError){
    written=false;};}

else{
  char filename[256];
  if (glk->save_file_dialog(filename)){
    TMemoryStream *game=new TMemoryStream();
    save_to_stream(game);
    written=true;
    try{
      game->SaveToFile(filename);}
    catch(TObject *EFCreateError){
      written=false;};
    delete game;};};

glk->saved=written;
if (story[VERSION]==3)
  branch(written);
else{
  write_var(written,story[exe_loc]);
  exe_loc++;};
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_restore()
{
unsigned char result=2;
char filename[256];

if (glk->restore_file_dialog(filename)){
  TMemoryStream *game=new TMemoryStream();
  if (FileExists(filename))
    game->LoadFromFile(filename);
  else{
    result=0;};
  if (result&&!restore_from_stream(game)){
    result=0;};
  game->Clear();}


else{
  result=0;};

glk->saved=result;
if (story[VERSION]==3)
  branch(result);
else{
  write_var(result,story[exe_loc]);
  exe_loc++;};
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_restart()
{
unsigned char flags2=story[FLAGS2];
memcpy(story,dynamic,read_word(STATIC_MEM));
prepare_header();
init_exe();
story[FLAGS2]=flags2;
if (story[FLAGS2]&1)
  stream2=true;
};
//----------------------------------------------------------------------------
void ZMACHINE::save_to_stream(TMemoryStream *game)
{
game->Clear();

save_string("FORM",game);
save_long(0,game);
save_string("IFZS",game);
save_string("IFhd",game);
save_long(13,game);
save_short(read_word(RELEASE),game);
for (int i=0;i<6;i++)
  save_string((char)story[SERIAL_NUM+i],game);
save_short(read_word(CHECKSUM),game);
save_24bit(exe_loc,game);
save_char(0,game);

save_string("CMem",game);
save_long(0,game);
int size=read_word(STATIC_MEM);
unsigned char *tmp=new unsigned char[size];
for (int i=0;i<size;i++)
  tmp[i]=story[i]^dynamic[i];
int i=0;
unsigned int count=0;
while (i<size){
  while (i<size&&tmp[i]){
    save_char(tmp[i],game);
    i++;
    count++;};
  int null_count=0;
  while (i<size&&!tmp[i]&&null_count<256){
    i++;
    null_count++;};
  if (null_count){
    save_char(0,game);
    save_char(null_count-1,game);
    count+=2;};};
game->Seek(38,soFromBeginning);
save_long(count,game);
game->Seek(0,soFromEnd);
if (game->Size%2)
  save_char(0,game);
delete tmp;

save_string("Stks",game);
save_long(0,game);
count=0;
for (i=0;i<=frame_count;i++){
  save_24bit(stack[i].return_pc,game);
  save_char(stack[i].local_count,game);
  save_char(stack[i].result_var,game);
  save_char(stack[i].args,game);
  save_short(stack[i].stack_count,game);
  count+=8;
  int local_limit=stack[i].local_count;
  if (local_limit>15)
    local_limit-=16;
  for (int j=0;j<local_limit;j++){
    save_short(stack[i].local[j],game);
    count+=2;};
  for (int j=0;j<stack[i].stack_count;j++){
    save_short(stack[i].stack[j],game);
    count+=2;};};
game->Seek(-(count)-4,soFromCurrent);
save_long(count,game);

game->Seek(4,soFromBeginning);
save_long(game->Size-8,game);

if (game->Size%2){
  game->Seek(0,soFromEnd);
  save_char(0,game);};
};
//----------------------------------------------------------------------------
bool ZMACHINE::restore_from_stream(TStream *game)
{
int tmp_exe;
unsigned char *tmp_mem;
game->Seek(0,soFromBeginning);

if (restore_string(4,game)!="FORM")
  return (false);
unsigned int file_size=restore_long(game)+8;
if (restore_string(4,game)!="IFZS")
  return(false);

if (!seek_chunk("IFhd",file_size,game))
  return(false);
unsigned int chunk_size=restore_long(game);
if (chunk_size!=13)
  return(false);
if (restore_short(game)!=read_word(RELEASE))
  return(false);
for (int i=0;i<6;i++)
  if (restore_string(1,game)!=(char)story[SERIAL_NUM+i])
    return(false);
if (restore_short(game)!=read_word(CHECKSUM))
  return(false);
tmp_exe=restore_24bit(game);

if (!seek_chunk("CMem",file_size,game))
  return (false);
chunk_size=restore_long(game);
tmp_mem=new unsigned char[read_word(STATIC_MEM)];
memcpy(tmp_mem,dynamic,read_word(STATIC_MEM));
int chunk_pos=0;
int story_pos=0;
while (chunk_pos<chunk_size){
  unsigned char next=restore_char(game);
  if (next){
    tmp_mem[story_pos]=next^dynamic[story_pos];
    story_pos++;
    chunk_pos++;}
  else{
    int compress=restore_char(game)+1;
    story_pos+=compress;
    chunk_pos+=2;};};

if (!seek_chunk("Stks",file_size,game))
  return(false);
chunk_size=restore_long(game);
chunk_pos=0;
for (frame_count=0;chunk_pos<chunk_size;frame_count++){
  stack[frame_count].return_pc=restore_24bit(game);
  stack[frame_count].local_count=restore_char(game);
  stack[frame_count].result_var=restore_char(game);
  stack[frame_count].args=restore_char(game);
  stack[frame_count].stack_count=restore_short(game);
  chunk_pos+=8;
  int local_limit=stack[frame_count].local_count;
  if (local_limit>15)
    local_limit-=16;
  for (int i=0;i<local_limit;i++){
    stack[frame_count].local[i]=restore_short(game);
    chunk_pos+=2;};
  for (int i=0;i<stack[frame_count].stack_count;i++){
    stack[frame_count].stack[i]=restore_short(game);
    chunk_pos+=2;};};
frame_count--;

unsigned char flags2=story[FLAGS2];
memcpy(story,tmp_mem,read_word(STATIC_MEM));
story[FLAGS2]=flags2;
delete tmp_mem;

prepare_header();

if (version==3)
  glk->window_set_arrangement(upper_win-1,WINMETHOD_ABOVE|WINMETHOD_FIXED,0);

exe_loc=tmp_exe;

//game->Clear();
return(true);
};
//----------------------------------------------------------------------------

void ZMACHINE::init_exe()
{
frame_count=0;
stack[0].return_pc=0;
stack[0].local_count=0;
stack[0].result_var=0;
stack[0].args=0;
stack[0].stack_count=0;

stream1=true;
stream2=false;
stream3=false;
stream3_level=-1;
stream4=false;
playback=false;
buffering=true;
fixed_font1=false;
fixed_font2=false;
fixed_font3=false;
sound_routine=0;

split_before=false;
last_split=0;
max_split=0;

next_undo=-1;
for (int i=0;i<10;i++)
  undo_used[i]=false;

output="";

exe_loc=read_word(EXE_POINT);

if (version==3){
  glk->stream_set_current(2);
  glk->set_style(STYLE_USER1);};

glk->stream_set_current(1);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_pop()
{
pop_stack();
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_catch()
{
write_var(frame_count, story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_throw(unsigned short result, unsigned short frame)
{
frame_count = frame;
ret_routine(result);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_quit()
{
//draw_status();
glk->flush_output();
quitting=true;
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_show_status()
{
if (version==3)
  update_status();
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_verify()
{
int length=min(glk->story_size,read_word(FILE_LENGTH)*pack);
unsigned short checksum=0;
for (int i=64;i<dynamic_size;i++)
  checksum+=dynamic[i];
for (int i=dynamic_size;i<length;i++)
  checksum+=story[i];
branch(checksum==read_word(CHECKSUM));
};
//----------------------------------------------------------------------------
void ZMACHINE::update_status()
{
int width;
glk->window_get_size(3,width,NULL);
String tmp="     ";

tmp+=read_text(obj_props(read_var(16))+1,false);
int next_pos=width/2+5;
while (tmp.Length()<=next_pos)
  tmp+=" ";

if (story[FLAGS1]&2){
  tmp+="Time: ";
  short hour=(short)read_var(17);
  if (hour>12)
    hour-=12;
  else
    if (hour==0)
      hour=12;
  tmp+=hour;
  tmp+=":";
  if (read_var(18)<10)
    tmp+="0";
  tmp+=(short)read_var(18);
  if (read_var(17)<12)
    tmp+=" AM";
  else
    tmp+=" PM";}

else{
  tmp+="Score: ";
  tmp+=(short)read_var(17);
  tmp+=" / ";
  tmp+=(short)read_var(18);};

while (tmp.Length()<=width)
    tmp+=" ";

WideString out=zscii_to_uni(tmp);

glk->stream_set_current(2);
glk->window_move_cursor(3,0,0);
glk->put_string(out.c_bstr());
glk->stream_set_current(1);
};
//---------------------------------------------------------------------------

void ZMACHINE::toggle_script()
{
stream2=!stream2;
glk->transcript_menu(true);

if (stream2){
  char filename[256];
  int answer=glk->script_file_dialog(filename);
  Word mode=fmCreate;
  if (answer==FILEMODE_WRITEAPPEND)
    mode=fmOpenReadWrite;
  else{
    if (answer==0){
      story[FLAGS2]--;
      stream2=false;
      glk->transcript_menu(false);
      return;};};
  mode = (mode | fmShareDenyNone);
  try{
    scriptf=new TFileStream(filename,mode);}
  catch(TObject *EFCreateError){
    story[FLAGS2]--;
    stream2=false;
    glk->transcript_menu(false);
    return;};
  scriptf->Seek(0,soFromEnd);}

else{
  glk->transcript_menu(false);
  delete scriptf;};
};
//----------------------------------------------------------------------------

void ZMACHINE::split_window(unsigned char lines)
{
last_split=lines;

if (!split_before||lines>max_split){
  glk->window_set_arrangement(upper_win-1,WINMETHOD_ABOVE|WINMETHOD_FIXED,lines);
  max_split=lines;
  split_before=true;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_split_window(unsigned char lines)
{
split_window(lines);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_window(unsigned char window)
{
if (window==0)
  glk->stream_set_current(1);
else{
  if (version==3){
    glk->window_clear(upper_win);
    glk->stream_set_current(3);}
  else{
    glk->stream_set_current(2);};};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_2s(unsigned short routine,unsigned short argv)
{
call(routine,1,&argv,true,false);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_erase_window(short window)
{
switch (window){
  case -2:
    glk->window_clear(1);
    glk->window_clear(upper_win);
    break;
  case -1:
    glk->window_clear(1);
    glk->window_clear(upper_win);
    split_before=false;
    max_split=0;
    glk->window_set_arrangement(upper_win-1,WINMETHOD_ABOVE|WINMETHOD_FIXED,0);
    glk->stream_set_current(1);
    break;
  case 0:
    glk->window_clear(1);
    break;
  case 1:
    glk->window_clear(upper_win);
    break;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_buffer_mode(bool flag)
{
buffering=flag;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_text_style(unsigned char style)
{
switch (style){
  case ROMAN:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_REVERSECOLOR,false);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_REVERSECOLOR,false);
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_WEIGHT,0);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_WEIGHT,0);
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_OBLIQUE,false);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_OBLIQUE,false);
    if (!fixed_font3)
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,true);
    fixed_font2=false;
    break;
  case REVERSE:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_REVERSECOLOR,true);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_REVERSECOLOR,true);
    break;
  case BOLD:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_WEIGHT,1);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_WEIGHT,1);
    break;
  case ITALIC:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_OBLIQUE,true);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_OBLIQUE,true);
    break;
  case FIXED:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,false);
    fixed_font2=true;
    break;};                  
};                    
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_cursor(unsigned short line,unsigned short column)
{
int height;
glk->window_get_size(upper_win,NULL,height);                   
if (line>height)                           
  split_window(line);

glk->window_move_cursor(upper_win,max(column-1,0),max(line-1,0));
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_1s(unsigned short routine)
{
call(routine,0,NULL,true,false);
};
//----------------------------------------------------------------------------
void ZMACHINE::Z_read_char(bool timer,unsigned short time,unsigned short routine)
{
EVENT event;
wchar_t key_pressed[2];

unsigned int timeout;
if (timer&&time&&routine)
  timeout=(time*100);
else
  timeout=0;

output="";

check_playback(key_pressed,1);

if (playback){
  glk->flush_output();}
else{
  EVENT event;
  glk->request_char_event(glk->window_get_current());
  glk->request_timer_events(timeout);
  while (!quitting){
    glk->select(&event);
    if (event.type==EVTYPE_CHARINPUT){
      if ((unsigned int)event.val1>=0xffffffe4)
        key_pressed[0]=vk_code[(unsigned int)event.val1-0xffffffe4];
      else
        key_pressed[0]=event.val1;
      key_pressed[1]=0;
      break;};
    if (event.type==EVTYPE_TIMER){
      call(routine,0,NULL,true,true);
      main_loop();
      quitting=false;
      if (int_result){
        write_var(0,story[exe_loc-1]);
        return;}
      else{
        output="";
        exe_loc--;
        continue;};};
    if (event.type==EVTYPE_SOUNDNOTIFY){
      call(sound_routine,0,NULL,false,true);
      main_loop();
      quitting=false;
      continue;};
    if (event.type==EVTYPE_ARRANGE)
      adjust_screen_size();};};

glk->request_timer_events(0);

if (quitting)
  return;

if (split_before){
  glk->window_set_arrangement(upper_win-1,WINMETHOD_ABOVE|WINMETHOD_FIXED,last_split);
  split_before=false;};

if (stream4){
  recordf->Write(&event.val1,1);
  recordf->Write("\r\n",2);};

String write_string=uni_to_zscii(key_pressed);
write_var((unsigned char)write_string[1],story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_output_stream(short stream,unsigned short table)
{
switch (stream){
  case -4:
    toggle_recording(false);
    break;
  case -3:
    if (stream3){
      stream3_level--;
      if (stream3_level<0)
        stream3=false;};
    break;
  case -2:
    if (story[FLAGS2]&1)
      story[FLAGS2]--;
     break;
  case -1:
    stream1=false;
    break;
  case 1:
    stream1=true;
    break;
  case 2:
    if (!(story[FLAGS2]&1))
      story[FLAGS2]++;
    break;
  case 3:
    if (stream3_level<16){
      stream3=true;
      stream3_level++;
      stream3_loc[stream3_level]=table;
      stream3_text[stream3_level]="";}
    else{
//      Application->MessageBox("This story has attempted to nest output to stream 3 more than 16 levels deep.  Possible infinite loop.","ERROR!",MB_OK);
      quitting=true;};    
    break;
  case 4:
    toggle_recording(true);
   break;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_scan_table(unsigned char argc,unsigned short x,unsigned short table,unsigned short len,unsigned char form)
{
if (argc<4)
  form=130;

unsigned short address=0;
unsigned short value;
bool word=(form&128);
unsigned char skip=form<<1;
skip>>=1;

for (int i=0;i<len;i++){
  if (word)
    value=read_word(table+(i*skip));
  else
    value=story[table+(i*skip)];
  if (value==x){
    address=(table+(i*skip));
    break;};};

write_var(address,story[exe_loc]);
exe_loc++;
branch(address);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_vs2()
{
unsigned short argv[8];
unsigned char argc=v2_args(argv);
call(argv[0],argc-1,&argv[1],true,false);
};
//----------------------------------------------------------------------------

unsigned char ZMACHINE::v2_args(unsigned short *argv)
{
unsigned char argc;

exe_loc=op_base+1;

unsigned short op_type=read_word(exe_loc);
exe_loc+=2;
for (argc=0;argc<8;argc++){
  if (op_type&32768)
    if (op_type&16384)
      break;
    else{
      argv[argc]=read_var(story[exe_loc]);
      exe_loc++;}
  else
    if (op_type&16384){
      argv[argc]=story[exe_loc];
      exe_loc++;}
    else{
      argv[argc]=read_word(exe_loc);
      exe_loc+=2;};
  op_type<<=2;};

return (argc);
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_sound_effect(unsigned char argc,unsigned char sound,unsigned char effect,unsigned short volume,unsigned short routine)
{
if (argc==0)
  sound=1;

switch (sound){
  case 1:
    PlaySound("Beep1",HInstance,SND_RESOURCE|SND_NODEFAULT|SND_ASYNC);
    return;
  case 2:
    PlaySound("Beep2",HInstance,SND_RESOURCE|SND_NODEFAULT|SND_ASYNC);
    return;};

if (effect<2||effect>3)
  return;

if (effect==2){
  int vol=LOBYTE(volume);
  int repeats;
  if (version>3){
    repeats=HIBYTE(volume);
    if (repeats==255)
      repeats=-1;
    sound_routine=routine;}
  else
    if (lurking_sound_repeat[sound-3])
      repeats=-1;
    else
      repeats=1;
  if (vol>8)
    vol=8;
  glk->schannel_set_volume(1,vol*8191);
  glk->schannel_play_ext(1,sound,repeats,sound_routine);}
else
  glk->schannel_stop(1);
};
//-----------------------------------------------------------------------------

void ZMACHINE::toggle_recording(bool start)
{
if (stream4==start)
  return;

if (start){
  char filename[256];
  int answer=glk->record_file_dialog(filename);
  Word mode=fmCreate;
  if (answer==2)
    mode=fmOpenReadWrite;
  else{
    if (answer==0){
      return;};};

  try{
    recordf=new TFileStream(filename,mode);}
  catch(TObject *EFCreateError){
    return;};
  recordf->Seek(0,soFromEnd);
  stream4=true;}

else{
  stream4=false;
  recordf->Position=recordf->Position-3;
  char read_char;
  do{
    recordf->Read(&read_char,1);
    recordf->Position=recordf->Position-2;}
  while (read_char!='\n'&&recordf->Position);
  if (recordf->Position)
    recordf->Size=recordf->Position+2;
  else
    recordf->Size=0;
  delete recordf;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_input_stream(unsigned char stream)
{
if (stream==playback)
  return;

if (stream==0){
    playback=false;
    delete playf;
    glk->moring=old_moring;}

else{
  char filename[256];
  if (glk->play_file_dialog(filename)){
    playf=new TFileStream(filename,fmOpenRead);
    playback=true;
    old_moring=glk->moring;
    glk->moring=false;};};
};
//----------------------------------------------------------------------------

void ZMACHINE::check_playback(wchar_t *buffer,int limit)
{
if (playback){
  for (int i=0;i<limit;i++)
    buffer[i]=0;

  int pos=0;
  char next_char;
  while (1){
    if (playf->Position>=playf->Size-1){
      playback=false;
      delete playf;
      glk->moring=old_moring;
      return;};
    playf->Read(&next_char,1);
    if (next_char=='\n'||next_char=='\r'){
      while (playf->Read(&next_char,1)!=0&&(next_char=='\n'||next_char=='\r')){};
      playf->Position=playf->Position-1;
      break;};
    if (pos<limit){
      buffer[pos]=next_char;
      pos++;};};

  pos++;
  buffer[pos]=0;
  
  if (limit>1){
    glk->put_string(buffer);
    glk->put_string((wchar_t *)"\n");};};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_1n(unsigned short routine)
{
call(routine,0,NULL,false,false);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_vn(unsigned short routine,unsigned char argc,unsigned short *argv)
{
call(routine,argc,argv,false,false);
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_check_arg_count(unsigned char arg)
{
arg--;
branch(stack[frame_count].args&argc_mask[arg]);
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_call_2n(unsigned short routine,unsigned short argv)
{
call(routine,1,&argv,false,false);
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_copy_table(unsigned short src,unsigned short dest,short size)
{
if (dest==0){
  memset(&story[src],0,abs(size));
  return;};

if (size>0){
  unsigned char *tmp=new unsigned char[size];
  memcpy(tmp,&story[src],size);
  memcpy(&story[dest],tmp,size);
  delete tmp;
  return;};

size=abs(size);
for (int i=0;i<size;i++)
  story[dest+i]=story[src+i];
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_call_vn2()
{
unsigned short argv[8];
unsigned char argc=v2_args(argv);
call(argv[0],argc-1,&argv[1],false,false);
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_tokenise(unsigned char argc,unsigned short text,unsigned short parse,unsigned short dictionary,bool flag)
{
if (argc<4)
  flag=false;

if ((argc<3)||(dictionary==0))
  dictionary=read_word(DICTIONARY);

text++;
int num=story[text];
String input;
char next_char;
for (int i=0;i<num;i++){
  text++;
  next_char=(char)story[text];
  input+=next_char;};
input=zscii_to_uni(input);
input=input.LowerCase();
input=uni_to_zscii(input);
parse_text(input,parse,dictionary,flag);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_encode_text(unsigned short zscii_text,unsigned short length,unsigned short from,unsigned short coded_text)
{
int address=(zscii_text+from);
String text="";

for (int i=0;i<length;i++){
  text+=(char)story[address];
  address++;};
text=text.LowerCase();
if (text.Length()>9)
  text=text.SetLength(9);

unsigned char output_char[9];
memset(output_char,5,9);
for (int i=0;i<text.Length();i++){
  bool found=false;
  for (int j=0;j<26&&!found;j++){
    if (text[i+1]==alpha[0][j]){
      output_char[i]=(j+6);
      found=true;};};
  if (!found){
    quitting=true;};};

unsigned short output_short[3];
for (int i=0;i<3;i++){
  output_short[i]=output_char[(i*3)];
  output_short[i]<<=5;
  output_short[i]+=output_char[(i*3)+1];
  output_short[i]<<=5;
  output_short[i]+=output_char[(i*3)+2];};
output_short[2]+=32768;

for (int i=0;i<3;i++){
  write_word(output_short[i],coded_text);
  coded_text+=2;};
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_print_table(unsigned char argc,unsigned short text_add,unsigned short width,unsigned short height,unsigned short skip)
{
if (argc<4){
  skip=0;
  if (argc<3)
    height=1;};
String text="";
int cur_add=text_add;
int x,y;
glk->window_get_cursor(upper_win,x,y);
int needed_height=y+height;
if (max_split<needed_height)
  split_window(needed_height);

for (int i=0;i<height;i++){
  for (int j=0;j<width;j++){
    text+=(char)story[cur_add];
    cur_add++;};
  do_print(text);
  cur_add+=skip;
  text="";
  if (i<(height-1)){
    y++;
    glk->window_move_cursor(upper_win,x,y);};};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_log_shift(short num,short places)
{
short result;

if (places>0)
  result=num<<places;
else if (places <0){
  places=abs(places);
  if (num < 0) {
    num=(num & 0x7FFF);
    places--;};
  result=num>>places;}
else
  result=num;

write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_art_shift(short num,short places)
{
short result;
  
if (places>0)
  result=num<<places;
else if (places <0){
  places=abs(places);
  result=num>>places;}
else
  result=num;

write_var(result,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_save_undo()
{
next_undo++;
if (next_undo>9)
  next_undo=0;
save_to_stream(undo_stream[next_undo]);
undo_used[next_undo]=true;
write_var(1,story[exe_loc]);
exe_loc++;                                    
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_restore_undo()
{
if (next_undo<0||!undo_used[next_undo]){
  write_var(0,story[exe_loc]);
  return;};

bool result=restore_from_stream(undo_stream[next_undo]);

if (result){
  undo_used[next_undo]=false;
  next_undo--;
  if (next_undo<0)
    next_undo=9;
  write_var(2,story[exe_loc]);}
else{
  write_var(0,story[exe_loc]);};
  
exe_loc++;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_ext()
{
unsigned char opcode=story[exe_loc];
unsigned short argv[4];
int argc=get_var_args(argv);

switch (opcode){
  case SAVE2:
    Z_save(argc,argv[0],argv[1],argv[2]);
    break;
  case RESTORE2:
    Z_restore();
    break;
  case LOG_SHIFT:
    Z_log_shift(argv[0],argv[1]);
    break;
  case ART_SHIFT:
    Z_art_shift(argv[0],argv[1]);
    break;
  case SET_FONT:
    Z_set_font(argv[0]);
    break;    
  case SAVE_UNDO:
    Z_save_undo();
    break;
  case RESTORE_UNDO:
    Z_restore_undo();
    break;
  case PRINT_UNICODE:
    Z_print_unicode(argv[0]);
    break; 
  case CHECK_UNICODE:
    Z_check_unicode(argv[0]);
    break;
  case SET_TRUE_COLOR:
    Z_set_true_color(argv[0],argv[1]);
    break;
  default:
//    Application->MessageBox("Illegal opcode!","Fatal Error",MB_OK);
    quitting=true;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_font(unsigned char font)
{
static unsigned short prev_font=NORMAL_FONT;
bool result;

switch (font){
  case NORMAL_FONT:
    glk->window_char_graphics(1,false);
    glk->window_char_graphics(upper_win,false);
    if (!fixed_font2)
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,true);
    fixed_font3=false;
    result=true;
    break;
  case FIXED_FONT:
    glk->window_char_graphics(1,false);
    glk->window_char_graphics(upper_win,false);
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_PROPORTIONAL,false);
    fixed_font3=true;
    result=true;
    break;
  case PICTURE_FONT:
    result=false;
    break;
  case CHAR_GRAPHICS_FONT:
    glk->window_char_graphics(1,true);
    glk->window_char_graphics(upper_win,true);
    result=true;
    break;
  default:
    result=false;
    break;};

if (result){
  write_var(prev_font,story[exe_loc]);
  prev_font=font;}
else
  write_var(0,story[exe_loc]);
exe_loc++;
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_color(unsigned char foreground,unsigned char background)
{
int ext_loc;

switch (foreground){
  case DEFAULT:
    ext_loc=read_word(EXT_TABLE);
    if ((ext_loc>0)&&(read_word(ext_loc)>4)){
      TColor color=color_from_srgb(read_word(ext_loc+10));
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
      glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
    } else {
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,glk->prop_font->Color);
      glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,glk->fixed_font->Color);
    }
    break;
  case BLACK:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorBlack);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorBlack);
    break;
  case RED:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorRed);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorRed);
    break;
  case GREEN:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorGreen);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorGreen);
    break;
  case YELLOW:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorYellow);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorYellow);
    break;
  case BLUE:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorBlue);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorBlue);
    break;
  case MAGENTA:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorMagenta);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorMagenta);
    break;
  case CYAN:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorCyan);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorCyan);
    break;
  case WHITE:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorWhite);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorWhite);
    break;
  case LIGHT_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorLtGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorLtGray);
    break;
  case MEDIUM_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorMdGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorMdGray);
    break;
  case DARK_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorDkGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,colorDkGray);
    break;};

switch (background){
  case DEFAULT:
    ext_loc=read_word(EXT_TABLE);
    if ((ext_loc>0)&&(read_word(ext_loc)>5)){
      TColor color=color_from_srgb(read_word(ext_loc+12));
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
      glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
    } else {
      glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,glk->textbuffer_style[STYLE_NORMAL].back_color);
      glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,glk->textgrid_style[STYLE_NORMAL].back_color);
    }
    break;
  case BLACK:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorBlack);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorBlack);
    break;
  case RED:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorRed);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorRed);
    break;
  case GREEN:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorGreen);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorGreen);
    break;
  case YELLOW:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorYellow);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorYellow);
    break;
  case BLUE:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorBlue);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorBlue);
    break;
  case MAGENTA:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorMagenta);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorMagenta);
    break;
  case CYAN:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorCyan);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorCyan);
    break;
  case WHITE:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorWhite);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorWhite);
    break;
  case LIGHT_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorLtGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorLtGray);
    break;
  case MEDIUM_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorMdGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorMdGray);
    break;
  case DARK_GRAY:
    glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorDkGray);
    glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,colorDkGray);
    break;};
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_set_true_color(short foreground, short background)
{
TColor color;

if (foreground == -1) {
  glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,glk->prop_font->Color);
  glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,glk->fixed_font->Color);
}
else if (foreground != -2) {
  color = color_from_srgb(foreground);
  glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
  glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_TEXTCOLOR,color);
}

if (background == -1) {
  glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,glk->textbuffer_style[STYLE_NORMAL].back_color);
  glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,glk->textgrid_style[STYLE_NORMAL].back_color);
}
else if (background != -2) {
  color = color_from_srgb(background);
  glk->window_stylehint_set(1,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
  glk->window_stylehint_set(upper_win,STYLE_NORMAL,STYLEHINT_BACKCOLOR,color);
}
};
//----------------------------------------------------------------------------

TColor ZMACHINE::color_from_srgb(unsigned short color)
{
TColor red, green, blue;

red = (color & 0x1f);
red = (TColor) ((float) red * 8.226);
green = ((color & 0x3e0) >> 5);
green = (TColor) ((float) green * 8.226);
blue = ((color & 0x7c00) >> 10);
blue = (TColor) ((float) blue * 8.226);
return ((blue << 16) + (green << 8) + red);
};
//----------------------------------------------------------------------------

void ZMACHINE::Z_check_unicode(unsigned short char_number)
{
bool result=glk->check_unicode(glk->window_get_current(),char_number);

if (result)
  write_var(3,story[exe_loc]);
else
  write_var(0,story[exe_loc]);

exe_loc++;
};
//-----------------------------------------------------------------------------

void ZMACHINE::Z_print_unicode(unsigned short char_number)
{
wchar_t uni_out[2];
uni_out[0]=char_number;
uni_out[1]=0;
glk->put_string(uni_out);
};
//-----------------------------------------------------------------------------

unsigned char ZMACHINE::translate_term_char(unsigned int keycode)
{
  switch (keycode){
    case 0:
      return (10);
    case KEYCODE_UP:
      return (129);
    case KEYCODE_DOWN:
      return (130);
    case KEYCODE_LEFT:
      return (131);
    case KEYCODE_RIGHT:
      return (132);
    case KEYCODE_FUNC1:
      return (133);
    case KEYCODE_FUNC2:
      return (134);
    case KEYCODE_FUNC3:
      return (135);
    case KEYCODE_FUNC4:
      return (136);
    case KEYCODE_FUNC5:
      return (137);
    case KEYCODE_FUNC6:
      return (138);
    case KEYCODE_FUNC7:
      return (139);
    case KEYCODE_FUNC8:
      return (140);
    case KEYCODE_FUNC9:
      return (141);
    case KEYCODE_FUNC10:
      return (142);
    case KEYCODE_FUNC11:
      return (143);
    case KEYCODE_FUNC12:
      return (144);
    case KEYCODE_NUMPAD0:
      return (145);
    case KEYCODE_NUMPAD1:
      return (146);
    case KEYCODE_NUMPAD2:
      return (147);
    case KEYCODE_NUMPAD3:
      return (148);
    case KEYCODE_NUMPAD4:
      return (149);
    case KEYCODE_NUMPAD5:
      return (150);
    case KEYCODE_NUMPAD6:
      return (151);
    case KEYCODE_NUMPAD7:
      return (152);
    case KEYCODE_NUMPAD8:
      return (153);
    case KEYCODE_NUMPAD9:
      return (154);
    default:
      return (0);};
}


