//---------------------------------------------------------------------------
#include <vcl.h>           
#include <algorithm.h>
#include <math.hpp>
#include <math.h>
#include <utilcls.h>

#pragma hdrstop

#include "glkthread.h"
#include "gclass.h"
#include "globals.h"

//Contents of the header
#define MAGIC_NUMBER 0
#define VERSION 4
#define RAMSTART 8
#define EXTSTART 12
#define ENDMEM 16
#define STACK_SIZE 20
#define START_FUNC 24
#define DECODING_TABLE 28
#define CHECKSUM 32

//Opcodes
#define NOP 0
#define ADD 16
#define SUB 17
#define MUL 18
#define DIV 19
#define MOD 20
#define NEG 21
#define BITAND 24
#define BITOR 25                   
#define BITXOR 26
#define BITNOT 27
#define SHIFTL 28
#define SSHIFTR 29
#define USHIFTR 30
#define JUMP 32
#define JZ 34
#define JNZ 35                                                  
#define JEQ 36
#define JNE 37
#define JLT 38
#define JGE 39
#define JGT 40
#define JLE 41
#define JLTU 42
#define JGEU 43
#define JGTU 44
#define JLEU 45
#define CALL 48
#define RETURN 49
#define CATCH 50
#define THROW 51
#define TAILCALL 52
#define COPY 64
#define COPYS 65                                        
#define COPYB 66
#define SEXS 68
#define SEXB 69
#define ALOAD 72
#define ALOADS 73           
#define ALOADB 74
#define ALOADBIT 75                                   
#define ASTORE 76
#define ASTORES 77
#define ASTOREB 78
#define ASTOREBIT 79
#define STKCOUNT 80
#define STKPEEK 81
#define STKSWAP 82
#define STKROLL 83
#define STKCOPY 84
#define STREAMCHAR 112
#define STREAMNUM 113
#define STREAMSTR 114
#define STREAMUNICHAR 115
#define GESTALT 256
#define DEBUGTRAP 257
#define GETMEMSIZE 258
#define SETMEMSIZE 259
#define JUMPABS 260
#define RANDOM 272
#define SETRANDOM 273
#define QUIT 288
#define VERIFY 289
#define RESTART 290
#define SAVE 291
#define RESTORE 292
#define SAVEUNDO 293
#define RESTOREUNDO 294
#define PROTECT 295
#define GLKCALL 304
#define GETSTRINGTBL 320
#define SETSTRINGTBL 321
#define GETIOSYS 328
#define SETIOSYS 329
#define LINEARSEARCH 336
#define BINARYSEARCH 337
#define LINKEDSEARCH 338
#define CALLF 352
#define CALLFI 353
#define CALLFII 354
#define CALLFIII 355
#define MZERO 368
#define MCOPY 369
#define MALLOC 376
#define MFREE 377
#define ACCELFUNC 384
#define ACCELPARAM 385
#define NUMTOF 400
#define FTONUMZ 401
#define FTONUMN 402
#define CEIL 408
#define FLOOR 409
#define FADD 416
#define FSUB 417
#define FMUL 418
#define FDIV 419
#define FMOD 420
#define SQRT 424
#define EXP 425
#define LOG 426
#define POW 427
#define SIN 432
#define COS 433
#define TAN 434
#define ASIN 435
#define ACOS 436
#define ATAN 437
#define ATAN2 438
#define JFEQ 448
#define JFNE 449
#define JFLT 450
#define JFLE 451
#define JFGT 452
#define JFGE 453
#define JISNAN 456
#define JISINF 457

//Opcode Results
#define DISCARD 0
#define IN_MEM 1
#define IN_LOCAL 2
#define ON_STACK 3
#define SET_QUIT 4

//Stack
#define FORMAT_LOCALS frame_ptr+8
#define LOCALS_POS frame_ptr+read_slong(frame_ptr+4)


//Search Options
#define KEY_INDIRECT 1
#define ZERO_KEY_TERMINATES 2
#define RETURN_INDEX 4

//GLK Functions
#define TICK 3
#define GLK_GESTALT 4
#define GESTALT_EXT 5
#define WINDOW_ITERATE 32
#define WINDOW_GET_ROCK 33
#define WINDOW_GET_ROOT 34
#define WINDOW_OPEN 35
#define WINDOW_CLOSE 36
#define WINDOW_GET_SIZE 37
#define WINDOW_SET_ARRANGEMENT 38
#define WINDOW_GET_ARRANGEMENT 39
#define WINDOW_GET_TYPE 40
#define WINDOW_GET_PARENT 41
#define WINDOW_CLEAR 42
#define WINDOW_MOVE_CURSOR 43
#define WINDOW_GET_STREAM 44
#define WINDOW_SET_ECHO_STREAM 45
#define WINDOW_GET_ECHO_STREAM 46
#define SET_WINDOW 47
#define WINDOW_GET_SIBLING 48
#define STREAM_ITERATE 64
#define STREAM_GET_ROCK 65
#define STREAM_OPEN_FILE 66
#define STREAM_OPEN_MEMORY 67
#define STREAM_CLOSE 68
#define STREAM_SET_POSITION 69
#define STREAM_GET_POSITION 70
#define STREAM_SET_CURRENT 71
#define STREAM_GET_CURRENT 72
#define FILEREF_CREATE_TEMP 96
#define FILEREF_CREATE_BY_NAME 97
#define FILEREF_CREATE_BY_PROMPT 98
#define FILEREF_DESTROY 99
#define FILEREF_ITERATE 100
#define FILEREF_GET_ROCK 101
#define FILEREF_DELETE_FILE 102
#define FILEREF_DOES_FILE_EXIST 103
#define FILEREF_CREATE_FROM_FILEREF 104
#define PUT_CHAR 128
#define PUT_CHAR_STREAM 129
#define PUT_STRING 130
#define PUT_STRING_STREAM 131
#define PUT_BUFFER 132
#define PUT_BUFFER_STREAM 133
#define SET_STYLE 134
#define SET_STYLE_STREAM 135
#define GET_CHAR_STREAM 144
#define GET_LINE_STREAM 145
#define GET_BUFFER_STREAM 146
#define CHAR_TO_LOWER 160
#define CHAR_TO_UPPER 161
#define STYLEHINT_SET 176
#define STYLEHINT_CLEAR 177
#define STYLE_DISTINGUISH 178
#define STYLE_MEASURE 179
#define SELECT 192
#define SELECT_POLL 193
#define REQUEST_LINE_EVENT 208
#define CANCEL_LINE_EVENT 209
#define REQUEST_CHAR_EVENT 210
#define CANCEL_CHAR_EVENT 211
#define REQUEST_MOUSE_EVENT 212
#define CANCEL_MOUSE_EVENT 213
#define REQUEST_TIMER_EVENTS 214
#define IMAGE_GET_INFO 224
#define IMAGE_DRAW 225
#define IMAGE_DRAW_SCALED 226
#define WINDOW_FLOW_BREAK 232
#define WINDOW_ERASE_RECT 233
#define WINDOW_FILL_RECT 234
#define WINDOW_SET_BACKGROUND_COLOR 235
#define SCHANNEL_ITERATE 240
#define SCHANNEL_GET_ROCK 241
#define SCHANNEL_CREATE 242
#define SCHANNEL_PLAY 248
#define SCHANNEL_PLAY_EXT 249
#define SCHANNEL_STOP 250
#define SCHANNEL_SET_VOLUME 251
#define SOUND_LOAD_HINT 252
#define SET_HYPERLINK 256
#define SET_HYPERLINK_STREAM 257
#define REQUEST_HYPERLINK_EVENT 258
#define CANCEL_HYPERLINK_EVENT 259
#define BUFFER_TO_LOWER_CASE_UNI 288
#define BUFFER_TO_UPPER_CASE_UNI 289
#define BUFFER_TO_TITLE_CASE_UNI 290
#define BUFFER_CANON_DECOMPOSE_UNI 291
#define BUFFER_CANON_NORMALIZE_UNI 292
#define PUT_CHAR_UNI 296
#define PUT_STRING_UNI 297
#define PUT_BUFFER_UNI 298
#define PUT_CHAR_STREAM_UNI 299
#define PUT_STRING_STREAM_UNI 300
#define PUT_BUFFER_STREAM_UNI 301
#define GET_CHAR_STREAM_UNI 304
#define GET_BUFFER_STREAM_UNI 305
#define GET_LINE_STREAM_UNI 306
#define STREAM_OPEN_FILE_UNI 312
#define STREAM_OPEN_MEMORY_UNI 313
#define REQUEST_CHAR_EVENT_UNI 320
#define REQUEST_LINE_EVENT_UNI 321
#define SET_ECHO_LINE_EVENT 336
#define SET_TERMINATORS_LINE_EVENT 337
#define CURRENT_TIME 352
#define CURRENT_SIMPLE_TIME 353
#define TIME_TO_DATE_UTC 360
#define TIME_TO_DATE_LOCAL 361
#define SIMPLE_TIME_TO_DATE_UTC 362
#define SIMPLE_TIME_TO_DATE_LOCAL 363
#define DATE_TO_TIME_UTC 364
#define DATE_TO_TIME_LOCAL 365
#define DATE_TO_SIMPLE_TIME_UTC 366
#define DATE_TO_SIMPLE_TIME_LOCAL 367

//ACCELERATED FUNCTION PARAMETER TABLE ENTRIES
#define CLASSES_TABLE 0
#define INDIV_PROP_START 1
#define CLASS_METACLASS 2
#define OBJECT_METACLASS 3
#define ROUTINE_METACLASS 4
#define STRING_METACLASS 5
#define SELF 6
#define NUM_ATTR_BYTES 7
#define CPV_START 8

//ACCELERATED FUNCTION NAMES
#define Z_REGION 1
#define CP_TAB 2
#define RA_PR 3
#define RL_PR 4
#define OC_CL 5
#define RV_PR 6
#define OP_PR 7

const unsigned char bit_mask[]={1,2,4,8,16,32,64,128};

extern GLK *glk;

//---------------------------------------------------------------------------

void GMACHINE::run_story()
{
glk->blank_reverse=true;
glk->char_cursor=false;

Randomize();

protect.start=0;
protect.len=0;

dynamic_size=(read_long(EXTSTART)-read_long(RAMSTART));
dynamic=new unsigned char[dynamic_size];
memcpy(dynamic,&story[read_long(RAMSTART)],dynamic_size);

stack=new unsigned char[read_long(STACK_SIZE)];

for (int i=0;i<10;i++){
  undo_stream[i]=new TMemoryStream();
  undo_used[i]=false;
  heap[i].start=0;
  heap[i].len=0;};
next_undo=-1;

init_exe();

//G_accelfunc(1,1074803);
//G_accelfunc(2,1075053);
//G_accelparam(CLASSES_TABLE,0x25f2a5);
//G_accelparam(INDIV_PROP_START,0x25f099);
//G_accelfunc(3,1072650);

main_loop();

delete stack;
delete dynamic;

for (int i=0;i<10;i++)
  delete undo_stream[i];
};
//---------------------------------------------------------------------------

unsigned int __inline GMACHINE::read_long(int loc)
{
return (story[loc]<<24|story[loc+1]<<16|story[loc+2]<<8|story[loc+3]);
};
//---------------------------------------------------------------------------

void GMACHINE::init_exe()
{
mem_size=read_long(EXTSTART);
resize_mem(read_long(ENDMEM));                           
normal_mem_size=mem_size;
stack_ptr=0;
frame_ptr=0;
exe_loc=0;
io_sys=0;
ramstart=read_long(RAMSTART);
stack_size=read_long(STACK_SIZE);
memset(stack,0,stack_size);
string_table=read_long(DECODING_TABLE);
heap_count=0;
accel_count=0;
string_indirect=0;
call(read_long(START_FUNC),0,NULL);
};
//---------------------------------------------------------------------------

void GMACHINE::call(unsigned int routine,unsigned int argc,int *argv)
{
unsigned int loc=routine;
unsigned char arg_type=story[loc];
loc++;
frame_ptr=stack_ptr;
stack_ptr+=8;
do{
  for (int i=0;i<2;i++){
    stack[stack_ptr]=story[loc];
    loc++;
    stack_ptr++;};}                    
while(stack[stack_ptr-1]!=0);
if (stack_ptr%4){
  for (int i=0;i<2;i++){
    stack[stack_ptr]=0;
    stack_ptr++;};};
write_slong(stack_ptr-frame_ptr,frame_ptr+4);
unsigned int ptr=FORMAT_LOCALS;
while (stack[ptr]!=0){
  memset(&stack[stack_ptr],0,stack[ptr]*stack[ptr+1]);
  stack_ptr+=(stack[ptr]*stack[ptr+1]);
  ptr+=2;
  while ((stack[ptr])&&(stack_ptr%stack[ptr])){
    stack_ptr++;};};
if (stack_ptr%4){
  for (int i=0;i<2;i++){
    stack[stack_ptr]=0;
    stack_ptr++;};};
write_slong(stack_ptr-frame_ptr,frame_ptr);

if (arg_type==0xC0){
  for (int i=argc-1;i>=0;i--){
    push_stack(argv[i]);};
  push_stack(argc);}
else{
  int pos_adj=0;
  int count=0;
  unsigned int write_addr=0;
  for (int i=0;i<argc&&stack[FORMAT_LOCALS+pos_adj]!=0;i++){
    write_local(argv[i],write_addr,stack[FORMAT_LOCALS+pos_adj]);
    write_addr+=stack[FORMAT_LOCALS+pos_adj];
    count++;
    if (count>=stack[FORMAT_LOCALS+pos_adj+1]){
      pos_adj+=2;
      count=0;};};};

for (int i=0;i<accel_count;i++){
  if (accel[i].address==routine){
    if ((accel[i].func_num==Z_REGION&&argc==1)||(accel[i].func_num!=Z_REGION&&argc==2)){
      call_accel(accel[i].func_num,argv[0],argv[1]);
      return;};};};

exe_loc=loc;
};
//---------------------------------------------------------------------------

void __inline GMACHINE::push_stub(unsigned int dest_type,unsigned int dest_addr)
{
push_stack(dest_type);
push_stack(dest_addr);
push_stack(exe_loc);
push_stack(frame_ptr);
};
//----------------------------------------------------------------------------

void __inline GMACHINE::pop_stub(unsigned int &dest_type,unsigned int &dest_addr)
{
frame_ptr=pop_stack();
exe_loc=pop_stack();
dest_addr=pop_stack();
dest_type=pop_stack();
};
//----------------------------------------------------------------------------

unsigned int __inline GMACHINE::pop_stack()
{
stack_ptr-=4;
return (read_slong(stack_ptr));
};
//---------------------------------------------------------------------------

void __inline GMACHINE::exe_opcode()
{
unsigned int opcode;
if (story[exe_loc]&128){
  if (story[exe_loc]&64){
    opcode=(read_long(exe_loc)-0xC0000000);
    exe_loc+=4;}
  else{
    opcode=(read_word(exe_loc)-0x8000);
    exe_loc+=2;};}
else{
  opcode=story[exe_loc];
  exe_loc++;};

int argv[7];

switch (opcode){
  case NOP:
    G_nop();
    return;
  case ADD:
    get_args(2,true,argv);
    G_add(argv[0],argv[1]);
    return;
  case SUB:
    get_args(2,true,argv);
    G_sub(argv[0],argv[1]);
    return;
  case MUL:
    get_args(2,true,argv);
    G_mul(argv[0],argv[1]);
    return;
  case DIV:
    get_args(2,true,argv);
    G_div(argv[0],argv[1]);
    return;
  case MOD:
    get_args(2,true,argv);
    G_mod(argv[0],argv[1]);
    return;
  case NEG:
    get_args(1,true,argv);
    G_neg(argv[0]);
    return;
  case BITAND:
    get_args(2,true,argv);
    G_bitand(argv[0],argv[1]);
    return;
  case BITOR:
    get_args(2,true,argv);
    G_bitor(argv[0],argv[1]);
    return;
  case BITXOR:
    get_args(2,true,argv);
    G_bitxor(argv[0],argv[1]);
    return;
  case BITNOT:
    get_args(1,true,argv);
    G_bitnot(argv[0]);
    return;
  case SHIFTL:
    get_args(2,true,argv);
    G_shiftl(argv[0],argv[1]);
    return;
  case SSHIFTR:
    get_args(2,true,argv);
    G_sshiftr(argv[0],argv[1]);
    return;
  case USHIFTR:
    get_args(2,true,argv);
    G_ushiftr(argv[0],argv[1]);
    return;
  case JUMP:
    get_args(1,false,argv);
    G_jump(argv[0]);
    return;
  case JZ:
    get_args(2,false,argv);
    G_jz(argv[0],argv[1]);
    return;
  case JNZ:
    get_args(2,false,argv);
    G_jnz(argv[0],argv[1]);
    return;  
  case JEQ:
    get_args(3,false,argv);
    G_jeq(argv[0],argv[1],argv[2]);
    return;    
  case JNE:
    get_args(3,false,argv);
    G_jne(argv[0],argv[1],argv[2]);
    return;  
  case JLT:
    get_args(3,false,argv);
    G_jlt(argv[0],argv[1],argv[2]);
    return;
  case JGE:
    get_args(3,false,argv);
    G_jge(argv[0],argv[1],argv[2]);
    return; 
  case JGT:
    get_args(3,false,argv);
    G_jgt(argv[0],argv[1],argv[2]);
    return;
  case JLE:
    get_args(3,false,argv);
    G_jle(argv[0],argv[1],argv[2]);
    return;
  case JLTU:
    get_args(3,false,argv);
    G_jltu(argv[0],argv[1],argv[2]);
    return;
  case JGEU:
    get_args(3,false,argv);
    G_jgeu(argv[0],argv[1],argv[2]);
    return;
  case JGTU:
    get_args(3,false,argv);
    G_jgtu(argv[0],argv[1],argv[2]);
    return;
  case JLEU:
    get_args(3,false,argv);
    G_jleu(argv[0],argv[1],argv[2]);
    return;
  case CALL:
    get_args(2,true,argv);
    G_call(argv[0],argv[1]);
    return;
  case RETURN:
    get_args(1,false,argv);
    G_return(argv[0]);
    return;
  case CATCH:
    G_catch();
    return;
  case THROW:
    get_args(2,false,argv);
    G_throw(argv[0],argv[1]);
    return;
  case TAILCALL:
    get_args(2,false,argv);
    G_tailcall(argv[0],argv[1]);
    return; 
  case COPY:
    get_args(1,true,argv);
    G_copy(argv[0]);
    return;
  case COPYS:
    get_args(1,true,argv,2);
    G_copys(argv[0]);
    return;
  case COPYB:
    get_args(1,true,argv,1);
    G_copyb(argv[0]);
    return;
  case SEXS:
    get_args(1,true,argv);
    G_sexs(argv[0]);
    return;
  case SEXB:
    get_args(1,true,argv);
    G_sexb(argv[0]);
    return;
  case ALOAD:
    get_args(2,true,argv);
    G_aload(argv[0],argv[1]);
    return;       
  case ALOADS:
    get_args(2,true,argv);
    G_aloads(argv[0],argv[1]);
    return;
  case ALOADB:
    get_args(2,true,argv);
    G_aloadb(argv[0],argv[1]);
    return;
  case ALOADBIT:
    get_args(2,true,argv);
    G_aloadbit(argv[0],argv[1]);
    return;
  case ASTORE:
    get_args(3,false,argv);
    G_astore(argv[0],argv[1],argv[2]);
    return;
  case ASTORES:
    get_args(3,false,argv);
    G_astores(argv[0],argv[1],argv[2]);
    return;
  case ASTOREB:
    get_args(3,false,argv);
    G_astoreb(argv[0],argv[1],argv[2]);
    return;
  case ASTOREBIT:
    get_args(3,false,argv);
    G_astorebit(argv[0],argv[1],argv[2]);
    return;
  case STKCOUNT:
    get_args(0,true);
    G_stkcount();
    return;
  case STKPEEK:
    get_args(1,true,argv);
    G_stkpeek(argv[0]);
    return;
  case STKSWAP:
    G_stkswap();
    return;
  case STKROLL:
    get_args(2,false,argv);
    G_stkroll(argv[0],argv[1]);
    return;
  case STKCOPY:
    get_args(1,false,argv);
    G_stkcopy(argv[0]);
    return;
  case STREAMCHAR:
  case STREAMUNICHAR:
    get_args(1,false,argv);
    G_streamchar(argv[0]);
    return;
  case STREAMNUM:
    get_args(1,false,argv);
    G_streamnum(argv[0]);
    return;
  case STREAMSTR:
    get_args(1,false,argv);
    G_streamstr(argv[0]);
    return;
  case GESTALT:
    get_args(2,true,argv);
    G_gestalt(argv[0],argv[1]);
    return;
  case DEBUGTRAP:
    get_args(1,false,argv);
    G_debugtrap(argv[0]);
    return;
  case GETMEMSIZE:
    get_args(0,true);
    G_getmemsize();
    return;
  case SETMEMSIZE:
    get_args(1,true,argv);
    G_setmemsize(argv[0]);
    return;
  case JUMPABS:
    get_args(1,false,argv);
    G_jumpabs(argv[0]);
    return;
  case RANDOM:
    get_args(1,true,argv);
    G_random(argv[0]);
    return;
  case SETRANDOM:
    get_args(1,false,argv);
    G_setrandom(argv[0]);
    return;
  case QUIT:
    G_quit();
    return;
  case VERIFY:
    get_args(0,true);
    G_verify();
    return;
  case RESTART:
    G_restart();
    return;
  case SAVE:
    get_args(1,true,argv);
    G_save(argv[0]);
    return;
  case RESTORE:
    get_args(1,true,argv);
    G_restore(argv[0]);
    return;
  case SAVEUNDO:
    get_args(0,true);
    G_saveundo();
    return;
  case RESTOREUNDO:
    get_args(0,true);
    G_restoreundo();
    return;
  case PROTECT:
    get_args(2,false,argv);
    G_protect(argv[0],argv[1]);
    return;
  case GLKCALL:
    get_args(2,true,argv);
    G_glk(argv[0],argv[1]);
    return;
  case GETSTRINGTBL:
    get_args(0,true);
    G_getstringtbl();
    return;
  case SETSTRINGTBL:
    get_args(1,false,argv);
    G_setstringtbl(argv[0]);
    return;
  case GETIOSYS:
    G_getiosys();
    return;
  case SETIOSYS:
    get_args(2,false,argv);
    G_setiosys(argv[0],argv[1]);
    return;
  case LINEARSEARCH:
    get_args(7,true,argv);
    G_linearsearch(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5],argv[6]);
    return;
  case BINARYSEARCH:
    get_args(7,true,argv);
    G_binarysearch(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5],argv[6]);
    return;
  case LINKEDSEARCH:
    get_args(6,true,argv);
    G_linkedsearch(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]);
    return;
  case CALLF:
    get_args(1,true,argv);
    G_callf(argv[0]);
    return;
  case CALLFI:
    get_args(2,true,argv);
    G_callfi(argv[0],argv[1]);
    return; 
  case CALLFII:
    get_args(3,true,argv);
    G_callfii(argv[0],argv[1],argv[2]);
    return;
  case CALLFIII:
    get_args(4,true,argv);
    G_callfiii(argv[0],argv[1],argv[2],argv[3]);
    return;
  case MZERO:
    get_args(2,false,argv);
    G_mzero(argv[0],argv[1]);
    return;
  case MCOPY:
    get_args(3,false,argv);
    G_mcopy(argv[0],argv[1],argv[2]);
    return;
  case MALLOC:
    get_args(1,true,argv);
    G_malloc(argv[0]);
    return;
  case MFREE:
    get_args(1,false,argv);
    G_mfree(argv[0]);
    return;
  case ACCELFUNC:
    get_args(2,false,argv);
    G_accelfunc(argv[0],argv[1]);
    return;
  case ACCELPARAM:
    get_args(2,false,argv);
    G_accelparam(argv[0],argv[1]);
    return;
  case NUMTOF:
    get_args(1,true,argv);
    G_numtof(argv[0]);
    return;
  case FTONUMZ:
    get_args(1,true,argv);
    G_ftonumz(argv[0]);
    return;
  case FTONUMN:
    get_args(1,true,argv);
    G_ftonumn(argv[0]);
    return;
  case CEIL:
    get_args(1,true,argv);
    G_ceil(argv[0]);
    return;
  case FLOOR:
    get_args(1,true,argv);
    G_floor(argv[0]);
    return;
  case FADD:
    get_args(2,true,argv);
    G_fadd(argv[0],argv[1]);
    return;
  case FSUB:
    get_args(2,true,argv);
    G_fsub(argv[0],argv[1]);
    return;
  case FMUL:
    get_args(2,true,argv);
    G_fmul(argv[0],argv[1]);
    return;
  case FDIV:
    get_args(2,true,argv);
    G_fdiv(argv[0],argv[1]);
    return;
  case FMOD:
    G_fmod();
    return;
  case SQRT:
    get_args(1,true,argv);
    G_sqrt(argv[0]);
    return;
  case EXP:
    get_args(1,true,argv);
    G_exp(argv[0]);
    return;
  case LOG:
    get_args(1,true,argv);
    G_log(argv[0]);
    return;
  case POW:
    get_args(2,true,argv);
    G_pow(argv[0],argv[1]);
    return;
  case SIN:
    get_args(1,true,argv);
    G_sin(argv[0]);
    return;
  case COS:
    get_args(1,true,argv);
    G_cos(argv[0]);
    return;
  case TAN:
    get_args(1,true,argv);
    G_tan(argv[0]);
    return;
  case ASIN:
    get_args(1,true,argv);
    G_asin(argv[0]);
    return;
  case ACOS:
    get_args(1,true,argv);
    G_acos(argv[0]);
    return;
  case ATAN:
    get_args(1,true,argv);
    G_atan(argv[0]);
    return;
  case ATAN2:
    get_args(2,true,argv);
    G_atan2(argv[0],argv[1]);
    return;
  case JFEQ:
    get_args(4,false,argv);
    G_jfeq(argv[0],argv[1],argv[2],argv[3]);
    return;
  case JFNE:
    get_args(4,false,argv);
    G_jfne(argv[0],argv[1],argv[2],argv[3]);
    return;
  case JFLT:
    get_args(3,false,argv);
    G_jflt(argv[0],argv[1],argv[2]);
    return;
  case JFLE:
    get_args(3,false,argv);
    G_jfle(argv[0],argv[1],argv[2]);
    return;
  case JFGT:
    get_args(3,false,argv);
    G_jfgt(argv[0],argv[1],argv[2]);
    return;
  case JFGE:
    get_args(3,false,argv);
    G_jfge(argv[0],argv[1],argv[2]);
    return;
  case JISNAN:
    get_args(2,false,argv);
    G_jisnan(argv[0],argv[1]);
    return;
  case JISINF:
    get_args(2,false,argv);
    G_jisinf(argv[0],argv[1]);
    return;};

String msg="Unknown opcode number ";
msg+=IntToHex((int)opcode,3);
msg+=" encountered at address ";
msg+=IntToHex((int)op_base,8);
msg+=".";
glk->error_message(msg.c_str());
quitting=true;
};
//---------------------------------------------------------------------------

void __inline GMACHINE::get_args(int argc,bool result_var,int *argv,unsigned int arg_size)
{
unsigned char arg_type[10];
int limit=argc;
if (result_var) limit++;
for (int i=0;i<limit;i++){
  if (i%2==0){
    arg_type[i]=story[exe_loc]&0x0F;}
  else{
    arg_type[i]=(story[exe_loc]&0xF0)>>4;
    exe_loc++;};};
if (limit%2)
  exe_loc++;

for (int i=0;i<argc;i++)
  argv[i]=get_arg(arg_type[i],arg_size);

if (result_var)
  result_format=arg_type[argc];
};
//---------------------------------------------------------------------------

int __inline GMACHINE::get_arg(unsigned char arg_type,int arg_size)
{
int result;

switch (arg_type){
  case 0:
    result=0;
    return (result);;
  case 1:
    result=(char)story[exe_loc];
    exe_loc++;
    return (result);;
  case 2:
    result=(short)read_word(exe_loc);
    exe_loc+=2;
    return (result);;
  case 3:
    result=read_long(exe_loc);
    exe_loc+=4;
    return (result);;
  case 5:
    if (arg_size==4)
      result=read_long(story[exe_loc]);
    else
      if (arg_size==2)
        result=read_word(story[exe_loc]);
      else
        result=story[story[exe_loc]];
    exe_loc++;
    return (result);;
  case 6:
    if (arg_size==4)
      result=read_long(read_word(exe_loc));
    else
      if (arg_size==2)
        result=read_word(read_word(exe_loc));
      else
        result=story[read_word(exe_loc)];
    exe_loc+=2;
    return (result);;
  case 7:
    if (arg_size==4)
      result=read_long(read_long(exe_loc));
    else
      if (arg_size==2)
        result=read_word(read_long(exe_loc));
      else
        result=story[read_long(exe_loc)];
    exe_loc+=4;
    return (result);;
  case 8:
    result=pop_stack();
    return (result);;
  case 9:
    result=read_local(story[exe_loc],arg_size);
    exe_loc++;
    return (result);;
  case 10:
    result=read_local(read_word(exe_loc),arg_size);
    exe_loc+=2;
    return (result);;
  case 11:
    result=read_local(read_long(exe_loc),arg_size);
    exe_loc+=4;
    return (result);;
  case 13:
    if (arg_size==4)
      result=read_long(ramstart+story[exe_loc]);
    else
      if (arg_size==2)
        result=read_word(ramstart+story[exe_loc]);
      else
        result=story[ramstart+story[exe_loc]];
    exe_loc++;
    return (result);;
  case 14:
    if (arg_size==4)
      result=read_long(ramstart+read_word(exe_loc));
    else
      if (arg_size==2)
        result=read_word(ramstart+read_word(exe_loc));
      else
        result=story[ramstart+read_word(exe_loc)];
    exe_loc+=2;
    return (result);;
  case 15:
    if (arg_size==4)
      result=read_long(ramstart+read_long(exe_loc));
    else
      if (arg_size==2)
        result=read_word(ramstart+read_long(exe_loc));
      else
        result=story[ramstart+read_long(exe_loc)];
    exe_loc+=4;
    return (result);};

String msg="Bad argument data encountered for statement at address ";
msg+=IntToHex((int)op_base,8);
msg+=".";
glk->error_message(msg.c_str());
quitting=true;
return (false);
};
//---------------------------------------------------------------------------

int __inline GMACHINE::read_local(unsigned int address,unsigned int size)
{
int result;
switch (size){
  case 1:
    result=stack[LOCALS_POS+address];
    break;
  case 2:
    result=read_sword(LOCALS_POS+address);
    break;
  case 4:
    result=read_slong(LOCALS_POS+address);
    break;};

return (result);
};
//---------------------------------------------------------------------------

void __inline GMACHINE::write_local(int value,unsigned int address,unsigned int size)
{
switch (size){
  case 1:
    stack[LOCALS_POS+address]=value;
    break;
  case 2:
    write_sword(value,LOCALS_POS+address);
    break;
  case 4:
    write_slong(value,LOCALS_POS+address);};
};
//---------------------------------------------------------------------------

void GMACHINE::main_loop()
{
while (!quitting){
  op_base=exe_loc;
  exe_opcode();};
};
//---------------------------------------------------------------------------

void GMACHINE::G_call(unsigned int address,unsigned int argc)
{
int *argv=new int[argc];
for (int i=0;i<argc;i++)
  argv[i]=pop_stack();

unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
call(address,argc,argv);

delete argv;
};
//---------------------------------------------------------------------------

void GMACHINE::result_code(unsigned int &type,unsigned int &address)
{
switch (result_format){
  case 0:
    type=DISCARD;
    address=0;
    return;
  case 5:
    type=IN_MEM;
    address=story[exe_loc];
    exe_loc++;
    return;
  case 6:
    type=IN_MEM;
    address=read_word(exe_loc);
    exe_loc+=2;
    return;
  case 7:
    type=IN_MEM;
    address=read_long(exe_loc);
    exe_loc+=4;
    return;
  case 8:
    type=ON_STACK;
    address=0;
    return;
  case 9:
    type=IN_LOCAL;
    address=story[exe_loc];
    exe_loc++;
    return;
  case 10:
    type=IN_LOCAL;
    address=read_word(exe_loc);
    exe_loc+=2;
    return;
  case 11:
    type=IN_LOCAL;
    address=read_long(exe_loc);
    exe_loc+=4;
    return;
  case 13:
    type=IN_MEM;
    address=(ramstart+story[exe_loc]);
    exe_loc++;
    return;
  case 14:
    type=IN_MEM;
    address=(ramstart+read_word(exe_loc));
    exe_loc+=2;
    return;
  case 15:
    type=IN_MEM;
    address=(ramstart+read_long(exe_loc));
    exe_loc+=4;
    return;};

String msg="Bad argument data encountered for statement at address ";
msg+=IntToHex((int)op_base,8);
msg+=".";
glk->error_message(msg.c_str());
quitting=true;
return;
};
//---------------------------------------------------------------------------

void GMACHINE::G_callfii(unsigned int address,int argv1,int argv2)
{
int *argv=new int[2];
argv[0]=argv1;
argv[1]=argv2;

unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
call(address,2,argv);

delete argv;
};
//---------------------------------------------------------------------------

void __inline GMACHINE::put_result(int result,unsigned int arg_size)
{
unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
write_result(result,dest_type,dest_address,arg_size);
};
//----------------------------------------------------------------------------

void __inline GMACHINE::write_result(int result,unsigned int dest_type,unsigned int dest_address,unsigned int arg_size)
{
switch (dest_type){
  case DISCARD:
    return;
  case IN_MEM:
    if (arg_size==4)
      write_long(result,dest_address);
    else
      if (arg_size==2)
        write_word(result,dest_address);
      else
        story[dest_address]=result;
    return;
  case IN_LOCAL:
    write_local(result,dest_address,arg_size);
    return;
  case ON_STACK:
    push_stack(result);
    return;
  case SET_QUIT:
    quitting=true;
    return;};
};
//----------------------------------------------------------------------------

void __inline GMACHINE::write_long(int value,unsigned int address)
{
story[address]=value>>24;
story[address+1]=value>>16;
story[address+2]=value>>8;
story[address+3]=value;
};
//----------------------------------------------------------------------------

void GMACHINE::G_copy(int value)
{
put_result(value);
};
//----------------------------------------------------------------------------

void GMACHINE::G_sub(int val1,int val2)
{
put_result(val1-val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_callfi(unsigned int address,int argv)
{
unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
call(address,1,&argv);
};
//---------------------------------------------------------------------------

void GMACHINE::branch(bool result,int offset)
{
if (result){
  if (offset==0||offset==1){
    ret(offset);
    return;};
  exe_loc+=(offset-2);};
};
//---------------------------------------------------------------------------

void GMACHINE::ret(int val)
{
stack_ptr=frame_ptr;
if (stack_ptr==0){
  quitting=true;
  return;};

unsigned int dest_type,dest_address;
pop_stub(dest_type,dest_address);
write_result(val,dest_type,dest_address);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jlt(int val1,int val2,int offset)
{
branch(val1<val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::resize_mem(unsigned int size)
{
story=(unsigned char *)realloc(story,size);
if (size>mem_size)
//  memset(&story[read_long(EXTSTART)],0,read_long(ENDMEM)-read_long(EXTSTART));
   memset(&story[mem_size],0,size-mem_size);

int dyn_tmp=size-read_long(RAMSTART);
dynamic=(unsigned char *)realloc(dynamic,dyn_tmp);
if (dyn_tmp>dynamic_size)
  memset(&dynamic[dynamic_size],0,dyn_tmp-dynamic_size);
dynamic_size=dyn_tmp;
                                    
mem_size=size;
};
//---------------------------------------------------------------------------

void GMACHINE::G_getmemsize()
{
put_result(mem_size);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jgeu(unsigned int val1,unsigned int val2,int offset)
{
branch(val1>=val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_aloadb(unsigned int addr1,int addr2)
{
put_result(story[addr1+addr2]);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jgt(int val1,int val2,int offset)
{
branch(val1>val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_aload(unsigned int addr1,int addr2)
{
put_result(read_long(addr1+4*addr2));
};
//---------------------------------------------------------------------------

void GMACHINE::G_return(int value)
{
ret(value);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jne(int val1,int val2,int offset)
{
branch(val1!=val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jeq(int val1,int val2,int offset)
{
branch(val1==val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_bitand(int val1,int val2)
{
put_result(val1&val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jz(int val,int offset)
{
branch(val==0,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jnz(int val,int offset)
{
branch(val!=0,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_add(int val1,int val2)
{
put_result(val1+val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_binarysearch(int key,unsigned int keysize,unsigned int start,unsigned int structsize,unsigned int numstructs,unsigned int keyoffset,unsigned int options)
{
unsigned char *cmp=new unsigned char[keysize];
if (options&KEY_INDIRECT){
  memcpy(cmp,&story[key],keysize);}
else{
  memset(cmp,0,keysize);
  switch (keysize){
    case 4:
      cmp[0]=key>>24;
      cmp[1]=key>>16;
      cmp[2]=key>>8;
      cmp[3]=key;
      break;
    case 2:
      cmp[0]=key>>8;
      cmp[1]=key;
      break;
    case 1:
      cmp[0]=key;
      break;
    default:
      glk->error_message("Game attempted a binary search with invalid or corrupt parameters.");
      return;};};

int left=0;
int right=numstructs-1;
while (left<=right){
  unsigned int midpt=(left+right)/2;
  unsigned int address=start+(midpt*structsize)+keyoffset;
  int chk=memcmp(cmp,&story[address],keysize);
  if (chk==0){
    if (options&RETURN_INDEX){
      put_result(midpt);}
    else{
      put_result(start+(midpt*structsize));};
    return;};
  if (chk>0){
    left=midpt+1;}
  else{
    right=midpt-1;};};

if (options&RETURN_INDEX)
  put_result(-1);
else
  put_result(0);

delete cmp;
};
//---------------------------------------------------------------------------

void GMACHINE::G_linearsearch(int key,unsigned int keysize,unsigned int start,unsigned int structsize,unsigned int numstructs,unsigned int keyoffset,unsigned int options)
{
unsigned char *cmp=new unsigned char[keysize];
if (options&KEY_INDIRECT){
  memcpy(cmp,&story[key],keysize);}
else{
  memset(cmp,0,keysize);
  switch (keysize){
    case 4:
      cmp[0]=key>>24;
      cmp[1]=key>>16;
      cmp[2]=key>>8;
      cmp[3]=key;
      break;
    case 2:
      cmp[0]=key>>8;
      cmp[1]=key;
      break;
    case 1:
      cmp[0]=key;
      break;
    default:
      glk->error_message("Game attempted a linear search with invalid or corrupt parameters.");
      return;};};

unsigned char *zeros=new unsigned char [keysize];
memset(zeros,0,keysize);

int loc=start;
for (int i=0;i<numstructs;i++){
  if ((memcmp(cmp,&story[loc+keyoffset],keysize)==0)){
    if (options&RETURN_INDEX){
      put_result(i);}
    else{                        
      put_result(loc);};
    return;};
  if ((options&ZERO_KEY_TERMINATES)&&(memcmp(zeros,&story[loc+keyoffset],keysize)==0)){
    break;};
  loc+=structsize;};

if (options&RETURN_INDEX)
  put_result(-1);
else
  put_result(0);

delete zeros;
delete cmp;
};
//---------------------------------------------------------------------------

void GMACHINE::G_linkedsearch(int key,unsigned int keysize,unsigned int start,unsigned int keyoffset,unsigned int nextoffset,unsigned int options)
{
unsigned char *cmp=new unsigned char[keysize];
if (options&KEY_INDIRECT){
  memcpy(cmp,&story[key],keysize);}
else{
  memset(cmp,0,keysize);
  switch (keysize){
    case 4:
      cmp[0]=key>>24;
      cmp[1]=key>>16;
      cmp[2]=key>>8;
      cmp[3]=key;
      break;
    case 2:
      cmp[0]=key>>8;
      cmp[1]=key;
      break;
    case 1:
      cmp[0]=key;
      break;
    default:
      glk->error_message("Game attempted a linked search with invalid or corrupt parameters.");
      return;};};

unsigned char *zeros=new unsigned char [keysize];
memset(zeros,0,keysize);

int loc=start;
do{
  if (memcmp(cmp,&story[loc+keyoffset],keysize)==0){
    put_result(loc);       
    return;};
  if ((options&ZERO_KEY_TERMINATES)&&(memcmp(zeros,&story[loc+keyoffset],keysize)==0)){
    break;};
  loc=read_long(loc+nextoffset);}
while (loc);

put_result(0);

delete zeros;
delete cmp;
};
//---------------------------------------------------------------------------

void GMACHINE::G_aloadbit(unsigned int address,int bit)
{
if (bit<0&&bit%8!=0)
  address--;
address+=(bit/8);
bit=(bit%8);
if (bit<0)
  bit=(8+bit);
unsigned char test=1;
test=(test<<bit);

if (test&story[address])
  put_result(1);
else
  put_result(0);
};
//---------------------------------------------------------------------------

void GMACHINE::G_aloads(unsigned int addr1,int addr2)
{
put_result(read_word(addr1+2*addr2));
};
//---------------------------------------------------------------------------

void GMACHINE::G_mul(int val1,int val2)
{
put_result(val1*val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jge(int val1,int val2,int offset)
{
branch(val1>=val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_stkcopy(unsigned int count)
{
unsigned int loc=stack_ptr-(count*4);
int tmp;
for (int i=0;i<count;i++){
  push_stack(read_slong(loc));
  loc+=4;};
};
//---------------------------------------------------------------------------

void GMACHINE::G_callf(unsigned int address)
{
unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
call(address,0,NULL);
};
//---------------------------------------------------------------------------

void GMACHINE::G_gestalt(unsigned int selector,int arg)
{
switch (selector){
  case 0:
    put_result(0x30102);
    return;
  case 1:
    put_result(0x10000);
    return;
  case 2:
    put_result(true);
    return;
  case 3:
    put_result(true);
    return;
  case 4:
    put_result(arg<3);
    return;
  case 5:
    put_result(true);
    return;
  case 6:
    put_result(true);
    return;
  case 7:
    put_result(true);
    return;
  case 8:
    if (heap_count)
      put_result(normal_mem_size);
    else
      put_result(false);
    return;
  case 9:
      put_result(true);
      return;
  case 10:
      put_result(arg>0&&arg<8);
      return;
  case 11:
      put_result(true);
      return;
  default:
//    glk->error_message("Invalid or corrupt selector in game's Gestalt statement.");
    put_result(false);
    return;};
};
//---------------------------------------------------------------------------

void GMACHINE::G_setiosys(unsigned int sys,unsigned int func)
{
switch (sys){
  case 0:
    io_sys=0;
    return;
  case 1:
    io_sys=func;
    return;
  case 2:
    io_sys=2;
    return;
  default:
    glk->error_message("Game attempted a Setiosys to unknown id.");};
};
//---------------------------------------------------------------------------

void GMACHINE::G_callfiii(unsigned int address,int argv1,int argv2,int argv3)
{
int *argv=new int[3];
argv[0]=argv1;
argv[1]=argv2;
argv[2]=argv3;

unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
call(address,3,argv);

delete argv;
};
//---------------------------------------------------------------------------

void GMACHINE::G_glk(unsigned int func,unsigned int argc)
{
int result=0;
int ref[3];
TIME_STRUCT time;
DATE_STRUCT date;
STREAM_RESULT sresult;
EVENT eresult;                            
int argv[6];
unsigned int *array;
String txt;
char *str;
wchar_t *wstr;
WideString wide_out;

switch (func){
  case TICK:
    glk->tick();
    break;
  case GLK_GESTALT:
    glk_operands(2,argv);
    result=glk->gestalt(argv[0],argv[1]);
    break;
  case GESTALT_EXT:
    glk_operands(4,argv);
    result=glk->gestalt_ext(argv[0],argv[1],ref,argv[3]);
    for (int i=0;i<argv[3];i++)
      write_long(ref[i],argv[2]+4*i);
    break;
  case WINDOW_ITERATE:
    glk_operands(1,argv);
    result=glk->window_iterate(argv[0],ref[0]);
    write_ref(ref,1);
    break;
  case WINDOW_GET_ROCK:
    glk_operands(1,argv);
    result=glk->window_get_rock(argv[0]);
    break;
  case WINDOW_GET_ROOT:
    result=glk->window_get_root();
    break;
  case WINDOW_OPEN:
    glk_operands(5,argv);
    result=glk->window_open(argv[0],argv[1],argv[2],argv[3],argv[4]);
    break;
  case WINDOW_CLOSE:
    glk_operands(1,argv);
    glk->window_close(argv[0],sresult);
    write_sresult(sresult);
    break;
  case WINDOW_GET_SIZE:
    glk_operands(1,argv);
    glk->window_get_size(argv[0],ref[0],ref[1]);
    write_ref(ref,2);
    break;
  case WINDOW_SET_ARRANGEMENT:
    glk_operands(4,argv);
    glk->window_set_arrangement(argv[0],argv[1],argv[2],argv[3]);
    break;
  case WINDOW_GET_ARRANGEMENT:
    glk_operands(1,argv);
    glk->window_get_arrangement(argv[0],ref[0],ref[1],ref[2]);
    write_ref(ref,3);
    break;
  case WINDOW_GET_TYPE:
    glk_operands(1,argv);
    result=glk->window_get_type(argv[0]);
    break;
  case WINDOW_GET_PARENT:
    glk_operands(1,argv);
    result=glk->window_get_parent(argv[0]);
    break;
  case WINDOW_MOVE_CURSOR:
    glk_operands(3,argv);
    glk->window_move_cursor(argv[0],argv[1],argv[2]);
    break;
  case WINDOW_GET_STREAM:
    glk_operands(1,argv);
    result=glk->window_get_stream(argv[0]);
    break;
  case WINDOW_SET_ECHO_STREAM:
    glk_operands(2,argv);
    glk->window_set_echo_stream(argv[0],argv[1]);
    break;
  case WINDOW_GET_ECHO_STREAM:
    glk_operands(1,argv);
    result;glk->window_get_echo_stream(argv[0]);
    break;
  case WINDOW_CLEAR:
    glk_operands(1,argv);
    glk->window_clear(argv[0]);
    break;
  case SET_WINDOW:
    glk_operands(1,argv);
    glk->set_window(argv[0]);
    break;
  case WINDOW_GET_SIBLING:
    glk_operands(1,argv);
    result=glk->window_get_sibling(argv[0]);
    break;
  case STREAM_ITERATE:
    glk_operands(1,argv);
    result=glk->stream_iterate(argv[0],ref[0]);
    write_ref(ref,1);
    break;
  case STREAM_GET_ROCK:
    glk_operands(1,argv);
    result=glk->stream_get_rock(argv[0]);
    break;
  case STREAM_OPEN_FILE:
    glk_operands(3,argv);
    result=glk->stream_open_file(argv[0],argv[1],argv[2]);
    break;
  case STREAM_OPEN_MEMORY:
    glk_operands(4,argv);
    result=glk->stream_open_memory(&story[argv[0]],argv[1],argv[2],argv[3]);
    break;
  case STREAM_CLOSE:
    glk_operands(1,argv);
    glk->stream_close(argv[0],sresult);
    write_sresult(sresult);
    break;
  case STREAM_SET_POSITION:
    glk_operands(3,argv);
    glk->stream_set_position(argv[0],argv[1],argv[2]);
    break;
  case STREAM_GET_POSITION:
    glk_operands(1,argv);
    result=glk->stream_get_position(argv[0]);
    break;
  case STREAM_SET_CURRENT:
    glk_operands(1,argv);
    glk->stream_set_current(argv[0]);
    break;
  case STREAM_GET_CURRENT:
    result=glk->stream_get_current();
    break;
  case FILEREF_CREATE_TEMP:
    glk_operands(2,argv);
    result=glk->fileref_create_temp(argv[0],argv[1]);
    break;
  case FILEREF_CREATE_BY_NAME:
    glk_operands(3,argv);
    txt=decode_string(argv[1]);
    result=glk->fileref_create_by_name(argv[0],txt.c_str(),argv[2]);
    break;
  case FILEREF_CREATE_BY_PROMPT:
    glk_operands(3,argv);
    result=glk->fileref_create_by_prompt(argv[0],argv[1],argv[2]);
    break;
  case FILEREF_DESTROY:                
    glk_operands(1,argv);
    glk->fileref_destroy(argv[0]);
    break;
  case FILEREF_ITERATE:
    glk_operands(1,argv);
    result=glk->fileref_iterate(argv[0],ref[0]);
    write_ref(ref,1);
    break;
  case FILEREF_GET_ROCK:
    glk_operands(1,argv);
    result=glk->fileref_get_rock(argv[0]);
    break;
  case FILEREF_DELETE_FILE:
    glk_operands(1,argv);
    glk->fileref_delete_file(argv[0]);
    break;
  case FILEREF_DOES_FILE_EXIST:
    glk_operands(1,argv);
    result=glk->fileref_does_file_exist(argv[0]);
    break;
  case FILEREF_CREATE_FROM_FILEREF:
    glk_operands(3,argv);
    result=glk->fileref_create_from_fileref(argv[0],argv[1],argv[2]);
    break;
  case PUT_CHAR:
    glk_operands(1,argv);
    argv[0]=(unsigned char)argv[0];
    glk->put_char(argv[0]);
    break;
  case PUT_CHAR_STREAM:
    glk_operands(2,argv);
    argv[1]=(unsigned char)argv[1];
    glk->put_char_stream(argv[0],argv[1]);
    break;
  case PUT_STRING:
  case PUT_STRING_UNI:
    glk_operands(1,argv);
    wide_out=decode_string(argv[0]);
    glk->put_string(wide_out.c_bstr());
    break;
  case PUT_STRING_STREAM:
  case PUT_STRING_STREAM_UNI:
    glk_operands(2,argv);
    wide_out=decode_string(argv[1]);
    glk->put_string_stream(argv[0],wide_out.c_bstr());
    break;
  case PUT_BUFFER:
    glk_operands(2,argv);
    glk->put_buffer(&story[argv[0]],argv[1]);
    break;
  case PUT_BUFFER_STREAM:
    glk_operands(3,argv);
    glk->put_buffer_stream(argv[0],&story[argv[1]],argv[2]);
    break;
  case SET_STYLE:
    glk_operands(1,argv);
    glk->set_style(argv[0]);
    break;
  case SET_STYLE_STREAM:
    glk_operands(2,argv);
    glk->set_style_stream(argv[0],argv[1]);
    break;
  case GET_CHAR_STREAM:
    glk_operands(1,argv);
    result=glk->get_char_stream(argv[0]);
    break;
  case GET_LINE_STREAM:
    glk_operands(3,argv);
    result=glk->get_line_stream(argv[0],&story[argv[1]],argv[2]);
    break;
  case GET_BUFFER_STREAM:
    glk_operands(3,argv);
    result=glk->get_buffer_stream(argv[0],&story[argv[1]],argv[2]);
    break;
  case CHAR_TO_LOWER:
    glk_operands(1,argv);
    result=glk->char_to_lower(argv[0]);
     break;
  case CHAR_TO_UPPER:
    glk_operands(1,argv);
    result=glk->char_to_upper(argv[0]);
    break;
  case STYLEHINT_SET:
    glk_operands(4,argv);
    if (argv[2]==STYLEHINT_TEXTCOLOR||argv[2]==STYLEHINT_BACKCOLOR)
      argv[3]=swap_endian_color(argv[3]);
    glk->stylehint_set(argv[0],argv[1],argv[2],argv[3]);
    break;
  case STYLEHINT_CLEAR:
    glk_operands(3,argv);
    glk->stylehint_clear(argv[0],argv[1],argv[2]);
    break;
  case STYLE_DISTINGUISH:
    glk_operands(3,argv);
    result=glk->style_distinguish(argv[0],argv[1],argv[2]);
    break;
  case STYLE_MEASURE:
    glk_operands(3,argv);
    result=glk->style_measure(argv[0],argv[1],argv[2],ref[0]);
    if (result&&(argv[2]==STYLEHINT_TEXTCOLOR||argv[2]==STYLEHINT_BACKCOLOR))
      ref[0]=swap_endian_color(ref[0]);
    write_ref(ref,1);
    break;
  case SELECT:
    glk->select(&eresult);
    if (eresult.type==EVTYPE_LINEINPUT){
      process_line_input(&eresult);};
      
    if (!quitting)
      write_eresult(eresult);
    break;
  case SELECT_POLL:
    glk->select_poll(&eresult);
    if (eresult.type==EVTYPE_LINEINPUT){
      process_line_input(&eresult);};
    eresult.type=EVTYPE_NONE;
    if (!quitting)
      write_eresult(eresult);
    break;
  case REQUEST_LINE_EVENT:
  case REQUEST_LINE_EVENT_UNI:
    glk_operands(4,argv);                 
    input[argv[0]-1].text=new wchar_t[argv[2]];
    input[argv[0]-1].address=argv[1];
    if (func==REQUEST_LINE_EVENT_UNI)
      input[argv[0]-1].unicode=true;
    else
      input[argv[0]-1].unicode=false;
    for (int i=0;i<argv[3];i++)
      input[argv[0]-1].text[i]=story[argv[1]+i];
    glk->request_line_event(argv[0],input[argv[0]-1].text,argv[2],argv[3]);
    break;
  case CANCEL_LINE_EVENT:
    glk_operands(1,argv);
    glk->cancel_line_event(argv[0],&eresult);
    if (eresult.type==EVTYPE_LINEINPUT){
      process_line_input(&eresult);};
    write_eresult(eresult);
    break;
  case REQUEST_CHAR_EVENT:
  case REQUEST_CHAR_EVENT_UNI:
    glk_operands(1,argv);
    glk->request_char_event(argv[0]);
    break;
  case CANCEL_CHAR_EVENT:
    glk_operands(1,argv);
    glk->cancel_char_event(argv[0]);
    break;
  case REQUEST_MOUSE_EVENT:
    glk_operands(1,argv);
    glk->request_mouse_event(argv[0]);
    break;
  case CANCEL_MOUSE_EVENT:
    glk_operands(1,argv);
    glk->cancel_mouse_event(argv[0]);
    break;
  case REQUEST_TIMER_EVENTS:
    glk_operands(1,argv);
    glk->request_timer_events(argv[0]);
    break;
  case IMAGE_GET_INFO:
    glk_operands(1,argv);
    result=glk->image_get_info(argv[0],ref[0],ref[1]);
    write_ref(ref,2);
    break;
  case IMAGE_DRAW:
    glk_operands(4,argv);
    result=glk->image_draw(argv[0],argv[1],argv[2],argv[3]);
    break;
  case IMAGE_DRAW_SCALED:
    glk_operands(6,argv);
    result=glk->image_draw_scaled(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]);
    break;
  case WINDOW_FLOW_BREAK:
    glk_operands(1,argv);
    glk->window_flow_break(argv[0]);
    break;
  case WINDOW_ERASE_RECT:
    glk_operands(5,argv);
    glk->window_erase_rect(argv[0],argv[1],argv[2],argv[3],argv[4]);
    break;
  case WINDOW_FILL_RECT:
    glk_operands(6,argv);
    argv[1]=swap_endian_color(argv[1]);
    glk->window_fill_rect(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]);
    break;
  case WINDOW_SET_BACKGROUND_COLOR:
    glk_operands(2,argv);
    argv[1]=swap_endian_color(argv[1]);
    glk->window_set_background_color(argv[0],argv[1]);
    break;
  case SCHANNEL_ITERATE:
    glk_operands(1,argv);
    result=glk->schannel_iterate(argv[0],ref[0]);
    write_ref(ref,1);
    break;
  case SCHANNEL_GET_ROCK:
    glk_operands(1,argv);
    result=glk->schannel_get_rock(argv[0]);
    break;
  case SCHANNEL_CREATE:
    glk_operands(1,argv);
    result=glk->schannel_create(argv[0]);
    break;
  case SCHANNEL_PLAY:
    glk_operands(2,argv);
    result=glk->schannel_play(argv[0],argv[1]);
    break;
  case SCHANNEL_PLAY_EXT:
    glk_operands(4,argv);
    result=glk->schannel_play_ext(argv[0],argv[1],argv[2],argv[3]);
    break;
  case SCHANNEL_STOP:
    glk_operands(1,argv);
    glk->schannel_stop(argv[0]);
    break;
  case SCHANNEL_SET_VOLUME:
    glk_operands(2,argv);
    glk->schannel_set_volume(argv[0],argv[1]);
    break;
  case SOUND_LOAD_HINT:
    glk_operands(2,argv);
    glk->sound_load_hint(argv[0],argv[1]);
    break;
  case SET_HYPERLINK:
    glk_operands(1,argv);
    glk->set_hyperlink(argv[0]);
    break;
  case SET_HYPERLINK_STREAM:
    glk_operands(2,argv);
    glk->set_hyperlink_stream(argv[0],argv[1]);
    break;
  case REQUEST_HYPERLINK_EVENT:
    glk_operands(1,argv);
    glk->request_hyperlink_event(argv[0]);
    break;
  case CANCEL_HYPERLINK_EVENT:
    glk_operands(1,argv);
    glk->cancel_hyperlink_event(argv[0]);
    break;
  case BUFFER_TO_LOWER_CASE_UNI:
    glk_operands(3,argv);
    result=glk->buffer_to_lower_case_uni((unsigned int *)&story[argv[0]],argv[1],argv[2]);
    break;
  case BUFFER_TO_UPPER_CASE_UNI:
    glk_operands(3,argv);
    result=glk->buffer_to_upper_case_uni((unsigned int *)&story[argv[0]],argv[1],argv[2]);
    break;
  case BUFFER_TO_TITLE_CASE_UNI:
    glk_operands(4,argv);
    result=glk->buffer_to_title_case_uni((unsigned int *)&story[argv[0]],argv[1],argv[2],argv[3]);
    break;
  case BUFFER_CANON_DECOMPOSE_UNI:
    glk_operands(3,argv);
    result=glk->buffer_canon_decompose_uni((unsigned int *)&story[argv[0]],argv[1],argv[2]);
    break;
  case BUFFER_CANON_NORMALIZE_UNI:
    glk_operands(3,argv);
    result=glk->buffer_canon_normalize_uni((unsigned int *)&story[argv[0]],argv[1],argv[2]);
    break;
  case PUT_CHAR_UNI:
    glk_operands(1,argv);
    glk->put_char(argv[0]);
    break;
  case PUT_CHAR_STREAM_UNI:
    glk_operands(2,argv);
    glk->put_char_stream(argv[0],argv[1]);
    break;
//  case PUT_STRING_UNI:
//    glk_operands(1,argv);
//    glk->put_string((wchar_t *)&story[argv[0]]);
//    break;
  case PUT_BUFFER_UNI:
    glk_operands(2,argv);
    glk->put_buffer(&story[argv[0]],argv[1],true);
    break;
//  case PUT_STRING_STREAM_UNI:
//    glk_operands(2,argv);
//    glk->put_string_stream(argv[0],(wchar_t *)&story[argv[1]]);
 //   break;
  case PUT_BUFFER_STREAM_UNI:
    glk_operands(3,argv);
    glk->put_buffer_stream(argv[0],&story[argv[1]],argv[2],true);
    break;
  case GET_CHAR_STREAM_UNI:
    glk_operands(1,argv);
    result=glk->get_char_stream(argv[0],true);
    break;
  case GET_BUFFER_STREAM_UNI:
    glk_operands(3,argv);
    result=glk->get_buffer_stream(argv[0],&story[argv[1]],argv[2],true);
    break;
  case GET_LINE_STREAM_UNI:
    glk_operands(3,argv);
    result=glk->get_line_stream(argv[0],&story[argv[1]],argv[2],true);
    break;
  case STREAM_OPEN_FILE_UNI:
    glk_operands(3,argv);
    result=glk->stream_open_file(argv[0],argv[1],argv[2],true);
    break;
  case STREAM_OPEN_MEMORY_UNI:
    glk_operands(4,argv);
    result=glk->stream_open_memory(&story[argv[0]],argv[1],argv[2],argv[3],true);
    break;
  case SET_ECHO_LINE_EVENT:
    glk_operands(2,argv);
    glk->set_echo_line_event(argv[0],argv[1]);
    break;
  case SET_TERMINATORS_LINE_EVENT:
    glk_operands(3,argv);
    array=new unsigned int[argv[2]];
    read_array(array,argv[1],argv[2]);
    glk->set_terminators_line_event(argv[0],array,argv[2]);
    delete (array);
    break;
  case CURRENT_TIME:
    glk->current_time(&time);
    write_tresult(time);
    break;
  case CURRENT_SIMPLE_TIME:
    glk_operands(1,argv);
    result=glk->current_simple_time(argv[0]);
    break;
  case TIME_TO_DATE_UTC:
    read_tresult(&time);
    glk->time_to_date_utc(&time,&date);
    write_dresult(date);
    break;
  case TIME_TO_DATE_LOCAL:
    read_tresult(&time);
    glk->time_to_date_local(&time,&date);
    write_dresult(date);
    break;
  case SIMPLE_TIME_TO_DATE_UTC:
    glk_operands(2,argv);
    glk->simple_time_to_date_utc(argv[0],argv[1],&date);
    write_dresult(date);
    break;
  case SIMPLE_TIME_TO_DATE_LOCAL:
    glk_operands(2,argv);
    glk->simple_time_to_date_local(argv[0],argv[1],&date);
    write_dresult(date);
    break;
  case DATE_TO_TIME_UTC:
    read_dresult(&date);
    glk->date_to_time_utc(&date,&time);
    write_tresult(time);
    break;
  case DATE_TO_TIME_LOCAL:
    read_dresult(&date);
    glk->date_to_time_local(&date,&time);
    write_tresult(time);
    break;
  case DATE_TO_SIMPLE_TIME_UTC:
    read_dresult(&date);
    glk_operands(1,argv);
    result=glk->date_to_simple_time_utc(&date,argv[0]);
    break;
  case DATE_TO_SIMPLE_TIME_LOCAL:
    read_dresult(&date);
    glk_operands(1,argv);
    result=glk->date_to_simple_time_local(&date,argv[0]);
    break;
  default:
    txt="Game attempted to execute unknown GLK function ";
    txt+=IntToHex((int)func,4);
    txt+=" at address ";
    txt+=IntToHex((int)op_base,8);
    txt+=".";
    glk->error_message(txt.c_str());};

if (!quitting)
  put_result(result);
};
//---------------------------------------------------------------------------

void GMACHINE::process_line_input (EVENT *eresult)
{
if (input[eresult->win-1].unicode){
  int input_pos=0;
  int output_pos=0;
  while (input[eresult->win-1].text[input_pos]!=0){
    write_long(input[eresult->win-1].text[input_pos],input[eresult->win-1].address+output_pos);
    input_pos++;
    output_pos+=4;};
  write_long(0,input[eresult->win-1].address+output_pos);}
else{
  char *str=WideToAnsi(input[eresult->win-1].text);
  memcpy(&story[input[eresult->win-1].address],str,eresult->val1);
  delete str;};

delete input[eresult->win-1].text;
};
//---------------------------------------------------------------------------

void GMACHINE::write_ref(int *ref,unsigned int num)
{                
unsigned int *addr=new unsigned int[num];

for (int i=0;i<num;i++){
  addr[i]=pop_stack();};

for (int i=0;i<num;i++){
  if (addr[i]==0)
    continue;
  if (addr[i]==0xffffffff){
    push_stack(ref[i]);}
  else{
    write_long(ref[i],addr[i]);};};

delete addr;
};
//----------------------------------------------------------------------------

void GMACHINE::G_jump(int offset)
{
branch(true,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::glk_operands(unsigned int argc,int *argv)
{
for (int i=0;i<argc;i++){
  argv[i]=pop_stack();};
};
//---------------------------------------------------------------------------

void GMACHINE::G_astore(unsigned int addr1,int addr2,int value)
{
write_long(value,addr1+(4*addr2));
};
//---------------------------------------------------------------------------

void GMACHINE::G_streamchar(wchar_t chr)
{
if (io_sys==0)
  return;

if (io_sys==2){
  if (string_indirect){
    wchar_t *tmp=new wchar_t[2];
    tmp[0]=chr;
    tmp[1]=0;
    indirect_output+=tmp;}
  else{
    glk->put_char(chr);};}
else{
  push_stub(SET_QUIT,0);
  call(io_sys,1,(int *)&chr);
  main_loop();
  quitting=false;};
};
//---------------------------------------------------------------------------

void GMACHINE::G_streamstr(unsigned int address)
{
WideString wide_out=decode_string(address);

if (io_sys==2){
  if (string_indirect)
    indirect_output+=wide_out;
  else
    glk->put_string(wide_out.c_bstr());};
};
//---------------------------------------------------------------------------

WideString GMACHINE::decode_string(unsigned int address)
{
WideString output="";
wchar_t tmp[2]={0,0};

if (story[address]==224){
  address++;
  while (io_sys>2&&story[address]!=0){
    tmp[0]=story[address];
    output+=do_indirect(output,io_sys,1,(int *)tmp);
    address++;};
  output+=(char *)&story[address];
  return (output);};

if (story[address]==226){
  address+=4;
  tmp[0]=read_long(address);
  while (tmp[0]!=0){
    if (io_sys>2)
      output+=do_indirect(output,io_sys,1,(int *)tmp);
    else
      output+=tmp;
    address+=4;
    tmp[0]=read_long(address);};
  return (output);};

if (story[address]==225){
  unsigned int indirect;
  bool found;
  bool done=false;
  unsigned int decoding_table=read_long(string_table+8);
  unsigned int str_loc=address+1;
  unsigned int table_loc=decoding_table;
  int i,j;
  unsigned int argc;
  int *argv;
  while (!done){
    for (int i=0;i<8&&!done;i++){
      do{
        found=false;
        switch (story[table_loc]){
            case 0:
            if (story[str_loc]&bit_mask[i])
              table_loc=read_long(table_loc+5);
            else
              table_loc=read_long(table_loc+1);
            break;
          case 1:
            done=true;
            break;
          case 2:
            tmp[0]=story[table_loc+1];
            if (io_sys>2)
              output+=do_indirect(output,io_sys,1,(int *)tmp);
            else
              output+=tmp;
            table_loc=decoding_table;
            found=true;
            break;
          case 3:
            table_loc++;
            if (io_sys>2){
              while (story[table_loc]!=0){
                tmp[0]=story[table_loc];
                output+=do_indirect(output,io_sys,1,(int *)tmp);
                table_loc++;};}
            else{
              output+=(char *)&story[table_loc];};
            table_loc=decoding_table;
            found=true;
            break;
          case 4:
            tmp[0]=read_long(table_loc+1);
            if (io_sys>2)
              output+=do_indirect(output,io_sys,1,(int *)tmp);
            else
              output+=tmp;
            table_loc=decoding_table;
            found=true;
            break;
          case 5:
            table_loc++;
            tmp[0]=read_long(table_loc);
            while (tmp[0]!=0){
              if (io_sys>2)
                output+=do_indirect(output,io_sys,1,(int *)tmp);
              else
                output+=tmp;
              table_loc+=4;
              tmp[0]=read_long(table_loc);};
            table_loc=decoding_table;
            found=true;
            break;
          case 8:
            indirect=read_long(table_loc+1);
            if (story[indirect]>=224&&story[indirect]<=226)
              output=output+decode_string(indirect);
            else
              output=do_indirect(output,indirect);
            table_loc=decoding_table;
            found=true;
            break;
          case 9:
            indirect=read_long(table_loc+1);
            indirect=read_long(indirect);
            if (story[indirect]>=224&&story[indirect]<=226)
              output=output+decode_string(indirect);
            else
              output=do_indirect(output,indirect);
            table_loc=decoding_table;
            found=true;
            break;
          case 10:
            indirect=read_long(table_loc+1);
            if (story[indirect]>=224&&story[indirect]<=226)
              output=output+decode_string(indirect);
            else{
              table_loc+=5;
              argc=read_long(table_loc);
              argv=new int[argc];
              for (j=0;j<argc;j++){
                table_loc+=4;
                argv[j]=read_long(table_loc);};
              output=do_indirect(output,indirect,argc,argv);};
            table_loc=decoding_table;
            found=true;
            break;
          case 11:
            indirect=read_long(table_loc+1);
            indirect=read_long(indirect);
            if (story[indirect]>=224&&story[indirect]<=226)
              output=output+decode_string(indirect);
            else{
              table_loc+=5;
              argc=read_long(table_loc);
              argv=new int[argc];
              for (j=0;j<argc;j++){
                table_loc+=4;
                argv[j]=read_long(table_loc);};
              output=do_indirect(output,indirect,argc,argv);};
            table_loc=decoding_table;
            found=true;
            break;
          default:
            glk->error_message("String decoding table is mal-formed or uses unknown formatting.");
            quitting=true;
            return ("");};}
      while (found);};
    str_loc++;};
  return (output);};

glk->error_message("String decoding table is mal-formed or uses unknown formatting.");
quitting=true;
return ("");
};
//---------------------------------------------------------------------------
WideString GMACHINE::do_indirect(WideString curr_output,unsigned int address,int argc,int *argv)
{
if (string_indirect==0)
  indirect_output="";

indirect_output+=curr_output;
string_indirect++;

push_stub(SET_QUIT,0);
call(address,argc,argv);
main_loop();
quitting=false;

string_indirect--;
return (indirect_output);
};

//---------------------------------------------------------------------------
void GMACHINE::G_streamnum(int num)
{
if (io_sys==0)
  return;
       
wchar_t output[33];
_itow(num,output,10);
int start=0;

while (io_sys>2&&output[start]!=0){
  push_stub(SET_QUIT,0);
  call(io_sys,1,(int *)&output[start]);
  main_loop();
  quitting=false;
  start++;};

if (output[start]!=0)
  if (string_indirect)
    indirect_output+=&output[start];
  else
    glk->put_string(&output[start]);
/*
if (io_sys==2){
  if (string_indirect)
    indirect_output+=output;
  else
    glk->put_string(output);}
else{
  for (int i=0;output[i]!=0;i++){
    push_stub(SET_QUIT,0);
    call(io_sys,1,(int *)&output[i]);
    main_loop();
    quitting=false;};};*/
};
//---------------------------------------------------------------------------

void GMACHINE::G_jle(int val1,int val2,int offset)
{
branch(val1<=val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_copyb(int value)
{
unsigned char num=value;
put_result(num,1);
};
//----------------------------------------------------------------------------

void GMACHINE::G_div(int val1,int val2)
{
put_result(val1/val2);
};
//---------------------------------------------------------------------------

unsigned int GMACHINE::frame_len()
{
return (read_slong(frame_ptr));
};
//---------------------------------------------------------------------------

void GMACHINE::G_astorebit(unsigned int address,int bit,unsigned int set)
{
if (bit<0&&bit%8!=0)
  address--;
address+=(bit/8);
bit=(bit%8);
if (bit<0)
  bit=(8+bit);
if (set){
  if (!(story[address]&bit_mask[bit])){
    story[address]+=bit_mask[bit];};}
else{
  if (story[address]&bit_mask[bit]){
    story[address]-=bit_mask[bit];};};
};
//---------------------------------------------------------------------------

void GMACHINE::write_sresult(STREAM_RESULT sresult)
{
unsigned int addr=pop_stack();

if (addr==0)
  return;

if (addr==0xffffffff){
  push_stack(sresult.readcount);
  push_stack(sresult.writecount);}
else{
  write_long(sresult.readcount,addr);
  write_long(sresult.writecount,addr+4);};
};
//----------------------------------------------------------------------------

void GMACHINE::G_random(int range)
{                         
int lower,upper;
if (range==0){
  lower=-2,147,483,648;
  upper=2,147,483,647;}
else{
  if (range<0){
    lower=range+1;
    upper=1;}
  else{
    lower=0;
    upper=range;};};
put_result(RandomRange(lower,upper));
};
//----------------------------------------------------------------------------

void GMACHINE::G_mod(int val1,int val2)
{
put_result(val1%val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_astoreb(unsigned int addr1,int addr2,int value)
{
story[addr1+addr2]=value;
};
//----------------------------------------------------------------------------
void GMACHINE::write_eresult(EVENT eresult)
{
unsigned int addr=pop_stack();

if (addr==0)
  return;

if (addr==0xffffffff){
  push_stack(eresult.type);
  push_stack(eresult.win);
  push_stack(eresult.val1);
  push_stack(eresult.val2);}
else{
  write_long(eresult.type,addr);
  write_long(eresult.win,addr+4);
  write_long(eresult.val1,addr+8);
  write_long(eresult.val2,addr+12);};
};
//----------------------------------------------------------------------------
void GMACHINE::save_to_stream(TMemoryStream *game)
{
game->Clear();

save_string("FORM",game);
save_long(0,game);
save_string("IFZS",game);
save_string("IFhd",game);
save_long(128,game);
game->Write(story,128);

save_string("CMem",game);
save_long(0,game);
save_long(mem_size,game);
unsigned char *tmp=new unsigned char[dynamic_size];
for (int i=0;i<dynamic_size;i++)
  tmp[i]=story[i+ramstart]^dynamic[i];
//unsigned int limit=dynamic_size-1;
//for (limit=dynamic_size-1;limit>=0&&!tmp[limit];limit--);
int i=0;
unsigned int count=0;
while (i<dynamic_size){
  while (i<dynamic_size&&tmp[i]){
    save_char(tmp[i],game);
    i++;
    count++;};
  int null_count=0;
  while (i<dynamic_size&&!tmp[i]&&null_count<256){
    i++;
    null_count++;};
  if (null_count){
    save_char(0,game);
    save_char(null_count-1,game);
    count+=2;};};
game->Seek(152,soFromBeginning);
save_long(count+4,game);
game->Seek(0,soFromEnd);
if (game->Size%2)
  save_char(0,game);
delete tmp;

unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
push_stub(dest_type,dest_address);
save_string("Stks",game);
save_long(stack_ptr,game);
game->Write(stack,stack_ptr);

if (heap_count){
  if (game->Size%2)
    save_char(0,game);
  save_string("MAll",game);
//  unsigned int count=0;
  save_long(8+(8*heap_count),game);
  save_long(normal_mem_size,game);
  save_long(heap_count,game);
  for (int i=0;i<10;i++){
    if (heap[i].start){
      save_long(heap[i].start,game);
      save_long(heap[i].len,game);};};};

game->Seek(4,soFromBeginning);
save_long(game->Size-8,game);

if (game->Size%2){
  game->Seek(0,soFromEnd);
  save_char(0,game);};

pop_stub(dest_type,dest_address);
write_result(0,dest_type,dest_address);
};
//----------------------------------------------------------------------------

unsigned int __inline GMACHINE::read_slong(int loc)
{
return (stack[loc]<<24|stack[loc+1]<<16|stack[loc+2]<<8|stack[loc+3]);
};
//---------------------------------------------------------------------------

unsigned short GMACHINE::read_sword(unsigned int loc)
{
return (stack[loc]<<8|stack[loc+1]);
};
//---------------------------------------------------------------------------

void GMACHINE::write_sword(short value, unsigned int loc)
{
stack[loc]=value>>8;
stack[loc+1]=value;
};
//----------------------------------------------------------------------------

void __inline GMACHINE::write_slong(int value,unsigned int loc)
{
stack[loc]=value>>24;
stack[loc+1]=value>>16;
stack[loc+2]=value>>8;
stack[loc+3]=value;
};
//----------------------------------------------------------------------------

void GMACHINE::G_saveundo()
{
next_undo++;
if (next_undo>9)
  next_undo=0;
save_to_stream(undo_stream[next_undo]);
undo_used[next_undo]=true;
};
//----------------------------------------------------------------------------

void GMACHINE::G_neg(int val)
{
put_result(-(val));
};
//----------------------------------------------------------------------------

void GMACHINE::G_nop()
{
};
//---------------------------------------------------------------------------

void GMACHINE::G_bitor(int val1,int val2)
{
put_result(val1|val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_bitxor(int val1,int val2)
{
put_result(val1^val2);
};
//---------------------------------------------------------------------------

void GMACHINE::G_bitnot(int value)
{
put_result(~value);
};
//---------------------------------------------------------------------------

void GMACHINE::G_shiftl(unsigned int value,unsigned int shift)
{
if (shift>=32)
  put_result(0);
else
  put_result(value<<shift);
};
//---------------------------------------------------------------------------

void GMACHINE::G_sshiftr(int value,unsigned int shift)
{
if (shift>=32){
  if (value<0)
    put_result(0xFFFFFFFF);
  else
    put_result(0);}
else{
  put_result(value>>shift);};
};
//---------------------------------------------------------------------------

void GMACHINE::G_ushiftr(unsigned int value,unsigned int shift)
{
if (shift>=32)
  put_result(0);
else
  put_result(value>>shift);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jltu(unsigned int val1,unsigned int val2,int offset)
{
branch(val1<val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jgtu(unsigned int val1,unsigned int val2,int offset)
{
branch(val1>val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jleu(unsigned int val1,unsigned int val2,int offset)
{
branch(val1<=val2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_copys(int value)
{
unsigned short num=value;
put_result(num,2);
};
//----------------------------------------------------------------------------

void GMACHINE::G_sexs(unsigned short value)
{
unsigned int result=value;
if (value&32768)
  result+=0xFFFF0000;
put_result(result);
};
//----------------------------------------------------------------------------

void GMACHINE::G_sexb(unsigned char value)
{
unsigned int result=value;
if (value&128)
  result+=0xFFFFFF00;
put_result(result);
};
//---------------------------------------------------------------------------

void GMACHINE::G_astores(unsigned int addr1,int addr2,int value)
{
write_word(value,addr1+(2*addr2));
};
//----------------------------------------------------------------------------

void GMACHINE::G_stkcount()
{
put_result((stack_ptr-frame_ptr-read_slong(frame_ptr))/4);
};
//----------------------------------------------------------------------------

void GMACHINE::G_stkpeek(unsigned int pos)
{
pos=(stack_ptr-4-(4*pos));
put_result(read_slong(pos));
};
//----------------------------------------------------------------------------

void GMACHINE::G_stkswap()
{
int val1=pop_stack();
int val2=pop_stack();
push_stack(val1);
push_stack(val2);
};
//----------------------------------------------------------------------------

void GMACHINE::G_stkroll(unsigned int num,int pos)
{
if (num==0)
  return;

if (num>(((stack_ptr-frame_ptr-read_slong(frame_ptr))/4)))
  return;

if (pos>0){
  while (pos>num)
    pos-=num;}
else{
  while (abs(pos)>num)
    pos+=num;};

if (pos==0)
  return;

int *value=new int[num];
int *result=new int[num];
for (int i=num-1;i>=0;i--)
  value[i]=pop_stack();
for (int i=0;i<num;i++){
  int new_pos=i+pos;
  if (new_pos>=(int)num){
    new_pos-=num;}
  else{
    if (new_pos<0){
      new_pos+=num;};};
  result[new_pos]=value[i];};
for (int i=0;i<num;i++)
  push_stack(result[i]);

delete value;
delete result;
};
//---------------------------------------------------------------------------

void GMACHINE::G_debugtrap(int value)
{
String tmp="Debugtrap statement encountered at address ";
tmp+=IntToHex((int)op_base,8);
tmp+=".";
glk->error_message(tmp.c_str());
};
//---------------------------------------------------------------------------

void GMACHINE::G_setmemsize(unsigned int size)
{
if (size<read_long(ENDMEM)||normal_mem_size!=mem_size){
  put_result(1);
  return;};

resize_mem(size);
normal_mem_size=size;
put_result(0);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jumpabs(unsigned int address)
{
exe_loc=address;
};
//---------------------------------------------------------------------------

void GMACHINE::G_setrandom(int seed)
{
if (seed!=0)
  RandSeed=seed*100;
else
  Randomize();
};
//---------------------------------------------------------------------------

void GMACHINE::G_quit()
{
quitting=true;
};
//---------------------------------------------------------------------------

void GMACHINE::G_verify()
{
unsigned int static_len=min(glk->story_size,ramstart);
unsigned int ver_checksum=read_long(CHECKSUM);
unsigned int checksum=0;
for (unsigned int i=0;i<static_len;i+=4)
  if (i!=32)
    checksum+=read_long(i);
for (unsigned int i=0;i<dynamic_size;i+=4)
  checksum+=read_dlong(i);

put_result(checksum!=ver_checksum);
};
//----------------------------------------------------------------------------

unsigned int GMACHINE::read_dlong(int loc)
{
return (dynamic[loc]<<24|dynamic[loc+1]<<16|dynamic[loc+2]<<8|dynamic[loc+3]);
};
//---------------------------------------------------------------------------

void GMACHINE::G_restart()
{
unsigned char *tmp;
if (protect.len&&protect.start<read_long(ENDMEM)){
  tmp=new unsigned char[protect.len];
  memcpy(tmp,&story[protect.start],protect.len);};
memcpy(&story[ramstart],dynamic,dynamic_size);
if (protect.len&&protect.start<read_long(ENDMEM)){
  memcpy(&story[protect.start],tmp,protect.len);
  delete tmp;};
init_exe();
};
//--------------------------------------------------------------------------

void GMACHINE::G_save(unsigned int stream)
{
TMemoryStream *game=new TMemoryStream();
save_to_stream(game);
unsigned char *buffer=new unsigned char[game->Size];
game->Seek(0,soFromBeginning);
game->Read(buffer,game->Size);
glk->put_buffer_stream(stream,buffer,game->Size);
delete buffer;
delete game;
glk->saved=true;
};
//----------------------------------------------------------------------------
bool GMACHINE::restore_from_stream(TStream *game)
{
unsigned char *tmp;
if (protect.len){
  tmp=new unsigned char[protect.len];
  if (protect.start<mem_size)
     memcpy(tmp,&story[protect.start],protect.len);
  else
     memset(tmp,0,protect.len);};

unsigned char header[128];
unsigned char *tmp_mem;
game->Seek(0,soFromBeginning);

if (restore_string(4,game)!="FORM")
  return (false);
unsigned int file_size=restore_long(game)+8;
if (restore_string(4,game)!="IFZS")
  return(false);

if (!seek_chunk("IFhd",file_size,game))
  return(false);
unsigned int chunk_size=restore_long(game);
if (chunk_size!=128)
  return(false);
game->Read(header,128);
if (memcmp(story,header,128))
  return (false);

if (!seek_chunk("CMem",file_size,game))
  return (false);
chunk_size=restore_long(game);
resize_mem(restore_long(game));
normal_mem_size=mem_size;
tmp_mem=new unsigned char[dynamic_size];
memcpy(tmp_mem,dynamic,dynamic_size);
int chunk_pos=0;
int story_pos=0;
while (chunk_pos<chunk_size){
  unsigned char next=restore_char(game);
  if (next){
    tmp_mem[story_pos]=next^dynamic[story_pos];
    story_pos++;
    chunk_pos++;}
  else{
    int compress=restore_char(game)+1;
    story_pos+=compress;
    chunk_pos+=2;};};

memcpy(&story[ramstart],tmp_mem,dynamic_size);
delete tmp_mem;

if (!seek_chunk("Stks",file_size,game))
  return(false);
chunk_size=restore_long(game);
chunk_pos=0;
game->Read(stack,chunk_size);
stack_ptr=chunk_size;

if (heap_count){
  heap_count=0;
  for (int i=0;i<heap_count;i++){
    heap[i].start=0;};};

if (seek_chunk("MAll",file_size,game)){
  game->Position+=4;
  normal_mem_size=restore_long(game);
  heap_count=restore_long(game);
  for (int i=0;i<heap_count;i++){
    heap[i].start=restore_long(game);
    heap[i].len=restore_long(game);};};

if (protect.len){
  if (protect.start<mem_size)
     memcpy(&story[protect.start],tmp,protect.len);
  delete tmp;};

unsigned int dest_type,dest_address;
pop_stub(dest_type,dest_address);
write_result(-1,dest_type,dest_address);
return(true);
};
//----------------------------------------------------------------------------

void GMACHINE::G_restore(unsigned int stream)
{
TMemoryStream *game=new TMemoryStream();
unsigned char *buffer=new unsigned char[8];
glk->get_buffer_stream(stream,buffer,8);
game->Write(buffer,8);
game->Seek(4,soFromBeginning);
unsigned int file_size=restore_long(game)+8;
delete buffer;

buffer=new unsigned char[file_size];
glk->get_buffer_stream(stream,buffer,file_size);
game->Write(buffer,file_size);
bool result=restore_from_stream(game);
delete game;
delete buffer;
glk->saved=result;

if (!result)
  put_result(1);
};
//----------------------------------------------------------------------------

void GMACHINE::G_restoreundo()
{
if (next_undo<0||!undo_used[next_undo]){
  put_result(1);
  return;};

bool result=restore_from_stream(undo_stream[next_undo]);

if (result){
  undo_used[next_undo]=false;
  next_undo--;
  if (next_undo<0)
    next_undo=9;}
else
  put_result(1);
};
//----------------------------------------------------------------------------

unsigned int GMACHINE::swap_endian_color(unsigned int value)
{
unsigned char red,green,blue;
blue=value;
value=value>>8;
green=value;
value=value>>8;
red=value;
unsigned int result=blue;
result=result<<8;
result+=green;
result=result<<8;
result+=red;
return (result);
};
//----------------------------------------------------------------------------

void GMACHINE::G_catch()
{
result_format=story[exe_loc]&0x0F;
unsigned char arg_type=(story[exe_loc]&0xF0)>>4;
exe_loc++;
unsigned int dest_type,dest_address;
result_code(dest_type,dest_address);
int offset=get_arg(arg_type);

push_stub(dest_type,dest_address);

write_result(stack_ptr,dest_type,dest_address);
branch(true,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_throw(int value,unsigned int token)
{
stack_ptr=token;
unsigned int dest_type,dest_address;
pop_stub(dest_type,dest_address);
write_result(value,dest_type,dest_address);
};
//---------------------------------------------------------------------------

void GMACHINE::G_tailcall(unsigned int routine,unsigned int argc)
{
int *argv=new int[argc];
for (int i=0;i<argc;i++)
  argv[i]=pop_stack();

stack_ptr=frame_ptr;
call(routine,argc,argv);
};
//---------------------------------------------------------------------------

void GMACHINE::G_protect(unsigned int start,unsigned int len)
{
protect.start=start;
protect.len=len;
};
//---------------------------------------------------------------------------

void __inline GMACHINE::push_stack(int value)
{
write_slong(value,stack_ptr);
stack_ptr+=4;
};
//---------------------------------------------------------------------------

void GMACHINE::G_getiosys()
{
unsigned char format1=story[exe_loc]&0x0F;
unsigned char format2=(story[exe_loc]&0xF0)>>4;
exe_loc++;

unsigned int sys=io_sys;
unsigned int address=0;
if (io_sys>2){
  sys=1;
  address=io_sys;};

result_format=format1;
put_result(sys);
result_format=format2;
put_result(address);
};
//----------------------------------------------------------------------------

void GMACHINE::G_setstringtbl(unsigned int address)
{
string_table=address;
};
//---------------------------------------------------------------------------

void GMACHINE::G_getstringtbl()
{
put_result(string_table);
};
//---------------------------------------------------------------------------

void GMACHINE::G_malloc(unsigned int size)
{
if (heap_count>=10||size==0){
  put_result(0);
  return;};               

for (int i=0;i<10;i++){
  if (!heap[i].start){
    heap[i].start=mem_size;
    heap[i].len=size;
    resize_mem(mem_size+size);
    put_result(heap[i].start);
    heap_count++;
    return;};};
};
//---------------------------------------------------------------------------

void GMACHINE::G_mfree(unsigned int address)
{
for (int i=0;i<10;i++){
  if (heap[i].start==address){
    heap[i].start=0;
    heap_count--;
    break;};};

unsigned int highest=normal_mem_size;
for (int i=0;i<10;i++){
  if (heap[i].start>=highest){
    highest=heap[i].start+heap[i].len;};};
resize_mem(highest);
};
//---------------------------------------------------------------------------

void GMACHINE::G_mzero(unsigned int len,unsigned int start)
{
memset(&story[start],0,len);
};
//---------------------------------------------------------------------------

void GMACHINE::G_mcopy(unsigned int len,unsigned int from,unsigned int to)
{
unsigned char *tmp=new unsigned char[len];
memcpy(tmp,&story[from],len);
memcpy(&story[to],tmp,len);
delete tmp;           
//memcpy(&story[to],&story[from],len);
};
//---------------------------------------------------------------------------

void GMACHINE::G_accelfunc(unsigned int func_num,unsigned int address)
{
if (func_num>7)
  return;

for (int i=0;i<accel_count;i++){
  if (accel[i].address==address){
    accel[i].func_num=0;
    accel[i].address=0;
    break;};};

if (func_num>0){
  accel[accel_count].func_num=func_num;
  accel[accel_count].address=address;
  accel_count++;};
};
//----------------------------------------------------------------------------

void GMACHINE::G_accelparam(unsigned int param,unsigned int value)
{
if (param<9)
  accel_param[param]=value;
};
//----------------------------------------------------------------------------

void GMACHINE::call_accel(int func_name,int argv1,int argv2)
{
switch (func_name){
  case Z_REGION:
    ret(I_zregion(argv1));
    return;
  case CP_TAB:
    ret(I_cptab(argv1,argv2));
    return;
  case RA_PR:
    ret(I_rapr(argv1,argv2));
    return;
  case RL_PR:
    ret(I_rlpr(argv1,argv2));
    return;
  case OC_CL:
    ret(I_occl(argv1,argv2));
    return;
  case RV_PR:
    ret(I_rvpr(argv1,argv2));
    return;
  case OP_PR:
    ret(I_oppr(argv1,argv2));
    return;};

glk->error_message("Accelerated function call to unknown function!");
quitting=true;
};
//----------------------------------------------------------------------------

bool __inline GMACHINE::I_objinclass(unsigned int obj)
{
return (read_long(obj+13+accel_param[NUM_ATTR_BYTES])==accel_param[CLASS_METACLASS]);
};
//----------------------------------------------------------------------------

int GMACHINE::I_zregion(unsigned int addr)
{
if (addr<36||addr>=mem_size)
  return (false);

if (story[addr]>=0xE0)
  return (3);

if (story[addr]>=0xc0)
  return (2);

if (story[addr]>=0x70&&story[addr]<=0x7f&&addr>=read_long(RAMSTART))
  return (1);

return (0);
};

//----------------------------------------------------------------------------

int GMACHINE::I_cptab(unsigned int obj,unsigned short id)
{
if (I_zregion(obj)!=1){
  glk->error_message("Tried to find the ~.~ of something in CP_Tab accelerated function.");
  quitting=true;
  return (0);};

unsigned int start=read_long(obj+16);
if (start==0)
  return (0);

int left=0;
int right=read_long(start)-1;
start+=4;

while (left<=right){
  int midpt=(left+right)/2;
  unsigned int address=start+(midpt*10);
  unsigned short chk=read_word(address);
  if (id==chk)
    return (address);
  if (id>chk)
    left=midpt+1;
  else
    right=midpt-1;};

return (0);
};
//----------------------------------------------------------------------------


int GMACHINE::I_rapr(unsigned int obj,unsigned int id)
{
unsigned int cla=0;

if (id&0xFFFF0000){
  cla=read_long(accel_param[CLASSES_TABLE]+((id&0xFFFF)*4));
  if (!I_occl(obj,cla))
    return (0);
  id=id>>16;
  obj=cla;};

unsigned int prop=I_cptab(obj,id);
if (prop==0)
  return (0);

if (I_objinclass(obj)&&cla==0){
  if (id<accel_param[INDIV_PROP_START]||id>=accel_param[INDIV_PROP_START]+8)
    return (0);};

if (read_long(accel_param[SELF])!=obj){
  if (story[prop+9]&1)
    return (0);};

return (read_long(prop+4));
};
//----------------------------------------------------------------------------

int GMACHINE::I_rlpr(unsigned int obj,unsigned int id)
{
unsigned int cla=0;

if (id&0xFFFF0000){
  cla=read_long(accel_param[CLASSES_TABLE]+((id&0xFFFF)*4));
  if (!I_occl(obj,cla))
    return (0);
  id=id>>16;
  obj=cla;};

int prop=I_cptab(obj,id);
if (prop==0)
  return (0);

if (I_objinclass(obj)&&cla==0){
  if (id<accel_param[INDIV_PROP_START]||id>=accel_param[INDIV_PROP_START]+8)
    return (0);};

if (read_long(accel_param[SELF])!=obj){
  if (story[prop+9]&1)
    return (0);};

return (4*read_word(prop+2));
};
//----------------------------------------------------------------------------

bool GMACHINE::I_occl(unsigned int obj,unsigned int cla)
{
int zr=I_zregion(obj);

if (zr==3){
  if (cla==accel_param[STRING_METACLASS])
    return (true);
  return (false);};

if (zr==2){
  if (cla==accel_param[ROUTINE_METACLASS])
    return (true);
  return (false);};

if (zr!=1)
  return (false);

if (cla==accel_param[CLASS_METACLASS]){
  if (I_objinclass(obj)||obj==accel_param[CLASS_METACLASS]||obj==accel_param[STRING_METACLASS]||obj==accel_param[ROUTINE_METACLASS]||obj==accel_param[OBJECT_METACLASS])
    return (true);
  return (false);};

if (cla==accel_param[OBJECT_METACLASS]){
  if (I_objinclass(obj)||obj==accel_param[CLASS_METACLASS]||obj==accel_param[STRING_METACLASS]||obj==accel_param[ROUTINE_METACLASS]||obj==accel_param[OBJECT_METACLASS])
    return (false);
  return (true);};

if (cla==accel_param[STRING_METACLASS]||cla==accel_param[ROUTINE_METACLASS])
  return (false);

if (!I_objinclass(cla)){
  glk->error_message("Tried to apply accelerated \"ofclass\" function with non-class.");
  quitting=true;
  return (false);};

int inlist=I_rapr(obj,2);

if (inlist==0)
  return (false);

int inlistlen=I_rlpr(obj,2)/2;

for (int jx=0;jx<inlistlen;jx++){
  if (read_long(inlist+jx*4)==cla)
    return (true);};

return (false);
};
//----------------------------------------------------------------------------

int GMACHINE::I_rvpr(unsigned int obj,unsigned int id)
{
unsigned int addr=I_rapr(obj,id);

if (addr==0){
  if (id>0&&id<accel_param[INDIV_PROP_START])
    return (read_long(accel_param[CPV_START]+id*4));
  glk->error_message("Tried to read (something) in accelerated function RV_PR.");
  quitting=true;
  return (0);};

return (read_long(addr));
};
//----------------------------------------------------------------------------

bool GMACHINE::I_oppr(unsigned int obj,unsigned int id)
{
int zr=I_zregion(obj);

if (zr==3){
  if (id==262||id==263)
    return (true);
  return (false);};

if (zr==2){
  if (id==261)
    return (true);
  return (false);};

if (zr!=1)
  return (false);

if (id>=accel_param[INDIV_PROP_START]&&id<accel_param[INDIV_PROP_START]+8){
  if (I_objinclass(obj))
    return (true);};

if (I_rapr(obj,id)!=0)
  return (true);
                                                      
return (false);                                          
};
//----------------------------------------------------------------------------

bool GMACHINE::check_nan(unsigned int val1,unsigned int val2)
{
if ((val1>=0x7f800001&&val1<=0x7fffffff)||(val2>=0x7f800001&&val2<=0x7fffffff)){
   put_result(0x7fffffff);
   return (true);};
if ((val1>=0xff800001&&val1<=0xffffffff)||(val2>=0xff800001&&val2<=0xffffffff)){
   put_result(0xffffffff);
   return (true);};

return (false);
}
//----------------------------------------------------------------------------

void GMACHINE::G_fadd(int val1,int val2)
{
//Is either value NAN?
if (check_nan(val1,val2))
   return;

//Cannot do +INF + -INF
if (val1==0x7f800000){
   if (val2==0xff800000){
      put_result(0x7fffffff);
      return;};}
else{
   if (val1==0xff800000){
      if (val2==0x7f800000){
         put_result(0xffffffff);
         return;};};};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
double result=*f1+*f2;    
if (result>MaxSingle*1.001){
   put_result(0x7f800000);
   return;};
if (result<-MaxSingle){
   put_result(0xff800000);
   return;};
float fresult=result;
int *i_result=(int *)&fresult;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_numtof(int val)
{
   float result=val;
   int *i_result=(int *)&result;
   put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_ftonumz(int val)
{                                         
  float *f=(float *)&val;
  
  if (*f>=0x80000000){
     put_result(0x7fffffff);
     return;}
  if (-(*f)>=0x80000000){
     put_result(0x80000000);
     return;};

  if ((val&0x7fffffff)>0x7f800000){
     if (val&0x80000000)
        put_result(0x80000000);
     else
        put_result(0x7fffffff);
     return;};

  put_result((int)*f);
}
//----------------------------------------------------------------------------

void GMACHINE::G_ftonumn(int val)
{                                         
  float *f=(float *)&val;

  if (*f>=0x80000000){
     put_result(0x7fffffff);
     return;}
  if (-(*f)>=0x80000000){
     put_result(0x80000000);
     return;};

  if ((val&0x7fffffff)>0x7f800000){
     if (val&0x80000000)
        put_result(0x80000000);
     else
        put_result(0x7fffffff);
     return;};

  float rounder=*f;
  if (fabs(fmod(rounder,1))>=.5)
     if (rounder>0)
        rounder=rounder+1;
     else
        rounder=rounder-1;
  
  put_result((int)rounder);
}
//----------------------------------------------------------------------------

void GMACHINE::G_jfge(int val1,int val2,int offset)
{
//Is any value NAN?
if (check_nan_branch(true,offset,val1,val2))
   return;

float *f1=(float *)&val1;
float *f2=(float *)&val2;

branch(*f1>=*f2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jflt(int val1,int val2,int offset)
{
//Is any value NAN?
if (check_nan_branch(true,offset,val1,val2))
   return;

float *f1=(float *)&val1;
float *f2=(float *)&val2;

branch(*f1<*f2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jisnan(int val,int offset)
{
branch((val&0x7fffffff)>0x7f800000,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jisinf(int val,int offset)
{
branch((val&0x7fffffff)==0x7f800000,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_fmod()
{
unsigned char arg_type[4];
for (int i=0;i<4;i++){
  if (i%2==0){
    arg_type[i]=story[exe_loc]&0x0F;}
  else{
    arg_type[i]=(story[exe_loc]&0xF0)>>4;
    exe_loc++;};};

int val1=get_arg(arg_type[0],4);
int val2=get_arg(arg_type[1],4);

float quotient,remainder;
int *i_quotient=(int *)&quotient;
int *i_remainder=(int *)&remainder;

//Is either value NAN?
if ((val1>=0x7f800001&&val1<=0x7fffffff)||(val2>=0x7f800001&&val2<=0x7fffffff)){
   *i_quotient=0x7fffffff;
   *i_remainder=0x7fffffff;}
else{
   if ((val1>=0xff800001&&val1<=0xffffffff)||(val2>=0xff800001&&val2<=0xffffffff)){
      *i_quotient=0xffffffff;
      *i_remainder=0xffffffff;}

//Cannot divide by 0
   else{
      if (val2==0){
         *i_quotient=0x7fffffff;
         *i_remainder=0x7fffffff;}
      else{
         if (val2==0x80000000){
            *i_quotient=0xffffffff;
            *i_remainder=0xffffffff;}

//Cannot divide into infinity
         else{
            if (val1==0x7f800000||val1==0xff800000){
               if (val2&0x80000000){
                  *i_quotient=0xffffffff;
                  *i_remainder=0xffffffff;}
               else{
                  *i_quotient=0x7fffffff;
                  *i_remainder=0x7fffffff;};}

//Deal with a val1 of 0 or -0
            else{
               if (!(val1&0x7fffffff)){
                  if (val1&0x80000000){
                     if (val2&0x80000000){
                        *i_quotient=0;
                        *i_remainder=0x80000000;}
                     else{
                        *i_quotient=0x80000000;
                        *i_remainder=0x80000000;};}
                  else{
                     if (val2&0x80000000){
                        *i_quotient=0x80000000;
                        *i_remainder=0;}
                     else{
                        *i_quotient=0;
                        *i_remainder=0;};};}

//Do the mod
               else{
                  float *f1=(float *)&val1;
                  float *f2=(float *)&val2;

                  quotient=*f1/(*f2);
                  quotient-=fmod(quotient,1);
                  remainder=fmod(*f1,*f2);};};};};};};

result_format=arg_type[2];
put_result(*i_remainder);
result_format=arg_type[3];
put_result(*i_quotient);
};
//---------------------------------------------------------------------------

void GMACHINE::G_log(int val)
{
//Deal with INF
if (val==0x7f800000){
   put_result(0x7f800000);
   return;};

//Cannot get the log of 0
if ((val&0x7fffffff)==0){
   put_result(0xff800000);
   return;};

//Cannot get the log of a negative number
if (val&0x80000000){
   put_result(0xffffffff);
   return;};

float *f=(float *)&val;
float result=log(*f);

int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_fdiv(int val1,int val2)
{
//Is either value NAN?
if (check_nan(val1,val2))
   return;

//Cannot divide by 0
if (val2==0){
   if (val1==0||val1==0x80000000){
      put_result(0x7fffffff);
      return;}
   else{
      put_result(0x7f800000);
      return;};}
else{
   if (val2==0x80000000){
      if (val1==0||val1==0x80000000){
         put_result(0xffffffff);
         return;}
      else{
         put_result(0xff800000);
         return;};};};

//Cannot do INF / INF
if (val1==0x7f800000||val1==0xff800000){
   if (val2==0x7f800000){
      put_result(0x7fffffff);
      return;}
   else{
      if (val2==0xff800000){
         put_result(0xffffffff);
         return;};};};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
double result=*f1/(*f2);    
if (result>MaxSingle*1.001){
   put_result(0x7f800000);
   return;};
if (result<-MaxSingle){
   put_result(0xff800000);
   return;};
float fresult=result;
int *i_result=(int *)&fresult;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_fmul(int val1,int val2)
{
//Is either value NAN?
if (check_nan(val1,val2))
   return;

//Cannot do INF * 0
if (val1==0x7f800000){
   if (val2==0||val2==0x80000000){
      put_result(0x7fffffff);
      return;};}
else{
   if (val1==0xff800000){
      if (val2==0||val2==0x80000000){
         put_result(0xffffffff);
         return;};};};
         
if (val1==0){
   if (val2==0x7f800000||val2==0xff800000){
      put_result(0x7fffffff);
      return;};}
else{
   if (val1==0x80000000){
      if (val2==0x7f800000||val2==0xff800000){
         put_result(0xffffffff);
         return;};};};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
double result=*f1*(*f2);    
if (result>MaxSingle*1.001){
   put_result(0x7f800000);
   return;};
if (result<-MaxSingle){
   put_result(0xff800000);
   return;};
float fresult=result;
int *i_result=(int *)&fresult;
put_result(*i_result);
}
//---------------------------------------------------------------------------

void GMACHINE::G_exp(int val)
{
//Is val NAN?
if (check_nan(val))
   return;

//Deal with INF
if (val==0x7f800000){
   put_result(0x7f800000);
   return;};
   
float *f=(float *)&val;                      
double result=exp(*f);
if (result>MaxSingle*1.001){
   put_result(0x7f800000);
   return;};
if (result<-MaxSingle){
   put_result(0xff800000);
   return;};
float fresult=result;
int *i_result=(int *)&fresult;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_fsub(int val1,int val2)
{
//Is either value NAN?
if (check_nan(val1,val2))
   return;

//Cannot do -INF - -INF
if (val1==0x7f800000){
   if (val2==0x7f800000){
      put_result(0x7fffffff);
      return;};}
else{
   if (val1==0xff800000){
      if (val2==0xff800000){
         put_result(0xffffffff);
         return;};};};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
double result=*f1-*f2;
if (result>MaxSingle*1.001){
   put_result(0x7f800000);
   return;};
if (result<-MaxSingle){
   put_result(0xff800000);
   return;};
float fresult=result;
int *i_result=(int *)&fresult;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_floor(int val)
{
//Is val NAN?
if (check_nan(val))
   return;

float *f=(float *)&val;
float mod=fmod(*f,1);

//If we already have a whole number, nothing to do.
if (mod==0){
   put_result(val);
   return;};

float result;
if (val&0x80000000)
   result=*f-mod-1;
else
   result=*f-mod;

//Deal with -0
if ((result==0)&&(val&0x80000000)){
   put_result(0x80000000);
   return;};
                                   
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_ceil(int val)
{
//Is val NAN?
if (check_nan(val))
   return;

float *f=(float *)&val;
float mod=fmod(*f,1);

//If we already have a whole number, nothing to do.
if (mod==0){
   put_result(val);
   return;};

float result;
if (val&0x80000000)                   
   result=*f-mod;
else
   result=*f-mod+1;

//Deal with -0        
if (result==0&&(val&0x80000000)){
   put_result(0x80000000);
   return;};

int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_sqrt(int val)
{
//Is val NAN?
if (check_nan(val))
   return;

//Deal with -0
if (val==0x80000000){
   put_result(0x80000000);
   return;};

//Cannot get the square root of a negative number
if (val&0x80000000){
   put_result(0xffffffff);
   return;};

float *f=(float *)&val;
float result=sqrt(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_pow(int val1,int val2)
{
//Cannot have val2 of +-0
if ((val2&0x7fffffff)==0){
   put_result(0x3f800000);
   return;};

//Is val1 NAN?
if (check_nan(val1))
   return;

float *f1=(float *)&val1;
float *f2=(float *)&val2;

//Cannot have val1 of 0
if ((val1&0x7fffffff)==0){
   if (*f2<0){
      if (fmod(*f2,1)==0&&fmod(*f2,2)!=0){
         put_result(0x7f800000|(val1&0x80000000));
         return;};
      put_result(0x7f800000);
      return;};
   if (fmod(*f2,1)==0&&fmod(*f2,2)!=0){
      put_result(val1);
      return;};
   put_result(0);
   return;};

//Cannot have -1, +-Infinity
if (*f1==-1&&(val2&0x7fffffff)==0x7f800000){
   put_result(0x3f800000);
   return;};

//Cannot have val1 of 1
if (*f1==1){
   put_result(0x3f800000);
   return;};                   

//Is val2 NAN?
if (check_nan(val2))
   return;

//Cannot have val2 of -INF
if (val2==0xff800000){
   if (fabs(*f1)<1){
      put_result(0x7f800000);
      return;};
   put_result(0);
   return;};

//Cannot have val2 of +INF
if (val2==0x7f800000){
   if (fabs(*f1)<1){
      put_result(0);
      return;};
   put_result(0x7f800000);
   return;};

//Cannot have val1 of -INF
if (val1==0xff800000){
   if (*f2<0){
      if (fmod(*f2,1)==0&&fmod(*f2,2)!=0){
         put_result(0x80000000);
         return;};
      put_result(0);
      return;};
   if (fmod(*f2,1)==0&&fmod(*f2,2)!=0){
      put_result(0xff800000);
      return;};
   put_result(0x7f800000);
   return;};

//Cannot have val1<0, val2 not an integer
if (*f1<0&&fmod(*f2,1)!=0){
   put_result(0xffffffff);
   return;};

//Deal with values too large to calculate
if ((*f1*(*f2))>=256){
   put_result(0x7f800000);
   return;};

float result=pow(*f1,*f2);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_jfne(int val1,int val2,int val3,int offset)
{
//Is any value NAN?
if (check_nan_branch(false,offset,val1,val2,val3))
   return;

//Deal with val1 of +-INF
if ((val1&0x7fffffff)==0x7f800000){
   branch(val1!=val2,offset);
   return;};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
float *f3=(float *)&val3;

branch(fabs(*f1-*f2)>fabs(*f3),offset);
};
//----------------------------------------------------------------------------

void GMACHINE::G_sin(int val)
{
float *f=(float *)&val;
float result=sin(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_cos(int val)
{
float *f=(float *)&val;
float result=cos(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_tan(int val)
{
float *f=(float *)&val;
float result=tan(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_asin(int val)
{
//Deal with -0
if (val==0x80000000){
   put_result(0x80000000);
   return;};

float *f=(float *)&val;

//Cannot have val>1
if (*f>1){
   put_result(0x7fffffff);
   return;};

//Cannot have val<-1
if (*f<-1){
   put_result(0xffffffff);
   return;};

float result=asin(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_acos(int val)
{
float *f=(float *)&val;

//Cannot have val>1
if (*f>1){
   put_result(0x7fffffff);
   return;};

//Cannot have val<-1
if (*f<-1){
   put_result(0xffffffff);
   return;};

float result=acos(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_atan(int val)
{
float *f=(float *)&val;
float result=atan(*f);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_atan2(int val1,int val2)
{
//Is either value NAN?
if (check_nan(val1,val2))
   return;

float pi=M_PI;
int *i_pi=(int *)&pi;

//Deal with val1 of +-0
if ((val1&0x7fffffff)==0){
   if (val2&0x80000000){
      put_result(*i_pi|(val1&0x80000000));
      return;};
    put_result(val1&0x80000000);
    return;};

//Deal with val1 of +-INF
if ((val1&0x7fffffff)==0x7f800000){
   if (val2==0x7f800000){
      pi/=4;
      put_result(*i_pi|(val1&0x80000000));
      return;};
   pi=3*pi/4;
   put_result(*i_pi|(val1&0x80000000));
   return;};

//Deal with val2 of INF
if (val2==0x7f800000){
   put_result(val1&0x80000000);
   return;};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
float result=atan2(*f1,*f2);
int *i_result=(int *)&result;
put_result(*i_result);
}
//----------------------------------------------------------------------------

void GMACHINE::G_jfeq(int val1,int val2,int val3,int offset)
{
//Is any value NAN?
if (check_nan_branch(true,offset,val1,val2,val3))
   return;

//Deal with val1 of +-INF
if ((val1&0x7fffffff)==0x7f800000){
   branch(val1==val2,offset);
   return;};

float *f1=(float *)&val1;
float *f2=(float *)&val2;
float *f3=(float *)&val3;

branch(fabs(*f1-*f2)<=fabs(*f3),offset);
};
//----------------------------------------------------------------------------

bool GMACHINE::check_nan_branch(bool equal,int offset,unsigned int val1,unsigned int val2,unsigned int val3)
{
if ((val1>=0x7f800001&&val1<=0x7fffffff)||(val2>=0x7f800001&&val2<=0x7fffffff)||(val3>=0x7f800001&&val3<=0x7fffffff)){
   branch(!equal,offset);
   return (true);};
if ((val1>=0xff800001&&val1<=0xffffffff)||(val2>=0xff800001&&val2<=0xffffffff)||(val3>=0xff800001&&val3<=0xffffffff)){
   branch(!equal,offset);
   return (true);};

return (false);
}
//---------------------------------------------------------------------------

void GMACHINE::G_jfle(int val1,int val2,int offset)
{
//Is any value NAN?
if (check_nan_branch(true,offset,val1,val2))
   return;

float *f1=(float *)&val1;
float *f2=(float *)&val2;

branch(*f1<=*f2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::G_jfgt(int val1,int val2,int offset)
{
//Is any value NAN?
if (check_nan_branch(true,offset,val1,val2))
   return;

float *f1=(float *)&val1;
float *f2=(float *)&val2;

branch(*f1>*f2,offset);
};
//---------------------------------------------------------------------------

void GMACHINE::write_tresult(TIME_STRUCT time)
{
unsigned int addr=pop_stack();

if (addr==0)
  return;

if (addr==0xffffffff){
  push_stack(time.high_sec);
  push_stack(time.low_sec);
  push_stack(time.microsec);}
else{
  write_long(time.high_sec,addr);
  write_long(time.low_sec,addr+4);
  write_long(time.microsec,addr+8);};
};
//---------------------------------------------------------------------------

void GMACHINE::read_tresult(TIME_STRUCT *time)
{
unsigned int addr=pop_stack();

if (addr==0){
  memset (time,0,12);
  return;};

if (addr==0xffffffff){
  time->microsec=pop_stack();
  time->low_sec=pop_stack();
  time->high_sec=pop_stack();}
else{
  time->high_sec=read_long(addr);
  time->low_sec=read_long(addr+4);
  time->microsec=read_long(addr+8);};
};
//---------------------------------------------------------------------------

void GMACHINE::write_dresult(DATE_STRUCT date)
{
unsigned int addr=pop_stack();

if (addr==0)
  return;

if (addr==0xffffffff){
  push_stack(date.year);
  push_stack(date.month);
  push_stack(date.day);
  push_stack(date.weekday);
  push_stack(date.hour);
  push_stack(date.minute);
  push_stack(date.second);
  push_stack(date.microsec);}
else{
  write_long(date.year,addr);
  write_long(date.month,addr+4);
  write_long(date.day,addr+8);
  write_long(date.weekday,addr+12);
  write_long(date.hour,addr+16);
  write_long(date.minute,addr+20);
  write_long(date.second,addr+24);
  write_long(date.microsec,addr+28);};
};
//---------------------------------------------------------------------------

void GMACHINE::read_dresult(DATE_STRUCT *date)
{
unsigned int addr=pop_stack();

if (addr==0){
  memset (time,0,12);
  return;};

if (addr==0xffffffff){
  date->microsec=pop_stack();
  date->second=pop_stack();
  date->minute=pop_stack();
  date->hour=pop_stack();
  date->weekday=pop_stack();
  date->day=pop_stack();
  date->month=pop_stack();
  date->year=pop_stack();}
else{
  date->year=read_long(addr);
  date->month=read_long(addr+4);
  date->day=read_long(addr+8);
  date->weekday=read_long(addr+12);
  date->hour=read_long(addr+16);
  date->minute=read_long(addr+20);
  date->second=read_long(addr+24);
  date->microsec=read_long(addr+28);};
};
//---------------------------------------------------------------------------

void GMACHINE::read_array(unsigned int *array,int addr,int count)
{
if (addr==0xffffffff){
  for (int i=0;i<count;i++){
    array[i]=pop_stack();};}
else{
  for (int i=0;i<count;i++){
    array[i]=read_long(addr+i*4);};};
}

