//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "colors.h"
#include "glkthread.h"
#include "verbs.h"
#include "nav.h"
#include "preps.h"
#include "Main.h"
//---------------------------------------------------------------------
#pragma resource "*.dfm"
TColorsDialog *ColorsDialog;
extern GLK *glk;

//---------------------------------------------------------------------
__fastcall TColorsDialog::TColorsDialog(TComponent* AOwner)
	: TForm(AOwner)
{
}
//---------------------------------------------------------------------
void TColorsDialog::populate_colors()
{
GameBackColor->Selected=MainForm->Color;
VerbsBackColor->Selected=VerbForm->Color;
NavBackColor->Selected=CompassForm->Color;
PrepBackColor->Selected=PrepForm->Color;

GameForeColor->Selected=MainForm->prop_font->Color;
VerbsForeColor->Selected=VerbForm->Font->Color;
NavForeColor->Selected=CompassForm->Font->Color;
PrepForeColor->Selected=PrepForm->Font->Color;
};
//---------------------------------------------------------------------------

void __fastcall TColorsDialog::FormShow(TObject *Sender)
{
oked=false;

orig_game_back=GameBackColor->Selected;
orig_verbs_back=VerbsBackColor->Selected;
orig_nav_back=NavBackColor->Selected;
orig_prep_back=PrepBackColor->Selected;

orig_game_fore=GameForeColor->Selected;
orig_verbs_fore=VerbsForeColor->Selected;
orig_nav_fore=NavForeColor->Selected;
orig_prep_fore=PrepForeColor->Selected;
}
//---------------------------------------------------------------------------

void __fastcall TColorsDialog::CancelBtnClick(TObject *Sender)
{
GameBackColor->Selected=orig_game_back;
VerbsBackColor->Selected=orig_verbs_back;
NavBackColor->Selected=orig_nav_back;
PrepBackColor->Selected=orig_prep_back;

GameForeColor->Selected=orig_game_fore;
VerbsForeColor->Selected=orig_verbs_fore;
NavForeColor->Selected=orig_nav_fore;
PrepForeColor->Selected=orig_prep_fore;
}
//---------------------------------------------------------------------------

void __fastcall TColorsDialog::FormClose(TObject *Sender,
      TCloseAction &Action)
{
if (!oked)
  CancelBtnClick(NULL);  
}
//---------------------------------------------------------------------------

void __fastcall TColorsDialog::OKBtnClick(TObject *Sender)
{
MainForm->Color=GameBackColor->Selected;
for (int i=0;i<11;i++){
  glk->textbuffer_style[i].back_color=GameBackColor->Selected;
  glk->textgrid_style[i].back_color=GameBackColor->Selected;};
VerbForm->Color=VerbsBackColor->Selected;
CompassForm->Color=NavBackColor->Selected;
PrepForm->Color=PrepBackColor->Selected;

MainForm->prop_font->Color=GameForeColor->Selected;
MainForm->fixed_font->Color=GameForeColor->Selected;
for (int i=0;i<11;i++){
  glk->textbuffer_style[i].text_color=GameForeColor->Selected;
  glk->textgrid_style[i].text_color=GameForeColor->Selected;};
VerbForm->Font->Color=VerbsForeColor->Selected;
CompassForm->Font->Color=NavForeColor->Selected;
PrepForm->Font->Color=PrepForeColor->Selected;

oked=true;
}
//---------------------------------------------------------------------------

