// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  prop.h:
//
//  this module defines the property class, which is used as a
//  higher-level representation of properties within the z-machine's
//  memory.  the object basically contains the address of the associated
//  property, providing an interface that simplifies code in inst.cc a
//  great deal.
//
//  note that properties can only be created by two means:
//    1. by an object object (see obj.cc)
//    2. as an invalid object, to be assigned later
// =======================================================================

#ifndef _prop_h_
#define _prop_h_

#include "zeal.h"
#include "machine.h"
#include "obj.h"

class property {
    public:
        property();
        property(const property& prop);

        property& operator=(const property& prop);

        bool valid();
        ubyte get_number();
        ubyte get_size();
        address get_address();
        property get_next();

        uword read_word();
        void write_word(uword word);

        static property from_addr(address addr);

    private:
        // only methods of the object and property classes can call
        // these constructors.
        friend class object;
        property(address addr_in);
        property(address table, ubyte n);

        address addr;

        ubyte get_header_size();
};

#endif // _prop_h_
