// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  error.cc:
//
//  this module defines some simple functions designed for use with the
//  assertion mechanism.  since we want assertions to be printed to the
//  game console, we need to use the io global, but we don't want to
//  access that within macros, since that's just plain messy.
// =======================================================================

#include "zeal.h"
#include "error.h"
#include "iface.h"

extern iface* io;

void
zeal_assert(char* msg, char* file, int line)
{
    if (io != NULL) {
        io->put_error("Fatal error: %s (%s:%d)", msg, file, line);
    }
    glk_exit();
}

void
zeal_warn(char* msg, bool* warned)
{
    if (io == NULL || io->put_warning(msg, warned)) {
        glk_exit();
    }
}
