# make_zcode_cat
# perl routine to construct the set of html documents for the Catalog of ZCode programs
# Michael Baum
# Last revised: Thursday, July 22, 1999 12:21 PM

($datafile,$refresh) = @ARGV;    # takes as argument the zcode data file name
                                 # $refresh is either 1 (true) or 0 (false) and
                                 # determines whether or not the boilerplate
                                 # documents are "refreshed" with new color and
                                 # background settings

if ($datafile eq "") {syntax();}

# Some global definitions, the html document names:
$dindex = "ZCatDNF.htm";     # detailed view -- no frames version
$dfdoc = "ZCatDF.htm";       # detailed view -- frames version
$dtop = "ZTopD.htm";         # detailed view -- top frame
$dfindex = "ZBottomD.htm";   # detailed view -- bottom frame
$tindex = "ZCatTNF.htm";     # titles view -- no frames version
$tfdoc = "ZCatTF.htm";       #             -- frames version
$ttop = "ZTopT.htm";         #             -- top frame
$tfindex = "ZBottomT.htm";   #             -- bottom frame
$aindex = "ZCatANF.htm";     # authors view -- no frames version
$afdoc = "ZCatAF.htm";       #              -- frames version
$atop = "ZTopA.htm";         #              -- top frame
$afindex = "ZBottomA.htm";   #              -- bottom frame
$gindex = "ZCatGNF.htm";     # categories view -- no frames version
$gfdoc = "ZCatGF.htm";       #                 -- frames version
$gtop = "ZTopG.htm";         #                 -- top frame
$gflist = "ZBottomG.htm";    #                 -- bottom frame
$gfindex = "GIndex.htm";     #                 -- index frame
$home = "ZCatalog.htm";      # home page
$homenf = "ZCatalogNF.htm";  #                 -- without frames
$howto = "ZCatHow.htm";      # "how to" page
$howtonf = "ZCatHowNF.htm";  #                 -- without frames

# Global html color definitions:
$bgcolor="#ADAAB2";
$textcolor="#000000";
#$linkcolor="#FFFF50";
$linkcolor="#DD1090";
$vlinkcolor=$linkcolor;
$alinkcolor="#FF00FF";
$background="stone.gif";
$emphasis="#100080";

$archive = "ftp://ftp.gmd.de/if-archive";   # default expansion for the archive site
$genres = "genre.dat";         # File that links genre tags with their expansions

@typenames = ("","Standard Games","Enhanced V.6 Games");  # two types for now

# First look up the information on the currently acceptable genre tags
# Yes, this is a misuse of the word "genre". No, I don't want to hear about it.
%genrelist = ();
%genreorder = ();
%genreexist = ();

open DATA, "<$genres" or die "Couldn't open the genre information file - $!\n";
while (<DATA>) {
   if (/^#/) {next;}    # Skip comment lines
   if (/^\s*$/) {next;} # Skip blank lines
   chomp;
   ($tag,$order,$text) = split(/\|/);
   $genrelist{"$order$tag"} = $text;
   $genreorder{$tag} = "$order$tag";
}
close DATA;

# This next section does the heavy work of creating an html document listing
# all of the program titles alphabetically, and hypertext-linked to a parallel
# document that gives all the fine detail on each program
# There are two versions of each document (yes, that's four in all), one for
# the "framed" version and one for the vanilla version
# As we read through the source data file, additional arrays are created to
# hold interim information used for the subsequent indices, such as the index
# by authors.

print "Building the z-code catalog documents...\n";

open DATA, "<$datafile" or die "Couldn't open $datafile - $!\n";
open MAIN, ">$dindex" or die "Couldn't open $dindex - $!\n";
open MAIN2, ">$dfindex" or die "Couldn't open $dfindex - $!\n";
open INDX, ">$tindex" or die "Couldn't open $tindex - $!\n";
open INDX2, ">$tfindex" or die "Couldn't open $tfindex - $!\n";

@indauthor='';     # This array holds the info for the author index
@indgenre='';      # This array holds the info for the genre index
$counter=0;
$coounter2=0;
$currentletter = 64;  # Used to keep our place in the alphabetical list
$firstcase = 1;

makedetailtop(MAIN,"NF");
maketitletop(INDX,"NF");
simpleheader(MAIN2,"Z-Catalogue Detailed View");
simpleheader(INDX2,"Z-Catalogue Titles View");

print MAIN "<dl>\n";
print MAIN2 "<dl>\n";

print "Creating the z-files detailed lists and the alphabetical lists of titles...\n";

while (<DATA>) {
   if (/^# Date: (.+)$/) {$update=$1; next;} # Get the last update record.
   if (/^#/) {next;}    # Skip comment lines
   if (/^\s*$/) {next;} # Skip blank lines
   chomp;
   ($title,$filename,$touch,$loc,$type,$genre,$author,$authemail,$rel,$ser,$inf,$lib,$source,$comp,$desc,$lang,$notes) = split(/\|/);
   $refname = "R$.";    # The "name" field used in the html docs is built out of the original datafile line number and the letter 'R'
   @nmlst = split(/ /,getname($author));   # Break out the author(s) last names for that index

   # These lines write the alphabetical list of titles
   $firstl = firstlet($title);
   while(chr($currentletter) ne $firstl) {
      $currentletter++;
      if ($firstcase) {$firstcase=0;}
      else {
         print INDX "</p><p align=\"left\"><a href=\"#index\"><b>Back to index...</b></a>\n</dd><br>\n";
         print INDX "<hr align=\"center\" width=\"50%\">\n";
         print MAIN "</p><p align=\"left\"><a href=\"#index\"><b>Back to index...</b></a>\n</dd><br>\n";
         print MAIN "<hr align=\"center\" width=\"50%\">\n";
         print INDX2 "</p></dd><br>\n<hr align=\"center\" width=\"50%\">\n";
      }
      print INDX "<p align=\"left\"><font color=\"$emphasis\" size=\"6\"><a name=\"",chr($currentletter),"name\">",chr($currentletter),"</font></a></p>\n";
      print INDX "<p align=\"center\">";
      print INDX2 "<p align=\"left\"><font color=\"$emphasis\" size=\"6\"><a name=\"",chr($currentletter),"name\">",chr($currentletter),"</font></a></p>\n";
      print INDX2 "<p align=\"center\">";
      print MAIN "<p align=\"left\"><font color=\"$emphasis\" size=\"6\"><a name=\"",chr($currentletter),"name\">",chr($currentletter),"</font></a></p>\n";
      print MAIN2 "</dl><a name=\"",chr($currentletter),"name\"> </a><dl>\n";

   }
   $title = fixtitle($title);
   print INDX "<a href=\"$dindex#$refname\">$title</a><br>\n";
   print INDX2 "<a href=\"$dfindex#$refname\">$title</a><br>\n";

   # These lines write the complete record info to the master list documents
   $author =~ s/\*//g;  # Strip out the * tags from the author field
   fulldesc(MAIN,$title,$filename,$loc,$author,$authemail,$rel,$ser,$inf,$lib,$source,$comp,$desc,$lang,$notes,$refname);
   fulldesc(MAIN2,$title,$filename,$loc,$author,$authemail,$rel,$ser,$inf,$lib,$source,$comp,$desc,$lang,$notes,$refname);

   # Create the array we'll use for building the author index
   foreach $nm (@nmlst) {
      $indauthor[$counter++] = "$nm|$title|$refname";
   }

   # Create the array used to build the genre list
   @gnlst = split(/ /,$genre);
   foreach $gn (@gnlst) {
      $indgenre[$counter2++] = "$type|$genreorder{$gn}|$title|$refname";
      $genreexist{$type . $genreorder{$gn}} = 1;     # use this later so the internal jump table only has entries for existing data
   }
}

close DATA;
print MAIN "</dl></BODY></HTML>\n";
close MAIN;
print MAIN2 "</dl></BODY></HTML>\n";
close MAIN2;
print INDX "</dd></dl><hr></BODY></HTML>\n";
close INDX;
print INDX2 "</dd></dl><hr></BODY></HTML>\n";
close INDX2;

# These next lines create the index-by-authors, once again in two versions

print "Creating the alphabetical list by authors...\n";
open INDX, ">$aindex" or die "Couldn't open $aindex - $!\n";
makeauthortop(INDX,"NF");
open INDX2, ">$afindex" or die "Couldn't open $afindex - $!\n";
simpleheader(INDX2,"Z-Files Catalogue Author Index");
print INDX "<hr>\n<dl>";
print INDX2 "<dl>";
@indauthor = sort { lc($a) cmp lc($b) } @indauthor;
$currentletter = 64;
$currentname = "";
$firstcase = 1;
foreach $authstr (@indauthor) {
   ($auth,$titl,$ref) = split(/\|/,$authstr);
   $firstl = firstlet($auth);
   while(chr($currentletter) ne $firstl) {
      $currentletter++;
      if ($firstcase) {$firstcase=0;}
      else {
         print INDX "</ul><p><a href=\"#index\"><b>Back to index...</b></a>\n</dd><br>\n";
         print INDX "<hr align=\"center\" width=\"50%\">\n";}
      print INDX "<dt><center><a name=\"",chr($currentletter),"name\"><font color=\"$emphasis\" size=\"7\">",chr($currentletter),"</font></a></center>\n<dd>";
      print INDX2 "</ul></dd><dt><center><a name=\"",chr($currentletter),"name\"><font color=\"$emphasis\" size=\"7\">",chr($currentletter),"</font></a></center>\n<dd>";
   }
   if ($currentname ne $auth) {
      $currentname = $auth;
      print INDX "</ul><h3>$auth</h3><ul>\n";
      print INDX2 "</ul><h3>$auth</h3><ul>\n";
   }
   print INDX "<li><a href=\"$dindex#$ref\"><b>$titl</b></a>\n";
   print INDX2 "<li><a href=\"$dfindex#$ref\"><b>$titl</b></a>\n";
}
print INDX "</ul></dl><hr></body></html>";
print INDX2 "</ul></dl><hr></body></html>";
close INDX;
close INDX2;

# And finally we create two versions of the index by categories

print "Creating the list of titles by genre...\n";

open INDX, ">$gindex" or die "Couldn't open $gindex - $!\n";
makegenretop(INDX,"NF");
genreindex(INDX,"NF");

open INDX2, ">$gfindex" or die "Couldn't open $gfindex - $!\n";
genreindex(INDX2,"F");
close INDX2;
open INDX2, ">$gflist" or die "Couldn't open $gflist - $!\n";
simpleheader(INDX2,"The Z-Code Catalogue - Category Index");

$currentname = "";
$currenttype = 0;
$firstcase = 1;

@indgenre = sort { lc($a) cmp lc($b) } @indgenre;
foreach $genstr (@indgenre) {
   ($typ,$gen,$tit,$ref) = split(/\|/,$genstr);
   if ($currenttype != $typ) {
      $currenttype = $typ;
      $firstcase = 1;
      print INDX "</dl>\n<hr><center><h2>$typenames[$currenttype]</h3></center><hr><dl>\n";
      print INDX2 "</dl>\n<hr><center><h2>$typenames[$currenttype]</h3></center><hr><dl>\n";
   }
   if ($genrelist{$gen} ne $currentname) {
      $currentname = $genrelist{$gen};
      if ($firstcase) {$firstcase = 0;}
      else {print INDX "<br><a href=\"#index\">Back to index...</a>\n";}
      print INDX "<dt><a name=\"$currenttype$gen\"><h3>$currentname <i>[$typenames[$currenttype]]</i></h3>";
      print INDX2 "<dt><a name=\"$currenttype$gen\"><h3>$currentname <i>[$typenames[$currenttype]]</i></h3>";

   }
   print INDX "<dd><a href=\"$dindex#$ref\">$tit</a><br>\n";
   print INDX2 "<dd><a href=\"$dfindex#$ref\">$tit</a><br>\n";
}
print INDX "<hr></body></html>\n";
print INDX2 "<hr></body></html>\n";
close INDX;
close INDX2;

# This next short section rebuilds the top frames of the various index documents,
# and rewrites the <BODY> settings for the boilerplate documents such as the
# frames and no-frames home pages. This only happens if $refresh is set to 1 (true)
# on the command line. This is just a simple way to keep all of the link and text
# colors as well as the background gif consistent if we decide to change them for
# some reason.

if ($refresh) {
   print "Refreshing color settings for $dtop.\n";
   open DOC, ">$dtop" or die "Couldn't open $dtop - $!\n";
   makedetailtop(DOC,"F");
   close DOC;
   print "Refreshing color settings for $ttop.\n";
   open DOC, ">$ttop" or die "Couldn't open $ttop - $!\n";
   maketitletop(DOC,"F");
   close DOC;
   print "Refreshing color settings for $atop.\n";
   open DOC, ">$atop" or die "Couldn't open $atop - $!\n";
   makeauthortop(DOC,"F");
   close DOC;
   print "Refreshing color settings for $gtop.\n";
   open DOC, ">$gtop" or die "Couldn't open $gtop - $!\n";
   makegenretop(DOC,"F");
   close DOC;
   refresh($howto);
   refresh($howtonf);
}

# We "refresh" the two "home" pages regardless because the subroutine
# also updates the timestamp line at the end of the page (which reports
# the date of last update of the data file.

refresh($home);
refresh($homenf);

print "Finished!\n";

# Bail!
exit;

# Since the titles are stored with leading articles at the end (for sorting purposes),
# the subroutine fixtitle puts them back in proper order again.

sub fixtitle {
   ($in) = @_;
   if ($in =~ /^(.*), (\w+)$/) {
      return "$2 $1";
   }
   return $in;
}

# The subroutine getname scans the author field data and picks out the relevant
# surnames (flagged by a leading '*') for use in the index by authors

sub getname {
   ($namein) = @_;
   @names = split(/ /,$namein);
   $out = "";
   foreach $nm (@names) {
      if ($nm =~ /\*(\S+)/) {
         $out = "$out$1 ";
      }
   }
   $out =~ s/,//g;
   chop($out);
   return $out;
}

# The subroutine firstlet returns the first letter, uppercased, of a string

sub firstlet {
   local($instr) = @_;
   return(uc(substr($instr,0,1)));
}

# The subroutine fulldesc is the bit that actually builds the html code for an
# entry in the detailed list of z-code programs, picking the necessary information
# out of the data record and formatting as needed.

sub fulldesc {
   local($outf,$tit,$fn,$loc,$aut,$eml,$rel,$ser,$inf,$lib,$src,$cmp,$dsc,$lng,$nts,$ref) = @_;
   local($locexpand);
   if ($fn eq "NA") {
      if ($loc ne "") { $loc = "May be no longer available. Last known location: $loc"; }
      else {$loc = "May be no longer available. No known location."};
   }
   else {
      if ($fn eq "COM") {
         $fn = "Commercial Product";
      }
      else {if ($loc =~ /\/$/) {$loc = $loc . $fn;} }
   }
   if ($loc =~ /^\[if-archive\](.+)$/) {$locexpand = "$archive$1";}
   else {$locexpand = $loc;}
   print $outf "<dt><a name=\"$ref\"><b>$tit</b></a>";
   if ($fn ne "NA") {print $outf " [<a href=\"$locexpand\">$fn</a>] <i>$lng</i>\n<dd>$aut";}
   else {print $outf " [$loc] <i>$lng</i>\n<dd>$aut";}
   if ($eml ne "") {print $outf " [<a href=\"mailto:$eml\">$eml</a>]";}
   print $outf "<br>";
   if ($rel ne "") {print $outf "Release: $rel ";}
   if ($ser ne "") {print $outf "Serial No.: $ser ";}
   if ($inf ne "") {print $outf "Inform version: $inf ";}
   if ($lib ne "") {print $outf "Library version: $lib ";}
   print $outf "<br>\n";
   if ($cmp ne "") {print $outf "$cmp<br>\n";}
   print $outf "<p>$dsc";
   if ($nts ne "") {print $outf "<br><i>$nts</i>";}
   if ($src ne "") {print $outf "<br>Source code available: $src";}
   print $outf "<br><br></p></dd>\n";
   return;
}

# simpleheader just puts a bare-bones html introduction on a file.
# It's used for the documents that make up the bottom frames of the
# "framed" version of the catalog

sub simpleheader {
   local($outf,$title) = @_;

   print $outf "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
   print $outf "<HTML>\n<HEAD>\n<TITLE>$title</TITLE>\n</HEAD>\n";
   print $outf "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   return;
}

# This subroutine builds the header and alphabet menu portion of the two html
# documents that list programs by title. Pass it "F" as the $mode value to get
# the frames version.

sub maketitletop {
   local($out,$mode) = @_;

   print $out <<Finis;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>The Z-Files Catalogue - Viewed by Title</TITLE>
<META NAME="Author" CONTENT="Michael Baum">
<META NAME="Keywords" CONTENT="interactive fiction games Inform">
</HEAD>
Finis

   print $out "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   print $out "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\"BORDER=\"0\">\n<TR>\n";
   print $out "<TD WIDTH=300><TABLE WIDTH=\"300\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\">\n\t<TR>\n";
   print $out "\t\t<TD WIDTH=\"100\"><IMG SRC=\"tibuttond.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></TD>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dindex\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$home\" TARGET=\"_top\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$homenf\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   print $out "\t</TR>\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$afdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$aindex\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gindex\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howto\" TARGET=\"_top\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howtonf\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   print $out "\t</TR>\n</TABLE></TD>\n";
   print $out "<TD WIDTH=\"400\"><IMG SRC=\"zfilestitle.gif\" ALT=\"The Z-Files Catalogue\" ALIGN=\"right\" HEIGHT=156 WIDTH=400>\n";
   print $out "</TR>\n<TR><TD COLSPAN=2><A NAME=\"index\"><TABLE ALIGN=\"center\" BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"80%\"></A>\n";
   print $out "<TR ALIGN=\"center\" VALIGN=\"middle\">\n";

   if ($mode eq "F") {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"$tfindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "\n</TR>\n<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
   if ($mode eq "F") {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"$tfindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "</TR></TABLE></TD></TR>\n</TABLE>\n";

   if ($mode eq "F") {print $out "</BODY>\n</HTML>";}
   return;
}

# This subroutine builds the header and alphabet menu portion of the two html
# documents that list programs by author. Pass it "F" as the $mode value to get
# the frames version.

sub makeauthortop {
   local($out,$mode) = @_;

   print $out <<Finis;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>The Z-Files Catalogue - Viewed by Author</TITLE>
<META NAME="Author" CONTENT="Michael Baum">
<META NAME="Keywords" CONTENT="interactive fiction games Inform">
</HEAD>
Finis

   print $out "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   print $out "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\"BORDER=\"0\">\n<TR>\n";
   print $out "<TD WIDTH=300><TABLE WIDTH=\"300\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\">\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tindex\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dindex\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$home\" TARGET=\"_top\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$homenf\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   print $out "\t</TR>\n\t<TR>\n";
   print $out "\t\t<TD WIDTH=\"100\"><IMG SRC=\"aubuttond.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></TD>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gindex\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howto\" TARGET=\"_top\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howtonf\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   print $out "\t</TR>\n</TABLE></TD>\n";
   print $out "<TD WIDTH=\"400\"><IMG SRC=\"zfilestitle.gif\" ALT=\"The Z-Files Catalogue\" ALIGN=\"right\" HEIGHT=156 WIDTH=400>\n";
   print $out "</TR>\n<TR><TD COLSPAN=2><A NAME=\"index\"><TABLE ALIGN=\"center\" BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"80%\"></A>\n";
   print $out "<TR ALIGN=\"center\" VALIGN=\"middle\">\n";

   if ($mode eq "F") {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"$afindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "\n</TR>\n<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
   if ($mode eq "F") {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"$afindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "</TR></TABLE></TD></TR>\n</TABLE>\n";

   if ($mode eq "F") {print $out "</BODY>\n</HTML>";}
   return;
}

# This subroutine builds the header and alphabet menu portion of the two html
# documents that list programs by title with details. Pass it "F" as the $mode
# value to get the frames version.

sub makedetailtop {
   local($out,$mode) = @_;

   print $out <<Finis;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>The Z-Files Catalogue - Detailed View</TITLE>
<META NAME="Author" CONTENT="Michael Baum">
<META NAME="Keywords" CONTENT="interactive fiction games Inform">
</HEAD>
Finis

   print $out "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   print $out "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\"BORDER=\"0\">\n<TR>\n";
   print $out "<TD WIDTH=300><TABLE WIDTH=\"300\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\">\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tindex\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   print $out "\t\t<TD WIDTH=\"100\"><IMG SRC=\"debuttond.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></TD>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$home\" TARGET=\"_top\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$homenf\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   print $out "\t</TR>\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$afdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$aindex\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$gindex\" TITLE=\"Z-Catalogue Index by Categories\"><IMG SRC=\"gebuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howto\" TARGET=\"_top\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howtonf\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   print $out "\t</TR>\n</TABLE></TD>\n";
   print $out "<TD WIDTH=\"400\"><IMG SRC=\"zfilestitle.gif\" ALT=\"The Z-Files Catalogue\" ALIGN=\"right\" HEIGHT=156 WIDTH=400>\n";
   print $out "</TR>\n<TR><TD COLSPAN=2><A NAME=\"index\"><TABLE ALIGN=\"center\" BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"80%\"></A>\n";
   print $out "<TR ALIGN=\"center\" VALIGN=\"middle\">\n";

   if ($mode eq "F") {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"$dfindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=65;$char<78;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "\n</TR>\n<TR ALIGN=\"center\" VALIGN=\"middle\">\n";
   if ($mode eq "F") {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"$dfindex#",chr($char),"name\" TARGET=\"ZBody\"><B>",chr($char),"</B></A></TD>";}}
   else {for ($char=78;$char<91;$char++) {print $out "<TD><A HREF=\"#",chr($char),"name\"><B>",chr($char),"</B></A></TD>";}}
   print $out "</TR></TABLE></TD></TR>\n</TABLE>\n";

   if ($mode eq "F") {print $out "</BODY>\n</HTML>";}
   return;
}

# This subroutine builds the header and alphabet menu portion of the two html
# documents that list programs by category. Pass it "F" as the $mode value to get
# the frames version.

sub makegenretop {
   local($out,$mode) = @_;

   print $out <<Finis;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>The Z-Files Catalogue - View by Categories</TITLE>
<META NAME="Author" CONTENT="Michael Baum">
<META NAME="Keywords" CONTENT="interactive fiction games Inform">
</HEAD>
Finis

   print $out "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   print $out "<TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\"BORDER=\"0\">\n<TR>\n";
   print $out "<TD WIDTH=300><TABLE WIDTH=\"300\" CELLSPACING=\"0\" CELLPADDING=\"0\" BORDER=\"0\">\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$tindex\" TITLE=\"Z-Catalogue Index by Titles\"><IMG SRC=\"tibuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Titles\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dfdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$dindex\" TITLE=\"Z-Catalogue Detailed List\"><IMG SRC=\"debuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Detailed List\"></A></TD>\n";}
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$home\" TARGET=\"_top\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$homenf\" TITLE=\"Z-Catalogue Home Page\"><IMG SRC=\"hobuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Home Page\"></A></TD>\n";}
   print $out "\t</TR>\n\t<TR>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$afdoc\" TARGET=\"_top\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$aindex\" TITLE=\"Z-Catalogue Index by Authors\"><IMG SRC=\"aubuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Authors\"></A></TD>\n";}
   print $out "\t\t<TD WIDTH=\"100\"><IMG SRC=\"gebuttond.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"Z-Catalogue Index by Categories\"></TD>\n";
   if ($mode eq "F") {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howto\" TARGET=\"_top\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   else {print $out "\t\t<TD WIDTH=\"100\"><A HREF=\"$howtonf\" TITLE=\"How To Play These Games\"><IMG SRC=\"plbuttonu.gif\" WIDTH=\"100\" HEIGHT=\"50\" ALT=\"How To Play These Games\"></A></TD>\n";}
   print $out "\t</TR>\n</TABLE></TD>\n";
   print $out "<TD WIDTH=\"400\"><IMG SRC=\"zfilestitle.gif\" ALT=\"The Z-Files Catalogue\" ALIGN=\"right\" HEIGHT=156 WIDTH=400>\n";
   print $out "</TR>\n</TABLE>\n";

   if ($mode eq "F") {print $out "</BODY>\n</HTML>";}
   return;
}

# genreindex builds the tricky internal jump table that lists the various categories of
# program. The nifty bit is that it only includes link entries for categories that
# actually exist.

sub genreindex {
   local($out,$mode) = @_;

   if ($mode eq "F") {
      print $out <<Finis;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>
<HEAD>
<TITLE>The Z-Files Catalogue - Genre Index</TITLE>
</HEAD>
Finis

      print $out "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";
   }

   if ($mode ne "F") {print $out "<hr>\n";}
   print $out "\n<a name=\"index\"><table align=\"center\" size=\"90%\" border=\"0\"></a>\n";
   foreach $key (sort keys %genrelist) {
      print $out "<tr><td align=\"right\" width=\"50%\"><b>$genrelist{$key}</b></td>\n";
      if ($mode eq "F") {
         if ($genreexist{"1" . $key}) {print $out "<td align=\"center\" width=\"25%\"><a href=\"$gflist#1$key\" TARGET=\"ZBody\">$typenames[1]</a></td>\n";}
         else {print $out "<td align=\"center\" width=\"25%\"></td>\n";}
      }
      else {
         if ($genreexist{"1" . $key}) {print $out "<td align=\"center\" width=\"25%\"><a href=\"#1$key\">$typenames[1]</a></td>\n";}
         else {print $out "<td align=\"center\" width=\"25%\"></td>\n";}
      }
      if ($mode eq "F") {
         if ($genreexist{"2" . $key}) {print $out "<td align=\"center\" width=\"25%\"><a href=\"$gflist#2$key\" TARGET=\"ZBody\">$typenames[2]</a></td>\n</tr>\n";}
         else {print $out "<td align=\"center\" width=\"25%\"></td>\n";}
      }
      else {
         if ($genreexist{"2" . $key}) {print $out "<td align=\"center\" width=\"25%\"><a href=\"#2$key\">$typenames[2]</a></td>\n</tr>\n";}
         else {print $out "<td align=\"center\" width=\"25%\"></td>\n";}
      }
   }
   print $out "</table>\n";
   if ($mode ne "F") {print $out "<hr>\n";}
   if ($mode eq "F") {print $out "</BODY>\n</HTML>";}

   return;
}

# subroutine refresh simply reads in an existing html page to a buffer array,
# and writes it back out again, rewriting the color and background settings in
# the <BODY> tag with whatever the current global values are. It also updates
# the last-revision line in the main ("ZCatalog.htm") pages.

sub refresh {
   local($fn) = @_;
   local(@lines,$ind,$count);
   $ind = 0;
   print "Refreshing $fn.\n";
   open FIL, "<$fn" or die "Unable to read from $fn - $!\n";
   while (<FIL>) {
      $lines[$ind] = $_;
      if (/^\<BODY/) { $lines[$ind] = "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" ALINK=\"$alinkcolor\" BACKGROUND=\"$background\">\n";}
      if (/^\<\!-- Date stamp --\>/) { $lines[$ind] = "<!-- Date stamp --><p><i>This catalogue stopped being current on $update.</i>\n";}
      $ind++;
   }
   close FIL;
   $count = $ind;
   open FIL, ">$fn" or die "Unable to write to $fn - $!\n";
   for ($ind=0;$ind<$count;$ind++) {print FIL $lines[$ind];}
   close FIL;
   return;
}

sub syntax {
   print <<Finis;

make_zcode_cat.pl
   Build the html documents for the Z-Code Catalog of programs.

   Syntax:
   perl make_zcode_cat.pl <datafile> <[1|0]>

      datafile - [required] name of the properly-formatted data file for
                  z-code programs (typically zfiles.dat).
      [1|0] - [optional] refresh color and background settings for the
                  "boilerplate" html documents such as ZCatalog.htm?
                  1 - yes 0 - no default -> no

Finis
   exit;
}