// VENUS


//  Venus Functions



venusdie: function
	{
	"You take two steps and get bogged down in the soft, hot ground.  A strange warm
		sensation quickly travels up your legs.  The feeling is almost pleasant until
		you realize that it is caused by the near-molten ground dissolving your suit
		and body.";
	die();
	}
;

vlakedie: function
	{
	"You take a bold step towards the lake, dive in and are quickly liquefied.";
	die();
	}
;

venuscount: function (parm)
{
    countvars.vt := countvars.vt + 1;
	if (countvars.vt = 9)
		{
		local  melist, j,  obj, objlist, lobjlist, jj, cobj,
		 cobjlist, lcobjlist, jjj, ccobj, vlist, vobj, vobjlist,vi,  l, masterlist, lmasterlist,
		venrlist, ri;
		l := [];
		melist := [];
		masterlist := [];
		vlist := [];
		venrlist := [venus lakeshore mthcave vcave ropeledge ledge shipin];
		{
		ri := 1;
		while( ri <= 7)
			{
			vobjlist := [];
			vobjlist := venrlist[ri].contents;			// routine gets all objects in the venusrooms
			l := l + vobjlist;								// groups all objects in venus together
			ri := ++ri;
			}
		vlist := l;
		}
		melist := Me.contents;             // inventory
		masterlist := vlist + melist;		// things in inventory + things on venus
		j := 1;
		lmasterlist := length (masterlist);        // # of things in inventory
		while (j <= lmasterlist)
			{
			obj := masterlist [j];
			if (obj.vulner)                   // is current object vulnerable
				{
				"\b\^<<obj.thedesc>> succumbs to the harsh Venusian 
					environment and corrodes away.";
				if (obj.istreasure) incscore(-20);	
					// -20 for loosing treasure	
				obj.moveInto(dvoid);
				if (obj.iscontainer)      // is object a container
					{
					objlist := obj.contents;				
					lobjlist := length (objlist);   
															// number of things in object
					jj := 1;
					if (lobjlist <> 0)
					{
					while (jj <= lobjlist)
						{
						cobj := objlist[jj];
						if (cobj.vulner)										// is object in the container vulnerable?
						{
						"\b\^<<cobj.thedesc>> falls to the ground 
							and quickly corrodes away.";
						if (cobj.istreasure) incscore(-20); 								//-20 for loosing treasure
						cobj.moveInto(dvoid);
						if (cobj.iscontainer)    // is the object a container itself?
							{
							cobjlist := cobj.contents;
							lcobjlist := length (cobjlist);
							jjj := 1;
							if(lcobjlist <> 0)
							{
							while (jjj <= lcobjlist)
								{
								ccobj := cobjlist [jjj];
								if (ccobj.vulner)	// vulnerable?
									{
									"\b\^<<ccobj.thedesc>> falls to the 
									ground and quickly corrodes away.";
									if (ccobj.istreaure) incscore (-20);								// -20 for loosing treasure
										ccobj.moveInto(dvoid);
									}
								else
									{
									"\b\^<<ccobj.thedesc>> falls to the ground.";
									ccobj.moveInto(Me.location);
									}
								jjj := jjj +1;
								}
							}
							}
						
						}
						else
						{
						"\b\^ <<cobj.thedesc>> falls to the ground.";
							cobj.moveInto(Me.location);
						}
						jj := jj +1;
						}
					}
					   }
					}
			j := j +1;
			}
			remdaemon (venuscount, nil);
			setdaemon (venuscount,nil);
		}
	}
;


// Venus itself	

venus: venusroom
	sdesc = "Venusian Valley"
	ldesc = "You are in one of the barren valleys of Venus.  The atmosphere is thick 
		as soup and the ground looks molten.  The temperature of this place 
		feels like the inside of a blast furnace.  You realize that any unprotected 
		items you bring here won't last long. \n\t The ground looks solid up a ridge 
		to the north or through a valley to the southeast.  The cylinder, with its 
		airlock open, is here are well."
	north = lakeshore
	se = mthcave
	east = {venusdie();}
	south = {venusdie();}
	sw = {venusdie();}
	west = {venusdie();}
	nw = {venusdie();}
	in = shipin	
;

vcylin: decoration
	sdesc = "large glowing cylinder"
	ldesc = "The cylinder's glow it extremely eerie in this atmosphere.  The light from it
		seems to flow like molasses.\b"
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'large' 'glowing'
	location = venus
	verDoGo(actor) = {}
	doGo(actor) = {Me.travelTo(shipin);}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(shipin);}
;


lakeshore: venusroom
	sdesc = "Lake Shore"
	ldesc = " You climb up the rise and behold a sight straight out of Hell.  A huge
			lake of near-molten rock lies all around you.  Every so often a 
		bubble of soft rock heaves up from the depths of the pool.  The only 
		safe path is back down the rise to the south."
	south = venus
	down = venus
	north = {vlakedie();}
	east = {vlakedie();}
	west = {vlakedie();}
	ne = {vlakedie();}
	se = {venusdie();}
	sw = {venusdie();}
	nw = {vlakedie();}
	in = {vlakedie();}
;

vlake: decoration
	sdesc = "lake"
	ldesc = "The molten lake looks like a very gooey Turkish bath.  Bubbles of gas 
		slowly rise from the depth of the pool and break on the surface."
	noun = 'lake' 'pool'
	adjective = 'molten'
	location = lakeshore
	verDoStepon(actor) ={}
	verDoGo(actor) = {}
	verDoEnter(actor) = {}
	doEnter(actor) = {vlakedie();}
	doStepon(actor) = {vlakedie();}
	doGo(actor) = {vlakedie();}

;

mthcave: venusroom
	sdesc = "Box Canyon"
	ldesc = "You are at the end of valley which continues to the northwest.
		  To the east, in the cliff face, there is the mouth of a dark cave."
	east = vcave
	nw = venus
	north = {
		"The cliffs prevent any movement in that direction.";
		return (nil);
		}
	south = {
		"The cliffs prevent any movement in that direction.";
		return (nil);
		}
	west = {
		"The cliffs prevent any movement in that direction.";
		return (nil);
		}
	ne = {
		"The cliffs prevent any movement in that direction.";
		return (nil);
		}
	se = {
		"The cliffs prevent any movement in that direction.";
		return (nil);
		}
	sw = {
			"The cliffs prevent any movement in that direction.";
			return (nil);
			}
	in = vcave
	up = {
		"The cliffs are too steep and soft to climb.";
		return(nil);
		}
;

vcaveopening: fixeditem
	sdesc = "cave"
	ldesc = "It looks like every other dark, foreboding cave you have ever seen."
	noun = 'cave'
	adjective = 'dark'
	location = mthcave
	verdoGo(actor) = {}
	doGo(actor) = {
			Me.travelTo(vcave);
			}
;

// The Cave and Pit


vcave: venusroom, darkroom
	cv = true
	sdesc = "Dark Cave"
	ldesc = "This small featureless cave is extremely dark. In the floor is a large open pit.  The only exit is out to the west."
	west = mthcave
	out = mthcave
	down = {
		if (rope.tieItem = strock)
		{
		"You climb down the rope until you are at the level of the ledge.\b";
		rope.moveInto(ropeledge);
		return(ropeledge);
		}
		else
		{
		"You start climbing down the pit, but the rock is too soft and you plummet 
		three hundred feet to your death.";
		die();
		}
		}
;

uledge: fixeditem
	sdesc = "ledge"
	ldesc = "You cannot see the ledge very clearly but something on it is reflecting
		your light source.  To see what it is, you would have to get down there."
	noun = 'ledge'
	location = vcave
;

strock: fixeditem
	sdesc = "sturdy rock"
	ldesc = "The rock sticks out from the pit wall for about eight inches."
	noun = 'rock'
	adjective = 'sturdy'
	location = nil
	tonce = nil
	verIoTieTo(actor) = {}
	ioTieTo(actor, dobj) =
				{
				if(dobj = rope)
				{
				"You tie one end of the rope to the rock and let the other fall 
		down the pit where
				it extends far past the ledge. ";
					rope.tieItem := self;
					rope.isfixed := true;
					rope.moveInto( vcave);
					rope.td := true;
					rope.vulner := nil;
					setdaemon(vropecount, nil);
				}
				else
				"You cannot tie <<dobj.thesdesc>> to the rock.";
			}
;

					
vpit: fixeditem, container
	sdesc = "deep pit"
	ldesc = {
		"The pit so deep that you cannot see its bottom.  The walls of the pit look very soft, you don't
		think you could get a good grip if you tried to climb down. One foot down 
			from the edge of the pit wall a sturdy rock hangs directly 
		over a ledge which is further down the pit.  ";
		strock.moveInto(vcave);
		if (rope.tieItem = strock)
			"A rope is tied to the rock and extends down into the pit, ending next to the ledge.  "; 
		}
	noun = 'pit'
	adjective = 'deep' 'dark'
	location = vcave
	ioDrop(actor, dobj ) =
			{
			"You watch as <<dobj.thedesc>> falls down into the pit and out of
			sight.  A few seconds later you hear a soft thud as <<dobj.thedesc>> hits the bottom.";
			if (dobj.istreasure)
				incscore(-20);		// -20 for droping treasure into pit
				dobj.moveInto(dvoid);
			}
	ioPutIn(actor, dobj)=
			{
			self.ioDrop(actor, dobj);
			}
	doClimbdown(actor) =
				{
				"You start climbing down the pit, but the rock is to soft and 
			you plummet three hundred feet to your death.";
				die();
				}
;


ropeledge: darkroom, venusroom
	cv = true
	sdesc = "By Ledge (on rope)"
	ldesc = 
		{
		"You are hanging on a rope by a small ledge. Below you is a very deep pit.";
		if (widget.location = ledge);
			"There is something shiny on the ledge, you have to get closer to see what it is.";
		}
	up = {
		"You climb up the rope.\b";
		rope.moveInto(vcave);
		return(vcave);
		}
	down = {
		"The rope ends here.  If you really want to go further down just let go of the rope.";
		return(nil);
		}
	doDrop(actor) ={
			"\^<<self.thedesc>> falls into the pit and smashes on the rocks far, far below.";
			self.moveInto(void);
			}
;

led: fixeditem
	sdesc = "small ledge"
	ldesc = {
		"You can see now the ledge is just large enough to hold you. ";
		if (widget.location = ledge)
		"There is something shiny on the ledge, you can't quite see what it is.";
		}
	noun = 'ledge'
	adjective = 'small'
	location = ropeledge
	verDoGeton(actor) = {}
	doGeton(actor) = {
			"You let the rope go as you step upon the ledge.\b";
			Me.travelTo (ledge);
			rope.moveInto (ledge);
			led.moveInto(ledge);
			}
	verDoGo(actor) = {}
	doGo(actor) =
			{
			self.doGeton(actor);
			}
	verDoGetoff(actor) ={}
	doGetoff(actor) =
				{
				if (Me.location = ledge)
				{
				"You grab the rope and step off the ledge.\b";
				Me.travelTo(ropeledge);
				rope.moveInto(ropeledge);
				led.moveInto(ropeledge);
				}
				else
				{
				"You aren't on the ledge!";
				return(nil);
				}
				}
;

rpit: fixeditem
	sdesc = "pit"
	ldesc = "The pit is dark and extremely deep."
	noun = 'pit'
	adjective = 'deep'
	location = ropeledge
;
				
ledge: darkroom, venusroom
	jd = true
	cv = true
	sdesc = "On a Ledge"
	ldesc =  {
			"You are on a ledge twenty feet down a deep pit. ";
			if (rope.location = ledge)
			"There is a rope dangling from above that you can climb up here.";
			}
	up = {
			"You grab the rope and climb up out of the pit.\b";
			rope.moveInto(vcave);
			return(vcave);
			}
	
;
