! cursor.inf - Screen display and cursor control routines.

! ZBefunge - a Befunge interpreter for a Z Machine.
! Copyright 1998 Francis Irving.

! This source code is distributed under the GNU general public license,
! version 2 or later (at your option).  See the file copying.txt for
! full information.

[ GoTo x y;
  if (x<=scr_xmax)
    x++;
  y++;
  @set_cursor y x;
];

[ AtScreen x y string;
  GoTo(x, y);
  print (string) string;
];

[ HLine x1 x2 y c  i;
  GoTo(x1, y);
  for (i=x1:i<=x2:i++) {
    print (char) c;
  }
];

[ VLine x y1 y2 c  i;
  for (i=y1:i<=y2:i++) {
    GoTo(x, i);
    print (char) c;
  }
];

[ Box x1 y1 x2 y2  i;
  style reverse;
  HLine(x1, x2, y1, ' ');
  VLine(x1, y1+1, y2-1, ' ');
  VLine(x2, y1+1, y2-1, ' ');
  HLine(x1, x2, y2, ' ');
  style roman;
  for (i=y1+1:i<y2:i++) {
    HLine(x1+1, x2-1, i, ' ');
  }
  GoTo(x1+1, y1+1);
];
