/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.iff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.zmpp.base.DefaultMemoryAccess;
import org.zmpp.base.MemoryAccess;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableFormChunk
implements FormChunk {
    private byte[] subId;
    private static final byte[] FORM_ID = "FORM".getBytes();
    private List<Chunk> subChunks;

    public WritableFormChunk(byte[] byArray) {
        this.subId = byArray;
        this.subChunks = new ArrayList<Chunk>();
    }

    public void addChunk(Chunk chunk) {
        this.subChunks.add(chunk);
    }

    @Override
    public byte[] getSubId() {
        return this.subId;
    }

    @Override
    public Iterator<Chunk> getSubChunks() {
        return this.subChunks.iterator();
    }

    @Override
    public Chunk getSubChunk(byte[] byArray) {
        for (Chunk chunk : this.subChunks) {
            if (!Arrays.equals(chunk.getId(), byArray)) continue;
            return chunk;
        }
        return null;
    }

    @Override
    public Chunk getSubChunk(int n) {
        return null;
    }

    @Override
    public byte[] getId() {
        return FORM_ID;
    }

    @Override
    public int getSize() {
        int n = this.subId.length;
        for (Chunk chunk : this.subChunks) {
            int n2 = chunk.getSize();
            if (n2 % 2 == 1) {
                ++n2;
            }
            n += 8 + n2;
        }
        return n;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public MemoryAccess getMemoryAccess() {
        return new DefaultMemoryAccess(this.getBytes());
    }

    public byte[] getBytes() {
        int n = 8 + this.getSize();
        byte[] byArray = new byte[n];
        DefaultMemoryAccess defaultMemoryAccess = new DefaultMemoryAccess(byArray);
        defaultMemoryAccess.writeByte(0, (byte)70);
        defaultMemoryAccess.writeByte(1, (byte)79);
        defaultMemoryAccess.writeByte(2, (byte)82);
        defaultMemoryAccess.writeByte(3, (byte)77);
        defaultMemoryAccess.writeUnsigned32(4, this.getSize());
        int n2 = 8;
        for (int i = 0; i < this.subId.length; ++i) {
            defaultMemoryAccess.writeByte(n2++, this.subId[i]);
        }
        for (Chunk chunk : this.subChunks) {
            byte[] byArray2 = chunk.getId();
            int n3 = chunk.getSize();
            for (int i = 0; i < byArray2.length; ++i) {
                defaultMemoryAccess.writeByte(n2++, byArray2[i]);
            }
            defaultMemoryAccess.writeUnsigned32(n2, n3);
            n2 += 4;
            MemoryAccess memoryAccess = chunk.getMemoryAccess();
            for (int i = 0; i < n3; ++i) {
                defaultMemoryAccess.writeByte(n2++, memoryAccess.readByte(8 + i));
            }
            if (n3 % 2 != 1) continue;
            defaultMemoryAccess.writeByte(n2++, (byte)0);
        }
        return byArray;
    }

    @Override
    public int getAddress() {
        return 0;
    }
}

