/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vmutil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBuffer<T> {
    private T[] elements;
    private int bufferstart;
    private int bufferend;
    private int size;

    public RingBuffer(int n) {
        this.elements = new Object[n];
    }

    public void add(T t) {
        this.bufferend %= this.elements.length;
        if (this.size == this.elements.length) {
            this.bufferstart = (this.bufferstart + 1) % this.elements.length;
        } else {
            ++this.size;
        }
        this.elements[this.bufferend++] = t;
    }

    public void set(int n, T t) {
        this.elements[this.mapIndex((int)n)] = t;
    }

    public T get(int n) {
        return this.elements[this.mapIndex(n)];
    }

    public int size() {
        return this.size;
    }

    public T remove(int n) {
        T t = this.get(n);
        for (int i = n; i < this.size - 1; ++i) {
            int n2 = this.mapIndex(i);
            int n3 = this.mapIndex(i + 1);
            this.elements[n2] = this.elements[n3];
        }
        --this.size;
        this.bufferend = (this.bufferend - 1) % this.elements.length;
        return t;
    }

    private int mapIndex(int n) {
        return (this.bufferstart + n) % this.elements.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{ ");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

