/*
	Support subroutines for Mystery Mansion.
	A very small (and hacked) subset of the HP1000 RTE's system lib.

	this expects f2c to have been run with the I2 (16 bit integers) for
	compatability with the 1000.  I don't know what 32 bit ints would do.

	Ken Cornetet poodad@gmail.com
	expressly released to the public domain
*/

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <fcntl.h>
#include "f2c.h"

//extern int errno;
int errno = 1;

/*
	A replacement for exec 11 (get date/time) call.
*/

exec_(dummy, itm)
shortint *dummy;
shortint *itm;
{
	struct tm *tm, *localtime();
	long t, time();

	time(&t);
	tm = localtime(&t);

	itm[0] = 0;
	itm[1] = tm->tm_sec;
	itm[2] = tm->tm_min;
	itm[3] = tm->tm_hour;
	itm[4] = tm->tm_yday + 1;				
}

/*
	Function to simulate segment loading on the HP1000.
	Segments have been replaced by subroutines, and setjmp/longjmp
	have been used to clean up the stack.
*/

static shortint ipx[5];

#include <setjmp.h>

void exexc_(name, i1, i2, i3, i4, i5, namelen)
char *name;
shortint *i1, *i2, *i3, *i4, *i5;
long namelen;
{
	static jmp_buf env;
	static int first = 1;		
	static char segment[6];
 
	ipx[0] = *i1;
	ipx[1] = *i2;
	ipx[2] = *i3;
	ipx[3] = *i4;
	ipx[4] = *i5;
	
	strncpy(segment, name, namelen);
	
	if( ! first ) longjmp(env, 1);
	
	if( first )
	{
		first = 0;
		setjmp(env);
		switch(segment[3]) {
		case 'A': mmsa_(); break;
		case 'B': mmsb_(); break;
		case 'C': mmsc_(); break;
		case 'D': mmsd_(); break;
		case 'E': mmse_(); break;
		case 'F': mmsf_(); break;
		case 'G': mmsg_(); break;
		case 'H': mmsh_(); break;
		case 'I': mmsi_(); break;
		case 'J': mmsj_(); break;
		case 'K': mmsk_(); break;
		case 'L': mmsl_(); break;
		default:
			fprintf(stderr, "Whoa, attempted to call segment %s\n", segment);
			fflush(stderr);
			exit(1);
		}
		fprintf(stderr, "Oops, segment %s didn't call next segment\n", segment);
		fflush(stderr);
		exit(2);
	}
}

void rmpax_(ip)
shortint *ip;
{
	ip[0] = ipx[0];
	ip[1] = ipx[1];
	ip[2] = ipx[2];
	ip[3] = ipx[3];
	ip[4] = ipx[4];				
}

#ifndef O_BINARY
#define O_BINARY    0
#endif

/* replacements for some simple FMGR FMP calls */

void open_(idcb, ierr, namf, creat)
shortint *idcb, *ierr, *creat;
char *namf;
{
	char *tmp;
	int mode;

	mode = O_RDWR|O_BINARY;
	if( *creat ) mode |= O_CREAT;

	tmp = namf;

	while( *tmp && *tmp != ' ' ) tmp++;
	*tmp = '\000';

	if( (*idcb = open(namf, mode, 0666)) == -1 )
	{
		*ierr = -1 * errno;
	}
	else
	{
		*ierr = 0;
	}
}

void readf_(idcb, ierr, ibuf, len)
shortint *idcb, *ierr, *ibuf, *len;
{
	if( read(*idcb, ibuf, *len * 2) < 0 )
	{
		*ierr = -1 * errno;
	}
	else
	{
		*ierr = 0;
	}
}

void writf_(idcb, ierr, ibuf, len)
shortint *idcb, *ierr, *ibuf, *len;
{
	if( write(*idcb, ibuf, *len * 2) < 0 )
	{
		*ierr = -1 * errno;
	}
	else
	{
		*ierr = 0;
	}
}

void close_(idcb)
shortint *idcb;
{
	close(*idcb);
}
