"Pronto" by Mel Hython

[-------------------------------------------------

COMENTARIO SOBRE LOS COMENTARIOS

Con este relato intentaré crear además un 
listado que pueda usarse como ejemplo, no
porque este relato me parezca especialmente
relevante a modo de ejemplo, si no porque 
considero que los ejemplos de uso de I7 son 
realmente necesarios en estos momentos.

Para ello seré cuidadoso con el uso de las 
secciones e intentaré ser coherente en el uso
de comentarios.

Los comentarios que usen líneas de:

==============================

representarán cabeceras de secciones muy 
diferenciadas, mientras que los que usen líneas 
de:

-------------------------------------------------

serán comentarios muy relevantes pero 
desestructurados. Finalmente los comentarios
 sin separador pero con letras mayúsculas
servirán para identificar objetos relativos al 
relato, ya sean personajes, items o localidades.

-------------------------------------------------]

[==============================

	Pronto

	Por Mel Hython, 2008

	Este relato surgió con motivo de la
	nanocomp de 2008, sobre la que se 
	puede leer información en:

	http://wiki.caad.es/XComp_2

	Como prueba extra personal fue 
	desarrollada exclusivamente durante
	el fin de semana de los días 11 a 13
	de Julio de 2008, empezando el 11
	a las 22:22. (Bonito número)
	
==============================]

[==============================

	Librerías y opciones

==============================]

Include Spanish by Sebastian Arg.
Include Basic Screen Effects SP by Emily Short.
Include Decorados by El Enano Malauva.

Use full-length room descriptions.
Use no scoring.

[==============================

	Referencia bibliográfica

==============================]
The story title is "Pronto".
The story author is "Mel Hython".
The story headline is "'Pronto. Empezará el resto de tu vida'".
The story genre is "Experimental".
The release number is 0.
The story description is "Pronto. Empezará el resto de tu vida.".
The story creation year is 2008.

[==============================

	El relato

==============================]
Part 1 - Reglas generales modificadas

Chapter 1 - Utilidades o librerías integradas

Section 1 - Facilidad para mostrar partes no interactivas

[--------------------------------------------------

La idea es bien simple -ya que hay muchas cosas 
que no sé hacer-, cada entrada de una tabla/lista 
simple, se muestra y tras ella se espera la 
pulsación de una tecla

--------------------------------------------------]
To relatar fragmento en (tabla - a table-name):
	let N be the number of rows in tabla;
	repeat through tabla begin;
		decrease N by 1;
		say "[frase entry]";
		say paragraph break;
		if N is not 0, esperar pulsacion de tecla;
	end repeat.

To relatar fragmento en (tabla - a table-name), limpiando pantalla:
	relatar fragmento en tabla;
	esperar pulsacion de tecla;
	limpiar pantalla.

Section 2 - Objetos que traen memoria

[--------------------------------------------------

La idea es incluir una clase nueva de objetos 
que contengan:

	- Un contador del número de veces 
	   que son examinados
	- Una tabla en la que se incluyen 
	   mensajes y/o reglas a activar
	   cuando se alcanza el contador
                   que corresponda

--------------------------------------------------]

[

CLASE: Decorado activo

Así como sus definiciones y reglas asociadas

]
A decorado activo is a kind of thing. 
A decorado activo is always scenery.
A decorado activo has a number that varies called veces examinado.
The veces examinado of a decorado activo is usually 0.
A decorado activo has a table-name called comportamiento.
The comportamiento of a decorado activo is usually Table of comportamiento por defecto de decorado activo.

[DEFINICIÓN: Una definición para saber fácilmente si hay algo que mirar
en las tablas o no]
Definition: a decorado activo (called el-decorado) is reglado if the number of filled rows in the comportamiento of el-decorado is greater than 0.

[REGLA para modificar el número de veces examinado]
After examining a decorado activo (called observado):
	increase the veces examinado of observado by 1.

[REGLA de sustitución de examinar]
Instead of examining a decorado activo (called observado):
	[Si la tabla está vacía hacer lo de siempre]
	if observado is not reglado, continue the action;
	let N be veces examinado of observado;
	increase N by 1;
	[Si hay algo en la tabla buscar el valor actual]
	if there is a regla corresponding to a vez of N in comportamiento of observado
	begin;
		[Existe, lo escogemos y ejecutamos la regla]
		choose row with a vez of N in comportamiento of observado;
		follow regla entry;
		increase the veces examinado of observado by 1;
	otherwise;
		[No hay trigger, hacer lo de siempre]
		continue the action;
	end if.

[TABLA POR DEFECTO de eventos disparados ante 
un número de examinados de un decorado activo]
Table of comportamiento por defecto de decorado activo
vez		regla
a number	a rulebook


[REGLA para coger un escenario]
Instead of taking a decorado activo (called cogido):		
	say "No me apetece intentarlo.".

Section 3 - La magia de este relato, la tabla de acciones en escenas

[--------------------------------------------------

	Todo el relato consiste en engañar
	la linealidad supuesta mediante la
	captura de las órdenes dadas
	y la transformación de unas escenas
	en otras, escenas que varían, se
	moldean, según encaje el texto
	hasta que colapsan en una escena
	que ya será la aventura hasta el final.

	Así solo rejugando (reentrando)
	una y otra vez pueden verse todas
	las diversas escenas que conforman
	esta 'historia'. 

	Es, por tanto, el puzzle sin puzzle, 
	un laberinto realizado con las
	mismas palabras.

--------------------------------------------------]

[Usamos como en el 'Museo de las Consciencias' una variable para gobernar las escenas]
SNum is a number that varies. SNum is usually 0.

[Ponemos una variable con la tabla de transiciones que se actualiza con cada escena]
TransActual is a table-name that varies.
TransActual is normally the Table of sintrans.

[La fake tabla de transiciones]
Table of sintrans
accion			nueva		regla		texto
a stored action		a number	a rulebook	a text

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero
escena		transiciones	descripcion	printedName	decorados	
a number	a table-name	a text		a text		a table-name

[Hay problemas con las columnas vacías y las acciones guardadas, creamos valores fake]
This is the fake rule: rule succeeds.

[Pillamos ahora cualquier acción y la desviamos según la tabla]
Instead of doing anything:
	[say ">> [the current action].";]
	repeat through TransActual:
		if the action-name part of the current action is the action-name part of accion entry:
			now SNum is nueva entry;
			let textoADecir be texto entry;
			let reglaASeguir be regla entry;
			repeat through Table of Transicion Por Numero:
				if the SNum is escena entry:
					now TransActual is transiciones entry;
					now the description of the location is descripcion entry;
					now the printed name of the location is printedName entry;
					now the decoracion of the location is decorados entry;
			if textoADecir is not "":
				say "[textoADecir]";
				say line break;
			follow the reglaASeguir;
			if the current action is not the action of looking:
				stop the action;
	continue the action.

[Ir tiene muchos problemas, así que la jodemos]
Moving is an action applying to nothing.

Instead of going (this is the moving better rule), try moving.

[La ponemos al principio siempre]
The moving better rule is listed first in the instead rules.

Carry out moving:
	say "No hay salida por ahí.".

[Necesitamos un segundo looking falso]
Slooking is an action applying to nothing.

Understand the commands "buscar" as "busca".

Rule for clarifying the parser's choice of anything: say "".

Section 4 - La regla por defecto

This is the ugh rule:
	say "Ugh!."

Section 5 - Decorados y sus nuevas tablas

[Mensajes por defecto]
Table of MensajesLugar
Table of topic
Table of MensajesLugarNoVeo
Table of MensajesLugarEsDecorado

Table of MensajesLugarNoveo
descripcion
"Miras, pero no ves eso por aquí. ¿Realmente importa?"

Table of MensajesLugarEsDecorado
descripcion
"No vas a perder el tiempo haciendo eso. Hay cosas más importantes ahora mismo."

The mensajes of a habitacionDecorada is normally the Table of MensajesLugar.

Section 6 - Colorear lo que no se entiende

Rule for printing a parser error:
	if the parser error is I beg your pardon:
		say paragraph break;
	otherwise:
		say "[one of]Piensas por un momento en [the player's command], pero, ¿qué sentido tiene ahora?[or]Deseas por un momento [the player's command], pero no, no es el momento.[or]Te dices que lo que realmente quieres es [the player's command], pero, es solo una tontería momentánea.[or]¿Crees que la solución es [the player's command]?[in random order]" instead.

Section 7 - Comandos nuevos

Viewing exits is an action applying to nothing.

Understand "salidas" as viewing exits.

Carry out viewing exits:
	say "No hay salidas visibles.".

[Desatarse fake]
Desating is an action applying to nothing.

Understand "desatarse" or "desatate" as desating.

Carry out desating:
	if SNum is 40:
		say "Te revuelves provocando un murmuro de pánico e incluso algún grito contenido, pero estás demasiado bien atada al poste.";
	otherwise:
		say "No hay nada que desatar.".

[Volar fake]
Flying is an action applying to nothing.
Understand "volar" or "flotar" or "vuela" or "flota" as flying.

Carry out flying:
	if SNum is 40:
		say "Amas volar. Pero no puedes volar estando atada a un maldito poste.";
	otherwise:
		say "No puedes volar.".

[desvestirse]
Naking is an action applying to nothing.
Understand "desvestirse" or "desvistate" or "quitate todo" or "quitarse todo" or "desnudarse" or "desnudate" as naking.

Carry out naking:
	repeat with item running through things worn by the player:	
		try silently taking off item;
	say "Te quitas todas tus prendas.".

[atacar fake]
Fattacking is an action applying to nothing.
Understand "atacar" or "ataca" or "destruir" or "destruye" or "atacar todo" or "ataca todo" or "destruir todo" or "destruye todo" as fattacking.

Carry out fattacking:
	say "Piensas en muerte. En violencia.".

[Pensar está mal definido]
Understand "pensar" as thinking.

[Intento de capturar el fin del juego]
Ending is an action applying to nothing.
Instead of quitting the game:
	try ending.

Carry out ending:
	say "Aún no es el momento, pero pronto llegará.".

Understand "quit" or "q" or "terminar" or "fin" or "acabar" or "abandonar" as ending.

[Ayuda.. jejeje]
Helping is an action applying to nothing.
Understand "ayuda" or "pedir ayuda" as helping.

Carry out helping:
	say "No parece muy problable que alguien te ayude ahora.".

[Rezar]
Praying is an action applying to nothing.
Understand "reza" or "rezar" as praying.

Carry out praying:
	say "No es el momento.".

[Morir]
Dying is an action applying to nothing.
Understand "morir" or "muere" as dying.

Carry out dying:
	say "A veces apetece morir, pero la muerte no hay que buscarla, llega con facilidad.".


Part  2 - Pronto

Chapter 0 - El comienzo

[--------------------------------------------------

   Regla activada al iniciar el juego

--------------------------------------------------]
When play begins:
	poner cuadro de inicio;
	wait for any key;
   	clear the screen;
	contar inicio de la historia;
	now the description of the player is "Eres lo que eres.".

[FRASE: Cuadro de inicio con el nombre del relato y fecha]
To poner cuadro de inicio:
	display the boxed quotation
	"          Pronto



	Un relato...   ...reentrante 

	

	Mel Hython, verano de 2008.";
	show the current quotation.

[FRASE: Introducción que relata el inicio]
To contar inicio de la historia:
	relatar fragmento en Table of Historia Inicial, limpiando pantalla.

[HISTORIA: El fragmento inicial]
Table of Historia Inicial 
frase
"Pronto."
"Muy pronto."
"En realidad, ahora."
"Empieza el resto de tu vida."

Chapter 1 - El Lugar

[Un lugar... que varía]
El lugar is a habitacionDecorada.

The description of lugar is "Empezará el resto de tu vida.". The printed name of lugar is "Pronto".

[Otro lugar usado como comodín]
OtroLugar is a room.

Chapter 2 - Una anotación de acciones

[--------------------------------------------------

   En este relato se trampea con la secuencia
   habitual de órdenes del jugador, por eso listo
   y capturo aquí (para que no se olvide) todas
   las órdenes definidas habitualmente y 
   en lugar de si tratamiento habitual pongo
   una flagelación.

--------------------------------------------------]

[Before taking, removing, unlocking, locking, taking off, wearing, inserting, putting, setting, dropping, throwing, pulling, giving, attacking, showing, going, entering, taking inventory, looking, examining, searching, looking under, asking, consulting, opening, closing, entering to room, exiting, getting off, saying yes, saying no, saying sorry, swearing, insultando, insultandosuave, waving hands, setting, pushing, turning, switching, burning, waiting, answering, telling, eating, sleeping, singing, climbing, squeezing, swinging, waking up, kissing, thinking, smelling, listening, tasting, touching, rubbing, tying, drinking, cutting, jumping, requesting the score, quitting the game, saving the game, restarting the game, restoring the game, verifying the story file, requesting the story file version, switching the story transcript on, witching the story transcript off, preferring abbreviated room description, preferring unabbreviated room descriptions, preferring sometimes abbreviated room descriptions, requesting the pronoun meanings, switching score notification on,  switching score notification off:]
[Instead of doing anything (this is the azotar a Mel rule):
	say "Este idiota de Mel, no ha tenido encuenta esto adecuadamente. ¡Azótenlo en público!";
	continue the action.]

[La ponemos al final siempre]
[The azotar a Mel rule is listed last in the instead rules.]

[Así solo me azotan por lo que haya olvidado, lo que será mucho]

Chapter 3 - Los finales

Section 0 - El final completo

To tal vez reinicio:
	end the game saying "FIN?".

Section 1 - Final más general

To finaliza pronto:
	relatar fragmento en Table of Final general;
	tal vez reinicio.

Table of Final general
frase
"Y con esto finaliza tu vida."
"Tal vez sea pronto, o tal vez no. Pero es lo que hay."
"Nada más."
"O tal vez..."
"Tal vez haya otras vidas que vivir, tal vez mejores, tal vez peores, ¿quién puede saberlo?"

Section 2 - Un final que no es final ni muerte

To finaliza invasion:
	relatar fragmento en Table of Final Victoria Invasion;
	tal vez reinicio.

Table of Final Victoria Invasion
frase
"Y así seguirá por siempre."
"En vuestro nuevo hogar."
"Era el destino y nada más."
"O tal vez..."
"Tal vez haya otras vidas que vivir, tal vez mejores, tal vez peores, ¿quién puede saberlo?"


Chapter 4 - Los objetos que pueden aparecer

Section 1 - El cadáver

[ El otro astronuta que puede estar en el caso de la nave]
The cadaver is thing. The printed name of cadaver is "cadáver".

The description of cadaver is "Es una manera trágica de morir. Apunto de regresar a la tierra tras una larga misión en el espacio. Traicionado por su compañera de viaje. Muerto a golpes.".

Section 2 - La pistola

[Para la escena de ver caer]
The pistola is thing and female.
The description of the pistola is "Tu pistola reglamentaria. Cargada. Lista para dar muerte... si es imprescindible.".

Section 3 - Las ropas

[Para la escena de infectado]
Some ropas is a thing and female.
The description of the ropas is "Tu uniforme del ejército. Lo que has llevado casi toda tu vida. Lo has arrojado casi sin pensar, así que está amontonado de mala manera.".

Understand "ropa" or "uniforme" as ropas when ropas is visible.

Section 4 - El pitillo

[Para la disgresión de la terraza]
The pitillo is a thing.
The description of the pitillo is "Un pitillo corto americano encendido. La muerte empaquetada y la vida misma en una situación desesperante.".

Understand "cigarro" or "cigarrillo" or "americano" as pitillo when pitillo is visible.

Section 5 - El matorral

[Para la cacería]
The matorral is a thing.
The description of the matorral is "Un matorral de casi seis yardas de diámetro, muy espeso y de considerable altura. Un buen escondrijo para un zorro cobarde.".

Understand "arbusto" or "seto" or "escondrijo" as matorral when matorral is visible.

Section 6 - La escopeta

[Para la cacería]
The escopeta is a thing and female.
The description of the escopeta is "Tu escopeta favorita para cazar zorros. La más adecuada por lo tanto para cazar el más importante de los zorros.".

Understand "arma" or "rifle"  as escopeta when escopeta is visible.

Chapter 9 - Escena neutral y marca de escenas

Section 1 - Definicion

[--------------------------------------------------

  Esta es la escena completamente neutral inicial

--------------------------------------------------]

[Tabla de transiciones de la escena]
Table of TSNeutral
accion			nueva	regla				texto
jumping			10	the saltar_vacio rule		""
taking inventory		20	the nave_final rule		"Revisas tus manos, están ensangrentadas. Claro que lo están."
looking			0	the ver_saltar rule			""
slooking			30	the fake rule			""
waking up		40	the hoguera rule			""
sleeping			40	the hoguera rule			"Cierras los ojos, tal vez duermes o sueñas."
flying			50	the volar rule			""
fattacking		60	the rabia final rule			""
viewing exits		70	the salidas rule			"No hay... no hay... ¡No hay!"
naking			80	the infectado rule			""
singing			90	the malvada cancion rule		""
moving			100	the museo rule			""
entering			100	the museo rule			""
exiting			110	the pitillo rule			""
dropping		120	the abandono rule		""
opening			0	the pre_museo rule		""
taking			120	the abandono rule		"Es todo lo que queda. Tú."
pushing			50	the volar rule			""
pushing to		50	the volar rule			""
pulling			0	the pre_museo rule		"Tiras de posibles palancas, abres cajones."
swearing obscenely	80	the infectado rule			"¡Joder!"
swearing mildly		80	the infectado rule			"No puedes creerlo."
waving hands		110	the pitillo rule			"Saludas antes de salir, pero sales."
setting			60	the rabia final rule			"Lo ajustas todo y..."
turning			0	the pre_museo rule		"Lo giras, lo retuerces todo, buscando un mecanismo."
burning			60	the rabia final rule			"Enciendes todo lo necesario y..."
switching on		60	the rabia final rule			"Enciendes todo lo necesario y..."
waiting			70	the salidas rule			"Pasa el tiempo... pero nadie viene a rescatarte."
answering		120	the abandono rule		"Ya intentas hablar contigo mismo."
telling			120	the abandono rule		"Ya intentas hablar contigo mismo."
eating			0	the fake rule			"Tal vez sepas bien."
squeezing		0	the pasado remoto rule		""	
swinging		50	the volar rule			"Te balanceas en el borde y..."
kissing			10	the saltar_vacio rule		"Te besas la mano y lo soplas para que llegue a él en forma de despedida. Entonces..."
thinking			130	the monje rule			""
smelling			140	the caceria rule			""
listening			70	the salidas rule			"Escuchas atentamente. Pero no se escucha nada más. Ni más explosiones, ni voces de nadie más... nada."
tasting			0	the sexo rule			""
touching		80	the infectado rule			"Te palpas."
rubbing			20	the nave_final rule		"Te frotas las manos contra el traje, pero siguen ensangrentadas."
drinking			120	the abandono rule		"Desearías poder beberte a tí mismo. Así tendrías algo que beber."
cutting			150	the corte profundo rule		""	
quitting the game		120	the abandono rule		"Es mejor acabar."
helping			70	the salidas rule			"'¡Ayuda!', gritas; pero nadie parece escuchar..."
praying			130	the monje rule			"Ruegas a Dios."
dying			120	the abandono rule		"Estaría bien morir."

[La ponemos al principio del juego]
When play begins:
	now TransActual is Table of TSNeutral.

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion			printedName		decorados
0		Table of TSNeutral	"Empezará el resto de tu vida."	"Pronto"			Table of defaultDecoracion

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

[El gran salto]
This is the saltar_vacio rule:
	relatar fragmento en Table of Salto Inicial, limpiando pantalla;
	el salto termina in four turn from now;
	try looking.

Table of Salto Inicial 
frase
"Saltas."
"Es lo mejor, sin duda."
"Entonces acabará todo."
"Es lo mejor."
"Rápidamente el borde de la terraza se pierde lejos, a tu espalda, y los gritos de horror desaparecen."
"La ciudad se precipita hacia tí."

[La nave]
This is the nave_final rule:
	try looking.

[Ver caer]
SNNL is a number that varies. SNNL is usually 0.
This is the ver_saltar rule:
	if SNNL is 0:
		now SNNL is 1;
	otherwise:
		se vera el salto in four turn from now;
		move the pistola to player;
		try slooking.

[Despertar en la hoguera]
This is the hoguera rule:
		relatar fragmento en Table of Despertar Atada;
		arde la hoguera in seven turns from now;
		try looking.

Table of Despertar Atada 
frase
"Despiertas y..."
"...te duele la cabeza."
"Recuerdas... que... te atacaron a tración, los muy hijos de puta." 
"Cobardes."
"Pero... ¿Qué es esto?" 
"Es... es la plaza de pueblo. Oh..."
"...malditos.. te han atado sobre una... una plataforma..."
"No.. no... esto es..."
"¡Una hoguera!"
"¡Malditos!"

[Volar solo es un texto sin interacción]
This is the volar rule:
	relatar fragmento en Table of Volar Inicio y Fin;
	finaliza pronto.

Table of Volar Inicio y Fin
frase
"Saltas por la ladera y las corrientes cálidas te recogen alzándote rápidamente entre las nubes."
"Adoras hacer parapente aquí, tan alto."
"Ni siquiera es volar... en caminar sobre estas nubes."
"Tan hermoso."
"Qué..."
"Tal vez haya un problema con tu sistema de oxígeno."
"No, todo es correcto, y sin embargo... no puede ser."
"Ves como surgen desde arriba, luces, cientos y cientos de ellas... como si viniesen del espacio."
"Tienen cierta forma vaga... como una cometa extensa y difusa hecha de luz."
"Una se gira hacia tí, ¿te mira? Algo surge de su centro como un rayo... y te... impacta."
"Hay algo de dolor... no demasiado."

[El sacrificio final, otra escena no interactiva]
This is the rabia final rule:
	relatar fragmento en Table of Rabia Final;
	finaliza pronto.

Table of Rabia Final
frase
"Pulsas el botón."
"Muchos han muerto hasta llegar a esto."
"Muchos han sido esclavizados desde que la invasión empezó."
"Muchos habrán de morir aún, empezando por tí."
"Todos los generadores comienzan a rugir."
"Alimentarán las antenas que se están desplegando en este momento. La radiación de microondas cubrirá la mitad del planeta y ellos, esas cosas, esos demonios del espacio exterior, vendrán hacia esta intensísima fuente de energía como polillas a la luz."
"Pero esta luz es mortal para ellos, canta su muerte, y ellos morirán como polillas."
"Ya empieza a radiar."
"Hay un breve, pero muy intenso dolor cuando todas tus células hierven a la vez."

[Atrapado!]
This is the salidas rule:
		sin aliento in ten turns from now;
		try looking.

[Infectado!]
This is the infectado rule:
		move ropas to lugar;
		relatar fragmento en Table of Verse Desnudo;
		try looking.

Table of Verse Desnudo
frase
"Anoche no lo soñaste."
"La luz entró en la habitación y se posó en tu pecho."
"No fue un sueño. Es una jodida realidad. Estás infectado."
"Por eso tienes que examinarte con cuidado, verte por completo. "
"Arrojas tus ropas lejos de tí y te miras en el espejo."

[Un pequeño apunte de la invasión]
This is the malvada cancion rule:
	relatar fragmento en Table of Cantar y Destruir;
	finaliza invasion.

Table of Cantar y Destruir
frase
"Cantas, todos cantáis."
"Y con cada estrofa de la canción un humano cae preso..."
"...o muerto, lo que más convenga."
"Cantáis vibrantes."
"Cantáis victoriosos."

[La escena del erudito, solo texto]
This is the museo rule:
	relatar fragmento en Table of Museo;
	finaliza pronto.

Table of Museo
frase
"Entras en tu pequeño museo y, para tu sorpresa, él está allí, mirando los viejos cuadros."
"'Es el Mal, ¿verdad?', te dice sin girarse a mirarte, 'El Mal'."
"'Sí así es', le contestas, 'y lleva con nosotros desde siempre, o tal vez algo menos'."
"Hay un largo silencio y entonces dice: 'Y está en ella...'"
"'Eso me temo', le dices."
"'Y ya se lo has dicho, ¿no es así?', te pregunta."
"'Sí, era mi obligación, mi deber', le contestas sin dejarte intimidar."
"'¿Qué va a hacer?', te pregunta mientras se gira a mirarte fijamente."
"Caminas unos pasos hasta un viejo tapiz, una representación persa del siglo XIV de una historia que conoces bien y le señalas a la mujer llameante que salta desde una alta torre."
"'Cabronazo', te dice, y sin mediar más palabra te dispara a bocajarro."

[El pitillo]
This is the pitillo rule:
	relatar fragmento en Table of Salir;
	move pitillo to the player;
	fin de pitillo in three turn from now;
	try looking.

Table of Salir 
frase
"Sales a la terraza."
"Ya no podías soportar ni un minuto más esa estúpida fiesta."
"¡Escritores de aventuras! ¡Menudos pelmazos!"
"Cada uno con su blah blah blah, cada cual con su parser... bah, como todos los escritores aficionados, insoportables."
"Respiras profundamente y miras la ciudad."
"Al menos las vistas desde esta terraza son buenas."

[El abandono]
This is the abandono rule:
	relatar fragmento en Table of Abandono;
	fin de abandono in five turn from now;
	try looking.

Table of Abandono 
frase
"Ya no te quedan esperanzas."
"Ya no te queda comida."
"Ni el recuerdo de la misma."
"Ya no te quedan pies."
"Solo un constante dolor al final de las piernas."
"Ya no queda mundo al que ir, en el que estar."


[La escena del erudito, solo texto]
This is the pre_museo rule:
	relatar fragmento en Table of Previa de Museo;
	try jumping.

Table of Previa de Museo
frase
"Lo abres todo."
"Armarios, cajas, los libros de las estanterías. Todo."
"Y finalmente lo encuentras, está ahí a simple vista, parece una percha, una percha pequeña en forma de gárgola, pero no, se trata de un pomo."
"El pomo abre la puerta que buscabas y la verdad queda al descubierto."
"Muy pronto reconoces los personajes del tapiz. Ella eres tú y los demás... también están."
"'Sí, pobre niña', dice el erudito entrando en este museo que guardaba oculto, 'esa eres tú'."
"Señalas a la imagen del tapiz, y temblando de miedo le preguntas si esa es la unica solución."
"'Es la única que se ha descubierto desde los tiempos remotos hasta ahora', contesta él, 'nada puede hacer frente al mal, excepto el sacrificio propio, así es como debe ser'."
"Lo entiendes. Demasiado bien."
"Te alejas de allí. Vagas por las calles y de pronto... te encuentras asomada a la terraza del edificio más alto de la ciudad."
"Sabes que es así. Que el mundo, la historia, el tiempo mismo se repite una y otra vez."
"Así que..."

[Entrada en el planeta]
This is the pasado remoto rule:
	relatar fragmento en Table of Pasado Remoto;
	try waking up.

Table of Pasado Remoto
frase
"Te retuerces con el calor de la entrada en el nuevo mundo."
"Es agradable para tí."
"Tu destino asignado es feo, desagradable, repleto de formas básicas y primitivas. Materiales."
"Pero es tu destino."
"Es fácil, aunque desagradable, sobrevolar este mundo. Pero, ¿dónde parar?"
"Cualquier parte debería valer."
"Todo está repleto de vida inerte. No te sirve de nada."
"Un momento. Eso es un ser animado."
"Ocupémoslo."
"Ha sido fácil. Es una... mujer... una... hembra humana. Oh, está tan ávida de poder. Será facilísimo realizar mi trabajo."
"Muy pronto habremos recorrido todo ese planeta. Muy pronto encontraré los medios que estos seres materiales tienen para volar al espacio y entonces informaré de todo lo que aprenda aquí."
"Esta será una misión gloriosa y corta."
"Muy pronto. Pero primero he de descansar. Dormir un poco."

[La presa]
This is the monje rule:
	relatar fragmento en Table of Monje;
	zorro encontrado in eight turns from now;
	try looking.

Table of Monje
frase
"¿Cómo has llegado a esta situación?"
"Tu eras un monje de lo más anodino, un monje cualquiera de los muchos que hay a lo largo y ancho del Imperio Británico."
"¿Por qué tuviste que meter las narices donde nadie quería que las metieses?"
"Por el conocimiento, claro, por el saber, desde luego... reconócelo, ha sido pura curiosidad y ya sabes el dicho del gato."
"Dios bendito, el poseído debe estar muy cerca, muy cerca. ¿Quién iba a imaginar que el poseído sería alguien de esta alcurnia? ¿Quién iba a imaginar que la cacería del zorro a la que me invitaba sería a la de un zorro con levita?"
"Oh, Dios mío, creo que lo estoy escuchando acercarse."

[La cacería]
This is the caceria rule:
	relatar fragmento en Table of Caceria;
	move escopeta to the player;
	try looking.

Table of Caceria
frase
"Uhm.. el rastro acaba por aquí, no cabe duda."
"Es realmente molesto que este ridículo zorro con levita te haya encontrado."
"Esta estaba siendo una buen vida."
"Ahora, lo primero es matarlo."

[Un pequeño dibujo de la querida bruja ardorosa]
This is the sexo rule:
	relatar fragmento en Table of Lujuria;
	try waking up.

Table of Lujuria
frase
"Te lames el sudoroso brazo."
"Es salado, en cierta forma agradable."
"Es tan extraño todo este mundo."
"Lo lames a él que yace boca abajo... murmura algo, algo sobre brujas y putas que no entiendes."
"Su sabor es diferente al tuyo."
"Ah... es agradable esto del sexo, sí que lo es."
"Pero da mucho sueño, tras hacerlo varias veces."
"Es mejor descansar ahora un poco."

[Una algo más sangriento]
This is the corte profundo rule:
	relatar fragmento en Table of Corte Profundo;
	finaliza pronto.

Table of Corte Profundo
frase
"Te cortas levemente la yema de un dedo."
"Está afilada."
"Sabes que está en tí, sabes lo que ha hecho con otras mujeres nobles de tu familia."
"Sabes que no lo puedes permitir."
"Tus piernas ya están atadas para morir dignamente."
"Apoyas el kwaiken sobre tu cuello y respiras profundamente."
"Lo sientes luchando en tu interior, pero lo ignoras."
"Simplemente realizas un corte profundo."


Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

Instead of examining down when the SNum is 0:
	say "Realmente hay mucha distancia hasta abajo.";
	if a random chance of 1 in 2 succeeds:
		try jumping;
	otherwise:
		try flying.

Instead of climbing when the SNum is 0:
	say "Escalas el último obstáculo y...";
	if a random chance of 1 in 2 succeeds:
		try jumping;
	otherwise:
		try flying.


Instead of examining up when the SNum is 0:
	say "Temes... mirar hacia arriba...";
	try looking.

Instead of examining or searching yourself when the SNum is 0:
	try naking.


Chapter 10 - Escena cayendo hacia el suelo

Section 1 - Definicion

[--------------------------------------------------

  Esta es la escena implica que el jugados saltó 
  al empezar, el valor de SNum es de 10

--------------------------------------------------]

[Tabla de transiciones de la escena]
Table of TSSaltoVacio
accion			nueva	regla				texto
jumping			10	the fake rule			"Ya saltaste. Ahora dejate llevar."
taking inventory		10	the fake rule			"¿Qué importa lo que lleves? Pronto acabará todo el dolor."
moving			10	the fake rule			"El único lugar al que vas a ir, viene ya a tí."
singing			10	the fake rule			"Entonas una triste melodía. La vuestra."
attacking		10	the fake rule			"Ya... estás haciendo todo lo posible por morir."
fattacking		10 	the fake rule			"Ya... estás haciendo todo lo posible por morir."
naking			10	the fake rule			"Eso sería ridículo."
thinking			10	the fake rule			"No hay nada en lo que pensar."
dying			10 	the fake rule			"Ya estas camino de ello."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
10		Table of TSSaltoVacio	"Bajo tus pies, a no muchos metros, las ventanas corren desenfrenadas. Más allá simplemente está la ciudad."		"Cayendo desde el más alto edificio de toda la ciudad"		Table of DecoSalto

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 10:
	say "La calle. Y tal vez él. Pero sobre todo el final del dolor y la angustia.".

Instead of examining up when the SNum is 10:
	say "Giras con dificultad la cabeza y atisbas el cielo. Ese lugar que tanto te aterra ahora.".

Instead of examining yourself when the SNum is 10:
	say "Por fuera pareces tu misma... pero sabes que el horror vive dentro de tí. Sabes lo que pretende y lo odias, te odias, por ello.".


[Final de la escena]
At the time when el salto termina:
	relatar fragmento en Table of Final del Salto;
	finaliza pronto.

[Final del salto]
Table of Final del Salto
frase
"El salto llega a su predecible y abrupto final."
"No duele tanto como habías temido."
"Tal vez... sólo es demasiado rápido como para sentirlo."

Section 4 - Decoración de esta escena

Table of DecoSalto
topic				descripcion				printedName
"ventana" or "ventanas"		"Son solo parpadeos, breves imágenes, puertas huidizas a una vida que ya no te corresponde."	"las ventanas del edificio bajo tus pies"
"ciudad"				"No quieres mirarla. No. Pensaste que serías feliz en ella, no... no sabías que es lo que en realidad pasaba, lo que en realidad... eras. No, es mejor no volver a mirar la ciudad."	"la ciudad"

Chapter 20 - Escena final de la nave

Section 1 - Definicion

[--------------------------------------------------

  Esta es la escena implica que el jugador pidió
  un inventario al principio, el valor de 
  SNum es de 10

--------------------------------------------------]

[Tabla de transiciones de la escena]
Table of TSNaveFinal
accion			nueva	regla			texto
looking			20	the TSNFlooking rule	""
viewing exits		20	the fake rule		"Solo hay una dirección a la que ir. Fuera, claro."
exiting			20 	the TSNFout rule		""
fattacking		20 	the fake rule		"No es el momento de dañar nada más."
naking			20	the fake rule		"Eso sería ridículo."
thinking			20	the fake rule		"No hay nada en lo que pensar."
jumping			20	the fake rule		"Ya flotas ingrávida. Saltar no tiene sentido en el espacio."
dying			20	the fake rule		"Te basta con salir afuera para quedar libre."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
20		Table of TSNaveFinal	"La cápsula, ¿qué si no?."	"En la cápsula"		Table of DecoNaveFinal

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

TSNFLN is a number that varies. TSNFLN is usually 0.

This is the TSNFlooking rule:
	if TSNFLN is 0:
		now TSNFLN  is 1;
	otherwise:
		move cadaver to lugar.

This is the TSNFout rule:
	relatar fragmento en Table of Final de la Nave;
	finaliza pronto.

Table of Final de la Nave
frase
"Abres la escotilla."
"Sientes que el aire se escapa y sientes el vacío que rápidamente te rodea. Al no llevar traje espacial eso te asusta un momento."
"Pero este es tu elemento."
"La humana que te contiene muere rápidamente, de forma desagradable y dolorosa, pero..."
"...eso te libera."
"Por fin en casa, por fin. Tras todos estos años de misión. Atrapada entre seres primitivos, ¡materiales!, ¡por fin libre en el vacío!"
"Despliegas tus alas incorpóreas y transmites tu posición."
"Los que esperas que sean tus congéneres aparecen de la nada casi al instante y entonces..."
"...no... ¡NO!... ¡Te consumen!... ¡NOOO!"
"Te tratan como a una mera sonda... te extirpan tu mente... tus recuerdos.. todo lo que has aprendido para preparar vuestro ataque."
	

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining a direction when the SNum is 20:
	say "En el espacio no hay direcciones privilegiadas, ni techos, ni suelos... todo es una frágil y peligrosa pared.".

Instead of examining yourself when the SNum is 20:
	say "Casi todo está hecho. Ya falta muy poco. Ya casi eres tú misma.".

Instead of going nowhere or moving when the SNum is 20:
	say "Solo hay un lugar al que ir desde aquí. Al exterior.".


Section 4 - Decoración de esta escena

Table of DecoNaveFinal
topic				descripcion				printedName
"pared" or "paredes" or "capsula" 	"Aluminio, cromo, cerámica, fibra de carbono... en el fondo todo demasiado delgado cuando ahí fuera lo que espera es el vacío y la muerte... pero no para tí."		"las paredes de la cápsula"
"aluminio" or "cromo" or "ceramica" or "fibra" or "carbono"	"Cosas materiales que ya te preocupan poco." 	"las cosas materiales"
"vacio" or "exterior" or "fuera" or "escotilla"	"Tu destino."		"el destino"
"manos" or  "mano"		"Las manos de tu huésped. Cubiertas con la sangre del otro ocupante de la cápsula. Sólo has sabido matarlo golpeándole la cabeza repetidamente."		"las manos"
"sangre"				"Tan familiar y ahora tan extraña a tí."		"la sangre"
"cabeza"				"Abierta, sangrante. Y no te molesta ni te inmuta. No te importa lo más mínimo. Ya no."	"la cabeza"
"compañera"			"Esa eres tú."	"tu misma"

Chapter 30 - Ver caer

Section 1 - Definicion

[--------------------------------------------------

  Esta es la escena implica que el jugados miró 
  al empezar, el valor de SNum es de 30

--------------------------------------------------]

[Tabla de transiciones de la escena]
Table of TSVerCaer
accion			nueva	regla				texto
jumping			30	the fake rule			"Ya saltaste. Ahora dejate llevar."
moving			30	the fake rule			"¿Qué sentido tiene ir a cualquier parte ahora?."
singing			30	the fake rule			"Entonas una triste melodía. La vuestra."
attacking		30	the fake rule			"Nunca podrías hacerle daño a ella... ni a tí... nunca, mientras ella viva."
fattacking		30 	the fake rule			"Nunca podrías hacerle daño a ella... ni a tí... nunca, mientras ella viva."
naking			30	the fake rule			"Eso sería ridículo."
thinking			30	the fake rule			"No hay nada en lo que pensar."
dying			30	the fake rule			"Tal vez pronto."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
30		Table of TSVerCaer	"La calle de la gran ciudad. Todos, horrorizados, miran hacia arriba."		"La calle de la gran ciudad"		Table of DecoVerCaer

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 30:
	say "El duro suelo. Ojalá fuese más blando.".

TVCN is a number that varies. TVCN is usually 0.
Instead of examining up when the SNum is 30:
	if TVCN is 0:
		say "Miras hacia arriba, y la ves. Su pequeño cuerpo corre a estrellarse contra el suelo. Lo ha hecho, se arrojado al vacío. Sientes horror y apartas la mirada.";
		now TVCN is 1;
	otherwise:
		say "¡No! No quieres verla caer.".

Instead of examining yourself when the SNum is 30:
	say "No eres más que un desdichado, alguien que no pudo evitar lo que más temía.".


[Final de la escena]
At the time when se vera el salto:
	relatar fragmento en Table of Final de VerCaer;
	finaliza pronto.

[Final del salto]
Table of Final de VerCaer
frase
"El sonido es espeluznante."
"Sabes que es ella, que está muerta, que has llegado tarde para salvarla de sí misma."
"Tembloroso, apuntas tu pistola a tu sien y aprietas el gatillo."

Section 4 - Decoración de esta escena

Table of DecoVerCaer
topic				descripcion				printedName
"ciudad"				"¿Qué más da como sea la ciudad? Es la ciudad, no es eso lo que tienes que ver, lo que temes ver..."	"la ciudad"
"calle"				"Está llena de gente y todos miran hacia arriba." 	"la calle"
"gente"				"No conoces a nadie, pero los reconoces a todos. Son gente normal, gente que es mejor que no sepan lo que está pasando."	"la gente"
"ella"				"Es... el amor de tu vida. La que veniste a salvar. Tu fracaso. Eso es lo que es."	"ella"

Chapter 40 - Hoguera

Section 1 - Definicion

[--------------------------------------------------

  Esta es la escena implica que el jugados despertó 
  al empezar, el valor de SNum es de 40

--------------------------------------------------]

[Tabla de transiciones de la escena]
Table of TSHoguera
accion			nueva	regla				texto
jumping			40	the fake rule			"No puedes salta, ni volar, mientras sigas atada a este poste."
moving			40	the fake rule			"No puedes ir a ningún lugar estando atada a este poste."
singing			40	the TSHsinging rule		""
fattacking		40 	the fake rule			"No puedes hacer gran cosa estando atada al poste."
naking			40	the fake rule			"Bailar desnuda es una de las partes que más te gusta de ser una bruja, después del placer sexual con cualquiera, claro... pero no es el momento de quitarse la ropa."
thinking			40	the fake rule			"No hay nada en lo que pensar."
dying			40	the fake rule			"Adoras la vida. ¿Por qué desear morir?"

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
40		Table of TSHoguera	"Atada a un poste, en una plataforma. La gente del pueblo, armadas con herramientas de labranza y antorchas, te mira expectante."		"En la plaza del pueblo"		Table of DecoHoguera

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

[Cantar soluciona la situación... un poco]
This is the TSHsinging rule:
	relatar fragmento en Table of Cantar Hoguera;
	finaliza pronto.

Table of Cantar Hoguera
frase
"Cantas."
"El poder reside en tu voz."
"Así que cantas. Cantas. Cantas."
"Y prontos sientes como se tambalean las maderas, como se estremecen los aldeanos, como el pueblo entero se sacude."
"Las cuerdas se aflojan y ries poderosa... libre."
"Mas... sientes un intenso dolor en el abdomen. Una saeta te ha atravesado de parte a parte. Clavándote en el poste."
"Miras hacia ellos y ves al hermoso cazador, tan gallardo, tan hijo de puta...  te ha dado muerte."
"Intentas cantar, pero él no te da oportunidad. Salta a la tarima y diestramente te corta el cuello de parte a parte."
"Tu poderosa voz se quiebra, se transforma en un manantial de sangre y... pronto... en una luz que surge de tu cuello."
"La luz... el poder de Satán que te abandona."
"Lo último que ves es el terror en los ojos del hermoso cazador."

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 40:
	say "Bajo tí una plataforma y bajo ella... leña seca, estos malnacidos quieren quemarte viva.".

Instead of examining up when the SNum is 40:
	say "El cielo. Adoras sentir como el Diablo te lleva volando por él cuando os sumís en el éxtasis del sexo.".

Instead of examining yourself when the SNum is 40:
	say "Eres la mujer más hermosa del pueblo. Y la más poderosa. ¿Quién si no? La misma novia del Diablo. Mefistófeles en persona te ama, te canta, te da el poder de aterrorizarlos a todos. Hasta hoy.".

Instead of taking decoration when the SNum is 40:
	say "No puedes alcanzar nada ni hacer gran cosa mientras estés atada.".


[Final de la escena]
At the time when arde la hoguera:
	relatar fragmento en Table of Final de Hoguera;
	finaliza pronto.

Table of Final de Hoguera
frase
"El párroco se adelante de entre los demás."
"Grita cosas incomprensibles en latín y ves con terror que porta una antorcha ardiente. ¡Bastardo! Bien que gemías de forma más placentera cuando me montabas. ¡Hijo de puta!."
"Ves como si durase eternamente la trayectoria de la antorcha, como prende en la leña seca y cómo el fuego te rodea."
"Chillas."
"Te abrasas como un churrusco de cerdo al fuego."
"El pánico te domina. Ruegas a Satán que te salve. Chillas y ruegas. Ruegas y chillas."
"Pero solo sientes como el poder te abandona."
"Como sale por tu boca. Luminoso, como la primera vez que lo viste."
"Como se eleva sobre tí provocando el pánico de entre la gente del pueblo."
"Toses."
"Y pierdes la visión de lo que pasa, y todo es dolor, todo es humo, todo es respirar el mismo infierno."

Section 4 - Decoración de esta escena

Table of DecoHoguera
topic				descripcion				printedName
"plataforma" or "hoguera"		"Los muy malditos lo tenían preparado. Todo esto no se prepara en un día. ¡Malditos! ¡Malditos ignorantes! Van a quemarte con toda esta estúpida leña seca."		"la hoguera"
"leña" or "madera" 		"Maderas y maderas... esto arderá hora y horas... no piensan dejar de tí ni los huesos."	"la leña"
"pueblo" or "casas" or "casa" or "plaza"	"Siempre pensaste que eran cuatro casas mal puestas, hediondas, repletas de estúpidos campesinos. Nunca lo sentiste como tu hora. Por eso te hizo tan feliz la luz que cayó del cielo y que te penetró en el campo. Por eso te hizo tan feliz escuchar la poderosa voz de Satán. La que es ahora tu poderosa voz."	"el pueblo"
"gente" or "pueblerinos" or "campesinos" or "malditos" or "aldeanos"	"Los conoces a cada uno por su nombre. A algunos de esos hombres los has cabalgado, a otros los has atemorizado, a la mayoría ambas cosas. Las mujeres no son muy diferentes, muchas te han rogado poder, amor... otras también han sido tus amantes. ¡Malditos! Ellos han probado el poder de tu voz, ellos han escuchado las sabias palabras del Diablo, se han aprovechado de tí y ahora... ahora te arrojan a la hoguera... ¡Malnacidos!."		"la gente"
"hombres" or "hombre"		"Ellos solo son bestias, fáciles de manipular, fáciles de poseer. Bestias."	"los hombres"
"mujeres" or "mujer"		"Ellas te temen tanto como desean ser tu, y por eso son peores que ellos. Son tus hermanas. Hermanas traidoras."	"las mujeres"
"poste"				"Entre la leña, en mitad de la plataforma, surge un poste macizo de madera. Probablemente está firmemente enterrado en el suelo. Y tu estás atada a él."	"el poste"

Chapter 70 - Atrapada!

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSAtrapado
accion			nueva	regla				texto
jumping			70	the fake rule			"No hay espacio para saltar."
moving			70	the fake rule			"Ojalá pudieses ir a cualquier parte."
singing			70	the fake rule			"Tienes que salir. No pienses en cantar, no, eso es lo que 'ellos' hacen."
attacking		70	the fake rule			"Golpeas... pero no sirve de mucho."
exiting			70	the fake rule			"Palpa aquí. Empujas allá. Pero nada logras, no hay forma de salir."
fattacking		70 	the fake rule			"Golpeas, pero no sirve de mucho."
naking			70	the fake rule			"Eso sería ridículo."
thinking			70	the fake rule			"Piensas... piensas... pero no encuentars ninguna solución. Solo sientes el terror. Recuerdas la explosión. Recuerdas al infiltrado. '¡Socorro!', acabas gritando inútilmente."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
70		Table of TSAtrapado	"Atrapada en una pequeña sección de los túneles bajo la instalación secreta."		"¡Atrapada!"		Table of DecoAtrapada

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 70:
	say "Piedra resistente. Maldita resistencia de la jodida piedra. Era imprescindible mantener el secreto, pero ahora esta resistencia acabará contigo.".

Instead of examining up when the SNum is 70:
	say "En el techo tampoco puedes ninguna forma de salir. ¡Tienes que salir! ¡Tienes que lograrlo! Tu eres la única que conoce el secreto, la única que sabe cómo acabar con los invasores.".

Instead of examining yourself when the SNum is 70:
	say "Estás malherida por culpa del infiltrado. ¡Maldita sea! Nadie logró detectar a esa cosa dentro del infiltrado. Tu bata está destrozada y a penas es tal cosa. El resto de tu ropa no está mucho mejor.".


[Final de la escena]
At the time when sin aliento:
	relatar fragmento en Table of Final de Atrapada;
	finaliza pronto.

[Final]
Table of Final de Atrapada
frase
"Ya no hay más tiempo."
"A medida que el aire se carga de dióxido de carbono, te duermes."
"Finalmente pierdes el conocimiento. Has fracasado. El secreto no llegará nunca al resto de la Humanidad. Serán para siempre esclavos de los invasores."

Section 4 - Decoración de esta escena

Table of DecoAtrapada
topic				descripcion				printedName
"seccion" or "tunel" or "tuneles" or "parte"	"Es solo una parte muy pequeña del entramado de túneles que tenía la instalación. Te has quedado atrapada con la explosión en esta angustiosamente pequeña sección."	"la sección"
"pared" or "paredes"		"Una parte es la lisa e impenetrable pared del túnel de la instalación secreta. Pero el resto... hay piedras derrumbadas en ambos lados"	"las paredes"
"piedra" or "piedras"		"Tal vez esta... no, no se mueve... ¿y esta?... no tampoco... ¡Mierda! ¡Mierda! ¡Mierda! No se mueve ninguna joder...." 	"las piedras"
"instalacion" or "secreta"		"En la instalación unos cuantos científicos supervivientes aún, libres aún, buscábais un arma contra la invasión de los seres de energía venidos del espacio exterior. Pero la explosión ha debido matarlos a todos, destruirlo todo."	"la instalación"
"explosion"			"Ya tenías la solución. Eran las microondas. Los atraen y si se modula determinado patrón, los mata, los destruye por completo. Pero... al mismo tiempo que lo descubriste también descubriste al Infiltrado... él te atacó inmediatamente, y luego disparaste tú y entonces... entonces... el disparó y... entonces.. huiste por los túneles y... de pronto... vino la explosión."	"la explosión"
"infiltrado"			"Todos confiaban en él. ¡Todos! Y la máquina debía detectar a los invasores. ¿Por qué no lo hizo? ¿Por qué? Todo puede haberse perdido por este error."	"el infiltrado"

[Un poco de truco]
Understand "pensar en [text]" or "piensa en [text]" or "recordar [text]" or "recuerda [text]" as examining decoration when SNum is 70.

Chapter 80 - Infectado!

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSInfectado
accion			nueva	regla				texto
jumping			80	the fake rule			"No seas ridículo, el parásito no va salir así."
moving			80	the fake rule			"No vas a ir a ninguna parte hasta no haberte sacado esa cosa."
singing			80	the infectado singing rule		""
attacking		80	the fake rule			"Esa cosa no sale solo golpeándola."
exiting			80	the fake rule			"No vas a ir a ninguna parte hasta no haberte sacado esa cosa."
fattacking		80 	the fake rule			"Tienes que localizar el parásito, ignora todo lo demás."
naking			80	the fake rule			"Ya estás desnudo."
thinking			80	the fake rule			"No hay nada en lo que pensar. Hay que buscar."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
80		Table of TSInfectado	"Tu pequeña y ordenada habitación del cuartel. Pero nada de lo que hay importa, excepto tu cuerpo desnudo en el espejo."		"Frente al espejo"		Table of DecoInfectado

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

This is the infectado singing rule:
	relatar fragmento en Table of esInfiltrado;
	finaliza pronto.

Table of esInfiltrado
frase
"Oh no..."
"Es demasiado tarde."
"El parásito te domina y canta de alegría."
"Mucho tiempo después te despiertas malherido. Varias heridas de bala, probablemente, sangran."
"Tienes una pistola en la mano y una mujer huye por un túnel."
"Huye de tí."
"Sientes cómo el parásito intenta retomar el control. La mujer es importante para él. Muy importante. Necesita matarla."
"No le das oportunidad de hacerse con ella. Hay un contenedor de combustible en una pared, apuntas con el arma al mismo y disparas."

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 80:
	say "Concéntrate en localizar el parásito antes de que sea tarde.".

Instead of examining up when the SNum is 80:
	say "Concéntrate en localizar el parásito antes de que sea tarde".

Instead of examining yourself when the SNum is 80:
	say "[one of]Primero echo un vistazo general. Todo parece normal, en su sitio. ¿Dónde está el maldito parásito?[or]Te palpas el abdomen. No hay agujeros, ni bultos, ni nada parece diferente, solo tu bien formado abdomen.[or]No, en el pecho no está. Palpas entre las costillas y no hay nada tampoco.[or]Vuelves a revisarlo todo y nada, no encuentras el parásito por ninguna parte.[stopping]".

Instead of taking ropas when the SNum is 80:
	say "No. No vas a vestirte hasta localizar el parásito.".

Instead of searching ropas when the SNum is 80:
	relatar fragmento en Table of Final de Infectado;
	finaliza pronto.

[Final]
Table of Final de Infectado
frase
"Rebuscas entre tus ropas y en seguida encuentras tu pistola reglamentaria."
"Al mirarla entiendes que no hay ninguna otra opción."
"No te cabe duda de que... es lo mejor..."
"Si no puedes encontrar, ni sacar el parásito, lo mejor es no darle oportunidad."
"Apoyas tu pistola sobre tu sien, te saludas a tí mismo con la otra mano y disparas..."

Section 4 - Decoración de esta escena

Table of DecoInfectado
topic				descripcion				printedName
"espejo"				"Es un espejo alto que te regalaron hace mucho, pero eso no importa, lo que importa es que con él te puedes examinar cada parte de tu cuerpo, y tal vez... tal vez... localizar al jodido parásito."	"el espejo"
"habitacion" or "cuartel"		"Céntrate en localizar el maldito parásito en tu cuerpo."	"el lugar"
"cuerpo"				"[one of]Te revisas el cuerpo y no encuentras nada de nada.[or]Pecho, no, abdomen, no... jodida cosa, ¿dónde estás?[or]No lo ves... no lo ves... maldita sea.. ¡no lo ves! No ves nada diferente en tu cuerpo.[in random order]"	"tu cuerpo"
"pecho"				"No, en el pecho no está. Palpas entre las costillas y no hay nada tampoco."	"tu cuerpo"
"abdomen"			"Te palpas el abdomen. No hay agujeros, ni bultos, ni nada parece diferente, solo tu bien formado abdomen."	"tu abdomen"
"culo"				"Con desagrado te metes el dedo en el culo. Profundamente. Pero no notas nada extraño."		"tu delicado culito"
"picha" or "trompa" or "elefante" or "polla" or "poya" or "pene" or "genitales"	"[one of]¿Se habrá escondido en el elefante? Te palpas los testículos y luego miras por la trompa como si fuese una manguera, pero el parásito no está ahí.[or]Te vuelves a palpar los bajos. Da cierto gusto, pero el mierda de bicho no está ahí.[stopping]"	"el gigantón"
"brazos" or "brazo" or "mano" or "manos" or "antebrazo" or "antebrazos"	"Te palpas, revisas... pero no está ahí."	"los brazos"
"pie" or "pies" or "pierna" or "piernas" or "muslo" or "muslos"			"Revisas tus pies, tus piernas, pero no está ahí."	"las piernas"
"cabeza" or "cara" or "ojo" or "ojos"		"Te miras al espejo fijamente. ¿Se habré escondido en tu dura mollera? No... no parece haber mucho sitio ahí, pero por si acaso te arreas un buen golpe. Nada sale de ahí, tan sólo te sientes un poco mareado."	"tu cabeza"
"oreja" or "orejas" or "oido" or "oido"	"Te metes el dedo en el oido. Pero no está ahí, solo sacas porquería amarilla."	"tus oídos"
"nariz"				"Te levantas la punta de la nariz y miras un largo rato. Pero no está por ahí, solo hay pelos largos y mocos."	"tu nariz peluda"
"boca" or "lengua" or "dientes" or "garganta"		"Abres mucho la boca, pero a parte de muchos empastes no se ve nada raro."	"tu boca"
"empastes"			"No, no parece haberse escondido en tus múltiples empastes."	"los empastes"
"cuello"				"Te palpas el cuello y todo parece norm... ¡espera!... ah, no... es sólo la nuez."	"tu cuello"
"piel"				"Revisas tu piel palmo a palmo, pero no hay nada extraño en ella."	"tu piel"

[Una acción muy particular]
Sexamining is an action applying to nothing.
Understand "buscar en tu cuerpo" or "buscar bultos" or "buscar en cuerpo" or "busca en tu cuerpo" or "buscar bicho/parasito"or "busca bicho/parasito" or "busca bultos" or "busca en cuerpo" as sexamining.

Carry out sexamining:
	try examining yourself.

Chapter 110 - Pitillo

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSPitillo
accion			nueva	regla				texto
jumping			10	the saltar_vacio rule		"La verdad es que es una gran idea, esta fiesta es insoportable."
moving			110	the fake rule			"No pienso ir a ninguna parte hasta acabarme este pitillo."
entering			110	the fake rule			"No pienso ir a ninguna parte hasta acabarme este pitillo."
exiting			110	the fake rule			"No pienso ir a ninguna parte hasta acabarme este pitillo."
thinking			110	the fake rule			"No, no. Pensar es aún peor para la salud que fumar."
dying			10	the saltar_vacio rule		"La verdad es que es una gran idea, esta fiesta es insoportable."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
110		Table of TSPitillo		"La terraza del que ha organizado esta fiesta insoportable."	"La terraza"		Table of DecoPitillo

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Instead of doing anything except looking or jumping or examining or examining decoration or moving or exiting or entering or taking inventory when the SNum is 110:
	say "Ahora mismo sólo te apetece terminarte este pitillo.".

Every turn when the SNum is 110:
	say "Das una calada. Y... [one of]te resulta tan increíblemente relajante.[or]toses... deberías dejarlo.[or]¡Tortillas y elfos! ¿Puede haber algo mejor que un pitillo?[or]recuerdas cierto enano pirómano, no sabes por qué.[or]te das cuenta de lo mucho mejor que se está en esta terraza que escuchando las locuras de Urbatain ahí dentro.[or]te das cuenta de lo mucho mejor que se está en esta terraza que escuchando las locuras de Akbarr ahí dentro.[or]te das cuenta de que si escuchas algo más del gordo cabrón de Mel te pegas un tiro, eso está claro.[or]te das cuenta de que ese tal Kilivor no ha venido a la fiesta.[or]te das cuenta de que en realidad no son tantos, y que hay más parsers en la mesa de la entrada que invitados.[or]piensas que te estás mareando y no estás muy seguro si ha sido por la pintura interactiva de Jarel, por los sonidos sicodélicos de Eliuk o por lo que se estaba fumando Grendel mientras escribía su última Minúscula.[or]das una segunda calada al recordar a Depresiv que sentado al teclado de un portatil gritaba '¡Mirad ahora sólo con los dedos de un pié!', mejor tres caladas y ojalá Grendel te hubiese dejado algo de su hierba.[or]te preguntas que hace una caja llena de escalopendras en una fiesta así.[or]te preguntas porqué los SPAC serán tan enormes cuando los pides en papel.[or]te preguntas si esto, la vidad, no es algo más que una absurda ilusión literaria.[or]te preguntas, bastante melancólico, dónde estarán las chicas.[in random order]".

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 110:
	say "La ciudad, ahí abajo, tan lejos.".

Instead of examining up when the SNum is 110:
	say "Es uno de esos días de verano tormentosos. Mal agüero.".

Instead of examining yourself when the SNum is 110:
	say "Mejor no mirarte, estás gordo y das un poco de pena.".


[Final de la escena]
At the time when fin de pitillo:
	relatar fragmento en Table of Final de Pitillo;
	now SNum is 0;
	now TransActual is Table of TSNeutral;
	try jumping.

[Final del salto]
Table of Final de Pitillo
frase
"El pitillo se acaba, lo lanzas por el borde de la terraza y ves como su pequeña luz cae y cae."
"Por alguna razón piensas en extraños alienígenas hechos tan solo de luz."
"Piensas en que sería mejor regresar a la fiesta, sobre todo para tu salud, porque la alternativa sería otro pitillo."
"Y entonces ocurre..."
"...Mel Hython sale a la terraza y te apunta con su dedo grueso como una salchicha al tiempo que te exhorta con un terrible conjuro: 'Contigo quería hablar amigo mío, tengo que contarte una idea que tengo sobre un relato... un relato reentrante, en donde se mezcla... ¿qué te pasa? Te veo mal.'"
"Y de pronto lo sabes, sabes que no hay otra solución y..."

Section 4 - Decoración de esta escena

Table of DecoPitillo
topic				descripcion				printedName
"ciudad"				"La ciudad. Todas las ciudades son iguales de noche. Una suerte de enjambre de luciérnagas pegadas a un bosque que no se puede ver. He estado en casi todos los contienentes y al final, siempre es lo mismo, siempre hay una terraza y el bosque de luciérnagas visto desde lo alto."	"la ciudad"
"terraza"				"No es que sea gran cosa. La gente que se dedica a estas cosas de la literatura interactiva casi no se puede permitir ni un piso. Pero para lo que suele ser habitual se podría decir que es todo un lujo."	"la terraza"

Chapter 120 - Abandono

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSAbandono
accion			nueva	regla				texto
moving			120	the fake rule			"No hay ningún lugar al que ir, todo es lo mismo."
singing			120 	the fake rule			"Cantar nunca. Ellos cantaban."
thinking			120	the fake rule			"Pensar sólo trae malos recuerdos."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
120		Table of TSAbandono	"Un lugar miserable, olvidado de la mano de Dios, en un mundo estéril."	"Un lugar miserable."		Table of DecoAbandono

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Every turn when the SNum is 120:
	say "[one of]Miras al horizonte y sólo ves una llanura estéril, parda. Vuestra obra.[or]Observas cansinamente el cielo, siempre verde, siempre cubierto de extraña luminiscencia.[or]Rugen tus tripas.[or]Te duelen los pies. Ya te doleran para siempre, de tanto que has caminado sin rumbo.[or]Sientes un arrebato de ira hacia ellos... ellos... ellos que os obligaron... pero fuísteis vosotros los que finalmente lo hicísteis.[or]Hace mucho calor. Siempre hace mucho calor. Te tocas la frente, pero ya no te queda ni sudor.[or]Te preguntas cuánto tiempo llevas caminando por este erial de cenizas. Hace tanto ya... no puedes recordarlo.[in random order]".

Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 120:
	say "La tierra... ya solo es ceniza.".

Instead of examining up when the SNum is 120:
	say "El cielo mismo está enfermo, con ese triste color verdoso todo el tiempo.".

Instead of examining yourself when the SNum is 120:
	say "Un despojo humano, casi muerto ya por el hambre y la radiación.".


[Final de la escena]
At the time when fin de abandono:
	relatar fragmento en Table of Final de Abandono;
	now SNum is 0;
	now TransActual is Table of TSNeutral;
	try waking up.

[Final del salto]
Table of Final de Abandono
frase
"No queda nada en este mundo muerto."
"Mejor me echo a dormir, aquí mismo."
"Quién sabe. Tal vez muera y se terminen todos mis problemas."
"Tal vez despierte y todo haya sido una pesadilla."
"Tal vez sueñe que vivo otra vida."
"Ojala."

Section 4 - Decoración de esta escena

Table of DecoAbandono
topic				descripcion				printedName
"tierra" or "ceniza" or "mundo" or "llanura"	"El mundo está muerto. Disparamos el arma. Los echamos, sí, ¿pero a qué precio? Nos hemos matado a nosotros mismos. Hemos destruido el mundo para ellos, pero también para nosotro. Todo está quemado, arruinado por la radiación."		"la tierra"
"tripa" or "tripas"			"Están tan vacías y tu piel tan marchita que a veces piensas que mirando tu barriga podría verse tu espalda. Deben estar tan juntas que casi deben ser la misma cosa."		"las tripas"
"luminiscencia" or "verde" or "verdoso"	"El cielo se puso verde cuando ellos murieron. La luminiscencia de alguna forma son sus cadáveres. Y en postrera venganza han contaminado el aire, todo el cielo, tal vez para siempre."	"la luminiscencia"
"frente"				"Reseca como el mismo mundo."	"tu frente"
"pie" or "pies"			"De tanto caminar, ya no sienten nada, excepto dolor permanente. Esos son tus pies. Los pies de un superviviente en un mundo estéril."	"tus pies"
"superviviente"			"Eso es lo que soy, un superviviente. ¿El último tal vez? Hace tanto que no veo a nadie..."	"tu mismo"

Chapter 130 - Monje

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSMonje
accion			nueva	regla				texto
jumping			130	the fake rule			"Eso sólo delataría tu posición."
moving			130	the fake rule			"No, no, mejor no moverse hasta que se haya ido."
entering			130	the fake rule			"Ya estás en el centro del matorral."
exiting			130	the fake rule			"Salir estando el monstruo ahí fuera es una locura."
smelling			130	the fake rule			"Por el olor... estás cagado de miedo."
viewing exits		130	the fake rule			"No eres un topo así que sólo puedes salir del matorral."
taking inventory		130	the fake rule			"No llevas nada que pueda salvarte de él."
waiting			130	the fake rule			"Sí. Sí. Esperar, es lo mejor. Intenta tranquilizarte."
fattacking		130	the monje a lo loco rule		""
thinking			130	the fake rule			"No hay mucho que pensar. Él te riene atrapado."
listening			130	the fake rule			"Está muy cerca. Puede descubrirte en cualquier momento."
praying			130	the fake rule			"Ruegas a Dios que te salve de la muerte."
dying			130	the fake rule			"Aún no quieres morir."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
130		Table of TSMonje		"En el centro de un espeso matorral en las tierras del poseído. Está cerca, preparado para matarte con su escopeta de cazar zorros. Lo mejor es esperar a que se vaya."	"Un espeso matorral"		Table of DecoMonje

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Instead of doing anything except  praying or listening or thinking or moving or fattacking or looking or jumping or examining or examining decoration or exiting or entering or smelling or viewing exits or waiting or taking inventory when the SNum is 130:
	say "Eso te asusta, es mejor no hacer nada hasta que se vaya y entonces huir.".

Every turn when the SNum is 130:
	say "[one of]Apenas puedes contener los jadeos de ansiedad.[or]Oh, Dios, oh, Dios... está justo aquí al lado.[or]Padre Nuestro que estás en los cielos...[or]Sus pasos. Son tan seguros y aterradores. ¡Puede que sepa donde estás![or]Se ha parado. Se ha detenido. Oh, no, ¿estará apuntándote con la escopeta desde fuera del matorral?[or]El matorral se mueve, oh Dios mío, va a descubrirnos.[or]Ruegas a Dios por tu alma y por la de él.[or]Piensas en lo bien que estarías ahora si tan solo hubieses aceptado ese destino en las misiones.[or]Oh, no, oh, no, está buscando entre las hojarasca del matorral.[or]Se te va a romper el corazón. Con lo fuerte que late debe estar oyéndote.[in random order]".

[Truco]
Understand "rompe cazador/poseido/endemoniado" as fattacking when the SNum is 130.
Understand "ataca cazador/poseido/endemoniado" as fattacking when the SNum is 130.
Understand "atacar cazador/poseido/endemoniado" as fattacking when the SNum is 130.
Understand "ataca a cazador/poseido/endemoniado" as fattacking when the SNum is 130.
Understand "atacar a cazador/poseido/endemoniado" as fattacking when the SNum is 130.

This is the monje a lo loco rule:
	relatar fragmento en Table of Final de Monje Valiente;
	finaliza pronto.

Table of Final de Monje Valiente
frase
"Ya estás cansado de huir."
"Te preparas y sales gritando dispuesto a enfrentarte a el."
"Pero solo eres un monje documentalista ridículo y él es un cazador experto, y endemoniado."
"Sólo te da tiempo a escuchar el sonido de un disparo, nada más."


Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 130:
	say "El suelo es solo tierra y las enmarañadas raíces del matorral.".

Instead of examining up when the SNum is 130:
	say "Por suerte el matorral te cubre por completo.".

Instead of examining outside when the SNum is 130:
	try examining decoration "fuera".

Instead of examining yourself when the SNum is 130:
	say "Has vivido mejores momentos, ahora tu levita está rota y tu lleno de arañazos.".


[Final de la escena]
At the time when zorro encontrado:
	relatar fragmento en Table of Final de Monje;
	finaliza pronto.

Table of Final de Monje
frase
"Te ha encontrado."
"Te adelantas hacia él y ruegas por tu vida."
"Pero la única respuesta es un sonoro disparo."
"Y un intenso dolor."
"Tocas incrédulo la sangre que mana de tu pecho."

Section 4 - Decoración de esta escena

Table of DecoMonje
topic				descripcion				printedName
"exterior" or "fuera" or "cazador" or "poseido" or "endemoniado"	"Con mucho cuidado retiras algunas hojas temeroso de que te vea y echas un vistazo fuera. Es él realmente, Dios bendito. Es él está mirando hacia aquí con el arma apoyada en el hombre. Te escondes rápidamente en el centro del matorral."	"el peligro"
"matorral" or "arbusto"		"No tan grande como quisieras pero es un refugio."	"el matorral"
"escopeta" or "arma"		"No quieres volver a verla. Es temible y está cargada."	"el arma"
"zorro" or "zorros"		"El único zorro que hay aquí eres tu mismo, que está a punto de ser cazado. Oh, Dios mío."	"el zorro"
"tierra" or "tierras"		"La buena tierra de Inglaterra. Salve sea la Reina. Ojalá pronto tu sangre no la riegue."	"la tierra"
"raices" or "raiz" or "leña"		"No es más que la fina leña que forma casi todo el matorral." 	"las raices"

Chapter 140 - El Cazador

Section 1 - Definicion

[Tabla de transiciones de la escena]
Table of TSCazador
accion			nueva	regla				texto
jumping			140	the fake rule			"Pegas un salto imposible hasta una rama, pero no se le ve desde ahí tampoco, así que bajas de nuevo."
moving			140	the fake rule			"Sabes que está por aquí cerca, no hay que ir a ningún otro lado."
entering			140	the fake rule			"Tienes que encontrarlo primero."
exiting			140	the fake rule			"Ya sabes de sobra que no puedes dejarlo vivir. Hay que cazarlo."
smelling			140	the cazador smelling rule		""
viewing exits		140	the fake rule			"Se puede ir a cualquier parte desde aquí, pero tienes que encontrarlo."
waiting			140	the fake rule			"Esperas un poco, pero no aparece por sí mismo."
fattacking		140	the fake rule			"En cuanto lo localices podrás acabar con él."
listening			140	the fake rule			"Casi puedes escuchar su corazón enloquecido por el miedo. Pobre iluso."
thinking			140	the fake rule			"Es el momento de actuar, eso es todo lo que puedes pensar. El momento de actuar, muy a tu pesar."
dying			140	the fake rule			"La vida ha sido buena, esta vez. Desear morir es una tontería. Y sin embargo..."

[La tabla de relación escena (por número) y tabla, empieza vacía y se añade con cada escena]
Table of Transicion Por Numero (continued)
escena		transiciones		descripcion		printedName		decorados
140		Table of TSCazador	"En una parte de los bosques de tus tierras. Cazando un zorro. Un zorro con levita que ha descubierto lo que eres. Pero está por aquí cerca, casi puedes olerlo."	"En el bosque"		Table of DecoCazador

Section 2 - Reglas de transicion

[--------------------------------------------------

 Aquí van todos los cambios que ocurran 
 además del cambio mismo de escena

--------------------------------------------------]

Instead of doing anything except  searching or listening or thinking or moving or fattacking or looking or jumping or examining or examining decoration or exiting or entering or smelling or viewing exits or waiting or taking inventory when the SNum is 140:
	say "Hay que centrarse en localizar al zorrito con levita demasiado fisgón.".

[Truco]
Understand "rompe zorro/sacerdote/monje/levita" as fattacking when the SNum is 140.
Understand "ataca zorro/sacerdote/monje/levita" as fattacking when the SNum is 140.
Understand "atacar zorro/sacerdote/monje/levita" as fattacking when the SNum is 140.
Understand "ataca a zorro/sacerdote/monje/levita" as fattacking when the SNum is 140.
Understand "atacar a zorro/sacerdote/monje/levita" as fattacking when the SNum is 140.

This is the cazador smelling rule:
	relatar fragmento en Table of Olisqueando;
	move matorral to lugar;
	try looking.

Table of Olisqueando
frase
"Uhm... uhm..."
"Está cerca el zorrito... por aquí... por aquí..."
"Huelo su miedo, sí."
"Sin lugar a dudas ha estado por aquí, por este matorral."


Section 3 - Acciones tratadas a parte, no en la tabla de transacciones

[--------------------------------------------------

 Aquí van todos las acciones que no implican
 una transacción pero que deben ser modificadas
 o frenadas y no se pueda usar la tabla

--------------------------------------------------]

[Examinares]
Instead of examining down when the SNum is 140:
	say "El suelo es solo tierra, tu tierra.".

Instead of examining up when the SNum is 140:
	say "La luz mortecina de la tarde se filtra a penas por entre las copas de los robles.".

Instead of examining yourself when the SNum is 140:
	say "Aunque ya tienes una cierta edad, tienes una apariencia excelente con tus ropas de cazar zorros.".



[Final de la escena]
Instead of searching matorral when the matorral is visible:
	relatar fragmento en Table of Final de Caceria;
	finaliza pronto.

Table of Final de Caceria
frase
"Sí, aquí está."
"El muy iluso ruega por su vida."
"Despreciable, como casi todos, le contesto con mi gatillo."
"Bueno, ya está hecho... casi."
"No puedes quedarte ahora en este cuerpo, ya no."
"Así que introduces los cañones de las escopeta en tu boca, cierras los ojos y aprietas el gatillo por segunda vez."

Section 4 - Decoración de esta escena

Table of DecoCazador
topic				descripcion				printedName
"bosque" or "bosques" or "arbol" or "arboles" or "robles" or "roble"	"Esta parte de la propiedad está cubierta por viejos robles, algunos de ellos los plantaste tu mismo, hace mucho."	"el bosque"
"zorro" or "zorros"		"Tienes que estar por aquí, en alguna parte."	"el zorro"
"tierra" or "tierras"		"Hace mucho que ganaste esta buena tierra por servicios a la Reina. Fue fácil. Casi todos por aquí abajo son idiotas en comparación a tí."		"la tierra"

Chapter 9999 - La escena fake

[La escena neutral es representada por el número 9999]
SFake is a scene. SFake begins when SNum is 9999.
SFake ends when the SNum is not 9999.

When SFake begins:
	say "Mierda. Caímos en un atolladero.";
	finaliza pronto.



