/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.app.beans;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URI;
import javax.swing.JPanel;

public class SVGPanel
extends JPanel {
    public static final long serialVersionUID = 1L;
    SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
    private boolean antiAlias;
    URI svgURI;
    private boolean scaleToFit;
    AffineTransform scaleXform = new AffineTransform();

    public SVGPanel() {
        this.initComponents();
    }

    public int getSVGHeight() {
        if (this.scaleToFit) {
            return this.getPreferredSize().height;
        }
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return 0;
        }
        return (int)diagram.getHeight();
    }

    public int getSVGWidth() {
        if (this.scaleToFit) {
            return this.getPreferredSize().width;
        }
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return 0;
        }
        return (int)diagram.getWidth();
    }

    public void paintComponent(Graphics gg) {
        super.paintComponent(gg);
        Graphics2D g = (Graphics2D)gg;
        Object oldAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return;
        }
        if (!this.scaleToFit) {
            try {
                diagram.render(g);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasHint);
            }
            catch (SVGException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        Rectangle2D.Double rect = new Rectangle2D.Double();
        diagram.getViewRect(rect);
        this.scaleXform.setToScale((double)width / rect.width, (double)height / rect.height);
        AffineTransform oldXform = g.getTransform();
        g.transform(this.scaleXform);
        try {
            diagram.render(g);
        }
        catch (SVGException e) {
            throw new RuntimeException(e);
        }
        g.setTransform(oldXform);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasHint);
    }

    public SVGUniverse getSvgUniverse() {
        return this.svgUniverse;
    }

    public void setSvgUniverse(SVGUniverse svgUniverse) {
        SVGUniverse old = this.svgUniverse;
        this.svgUniverse = svgUniverse;
        this.firePropertyChange("svgUniverse", old, svgUniverse);
    }

    public URI getSvgURI() {
        return this.svgURI;
    }

    public void setSvgURI(URI svgURI) {
        URI old = this.svgURI;
        this.svgURI = svgURI;
        this.firePropertyChange("svgURI", old, svgURI);
    }

    public void setSvgResourcePath(String resourcePath) throws SVGException {
        URI old = this.svgURI;
        try {
            this.svgURI = new URI(this.getClass().getResource(resourcePath).toString());
            this.firePropertyChange("svgURI", old, this.svgURI);
            this.repaint();
        }
        catch (Exception e) {
            throw new SVGException("Could not resolve path " + resourcePath, e);
        }
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean scaleToFit) {
        boolean old = this.scaleToFit;
        this.scaleToFit = scaleToFit;
        this.firePropertyChange("scaleToFit", old, scaleToFit);
    }

    public boolean getUseAntiAlias() {
        return this.getAntiAlias();
    }

    public void setUseAntiAlias(boolean antiAlias) {
        this.setAntiAlias(antiAlias);
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        boolean old = this.antiAlias;
        this.antiAlias = antiAlias;
        this.firePropertyChange("antiAlias", old, antiAlias);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

