/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class PromptDocumentFilter
extends DocumentFilter {
    private String leftPrompt = "";
    private String rightPrompt = "";

    public PromptDocumentFilter(String leftPrompt, String rightPrompt) {
        this.leftPrompt = leftPrompt;
        this.rightPrompt = rightPrompt;
    }

    public String getLeftPrompt() {
        return this.leftPrompt;
    }

    public String getRightPrompt() {
        return this.rightPrompt;
    }

    public void setLeftPrompt(String leftPrompt) {
        this.leftPrompt = leftPrompt;
    }

    public void setRightPrompt(String rightPrompt) {
        this.rightPrompt = rightPrompt;
    }

    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (offset >= this.leftPrompt.length() && offset <= fb.getDocument().getLength() - this.rightPrompt.length()) {
            fb.insertString(offset, string, attr);
        }
    }

    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        int leftmost = offset;
        int rightmost = offset + length;
        leftmost = Math.max(leftmost, this.leftPrompt.length());
        leftmost = Math.min(leftmost, fb.getDocument().getLength() - this.rightPrompt.length());
        rightmost = Math.min(rightmost, fb.getDocument().getLength() - this.rightPrompt.length());
        rightmost = Math.max(rightmost, this.leftPrompt.length());
        fb.remove(leftmost, rightmost - leftmost);
    }

    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        int leftmost = offset;
        int rightmost = offset + length;
        leftmost = Math.max(leftmost, this.leftPrompt.length());
        leftmost = Math.min(leftmost, fb.getDocument().getLength() - this.rightPrompt.length());
        rightmost = Math.min(rightmost, fb.getDocument().getLength() - this.rightPrompt.length());
        rightmost = Math.max(rightmost, this.leftPrompt.length());
        fb.replace(leftmost, rightmost - leftmost, text, attrs);
    }
}

