/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing;

import com.kitfox.svg.app.beans.SVGIcon;
import eu.irreality.age.ImageConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel
implements ImageConstants {
    private ImageIcon theRasterImage;
    private SVGIcon theVectorImage;
    private double vectorImageBaseWidth;
    private double vectorImageBaseHeight;
    private int scalingMode = 0;

    public ImagePanel() {
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public int getScalingMode() {
        return this.scalingMode;
    }

    public void setScalingMode(int scalingMode) {
        this.scalingMode = scalingMode;
    }

    public ImageIcon getRasterImage() {
        return this.theRasterImage;
    }

    public SVGIcon getVectorImage() {
        return this.theVectorImage;
    }

    public Icon getImage() {
        if (this.theRasterImage != null) {
            return this.theRasterImage;
        }
        return this.theVectorImage;
    }

    public void setRasterImage(ImageIcon ii) {
        this.theRasterImage = ii;
    }

    public void setVectorImage(SVGIcon si) {
        this.theVectorImage = si;
        this.vectorImageBaseWidth = si.getPreferredSize().getWidth();
        this.vectorImageBaseHeight = si.getPreferredSize().getHeight();
        this.theVectorImage.setAntiAlias(true);
    }

    public void setImage(Icon ic) throws UnsupportedOperationException {
        if (!(ic instanceof ImageIcon) && !(ic instanceof SVGIcon)) {
            throw new UnsupportedOperationException("setImage only supports ImageIcon or SVGIcon");
        }
        if (ic instanceof ImageIcon) {
            this.setRasterImage((ImageIcon)ic);
            this.theVectorImage = null;
        } else if (ic instanceof SVGIcon) {
            this.setVectorImage((SVGIcon)ic);
            this.theRasterImage = null;
        }
    }

    private void paintVectorImage(Graphics g) {
        int imageHeight = (int)this.vectorImageBaseHeight;
        int imageWidth = (int)this.vectorImageBaseWidth;
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        int drawX = 0;
        int drawY = 0;
        int drawW = panelWidth;
        int drawH = panelHeight;
        this.theVectorImage.setScaleToFit(true);
        if (this.scalingMode == 0) {
            drawX = panelWidth / 2 - imageWidth / 2;
            drawY = panelHeight / 2 - imageHeight / 2;
            drawW = imageWidth;
            drawH = imageHeight;
            this.theVectorImage.setScaleToFit(false);
        }
        if (this.scalingMode == 2) {
            drawX = 0;
            drawW = panelWidth;
            drawH = (int)((double)panelWidth * ((double)imageHeight / (double)imageWidth));
            drawY = panelHeight / 2 - drawH / 2;
        }
        if (this.scalingMode == 1) {
            drawY = 0;
            drawH = panelHeight;
            drawW = (int)((double)panelHeight * ((double)imageWidth / (double)imageHeight));
            drawX = panelWidth / 2 - drawW / 2;
        }
        this.theVectorImage.setPreferredSize(new Dimension(drawW, drawH));
        this.theVectorImage.paintIcon((Component)this, g, drawX, drawY);
    }

    private void paintRasterImage(Graphics g) {
        int imageHeight = this.theRasterImage.getIconHeight();
        int imageWidth = this.theRasterImage.getIconWidth();
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        int drawX = 0;
        int drawY = 0;
        int drawW = panelWidth;
        int drawH = panelHeight;
        if (this.scalingMode == 0) {
            drawX = panelWidth / 2 - imageWidth / 2;
            drawY = panelHeight / 2 - imageHeight / 2;
            drawW = imageWidth;
            drawH = imageHeight;
        }
        if (this.scalingMode == 2) {
            drawX = 0;
            drawW = panelWidth;
            drawH = (int)((double)panelWidth * ((double)imageHeight / (double)imageWidth));
            drawY = panelHeight / 2 - drawH / 2;
        }
        if (this.scalingMode == 1) {
            drawY = 0;
            drawH = panelHeight;
            drawW = (int)((double)panelHeight * ((double)imageWidth / (double)imageHeight));
            drawX = panelWidth / 2 - drawW / 2;
        }
        g.drawImage(this.theRasterImage.getImage(), drawX, drawY, drawW, drawH, this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.theRasterImage != null) {
            this.paintRasterImage(g);
        } else if (this.theVectorImage != null) {
            this.paintVectorImage(g);
        }
    }
}

