/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.spell;

import eu.irreality.age.EntityList;
import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.World;
import eu.irreality.age.spell.Correction;
import eu.irreality.age.spell.SpellingCorrector;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ReferenceNameCorrector
implements SpellingCorrector {
    private SpellingCorrector theCorrector;
    private static int MINLENGTH = 4;

    private Set extractRelevantWords(List names) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            StringTokenizer st = new StringTokenizer(name);
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (word.length() < MINLENGTH) continue;
                s.add(word);
            }
        }
        return s;
    }

    public ReferenceNameCorrector(World w, SpellingCorrector c) {
        int i;
        this.theCorrector = c;
        EntityList items = w.getAllItems();
        EntityList mobiles = w.getAllMobiles();
        LinkedHashSet words = new LinkedHashSet();
        for (i = 0; i < items.size(); ++i) {
            Item it = (Item)items.get(i);
            words.addAll(this.extractRelevantWords(it.getSingularReferenceNames()));
            words.addAll(this.extractRelevantWords(it.getPluralReferenceNames()));
        }
        for (i = 0; i < mobiles.size(); ++i) {
            Mobile mob = (Mobile)mobiles.get(i);
            words.addAll(this.extractRelevantWords(mob.getSingularReferenceNames()));
            words.addAll(this.extractRelevantWords(mob.getPluralReferenceNames()));
        }
        this.init(words);
    }

    public void init(Collection words) {
        this.theCorrector.init(words);
    }

    public void addDictionaryWord(String word) throws UnsupportedOperationException {
        this.theCorrector.addDictionaryWord(word);
    }

    public Correction getBestCorrection(String word) {
        return this.theCorrector.getBestCorrection(word);
    }
}

