/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.AbstractEntity;
import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.Informador;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.NaturalLanguage;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.Player;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.Room;
import eu.irreality.age.Spell;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Utility;
import eu.irreality.age.VisualConfiguration;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import eu.irreality.age.filemanagement.Paths;
import eu.irreality.age.messages.Messages;
import eu.irreality.age.spell.AGESpellChecker;
import eu.irreality.age.util.VersionComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class World
implements Informador,
SupportingCode {
    private boolean debugMode = true;
    private String worldname;
    private String modulename;
    private String worlddir;
    private URL worldurl;
    private int maxroom;
    private int maxitem;
    private int maxmob;
    private int maxabsent;
    private int maxspell;
    private Room[] room;
    private Item[] item;
    private Mobile[] mob;
    private AbstractEntity[] absent;
    private Spell[] spell;
    private InputOutputClient io;
    private List playerList = new Vector();
    private ObjectCode itsCode;
    private String author = null;
    private String version = null;
    private String parserVersion = null;
    private String date = null;
    private String type = null;
    private Random aleat;
    private long semilla;
    private NaturalLanguage lenguaje;
    private Map nameTable;
    public boolean serverIntroExeccedFlag;
    public Object serverIntroSyncObject = new Object();
    private Element[] itemNode;
    private Element[] mobNode;
    private Element[] roomNode;
    private Element[] absentNode;
    private Element[] spellNode;
    private VisualConfiguration vc;
    private List fileList = new ArrayList();
    private List playerTemplateNodes = new ArrayList();
    private HashMap playerTemplateNodesByName = new HashMap();
    private List playersToAdd = new Vector();
    private BufferedReader logReader;
    boolean from_log;
    private Messages messages = Messages.getDefaultInstance();
    private static Document dummyDoc = null;
    private boolean loadedState = false;
    private ClassLoader resourceLoader;
    public int commandMatchingMode = 2;
    private AGESpellChecker spellChecker;

    public Messages getMessages() {
        return this.messages;
    }

    public void loadMessages(URL u) throws IOException {
        Messages m = new Messages(u);
        m.setWorld(this);
        this.messages = m;
    }

    public void endOfLog() {
        this.from_log = false;
        List jugadores = this.getPlayerList();
        for (int i = 0; i < jugadores.size(); ++i) {
            Player jugador = (Player)jugadores.get(i);
            jugador.endOfLog();
        }
    }

    public FileInputStream openLogFile(String s) throws FileNotFoundException {
        FileInputStream logInput = null;
        try {
            logInput = new FileInputStream(s);
        }
        catch (FileNotFoundException exc) {
            try {
                logInput = new FileInputStream(new File(Paths.SAVE_PATH, s));
            }
            catch (FileNotFoundException exc2) {
                throw exc;
            }
        }
        return logInput;
    }

    public void prepareLog(String s) throws FileNotFoundException {
        this.from_log = true;
        FileInputStream logInput = this.openLogFile(s);
        this.logReader = new BufferedReader(Utility.getBestInputStreamReader(logInput));
        try {
            this.logReader.readLine();
            this.logReader.readLine();
        }
        catch (IOException exc) {
            this.write(this.io.getColorCode("error") + "Excepci\u00f3n I/O al leer el log" + this.io.getColorCode("reset"));
        }
        List jugadores = this.getPlayerList();
        for (int i = 0; i < jugadores.size(); ++i) {
            Player jugador = (Player)jugadores.get(i);
            jugador.prepareLog(this.logReader);
        }
    }

    public static Node getDetachedCopy(Node n) {
        try {
            if (dummyDoc == null) {
                dummyDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            return dummyDoc.importNode(n, true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return n;
        }
    }

    public void loadWorldFromXML(Node n, final InputOutputClient io, boolean noSerCliente) throws XMLtoWorldException {
        Element elt;
        int i;
        int i2;
        NodeList spellNodes;
        NodeList codeNodes;
        NodeList fileListNodes;
        NodeList confNodes;
        this.io = io;
        boolean jugadorAsignadoACliente = false;
        this.write(io.getColorCode("information") + "Obteniendo informaci\u00f3n de mundo...\n" + io.getColorCode("reset"));
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("World node not Element");
        }
        Element e = (Element)n;
        this.worldname = "Mundo Sin Nombre";
        this.version = "Desconocida";
        this.parserVersion = "No especificada";
        this.modulename = "Sin Nombre";
        this.maxroom = 0;
        this.maxitem = 0;
        this.maxmob = 0;
        this.author = "Don Nadie";
        this.date = "El a\u00f1o de Maricasta\u00f1a";
        this.type = "Qui\u00e9n sabe";
        if (e.hasAttribute("worldDir") && !e.getAttribute("worldDir").equals(".")) {
            this.worlddir = e.getAttribute("worldDir");
            try {
                this.worldurl = new URL(this.worlddir);
            }
            catch (MalformedURLException e1) {
                try {
                    this.worldurl = new File(this.worlddir).toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    System.err.println("worldDir attribute seems neither pathname nor URL:");
                    e1.printStackTrace();
                    e2.printStackTrace();
                }
            }
        }
        if (!e.hasAttribute("worldName")) {
            throw new XMLtoWorldException("World node lacks attribute worldName");
        }
        if (!e.hasAttribute("moduleName")) {
            throw new XMLtoWorldException("Item node lacks attribute moduleName");
        }
        if (!e.hasAttribute("maxroom")) {
            this.maxroom = e.getElementsByTagName("Room").getLength();
        }
        if (!e.hasAttribute("maxitem")) {
            this.maxitem = e.getElementsByTagName("Item").getLength();
        }
        if (!e.hasAttribute("maxmob")) {
            this.maxmob = e.getElementsByTagName("Mobile").getLength();
            Debug.println("Max Mob set to " + this.maxmob);
        }
        if (!e.hasAttribute("maxabsent")) {
            this.maxabsent = e.getElementsByTagName("AbstractEntity").getLength();
            Debug.println("Max Abstract set to " + this.maxmob);
        }
        if (!e.hasAttribute("maxspell")) {
            this.maxspell = e.getElementsByTagName("Spell").getLength();
            Debug.println("Max Spell set to " + this.maxmob);
        }
        this.worldname = e.getAttribute("worldName");
        this.modulename = e.getAttribute("moduleName");
        try {
            if (e.hasAttribute("maxroom")) {
                this.maxroom = Integer.valueOf(e.getAttribute("maxroom"));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxitem")) {
                this.maxitem = Integer.valueOf(e.getAttribute("maxitem"));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxmob")) {
                this.maxmob = Integer.valueOf(e.getAttribute("maxmob"));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxabsent")) {
                this.maxabsent = Integer.valueOf(e.getAttribute("maxabsent"));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxspell")) {
                this.maxmob = Integer.valueOf(e.getAttribute("maxspell"));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (e.hasAttribute("author")) {
            this.author = e.getAttribute("author");
        }
        if (e.hasAttribute("version")) {
            this.version = e.getAttribute("version");
        }
        if (e.hasAttribute("parserVersion")) {
            this.parserVersion = e.getAttribute("parserVersion");
        }
        if (e.hasAttribute("date")) {
            this.date = e.getAttribute("date");
        }
        if (e.hasAttribute("type")) {
            this.type = e.getAttribute("type");
        }
        if ((confNodes = e.getElementsByTagName("VisualConfiguration")).getLength() > 0) {
            Element confNode = (Element)confNodes.item(0);
            this.vc = new VisualConfiguration(confNode, this.worldurl.toString());
            if (io instanceof ColoredSwingClient) {
                Debug.println("VISUAL CONFIGURATION SET TO " + this.vc);
                ((ColoredSwingClient)io).setVisualConfiguration(this.vc);
            }
        }
        if ((fileListNodes = e.getElementsByTagName("FileList")).getLength() > 0) {
            Element fileListNode = (Element)fileListNodes.item(0);
            NodeList fileNodes = fileListNode.getElementsByTagName("File");
            this.fileList = new ArrayList();
            for (int i3 = 0; i3 < fileNodes.getLength(); ++i3) {
                if (!((Element)fileNodes.item(i3)).hasAttribute("path")) continue;
                this.fileList.add(this.getWorldDir() + ((Element)fileNodes.item(i3)).getAttribute("path"));
            }
        }
        ArrayList<String> playerIDs = new ArrayList<String>();
        NodeList plNodes = e.getElementsByTagName("PlayerList");
        if (plNodes.getLength() > 0) {
            Element plNode = (Element)plNodes.item(0);
            NodeList plidnodes = plNode.getElementsByTagName("Player");
            for (int i4 = 0; i4 < plidnodes.getLength(); ++i4) {
                Element playerIDNode = (Element)plidnodes.item(i4);
                if (!playerIDNode.hasAttribute("id")) continue;
                playerIDs.add(playerIDNode.getAttribute("id"));
            }
        }
        if ((codeNodes = e.getElementsByTagName("Code")).getLength() > 0) {
            for (int i5 = 0; i5 < codeNodes.getLength(); ++i5) {
                Element codeNode = (Element)codeNodes.item(i5);
                if (!(codeNode.getParentNode() instanceof Element) || !((Element)codeNode.getParentNode()).getTagName().equals("World")) continue;
                try {
                    this.itsCode = new ObjectCode(this, codeNode);
                    break;
                }
                catch (XMLtoWorldException ex) {
                    throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
                }
            }
        }
        this.write(io.getColorCode("information") + "Cargando datos ling\u00fc\u00edsticos...\n" + io.getColorCode("reset"));
        this.lenguaje = new NaturalLanguage();
        Thread.currentThread();
        Thread.yield();
        NodeList playerGenerationNodes = e.getElementsByTagName("PlayerGeneration");
        if (playerGenerationNodes.getLength() > 0) {
            Element playerGenerationNode = (Element)playerGenerationNodes.item(0);
            NodeList templateNodes = playerGenerationNode.getElementsByTagName("Template");
            for (int i6 = 0; i6 < templateNodes.getLength(); ++i6) {
                Element templateElement = (Element)templateNodes.item(i6);
                templateElement = (Element)World.getDetachedCopy(templateElement);
                this.playerTemplateNodes.add(templateElement);
                if (!templateElement.hasAttribute("name")) continue;
                this.playerTemplateNodesByName.put(templateElement.getAttribute("name"), templateElement);
            }
        }
        NodeList roomLists = e.getElementsByTagName("Rooms");
        NodeList itemLists = e.getElementsByTagName("Items");
        NodeList mobileLists = e.getElementsByTagName("Mobiles");
        NodeList absentLists = e.getElementsByTagName("AbstractEntities");
        NodeList spellLists = e.getElementsByTagName("Spells");
        Element roomListElement = roomLists.getLength() > 0 ? (Element)roomLists.item(0) : null;
        Element itemListElement = itemLists.getLength() > 0 ? (Element)itemLists.item(0) : null;
        Element mobileListElement = mobileLists.getLength() > 0 ? (Element)mobileLists.item(0) : null;
        Element absentListElement = absentLists.getLength() > 0 ? (Element)absentLists.item(0) : null;
        Element spellListElement = spellLists.getLength() > 0 ? (Element)spellLists.item(0) : null;
        NodeList roomNodes = roomListElement != null ? roomListElement.getElementsByTagName("Room") : null;
        NodeList itemNodes = itemListElement != null ? itemListElement.getElementsByTagName("Item") : null;
        NodeList mobileNodes = mobileListElement != null ? mobileListElement.getElementsByTagName("Mobile") : null;
        NodeList absentNodes = absentListElement != null ? absentListElement.getElementsByTagName("AbstractEntity") : null;
        NodeList nodeList = spellNodes = spellListElement != null ? spellListElement.getElementsByTagName("Spell") : null;
        if (roomNodes != null && roomNodes.getLength() != this.maxroom) {
            this.write("Warning: " + roomNodes.getLength() + " room nodes while maxroom is " + this.maxroom);
        }
        if (itemNodes != null && itemNodes.getLength() != this.maxitem) {
            this.write("Warning: " + itemNodes.getLength() + " item nodes while maxitem is " + this.maxitem);
        }
        if (mobileNodes != null && mobileNodes.getLength() != this.maxmob) {
            this.write("Warning: " + mobileNodes.getLength() + " mobile nodes while maxmob is " + this.maxmob);
        }
        if (absentNodes != null && absentNodes.getLength() != this.maxabsent) {
            this.write("Warning: " + absentNodes.getLength() + " abstract entity nodes while maxabsent is " + this.maxabsent);
        }
        if (spellNodes != null && spellNodes.getLength() != this.maxspell) {
            this.write("Warning: " + spellNodes.getLength() + "  spell nodes while maxspell is " + this.maxspell);
        }
        if (roomNodes != null) {
            this.roomNode = new Element[roomNodes.getLength()];
            for (i2 = 0; i2 < roomNodes.getLength(); ++i2) {
                this.roomNode[i2] = (Element)roomNodes.item(i2);
            }
        } else {
            this.roomNode = new Element[0];
        }
        if (itemNodes != null) {
            this.itemNode = new Element[itemNodes.getLength()];
            for (i2 = 0; i2 < itemNodes.getLength(); ++i2) {
                this.itemNode[i2] = (Element)itemNodes.item(i2);
            }
        } else {
            this.itemNode = new Element[0];
        }
        if (mobileNodes != null) {
            this.mobNode = new Element[mobileNodes.getLength()];
            for (i2 = 0; i2 < mobileNodes.getLength(); ++i2) {
                this.mobNode[i2] = (Element)mobileNodes.item(i2);
            }
        } else {
            this.mobNode = new Element[0];
        }
        if (absentNodes != null) {
            this.absentNode = new Element[absentNodes.getLength()];
            for (i2 = 0; i2 < absentNodes.getLength(); ++i2) {
                this.absentNode[i2] = (Element)absentNodes.item(i2);
            }
        } else {
            this.absentNode = new Element[0];
        }
        if (spellNodes != null) {
            this.spellNode = new Element[spellNodes.getLength()];
            for (i2 = 0; i2 < spellNodes.getLength(); ++i2) {
                this.spellNode[i2] = (Element)spellNodes.item(i2);
            }
        } else {
            this.spellNode = new Element[0];
        }
        this.write(io.getColorCode("information") + "Creando tabla de nombres...\n" + io.getColorCode("reset"));
        int nameTableSize = this.maxroom + this.maxitem + this.maxmob + this.maxabsent + this.maxspell;
        this.nameTable = new Hashtable(nameTableSize > 100 ? nameTableSize : 100);
        int nentries = 0;
        for (i = 0; i < this.roomNode.length; ++i) {
            elt = this.roomNode[i];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Room " + i + " without id or name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i + 10000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
        }
        for (i = 0; i < this.itemNode.length; ++i) {
            elt = this.itemNode[i];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Item " + i + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i + 30000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
        }
        for (i = 0; i < this.mobNode.length; ++i) {
            elt = this.mobNode[i];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Mobile " + i + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i + 20000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
        }
        for (i = 0; i < this.absentNode.length; ++i) {
            elt = this.absentNode[i];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("AbstractEntity " + i + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i + 40000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
        }
        for (i = 0; i < this.spellNode.length; ++i) {
            elt = this.spellNode[i];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Spell " + i + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i + 50000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
        }
        this.write(io.getColorCode("information") + "Inicializando entidades abstractas...\n" + io.getColorCode("reset"));
        this.absent = new AbstractEntity[this.absentNode.length];
        for (i = 0; i < this.absentNode.length; ++i) {
            this.absent[i] = AbstractEntity.getInstance(this, this.absentNode[i]);
            if (this.absent[i].getID() % 10000000 != 0) continue;
            this.absent[i].setID(i + 40000000);
        }
        this.write(io.getColorCode("information") + "Inicializando hechizos...\n" + io.getColorCode("reset"));
        this.spell = new Spell[this.spellNode.length];
        for (i = 0; i < this.spellNode.length; ++i) {
            this.spell[i] = Spell.getInstance(this, this.spellNode[i]);
            if (this.spell[i].getID() % 10000000 != 0) continue;
            this.spell[i].setID(i + 50000000);
        }
        this.write(io.getColorCode("information") + "Inicializando items...\n" + io.getColorCode("reset"));
        this.item = new Item[this.itemNode.length];
        for (i = 0; i < this.itemNode.length; ++i) {
            this.item[i] = Item.getInstance(this, this.itemNode[i]);
            if (this.item[i].getID() % 10000000 != 0) continue;
            this.item[i].setID(i + 30000000);
            Debug.println("&ID SET" + this.item[i].getID());
        }
        this.write(io.getColorCode("information") + "Inicializando bichos...\n" + io.getColorCode("reset"));
        this.mob = new Mobile[this.mobNode.length];
        for (i = 0; i < this.mobNode.length; ++i) {
            if ((this.mobNode[i].hasAttribute("id") || this.mobNode[i].hasAttribute("name")) && (playerIDs.contains(this.mobNode[i].getAttribute("id")) || playerIDs.contains(this.mobNode[i].getAttribute("name")))) {
                Element templateElement = (Element)World.getDetachedCopy(this.mobNode[i]);
                this.playerTemplateNodes.add(templateElement);
                if (templateElement.hasAttribute("name")) {
                    this.playerTemplateNodesByName.put(templateElement.getAttribute("name"), templateElement);
                }
                if (!noSerCliente && !jugadorAsignadoACliente) {
                    ReturnValue retval = new ReturnValue(null);
                    boolean endfound = this.runAssignPlayerCode(retval, io);
                    if (retval.getRetVal() != null && !endfound) {
                        jugadorAsignadoACliente = true;
                        this.mob[i] = (Player)retval.getRetVal();
                        this.playersToAdd.add(this.mob[i]);
                        this.mob[i].setNewState(15, 1L);
                    } else {
                        this.mob[i] = new Player(this, io, this.mobNode[i]);
                        jugadorAsignadoACliente = true;
                        this.addPlayer((Player)this.mob[i]);
                    }
                } else {
                    this.mob[i] = new Player(this, io, this.mobNode[i]);
                    ((Player)this.mob[i]).setPlayerName("Player Template");
                }
            } else {
                this.mob[i] = Mobile.getInstance(this, this.mobNode[i]);
            }
            if (this.mob[i].getID() % 10000000 != 0) continue;
            this.mob[i].setID(i + 20000000);
        }
        this.write(io.getColorCode("information") + "Inicializando habitaciones...\n" + io.getColorCode("reset"));
        this.room = new Room[this.roomNode.length];
        for (i = 0; i < this.roomNode.length; ++i) {
            this.room[i] = new Room(this, this.roomNode[i]);
            if (this.room[i].getID() % 10000000 != 0) continue;
            this.room[i].setID(i + 10000000);
        }
        this.write(io.getColorCode("information") + (this.maxroom + this.maxitem + this.maxmob + this.maxspell + this.maxabsent) + " entidades cargadas.\n" + io.getColorCode("reset"));
        this.write(io.getColorCode("information") + "Completando cargas diferidas..." + io.getColorCode("reset") + "\n");
        for (i = 0; i < this.maxitem; ++i) {
            this.item[i].loadInventoryFromXML(this);
            this.item[i].readRelationshipListFromXML(this, this.itemNode[i]);
        }
        for (i = 0; i < this.maxmob; ++i) {
            this.mob[i].readRelationshipListFromXML(this, this.mobNode[i]);
        }
        for (i = 0; i < this.maxroom; ++i) {
            this.room[i].readRelationshipListFromXML(this, this.roomNode[i]);
        }
        for (i = 0; i < this.maxabsent; ++i) {
            this.absent[i].readRelationshipListFromXML(this, this.absentNode[i]);
        }
        for (i = 0; i < this.maxspell; ++i) {
            this.spell[i].readRelationshipListFromXML(this, this.spellNode[i]);
        }
        this.write(io.getColorCode("information") + "\nMundo inicializado." + io.getColorCode("reset") + "\n");
        this.write("\n=============================================================");
        this.write("\n" + io.getColorCode("information") + "Informaci\u00f3n de Juego:");
        if (this.modulename != null) {
            this.write("\n" + io.getColorCode("information") + "[Nombre]           " + this.modulename + io.getColorCode("reset"));
        }
        if (this.type != null) {
            this.write("\n" + io.getColorCode("information") + "[Tipo]             " + this.type + io.getColorCode("reset"));
        }
        if (this.author != null) {
            this.write("\n" + io.getColorCode("information") + "[Autor]            " + this.author + io.getColorCode("reset"));
        }
        if (this.version != null) {
            this.write("\n" + io.getColorCode("information") + "[Versi\u00f3n]          " + this.version + io.getColorCode("reset"));
        }
        if (this.date != null) {
            this.write("\n" + io.getColorCode("information") + "[Fecha]            " + this.date + io.getColorCode("reset"));
        }
        if (this.parserVersion != null) {
            this.write("\n" + io.getColorCode("information") + "[Versi\u00f3n engine]   " + this.parserVersion + io.getColorCode("reset"));
        }
        this.write("\n=============================================================\n");
        if (new VersionComparator().compare(this.parserVersion, "1.0") < 0) {
            this.setCommandMatchingMode(0);
        }
        if (new VersionComparator().compare(this.parserVersion, "1.0") > 0 && new VersionComparator().compare(this.parserVersion, "1.1.1") < 0) {
            this.setCommandMatchingMode(1);
        }
        if (!jugadorAsignadoACliente && !noSerCliente) {
            Thread th = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Debug.println("Add player wait.");
                        Object object = World.this.serverIntroSyncObject;
                        synchronized (object) {
                            while (!World.this.serverIntroExeccedFlag) {
                                try {
                                    World.this.serverIntroSyncObject.wait();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        Debug.println("Adding player.");
                        World.this.addNewPlayerASAP(io);
                    }
                    catch (XMLtoWorldException xml2we) {
                        io.write("XML to World Exception when assigning player.\n");
                        xml2we.printStackTrace();
                    }
                }
            };
            th.start();
        }
        this.itemNode = null;
        this.mobNode = null;
        this.roomNode = null;
        this.absentNode = null;
        this.spellNode = null;
    }

    void legacyWorldLoad(String modulefile, InputOutputClient io, boolean noSerCliente) throws FileNotFoundException, IOException {
        int i;
        int nlinea;
        String id_linea;
        int line;
        int idnumber;
        BufferedReader br;
        this.io = io;
        FileInputStream fp = new FileInputStream(modulefile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        String linea = "";
        String token = "";
        String zipFile = "";
        this.write(io.getColorCode("information") + "\nCARGA DEL MUNDO EN LA M\u00c1QUINA DE ESTADOS DE AETHERIA\n" + io.getColorCode("reset"));
        this.write(io.getColorCode("information") + "\nObteniendo informaci\u00f3n de mundo...\n" + io.getColorCode("reset"));
        Thread.currentThread();
        Thread.yield();
        while ((linea = filein.readLine()) != null) {
            String id_linea2;
            boolean terminamos;
            token = StringMethods.getTok(linea, 1, ' ');
            if (token.equalsIgnoreCase("module")) {
                this.worldname = StringMethods.getTok(linea, 2, ' ');
                continue;
            }
            if (token.equalsIgnoreCase("maxroom")) {
                this.maxroom = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("maxitem")) {
                this.maxitem = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("maxmob")) {
                this.maxmob = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("printthis")) {
                this.write(StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ') + "\n");
                continue;
            }
            if (token.equalsIgnoreCase("modulename")) {
                this.modulename = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("author")) {
                this.author = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("version")) {
                this.version = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("date")) {
                this.date = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("parserversion")) {
                this.parserVersion = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("zipfile")) {
                zipFile = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("begin_eva_code")) {
                String EVACodeString = "";
                terminamos = false;
                while (!terminamos) {
                    linea = filein.readLine();
                    id_linea2 = StringMethods.getTok(linea, 1, ' ');
                    if (id_linea2.equalsIgnoreCase("end_eva_code")) {
                        terminamos = true;
                        continue;
                    }
                    EVACodeString = EVACodeString + "\n";
                    EVACodeString = EVACodeString + linea;
                }
                this.itsCode = new ObjectCode(EVACodeString, "EVA", this);
                continue;
            }
            if (!token.equalsIgnoreCase("begin_bsh_code")) continue;
            String BSHCodeString = "";
            terminamos = false;
            while (!terminamos) {
                linea = filein.readLine();
                id_linea2 = StringMethods.getTok(linea, 1, ' ');
                if (id_linea2.equalsIgnoreCase("end_bsh_code")) {
                    terminamos = true;
                    continue;
                }
                BSHCodeString = BSHCodeString + "\n";
                BSHCodeString = BSHCodeString + linea;
            }
            this.itsCode = new ObjectCode(BSHCodeString, "BeanShell", this);
        }
        this.write(io.getColorCode("information") + "\nCargando datos ling\u00fc\u00edsticos..." + io.getColorCode("reset"));
        this.lenguaje = new NaturalLanguage();
        Thread.currentThread();
        Thread.yield();
        this.write(io.getColorCode("information") + "\nCreando tabla de nombres...\n" + io.getColorCode("reset"));
        int nameTableSize = this.maxroom + this.maxitem + this.maxmob;
        this.nameTable = new Hashtable(nameTableSize > 100 ? nameTableSize : 100);
        int nentries = 0;
        try {
            for (int i2 = 0; i2 < this.maxitem; ++i2) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.itemFile(this, i2))));
                linea = "";
                idnumber = i2;
                for (line = 1; line < 100; ++line) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea == null) continue;
                    nlinea = 0;
                    try {
                        nlinea = Integer.valueOf(id_linea);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (nlinea == 1) {
                        idnumber = Integer.valueOf(linea);
                    }
                    if (nlinea != 4) continue;
                    this.nameTable.put(linea, new Integer(Utility.completeItemID(idnumber)));
                    ++nentries;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        try {
            for (int i3 = 0; i3 < this.maxroom; ++i3) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.roomFile(this, i3))));
                linea = "";
                idnumber = i3;
                for (line = 1; line < 100; ++line) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea == null) continue;
                    nlinea = 0;
                    try {
                        nlinea = Integer.valueOf(id_linea);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (nlinea == 1) {
                        idnumber = Integer.valueOf(linea);
                    }
                    if (nlinea != 4) continue;
                    this.nameTable.put(linea, new Integer(Utility.completeRoomID(idnumber)));
                    ++nentries;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        try {
            for (int i4 = 0; i4 < this.maxmob; ++i4) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.mobFile(this, i4))));
                linea = "";
                idnumber = i4;
                for (line = 1; line < 100; ++line) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea == null) continue;
                    nlinea = 0;
                    try {
                        nlinea = Integer.valueOf(id_linea);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (nlinea == 1) {
                        idnumber = Integer.valueOf(linea);
                    }
                    if (nlinea != 4) continue;
                    this.nameTable.put(linea, new Integer(Utility.completeMobileID(idnumber)));
                    ++nentries;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            this.write(io.getColorCode("information") + "Entradas: " + nentries + "\n" + io.getColorCode("reset"));
        }
        this.write(io.getColorCode("information") + "Inicializando items...\n" + io.getColorCode("reset"));
        this.item = new Item[this.maxitem];
        try {
            for (i = 0; i < this.maxitem; ++i) {
                this.item[i] = Item.getInstance(this, Utility.itemFile(this, i));
            }
        }
        catch (FileNotFoundException nomasitems) {
            this.maxitem = i;
        }
        catch (IOException npi) {
            System.err.println("No puedo abrir el objeto " + i);
        }
        this.write(io.getColorCode("information") + "Inicializando bichos...\n" + io.getColorCode("reset"));
        this.mob = new Mobile[this.maxmob];
        try {
            for (i = 1; i < this.maxmob; ++i) {
                this.mob[i] = Mobile.getInstance(this, Utility.mobFile(this, i));
            }
        }
        catch (FileNotFoundException nomasmobs) {
            this.maxmob = i;
        }
        catch (IOException npi) {
            System.err.println("No puedo abrir el bicho " + i);
        }
        this.write(io.getColorCode("information") + "Inicializando habitaciones...\n" + io.getColorCode("reset"));
        this.room = new Room[this.maxroom];
        try {
            for (i = 0; i < this.maxroom; ++i) {
                this.room[i] = new Room(this, Utility.roomFile(this, i));
            }
        }
        catch (FileNotFoundException nomashabitaciones) {
            this.maxroom = i;
        }
        catch (IOException npi) {
            System.err.println("No puedo abrir la habitaci\u00f3n " + i);
        }
        this.write(io.getColorCode("information") + (this.maxroom + this.maxitem + this.maxmob) + " entidades cargadas.\n");
        this.write(io.getColorCode("information") + "Completando cargas diferidas..." + io.getColorCode("reset"));
        for (i = 1; i < this.maxitem; ++i) {
            this.item[i].loadInventory(this);
        }
        this.write(io.getColorCode("information") + "\nMundo inicializado." + io.getColorCode("reset") + "\n");
        this.write("\n=============================================================");
        this.write("\n" + io.getColorCode("information") + "Informaci\u00f3n de Juego:");
        if (this.modulename != null) {
            this.write("\n" + io.getColorCode("information") + "[Nombre]           " + this.modulename + io.getColorCode("reset"));
        }
        if (this.type != null) {
            this.write("\n" + io.getColorCode("information") + "[Tipo]             " + this.type + io.getColorCode("reset"));
        }
        if (this.author != null) {
            this.write("\n" + io.getColorCode("information") + "[Autor]            " + this.author + io.getColorCode("reset"));
        }
        if (this.version != null) {
            this.write("\n" + io.getColorCode("information") + "[Versi\u00f3n]          " + this.version + io.getColorCode("reset"));
        }
        if (this.date != null) {
            this.write("\n" + io.getColorCode("information") + "[Fecha]            " + this.date + io.getColorCode("reset"));
        }
        if (this.parserVersion != null) {
            this.write("\n" + io.getColorCode("information") + "[Versi\u00f3n engine]   " + this.parserVersion + io.getColorCode("reset"));
        }
        this.write("\n=============================================================\n");
    }

    public void loadWorldFromStream(InputStream is, InputOutputClient io, boolean noSerCliente) throws ParserConfigurationException, SAXException, IOException, XMLtoWorldException {
        Document d = null;
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        io.write(io.getColorCode("information") + "Obteniendo \u00e1rbol DOM de los datos XML...\n" + io.getColorCode("reset"));
        d = db.parse(is);
        Element n = d.getDocumentElement();
        this.loadWorldFromXML(n, io, noSerCliente);
    }

    public World(URL url, InputOutputClient io, boolean noSerCliente) throws IOException {
        InputStream is = null;
        if (url.toString().toLowerCase().endsWith(".xml")) {
            if (!url.toString().startsWith("jar:") && !url.toString().startsWith("zip:")) {
                this.worlddir = url.toString().substring(0, url.toString().lastIndexOf("/") + 1);
                this.worldurl = new URL(this.worlddir);
            } else {
                this.worlddir = url.toString().substring(0, url.toString().lastIndexOf("/") + 1);
                this.worldurl = new URL(this.worlddir);
            }
            is = url.openStream();
        } else {
            this.worlddir = "jar:" + url.toString() + "!/";
            this.worldurl = new URL(this.worlddir);
            URLClassLoader ucl = new URLClassLoader(new URL[]{url}, this.getClass().getClassLoader());
            is = ucl.getResourceAsStream("world.xml");
            if (is == null) {
                throw new IOException("Resource world.xml could not be found in URL " + url);
            }
            this.setResourceJarFile(url);
        }
        try {
            this.loadWorldFromStream(is, io, noSerCliente);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new IOException(se);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (XMLtoWorldException x2we) {
            this.write("Excepci\u00f3n al leer el mundo de XML: " + x2we.getMessage());
        }
    }

    public World(String modulefile, InputOutputClient io, boolean noSerCliente) throws FileNotFoundException, IOException {
        this.worlddir = new File(new File(modulefile).getParent()).getPath() + File.separatorChar;
        this.worldurl = new File(modulefile).getParentFile().toURI().toURL();
        io.write(io.getColorCode("information") + "Leyendo datos XML...\n" + io.getColorCode("reset"));
        try {
            FileInputStream is = new FileInputStream(new File(modulefile));
            this.loadWorldFromStream(is, io, noSerCliente);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new IOException(pce);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new IOException(se);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (XMLtoWorldException x2we) {
            this.write("Excepci\u00f3n al leer el mundo de XML: " + x2we.getMessage());
        }
    }

    public String getWorldPath() {
        return this.worlddir;
    }

    public String getWorldDir() {
        return new File(this.worlddir).getName() + File.separatorChar;
    }

    public int getMaxRoom() {
        return this.maxroom;
    }

    public int getMaxItem() {
        return this.maxitem;
    }

    public int getMaxMob() {
        return this.maxmob;
    }

    public int getMaxAbstractEntity() {
        return this.maxabsent;
    }

    public int getMaxSpell() {
        return this.maxspell;
    }

    public Room getRoom(int roomid) {
        return this.room[roomid % 10000000];
    }

    public List getRooms() {
        ArrayList<Room> rooms = new ArrayList<Room>();
        for (int i = 0; i < this.maxroom; ++i) {
            rooms.add(this.getRoom(i));
        }
        return rooms;
    }

    public Room getRoom(String ident) {
        try {
            return this.getRoom(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getRoom(i);
            }
            return null;
        }
    }

    public int roomNameToID(String roomName) {
        Integer i = (Integer)this.nameTable.get(roomName);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public Entity getEntity(int id) {
        if (id >= 50000000) {
            return this.getSpell(id);
        }
        if (id >= 40000000) {
            return this.getAbstractEntity(id);
        }
        if (id >= 30000000) {
            return this.getItem(id);
        }
        if (id >= 20000000) {
            return this.getMobile(id);
        }
        if (id >= 10000000) {
            return this.getRoom(id);
        }
        return null;
    }

    public Entity getEntity(String ident) {
        try {
            return this.getEntity(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getEntity(i);
            }
            return null;
        }
    }

    public Item getItem(int itemid) {
        return this.item[itemid % 10000000];
    }

    public Item getItem(String ident) {
        try {
            return this.getItem(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getItem(i);
            }
            return null;
        }
    }

    public Mobile getMob(int mobid) {
        return this.mob[mobid % 10000000];
    }

    public Mobile getMobile(String ident) {
        return this.getMob(ident);
    }

    public Mobile getMobile(int id) {
        return this.getMob(id);
    }

    public Mobile getMob(String ident) {
        try {
            return this.getMob(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getMob(i);
            }
            return null;
        }
    }

    public EntityList getAllMobiles() {
        EntityList el = new EntityList();
        for (int i = 0; i < this.maxmob; ++i) {
            if (this.mob[i] == null) continue;
            el.addEntity(this.mob[i]);
        }
        return el;
    }

    public EntityList getAllItems() {
        EntityList el = new EntityList();
        for (int i = 0; i < this.maxitem; ++i) {
            if (this.item[i] == null) continue;
            el.addEntity(this.item[i]);
        }
        return el;
    }

    public AbstractEntity getAbstractEntity(int absentid) {
        return this.absent[absentid % 40000000];
    }

    public AbstractEntity getAbstractEntity(String ident) {
        try {
            return this.getAbstractEntity(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getAbstractEntity(i);
            }
            return null;
        }
    }

    public Spell getSpell(int spellid) {
        return this.spell[spellid % 50000000];
    }

    public Spell getSpell(String ident) {
        try {
            return this.getSpell(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getSpell(i);
            }
            return null;
        }
    }

    public Entity getObject(int objectid) {
        if (objectid == 20000000) {
            return this.getMob(objectid);
        }
        if (objectid < 20000000) {
            return this.getRoom(objectid);
        }
        if (objectid < 30000000) {
            return this.getMob(objectid);
        }
        if (objectid < 40000000) {
            return this.getItem(objectid);
        }
        if (objectid < 50000000) {
            return this.getAbstractEntity(objectid);
        }
        if (objectid < 60000000) {
            return this.getSpell(objectid);
        }
        return null;
    }

    public Entity getObject(String ident) {
        try {
            return this.getObject(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getObject(i);
            }
            return null;
        }
    }

    public InputOutputClient getIO() {
        return this.io;
    }

    public Element getItemNode(int itemid) {
        return this.itemNode[itemid % 10000000];
    }

    public Element getMobileNode(int mobid) {
        return this.mobNode[mobid % 10000000];
    }

    public Element getRoomNode(int roomid) {
        return this.roomNode[roomid % 10000000];
    }

    public Element getAbstractEntityNode(int absentid) {
        return this.absentNode[absentid % 10000000];
    }

    public Element getSpellNode(int spellid) {
        return this.spellNode[spellid % 10000000];
    }

    public Element getItemNode(String ident) {
        try {
            return this.getItemNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getItemNode(i);
            }
            return null;
        }
    }

    public Element getMobileNode(String ident) {
        try {
            return this.getMobileNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getMobileNode(i);
            }
            return null;
        }
    }

    public Element getRoomNode(String ident) {
        try {
            return this.getRoomNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getRoomNode(i);
            }
            return null;
        }
    }

    public Element getAbstractEntityNode(String ident) {
        try {
            return this.getAbstractEntityNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getAbstractEntityNode(i);
            }
            return null;
        }
    }

    public Element getSpellNode(String ident) {
        try {
            return this.getSpellNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getSpellNode(i);
            }
            return null;
        }
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public void setIO(InputOutputClient es) {
        this.io = es;
    }

    public String getModuleName() {
        return this.modulename;
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public NaturalLanguage getLang() {
        return this.getLanguage();
    }

    public NaturalLanguage getLanguage() {
        return this.lenguaje;
    }

    public void setRandomNumberSeed() {
        int i;
        Debug.println("Setting world's random generator.");
        this.semilla = new Date().getTime();
        this.aleat = new Random(this.semilla);
        Debug.println("Seed set to " + this.semilla);
        for (i = 0; i < this.maxroom; ++i) {
            this.room[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxmob; ++i) {
            this.mob[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxitem; ++i) {
            this.item[i].loadNumberGenerator(this);
        }
    }

    public void setRandomNumberSeed(String logfile) throws FileNotFoundException {
        int i;
        FileInputStream logInput = this.openLogFile(logfile);
        BufferedReader logReader = new BufferedReader(Utility.getBestInputStreamReader(logInput));
        try {
            logReader.readLine();
            this.semilla = Long.valueOf(logReader.readLine());
            this.aleat = new Random(this.semilla);
        }
        catch (IOException exc) {
            this.write("Excepci\u00f3n I/O al leer el log");
        }
        for (i = 0; i < this.maxroom; ++i) {
            this.room[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxmob; ++i) {
            this.mob[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxitem; ++i) {
            this.item[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxabsent; ++i) {
            this.absent[i].loadNumberGenerator(this);
        }
        for (i = 0; i < this.maxspell; ++i) {
            this.spell[i].loadNumberGenerator(this);
        }
    }

    public long getRandomNumberSeed() {
        return this.semilla;
    }

    public Random getRandom() {
        return this.aleat;
    }

    public List getPlayerList() {
        return this.playerList;
    }

    public Player getPlayer() {
        return (Player)this.playerList.get(0);
    }

    public Document getXMLRepresentation() throws ParserConfigurationException {
        int i;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element suElemento = doc.createElement("World");
        suElemento.setAttribute("worldName", String.valueOf(this.worldname));
        suElemento.setAttribute("moduleName", String.valueOf(this.modulename));
        suElemento.setAttribute("worldDir", String.valueOf(this.worlddir));
        suElemento.setAttribute("maxroom", String.valueOf(this.maxroom));
        suElemento.setAttribute("maxitem", String.valueOf(this.maxitem));
        suElemento.setAttribute("maxmob", String.valueOf(this.maxmob));
        suElemento.setAttribute("author", String.valueOf(this.author));
        suElemento.setAttribute("version", String.valueOf(this.version));
        suElemento.setAttribute("parserVersion", String.valueOf(this.parserVersion));
        suElemento.setAttribute("date", String.valueOf(this.date));
        suElemento.setAttribute("type", String.valueOf(this.type));
        if (this.vc != null) {
            suElemento.appendChild(this.vc.getXMLRepresentation(doc));
        }
        Element playerListElement = doc.createElement("PlayerList");
        for (int i2 = 0; i2 < this.playerList.size(); ++i2) {
            Element playerElement = doc.createElement("Player");
            if (((Player)this.playerList.get(i2)).getTitle() != null) {
                playerElement.setAttribute("id", String.valueOf(((Player)this.playerList.get(i2)).getTitle()));
            } else {
                playerElement.setAttribute("id", String.valueOf(((Player)this.playerList.get(i2)).getID()));
            }
            playerListElement.appendChild(playerElement);
        }
        suElemento.appendChild(playerListElement);
        Element fileListElement = doc.createElement("FileList");
        for (int i3 = 0; i3 < this.fileList.size(); ++i3) {
            Element fileElement = doc.createElement("File");
            fileElement.setAttribute("path", (String)this.fileList.get(i3));
            fileListElement.appendChild(fileElement);
        }
        suElemento.appendChild(fileListElement);
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        Element pgElement = doc.createElement("PlayerGeneration");
        for (int i4 = 0; i4 < this.playerTemplateNodes.size(); ++i4) {
            Element templateElt = doc.createElement("Template");
            Element theOriginalElt = (Element)this.playerTemplateNodes.get(i4);
            NodeList children = theOriginalElt.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                Node importedChild = doc.importNode(child, true);
                templateElt.appendChild(importedChild);
            }
            NamedNodeMap attrs = theOriginalElt.getAttributes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                templateElt.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
            pgElement.appendChild(templateElt);
        }
        suElemento.appendChild(pgElement);
        Element roomsElement = doc.createElement("Rooms");
        Element itemsElement = doc.createElement("Items");
        Element mobilesElement = doc.createElement("Mobiles");
        Element absentsElement = doc.createElement("AbstractEntities");
        Element spellsElement = doc.createElement("Spells");
        for (i = 0; i < this.maxroom; ++i) {
            roomsElement.appendChild(this.room[i].getXMLRepresentation(doc));
        }
        for (i = 0; i < this.maxitem; ++i) {
            itemsElement.appendChild(this.item[i].getXMLRepresentation(doc));
        }
        for (i = 0; i < this.maxmob; ++i) {
            Debug.println("Mob " + i);
            if (this.mob[i] == null) continue;
            mobilesElement.appendChild(this.mob[i].getXMLRepresentation(doc));
        }
        for (i = 0; i < this.maxabsent; ++i) {
            absentsElement.appendChild(this.absent[i].getXMLRepresentation(doc));
        }
        for (i = 0; i < this.maxspell; ++i) {
            spellsElement.appendChild(this.spell[i].getXMLRepresentation(doc));
        }
        suElemento.appendChild(roomsElement);
        suElemento.appendChild(itemsElement);
        suElemento.appendChild(mobilesElement);
        suElemento.appendChild(absentsElement);
        suElemento.appendChild(spellsElement);
        doc.appendChild(suElemento);
        return doc;
    }

    public void addItemAssigningID(Item newItem) {
        if (this.item.length <= this.maxitem) {
            Item[] newArray = this.item.length > 2 ? new Item[(int)((double)this.item.length * 1.5)] : new Item[4];
            for (int i = 0; i < this.maxitem; ++i) {
                newArray[i] = this.item[i];
            }
            this.item = newArray;
        }
        this.item[this.maxitem] = newItem;
        newItem.setID(this.maxitem);
        newItem.setWorld(this);
        ++this.maxitem;
        newItem.loadNumberGenerator(this);
    }

    public Item addCloneOfItem(Item ourItem) {
        return ourItem.createNewInstance(this, true, true);
    }

    public void addMobileAssigningID(Mobile newMob) {
        if (this.mob.length <= this.maxmob) {
            Mobile[] newArray = this.mob.length > 2 ? new Mobile[(int)((double)this.mob.length * 1.5)] : new Mobile[4];
            for (int i = 0; i < this.maxmob; ++i) {
                newArray[i] = this.mob[i];
            }
            this.mob = newArray;
        }
        this.mob[this.maxmob] = newMob;
        newMob.setID(this.maxmob);
        ++this.maxmob;
        newMob.loadNumberGenerator(this);
    }

    public void addRoomAssigningID(Room newRoom) {
        if (this.room.length <= this.maxroom) {
            Room[] newArray = this.room.length > 2 ? new Room[(int)((double)this.room.length * 1.5)] : new Room[4];
            for (int i = 0; i < this.maxroom; ++i) {
                newArray[i] = this.room[i];
            }
            this.room = newArray;
        }
        this.room[this.maxroom] = newRoom;
        newRoom.setID(this.maxroom);
        ++this.maxroom;
        newRoom.loadNumberGenerator(this);
    }

    public void addAbstractEntityAssigningID(AbstractEntity newAbsEnt) {
        if (this.absent.length <= this.maxabsent) {
            AbstractEntity[] newArray = this.absent.length > 2 ? new AbstractEntity[(int)((double)this.absent.length * 1.5)] : new AbstractEntity[4];
            for (int i = 0; i < this.maxabsent; ++i) {
                newArray[i] = this.absent[i];
            }
            this.absent = newArray;
        }
        this.absent[this.maxabsent] = newAbsEnt;
        newAbsEnt.setID(this.maxabsent);
        ++this.maxabsent;
        newAbsEnt.loadNumberGenerator(this);
    }

    public Player createPlayerFromTemplate(InputOutputClient io) throws XMLtoWorldException {
        if (this.playerTemplateNodes == null || this.playerTemplateNodes.size() < 1) {
            return null;
        }
        return new Player(this, io, (Element)this.playerTemplateNodes.get(0));
    }

    public Player createPlayerFromTemplate(InputOutputClient io, String templateName) throws XMLtoWorldException {
        Element playerTemplateNode = (Element)this.playerTemplateNodesByName.get(templateName);
        if (playerTemplateNode == null) {
            return null;
        }
        return new Player(this, io, playerTemplateNode);
    }

    public boolean runAssignPlayerCode(ReturnValue retval, InputOutputClient io) {
        boolean ejecutado = false;
        try {
            Debug.println("Before exec code");
            ejecutado = this.execCode("assignPlayer", new Object[]{io}, retval);
            Debug.println("After exec code");
        }
        catch (TargetError bshte) {
            this.writeError("bsh.TargetError found at assignPlayer routine\n");
            this.writeError(ExceptionPrinter.getExceptionReport(bshte));
            Debug.println(bshte.printTargetError((Throwable)bshte));
            this.writeError(bshte.printTargetError((Throwable)bshte));
            io.write(ExceptionPrinter.getExceptionReport(bshte));
            System.err.println("ARGH");
            bshte.printStackTrace();
        }
        return ejecutado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewPlayerASAP(InputOutputClient io) throws XMLtoWorldException {
        ReturnValue retval = new ReturnValue(null);
        boolean ejecutado = this.runAssignPlayerCode(retval, io);
        if (retval.getRetVal() != null) {
            Player p = (Player)retval.getRetVal();
            if (this.playerList.contains(p)) {
                p.reconnect(io);
                return;
            }
            World world = this;
            synchronized (world) {
                this.playersToAdd.add(p);
            }
            return;
        }
        if (ejecutado) {
            return;
        }
        World world = this;
        synchronized (world) {
            Player pl = this.createPlayerFromTemplate(io);
            if (pl == null) {
                io.write("Player template generated a null player. No player creation code [assignPlayer], player list or player templates defined?");
                io.write("addNewPlayerASAP() was unsuccessful.");
                return;
            }
            this.playersToAdd.add(pl);
        }
        io.write("Player enqueued to be added...\n");
    }

    public Room getLimbo() {
        return this.getRoom(0);
    }

    public void executePlayerIntro(Player p) {
        this.warnVersionIfNeeded(p);
        try {
            this.execCode("intro", "");
            this.execCode("intro", new Object[]{p});
            this.execCode("intro", new Object[]{p, new Boolean(this.comesFromLoadedState())});
        }
        catch (EVASemanticException esm) {
            this.write("EVASemanticException found at intro routine");
        }
        catch (TargetError bshte) {
            this.write("bsh.TargetError found at intro routine\n");
            this.writeError(ExceptionPrinter.getExceptionReport(bshte));
        }
    }

    public void update() {
        int i;
        for (i = 0; i < this.getMaxRoom(); ++i) {
            if (this.getRoom(i) == null) continue;
            this.getRoom(i).update(this);
        }
        for (i = 0; i < this.getMaxMob(); ++i) {
            if (this.getMob(i) == null) continue;
            this.getMob(i).update(this);
        }
        for (i = 0; i < this.getMaxItem(); ++i) {
            if (this.getItem(i) == null) continue;
            this.getItem(i).update(this);
        }
        for (i = 0; i < this.getMaxAbstractEntity(); ++i) {
            if (this.getAbstractEntity(i) == null) continue;
            this.getAbstractEntity(i).update(this);
        }
        for (i = 0; i < this.getMaxSpell(); ++i) {
            if (this.getSpell(i) == null) continue;
            this.getSpell(i).update(this);
        }
        if (!this.playersToAdd.isEmpty()) {
            for (i = 0; i < this.playersToAdd.size(); ++i) {
                Player p = (Player)this.playersToAdd.get(i);
                Debug.println("The " + i + "th Player is " + p);
                this.addMobileAssigningID(p);
                Room startingRoom = p.getPropertyValueAsString("room") != null ? this.getRoom(p.getPropertyValueAsString("room")) : this.getRoom(1);
                p.setRoom(startingRoom);
                if (p.getState() == 15) {
                    p.setNewState(1, 1L);
                }
                this.addPlayer(p);
                p.getIO().write("Has sido a\u00f1adido al mundo.\n");
                p.getRoom().reportActionAuto(p, null, "De repente, $1 aparece de la nada.\n", false);
                this.write("New player joined the game.\n");
                this.executePlayerIntro(p);
            }
            this.playersToAdd = new Vector();
        }
    }

    public boolean comesFromLoadedState() {
        return this.loadedState;
    }

    public void loadState(String statefname) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException, XMLtoWorldException {
        Document d = null;
        this.room = null;
        this.item = null;
        this.mob = null;
        this.absent = null;
        this.spell = null;
        this.playerList = new Vector();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.io.write(this.io.getColorCode("information") + "Obteniendo \u00e1rbol DOM de los datos XML [estado]...\n" + this.io.getColorCode("reset"));
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(statefname));
        }
        catch (FileNotFoundException fnfe) {
            try {
                fis = new FileInputStream(new File(Paths.SAVE_PATH, statefname));
            }
            catch (FileNotFoundException fnfe2) {
                throw fnfe;
            }
        }
        d = db.parse(fis);
        Element n = d.getDocumentElement();
        this.loadWorldFromXML(n, this.io, false);
        this.loadedState = true;
    }

    public int getNumberOfConnectedPlayers() {
        int addedPlayers = 0;
        for (int i = 0; i < this.playerList.size(); ++i) {
            Player cur = (Player)this.playerList.get(i);
            if (cur.getState() == 15) continue;
            ++addedPlayers;
        }
        return addedPlayers + this.playersToAdd.size();
    }

    public VisualConfiguration getVisualConfiguration() {
        return this.vc;
    }

    public List getFileList() {
        return this.fileList;
    }

    public void addPlayer(Player p) {
        this.playerList.add(p);
        if (this.from_log) {
            p.prepareLog(this.logReader);
        }
    }

    public void writeWithTemplate(String colorTemplate, String s) {
        this.write(this.io.getColorCode(colorTemplate) + s + this.io.getColorCode("reset"));
    }

    public void writeImportant(String s) {
        this.writeWithTemplate("important", s);
    }

    public void writeError(String s) {
        this.writeWithTemplate("error", s);
        if (this.debugMode) {
            System.err.print(s);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[World: ");
        if (this.worldname != null && this.worldname.length() > 0) {
            sb.append(this.worldname);
        } else {
            sb.append("(unnamed world)");
        }
        sb.append(", internal handle ");
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    private void setResourceJarFile(URL jarFileURL) {
        URLClassLoader ucl = new URLClassLoader(new URL[]{jarFileURL}, this.getClass().getClassLoader());
        this.resourceLoader = ucl;
    }

    private ClassLoader getDefaultResourceLoader() {
        try {
            return new URLClassLoader(new URL[]{new File(this.getWorldPath()).toURI().toURL()}, this.getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getGlobalResource(String path) throws Exception {
        return this.getClass().getClassLoader().getResource(path);
    }

    public InputStream getGlobalResourceAsStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public URL getResource(String path) {
        try {
            return new URL(this.worldurl, path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return new URL(this.worldurl, path).openStream();
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void warnVersionIfNeeded(Player p) {
        if (new VersionComparator().compare(GameEngineThread.getVersionNumber(), this.parserVersion) < 0) {
            if (p == null) {
                this.writeError("\n\nAVISO IMPORTANTE:\n");
                this.writeError("Est\u00e1s usando la versi\u00f3n " + GameEngineThread.getVersionNumber() + " de AGE, y este mundo ha sido pensado para la versi\u00f3n " + this.parserVersion + " y superiores.\n");
                this.writeError("El mundo puede no funcionar, desc\u00e1rgate la \u00faltima versi\u00f3n de AGE en http://code.google/com/p/aetheria para jugarlo.\n\n");
            } else {
                p.writeError("\n\nAVISO IMPORTANTE:\n");
                p.writeError("Est\u00e1s usando la versi\u00f3n " + GameEngineThread.getVersionNumber() + " de AGE, y este mundo ha sido pensado para la versi\u00f3n " + this.parserVersion + " y superiores.\n");
                p.writeError("El mundo puede no funcionar, desc\u00e1rgate la \u00faltima versi\u00f3n de AGE en http://code.google/com/p/aetheria para jugarlo.\n\n");
                p.waitKeyPress();
            }
        }
    }

    public String getRequiredAGEVersion() {
        return this.parserVersion;
    }

    public void setCommandMatchingMode(int matchingMode) {
        this.commandMatchingMode = matchingMode;
    }

    public int getCommandMatchingMode() {
        return this.commandMatchingMode;
    }

    public AGESpellChecker getSpellChecker() {
        if (this.spellChecker == null) {
            this.spellChecker = new AGESpellChecker(this, this.getLanguage());
        }
        return this.spellChecker;
    }

    public ObjectCode getAssociatedCode() {
        return this.itsCode;
    }
}

