/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.TargetError;
import eu.irreality.age.BSHCodeExecutedOKException;
import eu.irreality.age.CodeRunner;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.EVASyntaxException;
import eu.irreality.age.Entity;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.bsh.ExtendedBSHInterpreter;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ObjectCode {
    private String codeVersion;
    private String theCode;
    private World theWorld;
    boolean permanent = true;
    ExtendedBSHInterpreter permanentInterpreter = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static String getInterpreterVersion() {
        return "EVA 0.2, Beanshell 2.0 beta 2";
    }

    public String toString() {
        return this.theCode;
    }

    public Object clone() {
        ObjectCode oc = new ObjectCode(this.theCode, this.codeVersion, this.theWorld);
        oc.permanent = this.permanent;
        oc.permanentInterpreter = null;
        return oc;
    }

    public ObjectCode cloneIfNecessary() {
        if (this.permanent) {
            return (ObjectCode)this.clone();
        }
        return this;
    }

    public ObjectCode(String code, String version, World world) {
        this.theCode = code;
        this.codeVersion = version;
        this.theWorld = world;
    }

    void resetPermanentInterpreter() {
        this.permanentInterpreter = null;
    }

    public boolean run(String aroutine) throws EVASemanticException {
        if (!this.codeVersion.equalsIgnoreCase("EVA")) {
            return false;
        }
        try {
            CodeRunner maquina = new CodeRunner(this.theCode, this.theWorld);
            return maquina.runCode(this.theCode, aroutine);
        }
        catch (EVASyntaxException syn) {
            this.theWorld.writeError("Error de sintaxis en el c\u00f3digo EVA.\n");
            this.theWorld.writeError("En concreto: " + syn.getMessage() + "\n");
            return false;
        }
    }

    public boolean run(String aroutine, String dataSegment) throws EVASemanticException {
        if (!this.codeVersion.equalsIgnoreCase("EVA")) {
            return false;
        }
        try {
            CodeRunner maquina = new CodeRunner(this.theCode, this.theWorld);
            return maquina.runCode(this.theCode, aroutine, dataSegment);
        }
        catch (EVASyntaxException syn) {
            this.theWorld.writeError("Error de sintaxis en el c\u00f3digo EVA.\n");
            this.theWorld.writeError("En concreto: " + syn.getMessage() + "\n");
            return false;
        }
    }

    private void sourceStandardLibrary(ExtendedBSHInterpreter i) throws EvalError {
        try {
            i.source(this.getClass().getClassLoader().getResource("stdfunct.bsh"));
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Warning: BeanShell standard function library stdfunct.bsh not found!");
        }
        catch (IOException fnfe) {
            System.err.println("Warning: BeanShell standard function library stdfunct.bsh couldn't be read!");
        }
    }

    private void setPropertyVariables(ExtendedBSHInterpreter i, Object theCaller) throws EvalError {
        Entity context = null;
        if (theCaller instanceof Entity) {
            context = (Entity)theCaller;
        }
        if (context != null) {
            List pList = context.getProperties();
            for (int k = 0; k < pList.size(); ++k) {
                PropertyEntry pe = (PropertyEntry)pList.get(k);
                i.set(pe.getName(), pe.getValueAsBoolean());
            }
        }
    }

    private String prepareArguments(ExtendedBSHInterpreter i, Object[] theArguments) throws EvalError {
        String argString = " ";
        for (int k = 0; k < theArguments.length; ++k) {
            i.set("arg" + k, theArguments[k]);
            argString = argString + (k > 0 ? ", arg" : "arg") + k;
        }
        return argString;
    }

    private void doInitializations(ExtendedBSHInterpreter i, Object[][] initializations) throws EvalError {
        for (int w = 0; w < initializations.length; ++w) {
            Object[] curInit = initializations[w];
            if (curInit.length < 2) continue;
            i.set((String)curInit[0], curInit[1]);
        }
    }

    private void setStandardVariables(ExtendedBSHInterpreter i, Object theCaller) throws EvalError {
        i.set("obj", theCaller);
        i.set("self", theCaller);
        i.set("world", this.theWorld);
    }

    private ExtendedBSHInterpreter initInterpreter(Object theCaller) throws EvalError {
        ExtendedBSHInterpreter i;
        this.permanentInterpreter = i = new ExtendedBSHInterpreter();
        this.sourceStandardLibrary(i);
        this.setStandardVariables(i, theCaller);
        this.setPropertyVariables(i, theCaller);
        return i;
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments) throws TargetError {
        return this.run(aroutine, theCaller, theArguments, null);
    }

    public boolean evaluate(String code, Object theCaller, ReturnValue retval) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            ExtendedBSHInterpreter i;
            if (this.permanent && this.permanentInterpreter != null) {
                i = this.permanentInterpreter;
            } else {
                i = this.initInterpreter(theCaller);
                i.eval(this.theCode);
                this.setStandardVariables(i, theCaller);
            }
            Object returned = i.eval(code);
            retval.setRetVal(returned);
            return false;
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.reportEvalError(pe, null, theCaller, null);
        }
        catch (Exception e) {
            this.theWorld.writeError("Catched the following exception: " + e);
            e.printStackTrace();
        }
        return false;
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments, ReturnValue retval) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            ExtendedBSHInterpreter i;
            if (this.permanent && this.permanentInterpreter != null) {
                i = this.permanentInterpreter;
            } else {
                i = this.initInterpreter(theCaller);
                Object returned = i.eval(this.theCode);
                if (aroutine == null) {
                    if (retval != null) {
                        retval.setRetVal(returned);
                    }
                    return false;
                }
                this.setStandardVariables(i, theCaller);
            }
            if (!this.existsMethod(i, aroutine, theArguments)) {
                return false;
            }
            String argString = this.prepareArguments(i, theArguments);
            this.debugInfo(aroutine, theCaller, theArguments);
            Object returned = i.eval(aroutine + "(" + argString + ")");
            if (retval != null) {
                retval.setRetVal(returned);
            }
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.reportEvalError(pe, aroutine, theCaller, theArguments);
        }
        catch (Exception e) {
            this.theWorld.writeError("Catched the following exception: " + e);
            e.printStackTrace();
        }
        return false;
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments, ReturnValue retval, Object[][] initializations) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            ExtendedBSHInterpreter i = this.permanent && this.permanentInterpreter != null ? this.permanentInterpreter : this.initInterpreter(theCaller);
            this.doInitializations(i, initializations);
            Object returned = i.eval(this.theCode);
            if (aroutine == null) {
                retval.setRetVal(returned);
                return false;
            }
            this.setStandardVariables(i, theCaller);
            if (!this.existsMethod(i, aroutine, theArguments)) {
                return false;
            }
            String argString = this.prepareArguments(i, theArguments);
            this.debugInfo(aroutine, theCaller, theArguments);
            returned = i.eval(aroutine + "(" + argString + ")");
            retval.setRetVal(returned);
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.reportEvalError(pe, aroutine, theCaller, theArguments);
        }
        return false;
    }

    private void debugInfo(String aroutine, Object theCaller, Object[] theArguments) {
        Debug.printlnCodeDebugging("Calling BSH method: " + aroutine);
        Debug.printlnCodeDebugging("On object: " + theCaller);
        Debug.printlnCodeDebugging("With arguments:");
        if (theArguments.length == 0) {
            Debug.printlnCodeDebugging("(no arguments");
        } else {
            for (int i = 0; i < theArguments.length; ++i) {
                Debug.printlnCodeDebugging("#" + (i + 1) + ": " + this.prettyPrint(theArguments[i]));
            }
        }
    }

    private String prettyPrint(Object o) {
        if (o == null) {
            return "null";
        }
        String theClass = o.getClass().getSimpleName();
        return theClass + ": " + o;
    }

    void reportEvalError(EvalError pe, String aroutine, Object theCaller, Object[] theArguments) {
        ExceptionPrinter.reportEvalError(pe, this.theWorld, aroutine, theCaller, theArguments);
    }

    public Node getXMLRepresentation(Document doc) {
        return this.getXMLRepresentation(doc, "Code");
    }

    public Node getXMLRepresentation(Document doc, String tagName) {
        Element suElemento = doc.createElement(tagName);
        Text t = doc.createTextNode(this.theCode);
        suElemento.appendChild(t);
        suElemento.setAttribute("language", String.valueOf(this.codeVersion));
        return suElemento;
    }

    public ObjectCode(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Code node not Element");
        }
        Element e = (Element)n;
        if (!e.hasAttribute("language")) {
            throw new XMLtoWorldException("Code node lacks language attribute");
        }
        this.codeVersion = e.getAttribute("language");
        this.theCode = e.getFirstChild().getNodeValue();
        this.theWorld = mundo;
    }

    public boolean existsMethod(String methodName, Object theCaller, Object[] arguments) {
        ExtendedBSHInterpreter i;
        if (this.permanent && this.permanentInterpreter != null) {
            i = this.permanentInterpreter;
        } else {
            try {
                i = this.initInterpreter(theCaller);
                i.eval(this.theCode);
                this.setStandardVariables(i, theCaller);
            }
            catch (EvalError ee) {
                this.reportEvalError(ee, methodName, theCaller, arguments);
                return false;
            }
        }
        return this.existsMethod(i, methodName, arguments);
    }

    private boolean existsMethod(Interpreter i, String methodName, Object[] arguments) {
        int m;
        BshMethod[] metodos = i.getNameSpace().getMethods();
        for (m = 0; m < metodos.length; ++m) {
            BshMethod method = metodos[m];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != arguments.length) continue;
            boolean correct = true;
            for (int k = 0; k < arguments.length; ++k) {
                Class<?> argumentClass = null;
                if (arguments[k] instanceof Primitive) {
                    argumentClass = ((Primitive)arguments[k]).getType();
                } else if (arguments[k] != null) {
                    argumentClass = arguments[k].getClass();
                }
                if (arguments[k] == null && (class$java$lang$Object == null ? ObjectCode.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom(method.getParameterTypes()[k])) continue;
                if (arguments[k] == null && !(class$java$lang$Object == null ? ObjectCode.class$("java.lang.Object") : class$java$lang$Object).isAssignableFrom(method.getParameterTypes()[k])) {
                    correct = false;
                    continue;
                }
                if ((argumentClass == Integer.TYPE || argumentClass == (class$java$lang$Integer == null ? ObjectCode.class$("java.lang.Integer") : class$java$lang$Integer)) && (method.getParameterTypes()[k] == Integer.TYPE || method.getParameterTypes()[k] == (class$java$lang$Integer == null ? ObjectCode.class$("java.lang.Integer") : class$java$lang$Integer)) || (argumentClass == Long.TYPE || argumentClass == (class$java$lang$Long == null ? ObjectCode.class$("java.lang.Long") : class$java$lang$Long)) && (method.getParameterTypes()[k] == Long.TYPE || method.getParameterTypes()[k] == (class$java$lang$Long == null ? ObjectCode.class$("java.lang.Long") : class$java$lang$Long)) || (argumentClass == Boolean.TYPE || argumentClass == (class$java$lang$Boolean == null ? ObjectCode.class$("java.lang.Boolean") : class$java$lang$Boolean)) && (method.getParameterTypes()[k] == Boolean.TYPE || method.getParameterTypes()[k] == (class$java$lang$Boolean == null ? ObjectCode.class$("java.lang.Boolean") : class$java$lang$Boolean)) || (argumentClass == Character.TYPE || argumentClass == (class$java$lang$Character == null ? ObjectCode.class$("java.lang.Character") : class$java$lang$Character)) && (method.getParameterTypes()[k] == Character.TYPE || method.getParameterTypes()[k] == (class$java$lang$Character == null ? ObjectCode.class$("java.lang.Character") : class$java$lang$Character)) || (argumentClass == Float.TYPE || argumentClass == (class$java$lang$Float == null ? ObjectCode.class$("java.lang.Float") : class$java$lang$Float)) && (method.getParameterTypes()[k] == Float.TYPE || method.getParameterTypes()[k] == (class$java$lang$Float == null ? ObjectCode.class$("java.lang.Float") : class$java$lang$Float)) || (argumentClass == Double.TYPE || argumentClass == (class$java$lang$Double == null ? ObjectCode.class$("java.lang.Double") : class$java$lang$Double)) && (method.getParameterTypes()[k] == Double.TYPE || method.getParameterTypes()[k] == (class$java$lang$Double == null ? ObjectCode.class$("java.lang.Double") : class$java$lang$Double)) || arguments[k] == null || method.getParameterTypes()[k].isAssignableFrom(argumentClass)) continue;
                correct = false;
            }
            if (correct) break;
        }
        return m < metodos.length;
    }
}

