/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Descriptible;
import eu.irreality.age.Description;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.Inventory;
import eu.irreality.age.Mobile;
import eu.irreality.age.Nameable;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.Room;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Utility;
import eu.irreality.age.VolumeLimitExceededException;
import eu.irreality.age.Weapon;
import eu.irreality.age.Wearable;
import eu.irreality.age.WeightLimitExceededException;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import eu.irreality.age.util.Conversions;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Item
extends Entity
implements Descriptible,
SupportingCode,
Nameable {
    private String itemType;
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    private String isInstanceOf;
    protected Description[] descriptionList;
    protected Description[] singNames;
    protected Description[] plurNames;
    protected boolean gender;
    protected String respondToSing;
    protected String respondToPlur;
    protected int volume;
    protected int weight;
    protected String inventoryString;
    protected Inventory inventory;
    protected String partsInventoryString;
    protected Inventory partsInventory;
    protected Vector characterRefs;
    protected Vector mobRefs;
    protected String extraDescriptions;
    protected List extraDescriptionArrays = new ArrayList();
    protected List extraDescriptionNameArrays = new ArrayList();
    protected Vector onlyRestrictions;
    protected Description[] openDescriptionList = null;
    protected Description[] closeDescriptionList = null;
    protected Description[] unlockDescriptionList = null;
    protected Description[] lockDescriptionList = null;
    protected Inventory keys;
    protected boolean enabled;
    protected boolean isVirtual;
    protected boolean canGet;
    protected ObjectCode itsCode;
    private Random aleat;
    private World mundo;
    protected boolean properName = false;
    protected transient List rooms = new ArrayList();
    protected transient List mobiles = new ArrayList();
    transient boolean getDescription_bsh_call = false;

    public void addRoomReference(Room r) {
        this.rooms.add(r);
    }

    public void removeRoomReference(Room r) {
        this.rooms.remove(r);
    }

    public List getRoomReferences() {
        return this.rooms;
    }

    public void addMobileReference(Mobile m) {
        this.mobiles.add(m);
    }

    public void removeMobileReference(Mobile m) {
        this.mobiles.remove(m);
    }

    public List getMobileReferences() {
        return this.mobiles;
    }

    public boolean isGettable() {
        return this.canGet;
    }

    public void setGettable(boolean gettable) {
        this.canGet = gettable;
    }

    public Item createNewInstance(World mundo, boolean cloneContents, boolean cloneParts) {
        Item it = (Item)this.clone();
        this.mundo = mundo;
        it.inheritsFrom = 0;
        if (this.isInstanceOf == null || StringMethods.isStringOfZeroes(this.isInstanceOf)) {
            it.isInstanceOf = this.title;
            Debug.println("1) instanceOf set to " + this.title);
        } else {
            it.isInstanceOf = this.isInstanceOf;
            Debug.println("2) instanceOf set to " + this.isInstanceOf);
        }
        if (cloneContents && it.inventory != null) {
            it.inventory = it.inventory.cloneCopyingItems(mundo, cloneContents, cloneParts);
        }
        if (cloneParts && it.inventory != null) {
            it.partsInventory = it.partsInventory.cloneCopyingItems(mundo, cloneContents, cloneParts);
        }
        mundo.addItemAssigningID(it);
        return it;
    }

    public Object clone() {
        Item it = new Item();
        this.copyItemFieldsTo(it);
        return it;
    }

    public void copyItemFieldsTo(Item it) {
        int i;
        it.copyEntityFields(this);
        it.aleat = this.getRandom();
        it.canGet = this.canGet;
        it.enabled = this.enabled;
        it.extraDescriptions = this.extraDescriptions;
        it.gender = this.gender;
        it.idnumber = this.idnumber;
        it.inheritsFrom = this.inheritsFrom;
        it.inventory = this.inventory != null ? (Inventory)this.inventory.clone() : null;
        it.inventoryString = this.inventoryString;
        it.isInstanceOf = this.isInstanceOf;
        it.isVirtual = this.isVirtual;
        it.itemType = this.itemType;
        it.itsCode = this.itsCode != null ? this.itsCode.cloneIfNecessary() : null;
        it.keys = this.keys != null ? (Inventory)this.keys.clone() : null;
        it.partsInventory = this.partsInventory != null ? (Inventory)this.partsInventory.clone() : null;
        it.partsInventoryString = this.partsInventoryString;
        it.respondToPlur = this.respondToPlur;
        it.respondToSing = this.respondToSing;
        it.title = this.title;
        it.volume = this.volume;
        it.weight = this.weight;
        it.properName = this.properName;
        if (this.closeDescriptionList != null) {
            it.closeDescriptionList = new Description[this.closeDescriptionList.length];
            for (i = 0; i < it.closeDescriptionList.length; ++i) {
                it.closeDescriptionList[i] = (Description)this.closeDescriptionList[i].clone();
            }
        }
        it.descriptionList = new Description[this.descriptionList.length];
        for (i = 0; i < it.descriptionList.length; ++i) {
            it.descriptionList[i] = (Description)this.descriptionList[i].clone();
        }
        if (this.lockDescriptionList != null) {
            it.lockDescriptionList = new Description[this.lockDescriptionList.length];
            for (i = 0; i < it.lockDescriptionList.length; ++i) {
                it.openDescriptionList[i] = (Description)this.openDescriptionList[i].clone();
            }
        }
        if (this.openDescriptionList != null) {
            it.openDescriptionList = new Description[this.openDescriptionList.length];
            for (i = 0; i < it.lockDescriptionList.length; ++i) {
                it.unlockDescriptionList[i] = (Description)this.unlockDescriptionList[i].clone();
            }
        }
        if (this.unlockDescriptionList != null) {
            it.unlockDescriptionList = new Description[this.unlockDescriptionList.length];
            for (i = 0; i < it.lockDescriptionList.length; ++i) {
                it.lockDescriptionList[i] = (Description)this.lockDescriptionList[i].clone();
            }
        }
        it.singNames = new Description[this.singNames.length];
        for (i = 0; i < it.singNames.length; ++i) {
            it.singNames[i] = (Description)this.singNames[i].clone();
        }
        it.plurNames = new Description[this.plurNames.length];
        for (i = 0; i < it.plurNames.length; ++i) {
            it.plurNames[i] = (Description)this.plurNames[i].clone();
        }
    }

    public Item() {
    }

    public Item(World mundo, String itemfile) throws IOException, FileNotFoundException {
        this.constructItem(mundo, itemfile, true, "none");
    }

    public Item(World mundo, Node n) throws XMLtoWorldException {
        this.constructItem(mundo, n, true, "none");
    }

    public static Item getInstance(World mundo, String itemfile) throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(itemfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        String itemtype = "none";
        for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            try {
                if (id_linea == null || Integer.valueOf(id_linea) != 0) continue;
                itemtype = linea;
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        Item ourNewItem = itemtype.equalsIgnoreCase("weapon") ? new Weapon(mundo, itemfile) : (itemtype.equalsIgnoreCase("wearable") ? new Wearable(mundo, itemfile) : new Item(mundo, itemfile));
        return ourNewItem;
    }

    public static Item getInstance(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Item node not Element");
        }
        Element e = (Element)n;
        Item ourNewItem = !e.hasAttribute("type") ? new Item(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("weapon") ? new Weapon(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("wearable") ? new Wearable(mundo, n) : new Item(mundo, n)));
        return ourNewItem;
    }

    public void constructItem(World mundo, String itemfile, boolean allowInheritance, String itemtype) throws IOException, FileNotFoundException {
        this.mundo = mundo;
        FileInputStream fp = new FileInputStream(itemfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        this.itemType = itemtype;
        block29: for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea == null) continue;
            switch (Integer.valueOf(id_linea)) {
                case 1: {
                    this.idnumber = Integer.valueOf(linea);
                    continue block29;
                }
                case 2: {
                    this.inheritsFrom = Integer.valueOf(linea);
                    if (this.inheritsFrom >= this.idnumber || !allowInheritance) continue block29;
                    this.constructItem(mundo, Utility.itemFile(mundo, this.inheritsFrom), true, itemtype);
                    this.constructItem(mundo, itemfile, false, itemtype);
                    return;
                }
                case 3: {
                    this.setNewState(Integer.valueOf(linea));
                    continue block29;
                }
                case 4: {
                    this.title = linea;
                    continue block29;
                }
                case 5: {
                    this.isInstanceOf = String.valueOf(Integer.valueOf(linea));
                    if (Integer.valueOf(this.isInstanceOf) >= Integer.valueOf(this.idnumber) || !allowInheritance) continue block29;
                    this.constructItem(mundo, Utility.itemFile(mundo, Integer.valueOf(this.isInstanceOf)), true, itemtype);
                    this.constructItem(mundo, itemfile, false, itemtype);
                    return;
                }
                case 10: {
                    this.descriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 11: {
                    this.singNames = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 12: {
                    this.plurNames = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 13: {
                    int temp = Integer.valueOf(linea);
                    if (temp == 0) {
                        this.gender = false;
                        continue block29;
                    }
                    this.gender = true;
                    continue block29;
                }
                case 14: {
                    this.respondToSing = linea;
                    continue block29;
                }
                case 15: {
                    this.respondToPlur = linea;
                    continue block29;
                }
                case 16: {
                    this.weight = Integer.valueOf(linea);
                    continue block29;
                }
                case 17: {
                    this.volume = Integer.valueOf(linea);
                    continue block29;
                }
                case 20: {
                    this.inventoryString = linea;
                    continue block29;
                }
                case 32: {
                    this.openDescriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 33: {
                    this.closeDescriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 34: {
                    this.unlockDescriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 35: {
                    this.lockDescriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block29;
                }
                case 36: {
                    int nkeys = StringMethods.numToks(linea, '&');
                    this.keys = new Inventory(10000000, 1000000);
                    for (int i = 1; i <= nkeys; ++i) {
                        int key_id = Integer.valueOf(StringMethods.getTok(linea, i, '&'));
                        if (key_id > this.idnumber) {
                            mundo.write("Warning! La ID de una llave no puede ser mayor que la del objeto que abre (" + key_id + " > " + this.idnumber + ")\n");
                            continue;
                        }
                        try {
                            this.keys.addItem(mundo.getItem(key_id));
                            continue;
                        }
                        catch (Exception exc) {
                            mundo.write("Excepci\u00f3n absurda (llave pesada)" + exc);
                        }
                    }
                    continue block29;
                }
                case 80: {
                    int intval;
                    String EVACodeString = linea;
                    boolean terminamos = false;
                    while (!terminamos) {
                        linea = filein.readLine();
                        id_linea = StringMethods.getTok(linea, 1, ' ');
                        try {
                            intval = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException e) {
                            intval = 0;
                        }
                        if (intval == 81) {
                            terminamos = true;
                            continue;
                        }
                        EVACodeString = EVACodeString + "\n";
                        EVACodeString = EVACodeString + linea;
                    }
                    this.itsCode = new ObjectCode(EVACodeString, "EVA", mundo);
                    continue block29;
                }
                case 84: {
                    int intval;
                    String bshCodeString = linea;
                    boolean terminamos = false;
                    while (!terminamos) {
                        linea = filein.readLine();
                        id_linea = StringMethods.getTok(linea, 1, ' ');
                        try {
                            intval = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException e) {
                            intval = 0;
                        }
                        if (intval == 85) {
                            terminamos = true;
                            continue;
                        }
                        bshCodeString = bshCodeString + "\n";
                        bshCodeString = bshCodeString + linea;
                    }
                    this.itsCode = new ObjectCode(bshCodeString, "BeanShell", mundo);
                    continue block29;
                }
            }
        }
        if (itemtype.equalsIgnoreCase("weapon")) {
            ((Weapon)this).readWeaponSpecifics(mundo, itemfile);
        }
        if (this.getID() < 10000000) {
            this.idnumber += 30000000;
        }
    }

    public void constructItem(World mundo, Node n, boolean allowInheritance, String itemtype) throws XMLtoWorldException {
        NodeList codeNodes;
        NodeList singRefNamesNodes;
        Element descrNode;
        int i;
        NodeList descrNodes;
        Element descrListNode;
        Element e;
        block50: {
            block49: {
                if (!(n instanceof Element)) {
                    throw new XMLtoWorldException("Item node not Element");
                }
                e = (Element)n;
                this.itemType = itemtype;
                this.mundo = mundo;
                this.canGet = true;
                this.isVirtual = false;
                this.enabled = true;
                if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
                    this.constructItem(mundo, mundo.getItemNode(e.getAttribute("extends")), true, itemtype);
                    this.constructItem(mundo, n, false, itemtype);
                    return;
                }
                if (e.hasAttribute("clones") && !e.getAttribute("clones").equals("0") && allowInheritance) {
                    this.constructItem(mundo, mundo.getItemNode(e.getAttribute("clones")), true, itemtype);
                    Debug.println("Overridden item gender is " + this.gender);
                    this.isInstanceOf = e.getAttribute("clones");
                    Debug.println("Overridden item gender is now " + this.gender);
                    return;
                }
                if (!e.hasAttribute("name")) {
                    throw new XMLtoWorldException("Item node lacks attribute name");
                }
                if (!e.hasAttribute("volume") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute volume, id=" + e.getAttribute("id"));
                }
                if (!e.hasAttribute("weight") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute weight, id=" + e.getAttribute("id"));
                }
                if (!e.hasAttribute("gender") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute gender, id=" + e.getAttribute("id"));
                }
                try {
                    if (e.hasAttribute("id")) {
                        this.idnumber = Integer.valueOf(e.getAttribute("id"));
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Bad number format at attribute id in item node");
                }
                this.title = e.getAttribute("name");
                if (!this.gender) {
                    this.gender = Boolean.valueOf(e.getAttribute("gender"));
                }
                Debug.println("Gender has been set to " + this.gender + " for " + this.title);
                try {
                    this.weight = Integer.valueOf(e.getAttribute("weight"));
                }
                catch (NumberFormatException nfe) {
                    if (!allowInheritance) break block49;
                    throw new XMLtoWorldException("Bad number format at attribute weight in item node");
                }
            }
            try {
                this.volume = Integer.valueOf(e.getAttribute("volume"));
            }
            catch (NumberFormatException nfe) {
                if (!allowInheritance) break block50;
                throw new XMLtoWorldException("Bad number format at attribute volume in item node");
            }
        }
        if (e.hasAttribute("enabled")) {
            this.enabled = Boolean.valueOf(e.getAttribute("enabled"));
        }
        if (e.hasAttribute("isVirtual")) {
            this.isVirtual = Boolean.valueOf(e.getAttribute("isVirtual"));
        }
        if (e.hasAttribute("canGet")) {
            this.canGet = Boolean.valueOf(e.getAttribute("canGet"));
        }
        if (e.hasAttribute("properName")) {
            this.properName = Boolean.valueOf(e.getAttribute("properName"));
        }
        this.readPropListFromXML(mundo, n);
        NodeList descrListNodes = e.getElementsByTagName("DescriptionList");
        if (descrListNodes.getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.descriptionList = new Description[descrNodes.getLength()];
            for (i = 0; i < descrNodes.getLength(); ++i) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.descriptionList[i] = new Description(mundo, descrNode);
                    continue;
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
            }
        }
        if ((descrListNodes = e.getElementsByTagName("SingularNames")).getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.singNames = new Description[descrNodes.getLength()];
            for (i = 0; i < descrNodes.getLength(); ++i) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.singNames[i] = new Description(mundo, descrNode);
                    continue;
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
            }
        }
        if ((descrListNodes = e.getElementsByTagName("PluralNames")).getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.plurNames = new Description[descrNodes.getLength()];
            for (i = 0; i < descrNodes.getLength(); ++i) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.plurNames[i] = new Description(mundo, descrNode);
                    continue;
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
            }
        }
        if ((singRefNamesNodes = e.getElementsByTagName("SingularReferenceNames")).getLength() > 0) {
            Element singRefNamesNode = (Element)singRefNamesNodes.item(0);
            NodeList nameNodes = singRefNamesNode.getElementsByTagName("Name");
            this.respondToSing = "";
            for (int i2 = 0; i2 < nameNodes.getLength(); ++i2) {
                Element nameNode = (Element)nameNodes.item(i2);
                Node hijo = nameNode.getFirstChild();
                while (!(hijo instanceof Text)) {
                    hijo = hijo.getNextSibling();
                }
                this.respondToSing = this.respondToSing + hijo.getNodeValue();
                if (i2 >= nameNodes.getLength() - 1) continue;
                this.respondToSing = this.respondToSing + "$";
            }
        }
        this.respondToPlur = Utility.loadNameListFromXML(mundo, e, "PluralReferenceNames", true);
        List temp = Utility.loadExtraDescriptionsFromXML(mundo, e, "ExtraDescriptionList", true);
        if (temp == null || temp.size() < 2) {
            this.extraDescriptionArrays = new ArrayList();
            this.extraDescriptionNameArrays = new ArrayList();
        } else {
            this.extraDescriptionArrays = (List)temp.get(1);
            this.extraDescriptionNameArrays = (List)temp.get(0);
        }
        Description[] dl = Utility.loadDescriptionListFromXML(mundo, e, "OpenDescriptionList", true);
        if (dl != null) {
            this.openDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "CloseDescriptionList", true)) != null) {
            this.closeDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "LockDescriptionList", true)) != null) {
            this.lockDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "UnlockDescriptionList", true)) != null) {
            this.unlockDescriptionList = dl;
        }
        if ((codeNodes = e.getElementsByTagName("Code")).getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (itemtype.equalsIgnoreCase("weapon")) {
            ((Weapon)this).readWeaponSpecifics(mundo, e);
        } else if (itemtype.equalsIgnoreCase("wearable")) {
            ((Wearable)this).readWearableSpecifics(mundo, e);
        }
        if (this.getID() < 10000000) {
            this.idnumber += 30000000;
        }
        try {
            boolean ejecutado = this.execCode("onInit", new Object[0]);
        }
        catch (TargetError te) {
            te.printStackTrace();
            mundo.writeError("BeanShell error on initting item " + this + ": error was " + (Object)((Object)te));
            mundo.writeError(ExceptionPrinter.getExceptionReport(te));
        }
    }

    public int getID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getTotalWeight() {
        int totalWeight = this.weight;
        if (this.inventory != null) {
            totalWeight += this.inventory.getWeight();
        }
        return totalWeight;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public String getDescription(long comparand) {
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matches(comparand)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        if (!this.isContainer()) {
            return desString;
        }
        if (this.inventory.isEmpty()) {
            return StringMethods.textualSubstitution(StringMethods.textualSubstitution(StringMethods.textualSubstitution(desString, "lleva %INVENTORY", "no lleva nada."), "hay %INVENTORY", "no hay nada."), "%INVENTORY", "nada.");
        }
        return StringMethods.textualSubstitution(desString, "%INVENTORY", this.inventory.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(Entity viewer) {
        if (!this.getDescription_bsh_call) {
            boolean ejecutado = false;
            ReturnValue retval = new ReturnValue(null);
            try {
                this.getDescription_bsh_call = true;
                ejecutado = this.execCode("getDescription", new Object[]{viewer}, retval);
            }
            catch (TargetError te) {
                te.printStackTrace();
            }
            finally {
                this.getDescription_bsh_call = false;
            }
            if (retval.getRetVal() != null) {
                return (String)retval.getRetVal();
            }
            if (ejecutado) {
                return null;
            }
        }
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matchesConditions(this, viewer)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        if (!this.isContainer()) {
            return desString;
        }
        if (this.inventory.isEmpty()) {
            return StringMethods.textualSubstitution(StringMethods.textualSubstitution(StringMethods.textualSubstitution(desString, "lleva %INVENTORY", "no lleva nada."), "hay %INVENTORY", "no hay nada."), "%INVENTORY", "nada.");
        }
        return StringMethods.textualSubstitution(desString, "%INVENTORY", this.inventory.toString());
    }

    public String getName(boolean s_p, int comparand) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        for (int i = 0; i < theList.length; ++i) {
            if (!theList[i].matches(comparand)) continue;
            desString = desString + theList[i].getText();
        }
        return desString;
    }

    public String getName(boolean s_p, Entity viewer) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        if (theList == null) {
            return desString;
        }
        for (int i = 0; i < theList.length; ++i) {
            if (!theList[i].matchesConditions(this, viewer)) continue;
            desString = desString + theList[i].getText();
        }
        return desString;
    }

    public String getSingName(int comparand) {
        return this.getName(true, comparand);
    }

    public String getSingNameTrue(int comparand) {
        String s = this.getName(true, comparand);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String getSingName(Entity viewer) {
        return this.getName(true, viewer);
    }

    public String getSingNameTrue(Entity viewer) {
        String s = this.getName(true, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String getPlurName(int comparand) {
        return this.getName(false, comparand);
    }

    public String getPlurName(Entity viewer) {
        return this.getName(false, viewer);
    }

    public String getPlurNameTrue(int comparand) {
        String s = this.getName(false, comparand);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String getPlurNameTrue(Entity viewer) {
        String s = this.getName(false, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String constructName(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "un " + this.getSingName(comparand);
            }
            return "una " + this.getSingName(comparand);
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            return str + " " + this.getPlurName(comparand);
        }
        return nItems + " " + this.getPlurName(comparand);
    }

    public String constructName(int nItems, Entity viewer) {
        if (nItems == 1) {
            return this.presentName(this.getSingName(viewer), "un", "una");
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            Debug.println("CONSNAME RETT'N' " + str + " " + this.getPlurName(viewer));
            return str + " " + this.getPlurName(viewer);
        }
        return nItems + " " + this.getPlurName(viewer);
    }

    public String constructName2(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingName(comparand);
            }
            return "la " + this.getSingName(comparand);
        }
        return nItems + " " + this.getPlurName(comparand);
    }

    public String constructName2(int nItems, Entity viewer) {
        if (nItems == 1) {
            return this.presentName(this.getSingNameTrue(viewer), "el", "la");
        }
        return nItems + " " + this.getPlurName(viewer);
    }

    public String constructName2True(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingNameTrue(comparand);
            }
            return "la " + this.getSingNameTrue(comparand);
        }
        return nItems + " " + this.getPlurNameTrue(comparand);
    }

    public String constructName2True(int nItems, Entity viewer) {
        if (nItems == 1) {
            return this.presentName(this.getSingNameTrue(viewer), "el", "la");
        }
        return nItems + " " + this.getPlurNameTrue(viewer);
    }

    public String constructName2OneItem() {
        return this.constructName2True(1, this.getState());
    }

    public String constructName2OneItem(Entity viewer) {
        return this.constructName2True(1, viewer);
    }

    public String presentName(String baseName, String mascArticle, String femArticle) {
        boolean properName = this.properName;
        if (baseName.startsWith("P$")) {
            properName = true;
            baseName = baseName.substring(2);
        } else if (baseName.startsWith("N$")) {
            properName = false;
            baseName = baseName.substring(2);
        }
        if (properName) {
            return baseName;
        }
        if (this.gender) {
            return mascArticle + " " + baseName;
        }
        return femArticle + " " + baseName;
    }

    public String getExtraDescription(String thingieName, Entity viewer) {
        if (thingieName == null || thingieName.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.extraDescriptionNameArrays.size(); ++i) {
            int j;
            String[] curNameArray = (String[])this.extraDescriptionNameArrays.get(i);
            Description[] curDesArray = (Description[])this.extraDescriptionArrays.get(i);
            for (j = 0; j < curNameArray.length; ++j) {
                if (!thingieName.toLowerCase().endsWith(curNameArray[j].toLowerCase())) continue;
                String desString = "";
                for (int k = 0; k < curDesArray.length; ++k) {
                    if (!curDesArray[k].matchesConditions(this, viewer)) continue;
                    desString = desString + "\n";
                    desString = desString + curDesArray[k].getText();
                }
                if (desString.length() > 0) {
                    return desString.substring(1);
                }
                return null;
            }
            for (j = 0; j < curNameArray.length; ++j) {
                if (!StringMethods.getTok(thingieName, StringMethods.numToks(thingieName, ' '), ' ').equalsIgnoreCase(curNameArray[j])) continue;
                String desString = "";
                for (int k = 0; k < curDesArray.length; ++k) {
                    if (!curDesArray[k].matchesConditions(this, viewer)) continue;
                    desString = desString + "\n";
                    desString = desString + curDesArray[k].getText();
                }
                if (desString.length() > 0) {
                    return desString.substring(1);
                }
                return null;
            }
        }
        return null;
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        String listaDeInteres = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        return this.matchesCommand(commandArgs, listaDeInteres, this.mundo.getCommandMatchingMode());
    }

    public String getInstanceOf() {
        return this.isInstanceOf;
    }

    public void setWorld(World mundo) {
        this.mundo = mundo;
    }

    public void setInstanceOf(String newid) {
        this.isInstanceOf = newid;
    }

    public boolean isSame(Item other) {
        Debug.print("isSame " + this + "(" + this.getTitle() + "," + this.idnumber + ", cloning " + this.getInstanceOf() + ")" + " " + other + "(" + other.getTitle() + "," + other.idnumber + ", cloning " + other.getInstanceOf() + ")? ");
        return this.getTitle().equals(other.getInstanceOf()) || other.getTitle().equals(this.getInstanceOf()) || this.getInstanceOf() != null && this.getInstanceOf().equals(other.getInstanceOf()) && !StringMethods.isStringOfZeroes(this.getInstanceOf());
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean isInvisible(Entity viewer) {
        return this.getSingName(viewer).length() <= 0;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public void changeState(World mundo) {
        try {
            this.execCode("event_endstate", "this: " + this.getID() + "state: " + this.getState());
        }
        catch (EVASemanticException exc) {
            mundo.write("EVASemanticException found at event_endstate , item number " + this.getID());
        }
    }

    public boolean getGender() {
        return this.gender;
    }

    public boolean isOpenable() {
        return this.openDescriptionList != null && this.openDescriptionList.length > 0;
    }

    public boolean isCloseable() {
        return this.closeDescriptionList != null && this.closeDescriptionList.length > 0;
    }

    public boolean isUnlockable() {
        return this.unlockDescriptionList != null && this.unlockDescriptionList.length > 0;
    }

    public boolean isLockable() {
        return this.lockDescriptionList != null && this.lockDescriptionList.length > 0;
    }

    public boolean isOpen() {
        return (0x100 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("closed");
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isUnlocked() {
        return (0x200 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("locked");
    }

    public boolean isLocked() {
        return !this.isUnlocked();
    }

    public boolean unlocksWithKey(Item key) {
        if (this.keys != null) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.elementAt(i).equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public String abrir() {
        boolean exito = false;
        String descriptionText = "";
        if (!this.isOpenable()) {
            return this.mundo.getMessages().getMessage("item.not.openable", new Object[]{this});
        }
        for (int i = 0; i < this.openDescriptionList.length; ++i) {
            Description des_actual = this.openDescriptionList[i];
            if (!des_actual.matchesConditions(this)) continue;
            String elTexto = des_actual.getText();
            StringTokenizer st = new StringTokenizer(elTexto, ":");
            String firstToken = st.nextToken();
            if (firstToken.equalsIgnoreCase("SUCCESS") || firstToken.equalsIgnoreCase("EXITO")) {
                exito = true;
            }
            elTexto = "";
            while (st.hasMoreTokens()) {
                elTexto = elTexto + st.nextToken();
            }
            if (elTexto.equals("")) continue;
            descriptionText = descriptionText + elTexto;
        }
        if (exito) {
            this.setNewState(this.getState() & 0xFFFFFEFF);
            this.setProperty("closed", false);
            List habitaciones = this.getRoomReferences();
            for (int i = 0; i < habitaciones.size(); ++i) {
                Room thisHabitacion = (Room)habitaciones.get(i);
            }
        }
        try {
            this.execCode("onOpen", new Object[]{new Boolean(exito)});
        }
        catch (TargetError bshte) {
            return "bsh.TargetError found onOpen , item number " + this.getID() + ": " + (Object)((Object)bshte) + "[description was: " + descriptionText + "]";
        }
        return descriptionText;
    }

    public String cerrar() {
        if (!this.isCloseable()) {
            return this.mundo.getMessages().getMessage("item.not.closeable", new Object[]{this});
        }
        String descriptionText = "";
        boolean exito = false;
        for (int i = 0; i < this.closeDescriptionList.length; ++i) {
            Description des_actual = this.closeDescriptionList[i];
            if (!des_actual.matchesConditions(this)) continue;
            String elTexto = des_actual.getText();
            StringTokenizer st = new StringTokenizer(elTexto, ":");
            String firstToken = st.nextToken();
            if (firstToken.equalsIgnoreCase("SUCCESS") || firstToken.equalsIgnoreCase("EXITO")) {
                exito = true;
            }
            elTexto = "";
            while (st.hasMoreTokens()) {
                elTexto = elTexto + st.nextToken();
            }
            if (elTexto.equals("")) continue;
            descriptionText = descriptionText + elTexto;
        }
        if (exito) {
            this.setNewState(this.getState() | 0x100);
            this.setProperty("closed", true);
            List habitaciones = this.getRoomReferences();
            for (int i = 0; i < habitaciones.size(); ++i) {
                Room thisHabitacion = (Room)habitaciones.get(i);
            }
        }
        try {
            this.execCode("onClose", new Object[]{new Boolean(exito)});
        }
        catch (TargetError bshte) {
            return "bsh.TargetError found onOpen , item number " + this.getID() + ": " + (Object)((Object)bshte) + "[description was: " + descriptionText + "]";
        }
        return descriptionText;
    }

    public String unlock(Item key) {
        if (!this.isUnlockable()) {
            return this.mundo.getMessages().getMessage("item.not.unlockable", new Object[]{this});
        }
        String descriptionText = "";
        if (!this.unlocksWithKey(key)) {
            for (int i = 0; i < this.unlockDescriptionList.length; ++i) {
                Description des_actual = this.unlockDescriptionList[i];
                String elTexto2 = "";
                if (des_actual.matchesConditions(this)) {
                    String temp;
                    String elTexto1 = des_actual.getText();
                    StringTokenizer st = new StringTokenizer(elTexto1, ":");
                    while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("FAIL") && !temp.equalsIgnoreCase("FRACASO")) {
                    }
                    elTexto2 = st.hasMoreTokens() ? st.nextToken() : "";
                }
                descriptionText = descriptionText + elTexto2;
            }
            if (descriptionText.equals("")) {
                descriptionText = "No consigues abrir " + this.getTitle();
            }
        } else {
            boolean unlocked = false;
            for (int i = 0; i < this.unlockDescriptionList.length; ++i) {
                Description des_actual = this.unlockDescriptionList[i];
                String elTexto2 = "";
                if (des_actual.matchesConditions(this)) {
                    String elTexto1 = des_actual.getText();
                    StringTokenizer st = new StringTokenizer(elTexto1, ":");
                    String temp = null;
                    while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("SUCCESS") && !temp.equalsIgnoreCase("EXITO")) {
                    }
                    if (temp.equalsIgnoreCase("SUCCESS") || temp.equalsIgnoreCase("EXITO")) {
                        elTexto2 = st.nextToken();
                        unlocked = true;
                    }
                    unlocked = true;
                }
                if (elTexto2.equals("")) continue;
                descriptionText = descriptionText + "\n";
                descriptionText = descriptionText + elTexto2;
            }
            if (unlocked) {
                this.setNewState(this.getState() & 0xFFFFFDFF);
                this.setProperty("locked", false);
                List habitaciones = this.getRoomReferences();
                for (int i = 0; i < habitaciones.size(); ++i) {
                    Room thisHabitacion = (Room)habitaciones.get(i);
                    thisHabitacion.reportAction(this, null, null, "$1 se abre con llave.\n", "Te abres con llave.\n", "Abres con llave.\n", false);
                }
            }
        }
        return descriptionText;
    }

    public String lock(Item key) {
        String descriptionText;
        block11: {
            block10: {
                if (!this.isLockable()) {
                    return this.mundo.getMessages().getMessage("item.not.lockable", new Object[]{this});
                }
                descriptionText = "";
                if (this.unlocksWithKey(key)) break block10;
                for (int i = 0; i < this.lockDescriptionList.length; ++i) {
                    Description des_actual = this.lockDescriptionList[i];
                    String elTexto2 = "";
                    if (des_actual.matchesConditions(this)) {
                        String temp;
                        String elTexto1 = des_actual.getText();
                        StringTokenizer st = new StringTokenizer(elTexto1, ":");
                        while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("FAIL") && !temp.equalsIgnoreCase("FRACASO")) {
                        }
                        if (st.hasMoreTokens()) {
                            elTexto2 = st.nextToken();
                        }
                    }
                    if (elTexto2.equals("")) continue;
                    descriptionText = descriptionText + "\n";
                    descriptionText = descriptionText + elTexto2;
                }
                break block11;
            }
            boolean locked = false;
            for (int i = 0; i < this.lockDescriptionList.length; ++i) {
                Description des_actual = this.lockDescriptionList[i];
                String elTexto2 = "";
                if (des_actual.matches(this.getState())) {
                    String elTexto1 = des_actual.getText();
                    StringTokenizer st = new StringTokenizer(elTexto1, ":");
                    String temp = null;
                    while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("SUCCESS") && !temp.equalsIgnoreCase("EXITO")) {
                    }
                    if (temp.equalsIgnoreCase("SUCCESS") || temp.equalsIgnoreCase("EXITO")) {
                        elTexto2 = st.nextToken();
                        locked = true;
                    }
                    locked = true;
                }
                if (elTexto2.equals("")) continue;
                descriptionText = descriptionText + "\n";
                descriptionText = descriptionText + elTexto2;
            }
            if (!locked) break block11;
            this.setNewState(this.getState() | 0x200);
            this.setProperty("locked", true);
            List habitaciones = this.getRoomReferences();
            for (int i = 0; i < habitaciones.size(); ++i) {
                Room thisHabitacion = (Room)habitaciones.get(i);
                thisHabitacion.reportAction(this, null, null, "$1 se cierra con llave.\n", "Te cierras con llave.\n", "Cierras con llave.\n", false);
            }
        }
        return descriptionText;
    }

    public String getBestReferenceName(boolean pluralOrSingular) {
        String theList = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        String tmp = StringMethods.getTok(theList, 1, '$');
        return Character.toLowerCase(tmp.charAt(0)) + tmp.substring(1);
    }

    public void loadInventoryFromXML(World mundo) throws XMLtoWorldException {
        Element n = mundo.getItemNode(String.valueOf(this.getID()));
        Element e = null;
        try {
            e = n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Item node not Element");
        }
        NodeList inventoryNodes = e.getElementsByTagName("Inventory");
        ArrayList<Node> realInventoryNodes = new ArrayList<Node>();
        ArrayList<Node> partsInventoryNodes = new ArrayList<Node>();
        ArrayList<Node> keysInventoryNodes = new ArrayList<Node>();
        for (int i = 0; i < inventoryNodes.getLength(); ++i) {
            if (inventoryNodes.item(i).getParentNode() == e) {
                realInventoryNodes.add(inventoryNodes.item(i));
                continue;
            }
            if (inventoryNodes.item(i).getParentNode() instanceof Element && ((Element)inventoryNodes.item(i).getParentNode()).getTagName().equalsIgnoreCase("parts")) {
                partsInventoryNodes.add(inventoryNodes.item(i));
                continue;
            }
            if (!(inventoryNodes.item(i).getParentNode() instanceof Element) || !((Element)inventoryNodes.item(i).getParentNode()).getTagName().equalsIgnoreCase("keylist")) continue;
            keysInventoryNodes.add(inventoryNodes.item(i));
        }
        this.inventory = realInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)realInventoryNodes.get(0));
        this.partsInventory = partsInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)partsInventoryNodes.get(0));
        this.keys = keysInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)keysInventoryNodes.get(0));
    }

    public void loadInventory(World mundo) {
        int maxvol;
        int maxweight;
        if (this.inventoryString == null || this.inventoryString.equals("")) {
            this.inventory = null;
            return;
        }
        int nObjects = StringMethods.numToks(this.inventoryString, '$') - 2;
        try {
            maxweight = Integer.valueOf(StringMethods.getTok(this.inventoryString, 1, '$'));
            maxvol = Integer.valueOf(StringMethods.getTok(this.inventoryString, 2, '$'));
        }
        catch (NumberFormatException nfe) {
            this.inventory = null;
            return;
        }
        this.inventory = new Inventory(maxweight, maxvol, nObjects);
        for (int i = 0; i < nObjects; ++i) {
            try {
                this.inventory.addItem(mundo.getItem(StringMethods.getTok(this.inventoryString, i + 3, '$')));
                continue;
            }
            catch (WeightLimitExceededException exc) {
                mundo.write("Item too heavy for container, ID " + this.idnumber);
                continue;
            }
            catch (VolumeLimitExceededException exc2) {
                mundo.write("Item too big for container , ID " + this.idnumber);
            }
        }
    }

    public Inventory getContents() {
        return this.inventory;
    }

    public boolean isContainer() {
        return this.inventory != null;
    }

    public Inventory getParts() {
        return this.partsInventory;
    }

    public boolean isComposite() {
        return this.partsInventory != null;
    }

    public Node getXMLRepresentation(Document doc) {
        Text elNombre;
        Element esteNombre;
        String tok;
        Description nuestraDescripcion;
        int i;
        Element listaDesc;
        Element suElemento = doc.createElement("Item");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.setAttribute("clones", String.valueOf(this.isInstanceOf));
        suElemento.setAttribute("type", String.valueOf(this.itemType));
        suElemento.setAttribute("volume", String.valueOf(this.volume));
        suElemento.setAttribute("weight", String.valueOf(this.weight));
        suElemento.setAttribute("enabled", String.valueOf(this.enabled));
        suElemento.setAttribute("isVirtual", String.valueOf(this.isVirtual));
        suElemento.setAttribute("canGet", String.valueOf(this.canGet));
        if (this.properName) {
            suElemento.setAttribute("properName", String.valueOf(this.properName));
        }
        suElemento.setAttribute("openable", String.valueOf(this.openDescriptionList != null));
        suElemento.setAttribute("closeable", String.valueOf(this.closeDescriptionList != null));
        suElemento.setAttribute("lockable", String.valueOf(this.lockDescriptionList != null));
        suElemento.setAttribute("unlockable", String.valueOf(this.unlockDescriptionList != null));
        suElemento.setAttribute("gender", String.valueOf(this.gender));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        if (this.descriptionList != null) {
            listaDesc = doc.createElement("DescriptionList");
            for (i = 0; i < this.descriptionList.length; ++i) {
                Description nuestraDescripcion2 = this.descriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.singNames != null) {
            Element listaSing = doc.createElement("SingularNames");
            for (int i2 = 0; i2 < this.singNames.length; ++i2) {
                nuestraDescripcion = this.singNames[i2];
                listaSing.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaSing);
        }
        if (this.plurNames != null) {
            Element listaPlur = doc.createElement("PluralNames");
            for (int i3 = 0; i3 < this.plurNames.length; ++i3) {
                nuestraDescripcion = this.plurNames[i3];
                listaPlur.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaPlur);
        }
        if (this.respondToSing != null) {
            Element respTo = doc.createElement("SingularReferenceNames");
            StringTokenizer st = new StringTokenizer(this.respondToSing, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.respondToPlur != null) {
            Element respTo = doc.createElement("PluralReferenceNames");
            StringTokenizer st = new StringTokenizer(this.respondToPlur, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.inventory != null) {
            suElemento.appendChild(this.inventory.getXMLRepresentation(doc));
        }
        if (this.partsInventory != null) {
            Element partsElt = doc.createElement("Parts");
            suElemento.appendChild(partsElt);
            partsElt.appendChild(this.partsInventory.getXMLRepresentation(doc));
        }
        if (this.extraDescriptions != null) {
            Element extraDes = doc.createElement("ExtraDescriptionList");
            StringTokenizer st1 = new StringTokenizer(this.extraDescriptions, "@");
            while (st1.hasMoreTokens()) {
                String desActual = st1.nextToken();
                Element unaDescripcion = doc.createElement("ExtraDescription");
                StringTokenizer st2 = new StringTokenizer(desActual, "$");
                while (st2.hasMoreTokens()) {
                    String wordActual = st2.nextToken();
                    if (st2.hasMoreTokens()) {
                        Element comando = doc.createElement("Name");
                        Text contenido = doc.createTextNode(wordActual);
                        comando.appendChild(contenido);
                        unaDescripcion.appendChild(comando);
                        continue;
                    }
                    Text texto = doc.createTextNode(wordActual);
                    unaDescripcion.appendChild(texto);
                }
                extraDes.appendChild(unaDescripcion);
            }
            suElemento.appendChild(extraDes);
        }
        if (this.keys != null) {
            Element keysel = doc.createElement("KeyList");
            keysel.appendChild(this.keys.getXMLRepresentation(doc));
            suElemento.appendChild(keysel);
        }
        if (this.openDescriptionList != null) {
            listaDesc = doc.createElement("OpenDescriptionList");
            for (i = 0; i < this.openDescriptionList.length; ++i) {
                Description nuestraDescripcion3 = this.openDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion3.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.closeDescriptionList != null) {
            listaDesc = doc.createElement("CloseDescriptionList");
            for (i = 0; i < this.closeDescriptionList.length; ++i) {
                Description nuestraDescripcion4 = this.closeDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion4.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.lockDescriptionList != null) {
            listaDesc = doc.createElement("LockDescriptionList");
            for (i = 0; i < this.lockDescriptionList.length; ++i) {
                Description nuestraDescripcion5 = this.lockDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion5.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.unlockDescriptionList != null) {
            listaDesc = doc.createElement("UnlockDescriptionList");
            for (i = 0; i < this.unlockDescriptionList.length; ++i) {
                Description nuestraDescripcion6 = this.unlockDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion6.getXMLRepresentation(doc));
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public Random getRandom() {
        return this.aleat;
    }

    public void setID(int newid) {
        this.idnumber = newid < 30000000 ? newid + 30000000 : newid;
    }

    public static Item initCorpse(Mobile m) {
        Item it = new Item();
        it.itemType = "corpse";
        it.inheritsFrom = 0;
        it.isInstanceOf = "0";
        it.title = "cad\u00e1ver de " + m.constructName(1);
        it.descriptionList = new Description[1];
        it.descriptionList[0] = new Description("Es un cad\u00e1ver de " + m.constructName(1) + ", que lleva %INVENTORY", 0L, 0L);
        it.singNames = new Description[1];
        it.singNames[0] = new Description(it.title, 0L, 0L);
        it.plurNames = new Description[1];
        it.plurNames[0] = new Description("cad\u00e1veres de " + m.constructName(2), 0L, 0L);
        it.gender = true;
        it.respondToSing = it.title + "$cad\u00e1ver$cadaver$cuerpo$muerto";
        it.respondToPlur = it.title + "$cad\u00e1veres$cadaveres$cuerpos$muertos";
        it.volume = 1000;
        it.weight = 1000;
        it.inventory = m.getInventoryForCorpse();
        if (it.inventory == null) {
            it.inventory = new Inventory(10000, 10000);
        }
        it.mobRefs = null;
        it.extraDescriptions = null;
        it.onlyRestrictions = null;
        it.openDescriptionList = null;
        it.closeDescriptionList = null;
        it.lockDescriptionList = null;
        it.unlockDescriptionList = null;
        it.keys = null;
        it.enabled = true;
        it.isVirtual = false;
        it.canGet = true;
        it.properName = false;
        it.itsCode = null;
        return it;
    }

    public Inventory getFlattenedPartsInventory() {
        if (this.partsInventory == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.partsInventory.getWeightLimit(), this.partsInventory.getVolumeLimit());
        for (int i = 0; i < this.partsInventory.size(); ++i) {
            Item thisPart = this.partsInventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedPartsInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            for (int j = 0; j < subInv.size(); ++j) {
                try {
                    result.addItem(subInv.elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    Debug.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
            }
            try {
                result.addItem(thisPart);
                continue;
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    public void informActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, objects, thirdPersonDes, self_included);
    }

    public void informAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void reportActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, objects, thirdPersonDes, null, self_included);
    }

    public void reportAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, null, self_included);
    }

    public void reportActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String style, boolean self_included) {
        List habitaciones = this.getRoomReferences();
        for (int i = 0; i < habitaciones.size(); ++i) {
            Room hab = (Room)habitaciones.get(i);
            hab.reportActionAuto(source, target, objects, thirdPersonDes, style, self_included);
        }
    }

    public void reportAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, String style, boolean self_included) {
        List habitaciones = this.getRoomReferences();
        for (int i = 0; i < habitaciones.size(); ++i) {
            Room hab = (Room)habitaciones.get(i);
            hab.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, style, self_included);
        }
    }

    public void removeFromInventories() {
        int i;
        for (i = 0; i < this.rooms.size(); ++i) {
            Room r = (Room)this.rooms.get(i);
            r.removeItem(this);
        }
        for (i = 0; i < this.mobiles.size(); ++i) {
            Mobile m = (Mobile)this.mobiles.get(i);
            m.removeItem(this);
        }
    }

    public void moveTo(Room target) throws WeightLimitExceededException, VolumeLimitExceededException {
        this.removeFromInventories();
        target.addItem(this);
    }

    public void moveTo(Mobile target) throws WeightLimitExceededException, VolumeLimitExceededException {
        this.removeFromInventories();
        target.addItem(this);
    }

    public Inventory getFlattenedInventory() {
        if (this.inventory == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.inventory.getWeightLimit(), this.inventory.getVolumeLimit());
        for (int i = 0; i < this.inventory.size(); ++i) {
            Item thisPart = this.inventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            for (int j = 0; j < subInv.size(); ++j) {
                try {
                    result.addItem(subInv.elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    Debug.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
            }
            try {
                result.addItem(thisPart);
                continue;
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isWearable() {
        return this instanceof Wearable;
    }

    public boolean isWeapon() {
        return this instanceof Weapon;
    }

    public List getSingularReferenceNames() {
        return Conversions.getReferenceNameList(this.respondToSing);
    }

    public List getPluralReferenceNames() {
        return Conversions.getReferenceNameList(this.respondToPlur);
    }

    public ObjectCode getAssociatedCode() {
        return this.itsCode;
    }
}

