 /*@@
   @file      error.c
   @date      Thu Sep 12 02:15:44 1996
   @author    Alan Shutko
   @desc 

   Error display routines.
   
   @enddesc 
 @@*/

#ifndef lint
static char *rcsid = "$Header: /home/ats/Classes/cs422/program3/libats/error.c,v 1.2 1996/11/04 18:20:54 ats Exp $";
#endif

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "error.h"
#include "ats.h"

 /*@@
   @routine    error_system
   @date       Thu Sep 12 14:27:20 1996
   @author     Alan Shutko
   @desc 

   This call signals an error in handling a system call to the user.
   It will print a error string (with standard printf handling), print
   the system error, then continue as specified in the abort
   parameter.

   If abort is RETURN, error_system will return to the caller.  If
   QUIT, it will call exit(EXIT_FAILURE).  If DUMP, it will call
   abort().
   
   @enddesc 
   @calls     
   @calledby   
   @var     abort
   @vdesc   Details what action to take after error is printed
   @vtype   err_status
   @vio     in
   @var     fmt
   @vdesc   format string
   @vtype   char*
   @vio     in
   @vcomment 
   Printf style handline
   @endvar 
@@*/


Prototype void error_system(err_status errflag, const char *fmt, ...)
{
    va_list args;
    int errno_save;             /* prevent errors from printf */
    char buf[MAXLINE];

    va_start(args, fmt);

    errno_save = errno;
    vsprintf(buf, fmt, args);
    sprintf(buf+strlen(buf), ": %s", strerror(errno_save));
    strcat(buf, "\n");
    fputs(buf, stderr);
    fflush(NULL);

    va_end(args);
    switch (errflag)
    {
        case ERR_RETURN:
            return;
        case ERR_DUMP:
            abort();
        case ERR_QUIT:
            exit(EXIT_FAILURE);
        default:
            error_user(ERR_DUMP, "Bad call to error_system!");
    }
}

 /*@@
   @routine    error_user
   @date       Thu Sep 12 14:40:10 1996
   @author     Alan Shutko
   @desc 

   This call signals an error in userspace to the user.  It will print
   a error string (with standard printf handling).

   If abort is RETURN, error_system will return to the caller.  If
   QUIT, it will call exit(EXIT_FAILURE).  If DUMP, it will call
   abort().
   
   @enddesc 
   @calls     
   @calledby   
   @var     abort
   @vdesc   Details what action to take after error is printed
   @vtype   err_status
   @vio     in
   @var     fmt
   @vdesc   format string
   @vtype   char*
   @vio     in
   @vcomment 
   Printf style handline
   @endvar 
@@*/


Prototype void error_user(err_status errflag, const char *fmt, ...)
{
    va_list args;

    int errno_save;
    /* prevent errors from printf */
    char buf[MAXLINE];

    va_start(args, fmt);
    errno_save = errno;
    vsprintf(buf, fmt, args);
    strcat(buf, "\n");
    fputs(buf, stderr);
    fflush(NULL);

    va_end(args);
    switch (errflag)
    {
        case ERR_RETURN:
            return;
        case ERR_DUMP:
            abort();
        case ERR_QUIT:
            exit(EXIT_FAILURE);
        default:
            error_user(ERR_DUMP, "Bad call to error_system!");
    }
}

