/* 
 * FILE:   main.c
 * AUTHOR: Alan Shutko <ats@hubert.wustl.edu>
 *
 * ID: $Id: int-fiction.c,v 1.3 1996/12/17 05:52:45 ats Exp $
 *
 * Functions:
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "int-fiction.h"
#include "ats.h"

/* ************************************************************ */
#include "dialog.h"
/* globals */
pid_t tailbg_pids[MAX_TAILBG], tailbg_lastpid = 0, tailbg_nokill_pids[MAX_TAILBG], tailbg_nokill_lastpid = 0;
char *backtitle, *lock_refresh, *lock_tailbg_refreshed, *lock_tailbg_exit;
int beep_signal,
    is_tailbg = 0,
    print_siz,
    cr_wrap,
    size_err,
    tab_len,
    tab_correct;
int begin_x,
    begin_y,
    begin_set,
    aspect_ratio,
    screen_initialized = 0;
int cant_kill;

int separate_output;	/* local file */
/* ************************************************************ */

#ifndef DEFAULT_GAME_LIST
#define DEFAULT_GAME_LIST "game.list"
#endif /* DEFAULT_GAME_LIST */

#ifdef DEBUG
#define debug(x) puts(x)
#else
#define debug(x)
#endif /* DEBUG */
extern char *fullpath;
gameptr games = NULL;

int main(int argc, char **argv)
{
    char *game_list, *tmp, line[4096];
    FILE* fp;
    int num_games, filename_length, x;
    gameptr *tmpgame = &games;
    char **items;
    
    /* Open file */
    if (!(game_list = getenv("IF_GAME_LIST")))
        game_list = DEFAULT_GAME_LIST;

    if ((fp = fopen(game_list, "r")) == NULL)
        error_system(ERR_QUIT, "Cannot open game file %s", game_list);

    /* ************************************************************
     *                      Read game list
     * ************************************************************/
    
    fgets(line, sizeof(line), fp);
    for(num_games=0; !feof(fp); num_games++)
    {
        if ((*tmpgame = malloc(sizeof(Game))) == NULL)
            error_system(ERR_QUIT, "Couldn't allocate memory for game");
        
        if (!(tmp=strtok(line, "|")))           /* NAME */
            error_user(ERR_QUIT, "Bad record:\n%s", line);
        strncpy((*tmpgame)->Name, tmp, 30);
        debug(tmp);
        
        if (!(tmp=strtok(NULL, "|")))           /* DESCRIPTION */
            error_user(ERR_QUIT, "Bad record:\n%s", line);
        strncpy((*tmpgame)->Description, tmp, 40);
        debug(tmp);

        if (!(tmp=strtok(NULL, "|")))           /* FILE */
            error_user(ERR_QUIT, "Bad record:\n%s", line);
        (*tmpgame)->File = pathalloc(&filename_length);
        strncpy((*tmpgame)->File, tmp, filename_length);
        debug(tmp);
        
        if (!(tmp=strtok(NULL, "|")))           /* INTERPRETER */
            error_user(ERR_QUIT, "Bad record:\n%s", line);
        tmp[strlen(tmp)-1] = '\0';
        (*tmpgame)->Interpreter = pathalloc(&filename_length);
        strncpy((*tmpgame)->Interpreter, tmp, filename_length);
        debug(tmp);

        if (!games)
            games = *tmpgame;
        
        tmpgame = &(*tmpgame)->next;
        fgets(line, sizeof(line), fp);
    }

    if (!(items = malloc(sizeof(char *) * (num_games+1) * 2)))
        error_system(ERR_QUIT, "Could not allocate memory for Game list");

    printf("Please wait while I check for games....");
    fflush(stdout);

    pathsearch_valid_games();
    printf("done.\n");
    fflush(stdout);
    
    /*
     * Create list for dialog call
     */
    for (tmpgame = &games, x=0; *tmpgame; tmpgame = &(*tmpgame)->next)
    {
        if ((*tmpgame)->valid)
        {
            items[2 * x] = (*tmpgame)->Name;
            items[2*x+1] = (*tmpgame)->Description;
            x++;
        }
    }

    init_dialog();
    x = dialog_menu("IF Game Selector", "Please choose a cool game",
                    0,0,0, x, (const char * const *)items);
    killall_bg();
    refresh();
    end_dialog();

    if (x < 0 )
        exit(0);
    
    for (tmpgame = &games; *tmpgame; tmpgame = &(*tmpgame)->next)
        if(strcmp(items[2*x], (*tmpgame)->Name) == 0)
            break;
    
    sprintf(line, "%s_INTERPRETER", (*tmpgame)->Interpreter);

    if ((tmp = getenv(line)) == NULL)
        error_user(ERR_QUIT, "\nPlease set your %s environment variable", line);

    sprintf(line, "%s %s\n", tmp, (*tmpgame)->File);
/*     printf("c\n"); */
    system(line);
    exit(0);
 
}

