//-----------------------------------------------------------------------------
// Cave.c  A Cave Adventure created by Russel Wallace,  Cybiko port by Athlor |
//-----------------------------------------------------------------------------
#include <CyWin.h>
#define NUM_VERB       42
#define NUM_NOUN       47
#define NUM_LOC        146
#define NUM_OBJ        33
#define BUFLEN         256
#define NUM_NOUN_SYN   8
#define NUM_VERB_SYN   18
#define FLAGS_SIZE     15
#define TRUE           1
#define FALSE          0
#define NOWHERE        0
#define NOTHING        0
#define CARRIED        255
#define WORN           254
#define MAXWEIGHT      60
#define L_GLASS        22
#define L_BEYOND_GLASS 21
#define L_WEEDS        64
#define L_WIRE         38
#define L_GATE         34
#define L_WEREWOLF     81
#define L_SIGN         71
#define L_PLANT        69
#define L_TOP_PLANT    146
#define L_OGRE         87
#define L_DOOR         60
#define L_CHASM_WEST   26
#define L_CHASM_EAST   27
#define L_STREAM_WEST  5
#define L_STREAM_EAST  4
#define L_VAMPIRE      73
#define L_BASILISK     46
#define L_DROPZONE     16
#define L_TREE         18
#define L_TREETOP      19
#define L_SAFE         40
#define L_DRAUGHTS     66
#define mode           flag_base[0]
#define cp             flag_base[1] // Current pos (room)
#define glass_cut      flag_base[2]
#define gate_oiled     flag_base[3]
#define wire_cut       flag_base[4]
#define weeds_dead     flag_base[5]
#define plant_watered  flag_base[6]
#define werewolf_dead  flag_base[7]
#define vampire_gone   flag_base[8]
#define basilisk_dead  flag_base[9]
#define door_open      flag_base[10]
#define riddles_solved flag_base[11]
#define waved          flag_base[12]
#define look           flag_base[13]
#define game_over      flag_base[14]
#define LED (*(char *)0xFFFF61) // Green LED register
#define tolower(c) ((c)>='A'&&(c)<='Z')?((c)+32):(c)

enum {M_BRIEF,M_NORMAL,M_VERBOSE};

enum {V_NORTH=1,V_SOUTH,V_EAST,V_WEST,V_LOOK,V_SCORE,V_HELP,V_OPEN,V_WAVE,
  V_CUT,V_LIGHT,V_OIL,V_EXAMINE,V_SAVE,V_LOAD,V_OFF,V_GET,V_DROP,V_INV,
  V_QUIT,V_CLOSE,V_CLIMB,V_JUMP,V_CROSS,V_SPRAY,V_WEAR,V_REMOVE,V_WATER,
  V_FILL,V_EMPTY,V_THROW,V_UNLOAD,V_FIRE,V_SHOOT,V_KILL,V_BREAK,V_KICK,
  V_FUCK,V_VERBOSE,V_BRIEF,V_NORMAL,V_SWIM};

enum {N_TORCH_UNLIT=1,N_TORCH_LIT,N_MATCHES,N_AXE,N_PLANK,N_DIAMOND,N_OIL,
  N_CAN,N_HACKSAW,N_WEEDKILLER,N_PACKET,N_MASK,N_WATER,N_BUCKET,N_BULLET,
  N_BRACELET,N_GUN_UNLOADED,N_GUN_LOADED,N_RING,N_CRUCIFIX,N_MIRROR,N_PAPER,
  N_KEY,N_STONE,N_STAFF,N_STATUETTE,N_SAFE_LOCKED,N_SAFE_OPEN,N_EMERALD,
  N_FOLDER,N_TOAD,N_TREE,N_FALLEN_TREE,N_GLASS,N_WEEDS,N_WIRE,N_GATE,N_WEREWOLF,
  N_SIGN,N_PLANT,N_OGRE,N_DOOR,N_CHASM,N_STREAM,N_VAMPIRE,N_BASILISK,N_ALL};

typedef int ubyte;

char buffer[BUFLEN];  // For input of commands
char filename[BUFLEN]="CA.Save";
char t[64];           // Temp for sprintf
ubyte flag_base[15];
long gametime;  // Number of turns elapsed
ubyte v,n;      // Flags to hold information during the game
ubyte visited[NUM_LOC+1],moved[NUM_OBJ+1],location[NUM_OBJ+1];
int filehandle; // For save/load

char forest_short[]="Forest";
char maze_short[]="Maze";
char forest_long[]="You are wandering through a dense forest.";
char maze_long[]="You are wandering through a maze of seemingly identical passages.";

char *verb[]={
 "","n","s","e","w","look","score","help","open","wave","cut","light","oil",
 "examine","save","load","off","get","drop","inv","quit","close", "climb",
 "jump","cross","spray","wear","remove","water","fill","empty","throw","unload",
 "fire","shoot","kill","break", "kick","fuck","verbose","brief","normal","swim"};

ubyte need_obj[NUM_VERB+1]={
 0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0};

char *noun[NUM_NOUN+1]={
 "","torch","","matches","axe","plank","diamond","oil","","hacksaw","weedkiller","",
 "mask","water","bucket","bullet","bracelet","gun","","ring","crucifix","mirror",
 "paper","key","stone","staff","statuette","safe","","emerald","folder","toad","tree",
 "","glass","weeds","wire","gate","werewolf","sign","plant","ogre","door","chasm",
 "stream","vampire","basilisk","all"};

char *obj[]={"","an unlit torch","a blazing torch","a box of matches","an axe","a wooden plank",
 "a diamond","a can of oil","an empty can","a hacksaw","a packet of weedkiller","an empty packet",
 "a gas mask","a bucket of water","an empty bucket","a silver bullet","a silver bracelet","a gun",
 "a gun","a gold ring","a silver crucifix","a mirror","a scrap of paper","a key","a small stone",
 "a long staff","a jade statuette","a locked safe","an open safe","an emerald","a brown folder",
 "a toad","a tree","a fallen tree",};

char *init_obj[]={"","There is an unlit torch lying on the ground.","",
 "You can see a box of matches jammed in a crevice in one branch.",
 "A large axe is lying among the trees.",
 "An old wooden plank is lying in the grass.",
 "The sparkle of a diamond catches your eye from a pile of dust.",
 "There is a can of oil sitting on one shelf.","",
 "There is an old hacksaw sitting on a rickety shelf.",
 "A plastic packet of weedkiller is sitting in the corner.","",
 "A gas mask is hanging from a hook on the wall.","",
 "An empty bucket is lying in the corner.",
 "There appears to be a silver bullet jammed into a crevice in the ground.",
 "A silver bracelet is lying on the ground.",
 "There is a gun lying abandoned in the corner.","",
 "The gleam of gold catches your eye from a gold ring lying in the dust.",
 "There is a silver crucifix hanging by its chain from a hook on the wall.",
 "A large gleaming mirror is leaning against the wall.",
 "You notice a scrap of paper on the ground.",
 "A key is lying in a depression in the ground.",
 "A small stone is sitting in the middle of the path.",
 "A long ornate gilded staff is leaning against the wall.",
 "A jade statuette is sitting on a ledge.",
 "A locked safe is sitting in the corner.",
 "An open safe is sitting in the corner.",
 "There is an emerald in the safe.",
 "There is a brown folder in the safe.",
 "There is an ugly toad sitting in the corner staring balefully at you.",
 "A single large tree is growing in the middle\
 of the path, neatly blocking your way north.",
 "A fallen tree is lying across the path and extending into the forest."};

char *long_obj[]={"","It's a standard-issue adventure game torch,\
 requiring a source of fire to light it, and currently unlit.",
 "The torch is blazing, giving off a bright yellow light.",
 "It's a box of matches of the sort that can be bought\
 in any newsagents or found in most adventure games.",
 "The axe has a long wooden shaft and a sharp, heavy steel blade. An\
 experimental swing indicates that it's too clumsy to be of much use as a weapon.",
 "It's a perfectly ordinary long wooden plank. It has no weatherproof\
 coating of any kind and the edges are a bit rough, not planed very well.",
 "It's a large, hard, sharp piece of crystalline\
 carbon with a substantial market value.",
 "The can is small and almost rectangular. The oil is a black sticky liquid.",
 "It's an empty metal can with black stains around the edge.",
 "A hacksaw is a small saw with a very hard, sharp\
 blade, which can cut through wood or soft metals.",
 "At the bottom of the label is the legend 2,4,5-T and beside it is the\
 large black-on-yellow X which chemical companies put on things that should\
 really carry the skull-and-crossbones poison symbol when they don't want\
 to frighten their customers. A spray nozzle is on the top of the packet,\
 and the instructions on the label read: \"To use, type SPRAY <target>\".",
 "The packet is now empty.",
 "This is a well-made piece of military equipment, standard issue for CBW\
 (chemical and biological warfare) protection.",
 "The bucket is made of plastic and its contents are made of hydrogen oxide.",
 "The bucket is made of plastic and its contents are made of nitrogen,\
 oxygen, carbon dioxide, argon and water vapor, with traces of other gases.",
 "The bullet is actually a composite of the standard lead (for\
 weight and cheapness) and silver (for use in horror movies).",
 "The bracelet is highly polished and gleams in the light.\
 It's quite pretty and more to the point, valuable.",
 "This is a .357 Magnum revolver, capable of blowing away any murderous\
 speleologists you're likely to encounter (at least if it were loaded).",
 "This is a .357 Magnum revolver, capable of blowing away any murderous\
 speleologists you're likely to encounter. It contains one bullet.",
 "At first sight the ring seems completely featureless, but closer\
 examination reveals runic symbols scratched into the metal.",
 "This is an ancient religious symbol. It's also made of solid silver\
 and you could probably get a good bit of money for it.",
 "You stare into the large gleaming mirror and almost jump through the\
 ceiling when you see something more hideous than you have ever imagined.\
 You calm down on realizing that it's quite harmless. (OK, only kidding,\
 actually you're a fine specimen of an adventurer.)",
 "On the paper is written a square root symbol enclosing the number 3169014436.",
 "The function of this key is to open a door. This is its only purpose in life.\
 As such, it is totally unadorned, and has no interesting features whatsoever.",
 "It is made of coarse granite. A glance at the scenery reveals that the\
 hill it comes from is an outcrop of this granite, which survived when the\
 surrounding sedimentary rocks were eroded away. The rock was probably formed\
 around the late Cretaceous era, though you cannot be certain. You resolve\
 to conduct carbon-dating tests on the stone when you return to civilization.",
 "The staff is long and carved with ornate symbols, all incomprehensible.",
 "The statuette is small and very ugly, but\
 made of green jade and probably quite valuable.",
 "The safe is locked with a combination lock with a hundred thousand\
 possible combinations. The walls are made of multiple-layer steel alloy\
 several inches thick, capable of withstanding drills and explosives and\
 interspersed with layers of corrosion-resistant metal. You haven't a hope\
 of breaking into it.",
 "The safe door is open.",
 "You gaze into the green depths of the emerald and see something. It\
 seems to be a moving shadow. You stare harder and finally make out something\
 pink and stubby. It seems to be behind the emerald, not within it. You have\
 discovered one of your fingers.",
 "The folder is full of extremely important and\
 confidential documents of no interest whatsoever to you.",
 "The toad is peculiarly ugly, warty, garishly\
 coloured and coated with some sort of glistening slime.",
 "The tree towers above you in all its magnificence. It would be a  beautiful\
 sight were it not for the fact that the trunk is growing right in  the\
 middle of a narrow gap between rocky outcrops and blocking your way north.",
 "A huge trunk lies across the path. It appears scramble-over-able.",
 "",     // Glass-variable appearance
 "",     // Weeds-variable appearance
 "",     // Wire-variable appearance
 "",     // Gate-variable appearance
 "The werewolf is large and dark and hairy and travelling in your\
 direction at quite a high speed. It seems to have very big sharp teeth.",
 "On closer examination the sign seems to be an award. It's some obscure\
 acting award on a cheap bronze plaque ... the name of the film is SECOND\
 COUSIN OF DRACULA, and the name of the actor is too tarnished to make out.",
 "",     // Plant-variable appearance
 "The ogre is huge and horribly ugly and extremely fierce looking. That's\
 all you can see from this distance. It's probably all you want to know.",
 "",     // Door-variable appearance
 "The chasm is incredibly deep. It seems to go down forever. It's\
 probably not really that deep, just that the torchlight can't reach down\
 very far, but why spoil the fun?",
 "The stream is wide and clear with high banks. It's not flowing very\
 fast. You catch glimpses of brightly coloured fish swimming in it.",
 "The vampire is tall and wearing the fashionable Dracula-style black\
 cloak. He also has the classical-style long fangs and face as pale as if\
 his computer had just given him a corrupted-disk error message on a disk\
 containing two weeks' work.",
 "It's a stone statue of a small harmless-looking lizard."};

ubyte value[NUM_OBJ+1]={
 0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,5,15,0,0,20,15,10,0,0,0,20,5,0,0,5,0,0,0,0};

ubyte weight[NUM_OBJ+1]={
 0,3,3,1,6,7,1,3,2,2,6,3,4,6,2,2,2,3,5,1,1,8,1,1,2,7,5,255,255,1,3,3,255,255};

ubyte init_loc[NUM_OBJ+1]={
 0,1,0,19,11,14,54,43,0,16,28,0,35,0,16,140,144,44,0,62,56,78,21,0,2,90,36,40,0,0,0,65,18,0};

char *lshort[]={"","Clearing","Top of Hill","Steep Narrow Trail",
 "East of Stream","West of Stream","Long Path","Long Path","Clearing","Path",
 "Wide Meadow","Clearing","Narrow Lane","Narrow Lane","Field",
 "Outside Well-House","Well-House","Field","Path","Top of Tree",
 "Cave Entrance","Dusty Room","End of Hall","Great Hall","Wide Corridor",
 "Dark Tunnel","Narrow Passage","Small Cave","Stony Cave","Store Room",
 "Tunnel","Passage","Underground Tunnel","Long Low Tunnel","Damp Cave",
 "Dead End","Cave","Cramped Cave","Gloomy Passage","Underground Tunnel",
 "Dungeon","Stairway","Top of Stairway","Cave","Dead End","Rocky Room",
 "Dank Wet Room","Spacious Cave","Cold Stony Cave","Large Cave",
 "Winding Tunnel","Tunnel","Rocky Alcove","Rocky Tunnel","Store Room",
 "North End of Cavern","Small Room","South End of Cavern","Long Passage",
 "Large Cave","Narrow Passage","Spacious Cave","Dead End","Small Ante-Room",
 "Dirty Narrow Cave","Short Tunnel","Large Cave","Rocky Room","Passage",
 "Dusty Room","Twisting Tunnel","Passage","Cramped Cave","Vampire's Lair",
 "Gloomy Passage","Cave","Dead End","Winding Tunnel","Tunnel",
 "Long High Cave","Winding Tunnel","Echoing Cavern","Tunnel",
 "Winding Passage","Cave","Gloomy Cave","Narrow Passage","Gloomy Tunnel",
 "Series of Rooms","Large Hall","Throne Room",forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,forest_short,forest_short,forest_short,
 forest_short,forest_short,maze_short,maze_short,maze_short,maze_short,
 maze_short,maze_short,maze_short,maze_short,maze_short,maze_short,
 maze_short,maze_short,maze_short,maze_short,maze_short,maze_short,
 maze_short,maze_short,maze_short,maze_short,"Winding Tunnel","Gloomy Cave"};

char *llong[]={"",
 "This is a small clearing at the top of a hill. Trees surround you in\
 all directions except west.",
 "You are at the top of a high hill. A trail leads down the hill to the\
 north and there is a clearing to the east.",
 "You are on a steep narrow trail leading up the north face of a high\
 hill. The sound of a stream can be heard from below.",
 "You are standing on the east bank of a wide, clear stream. Brightly coloured\
 fish can be seen swimming in the stream. You are surrounded on all sides by\
 forest except for a trail which leads up a hill to the south.",
 "You are standing on the west bank of a wide, rushing stream. You catch\
 glimpses of some brightly coloured fish in the water. A path leads west.",
 "You are walking along a long east-west path through the forest. You\
 can hear the sound of a stream from the east.",
 "This is the western end of a long east-west forest path.",
 "You are in a wide clearing among the trees. The forest surrounds you on\
 all sides, looking deep and menacing. A single path leads west.",
 "You are on an east-west forest path.",
 "This is a wide, pleasant meadow. A lane leads south and a smaller path\
 leads east. There is an opening among the trees to the west.",
 "You are in a nondescript forest clearing. More open ground can be seen\
 to the east.",
 "You are walking along a narrow lane which leads to a meadow to the\
 north and dwindles into the distance in the south.",
 "You are near the end of a narrow lane which leads north into the\
 forest. A gate opens onto a field to the west and the lane continues south\
 for a short distance.",
 "This is a small grassy field in the middle of the woods. A narrow lane\
 can be reached through a gate to the east.",
 "You are at the end of a lane which continues to the north, and\
 standing outside a well-house which can be entered to the east.",
 "This is a small, disused well-house of the type familiar to any\
 experienced adventurer. No water is currently available here; the building's\
 function is now indicated by the message \"LEAVE YOUR TREASURE HERE FOR\
 POINTS\" scrawled on one wall. A single door leads west.",
 "This is a large open field among the woods. You are surrounded on\
 almost every side by trees. A single path leads north.",
 "You are on a north-south path. To the south lies open ground. To the\
 north looms a stony hill towards which the path leads.",
 "You are in the branches of a tall tree. The ground looks an unpleasantly\
 long way away.",
 "You are standing under a high, stony hill which rises to the north. The\
 hill is too steep to be climbed but directly to the north gapes the entrance\
 to a dark cave. A path leads south into the forest.",
 "You are in a small dusty room, bare of any ornament. An exit leads east\
 through a broken pane of glass.",
 "You are at the western end of a long hall. A doorway leads north.",
 "You are in a vast hall which extends a considerable distance to the\
 west. A doorway opens onto a corridor to the east.",
 "You are at a corner in a wide corridor which connects with a tunnel to\
 the north and leads into a large chamber to the west.",
 "You are at the start of a dark tunnel. To the south is the exit to the\
 open air, and passages lead into the blackness to the east and north.",
 "You are in a narrow east-west passage. To the east yawns a vast chasm\
 which extends down as far as you can see and is probably too wide to jump over.",
 "You are in a small cave. A tunnel leads off to the north and to the\
 west gapes a deep chasm.",
 "You are in a stony cave with rough, uneven walls. A single rough-hewn\
 doorway leads south into a large hall.",
 "This is a small nondescript storeroom opening off the tunnel to the east.",
 "You are in a small east-west tunnel. A wider corridor leads off to the south.",
 "You are walking along a long gloomy north-south passageway. A narrow\
 tunnel leads off to the west.",
 "This is a long tunnel which opens into a small cave to the south and\
 continues for a long distance to the north. A small opening leads east.",
 "You are in a long east-west tunnel with no distinguishing features.",
 "You are in a cold, damp cave. A cramped tunnel goes off to the west.",
 "The tunnel ends abruptly here in a wall of solid rock. This space is\
 slightly wider than the rest of the tunnel and the walls are somewhat more finished.",
 "This is a small cave leading off from the slightly larger one to the west.",
 "You are in a cramped cave. An even smaller cave adjoins this one to the\
 east. A short tunnel leads off to the south and a longer passageway leads\
 off to the north. Strands of barbed wire drape from the entrance to this passage.",
 "You are in a gloomy passage which curves off to the north and opens\
 into a small cave to the south.",
 "You are in a twisty north-south tunnel. To the south you can see a\
 cave through an open gate.",
 "You are in a dank dungeon buried deep beneath the surface. The only\
 exit is via the stairway leading up to the east.",
 "You are on a steep stone stairway which leads deep down into the depths\
 of the earth to the west and ascends to the east.",
 "You are at the top of a stairway which descends to the west as far as\
 the eye can make out. An exit leads east.",
 "You are in a small cave. The only exit is south.",
 "The tunnel comes abruptly to a dead end here. The only way you can go\
 is back to the south.",
 "You are in a large rocky room with rough-hewn walls. Exits lead north,\
 south and west.",
 "This is a dank, wet chamber. Slime drips from the walls and the sound of\
 water can be heard in the distance. Exits are north, south and east.",
 "You are in a long spacious cave. There are doorways in the north and\
 south walls.",
 "You are in a cold stony cave. The only exit leads north.",
 "This is a large cave which adjoins the tunnel to the east.",
 "You are wandering through a narrow winding tunnel. You can go north,\
 east or west.",
 "You are in a twisting tunnel. Exits are south or west.",
 "You are in a rocky alcove which opens off the main passage to the east.",
 "This is a short east-west tunnel. The words BEWARE OF THE B... are\
 painted on the wall, trailing off into a long streak.",
 "This is a small store-room which opens off the north end of a large cavern.",
 "You are standing in the northern end of a huge cavern. Doorways open\
 to the east, west and north.",
 "You are in a small room connected to a large cavern. The only exit is west.",
 "You are at the southern end of a vast cavern. An exit leads south.",
 "You are in a long north-south passage. An alcove adjoins the passage\
 to the west.",
 "You are in a large cave. Passages curve off to the east and west and a\
 narrow opening leads north.",
 "You are standing in a very narrow straight north-south passage.",
 "You are in a spacious cave. An exit leads north.",
 "The short tunnel leading off from the ante-room comes to a dead end\
 here. The only exit is west.",
 "You are in a small ante-room with a cave opening to the south and a\
 short tunnel leading off to the east. A winding passage goes north.",
 "You are in a filthy little cave. An open door leads south and a short\
 winding passage leads east.",
 "This is a short, obviously unfinished tunnel extending from the larger\
 one to the east.",
 "You are in a large cave with a high ceiling. A strong wind blows\
 through here from unseen sources. You can go north, west or east.",
 "You are in a large rocky room. Exits are east and west, or south past\
 a few scraps of poisoned weed.",
 "You are in a short north-south passage.",
 "You are in a dusty room at the end of the passage. There is a large\
 round hole in the ceiling.",
 "You are in a twisting tunnel. Exits are north and west.",
 "You are in a north-south tunnel. A doorway opens to the east. You can\
 see a sign on the wall.",
 "You are in a cramped cave which adjoins the passage to the west.",
 "You are in the vampire's lair. The vampire himself is standing nearby.\
 He flashes a toothy grin at you.",
 "You are in a gloomy east-west passage. Another passage leads off to the south.",
 "The passage here opens into a large cave. Exits are east and west and\
 another doorway leads north.",
 "You are at a dead end and can only go back west.",
 "You are in a narrow winding tunnel and can go east or south.",
 "You are at the end of the tunnel which leads back west.",
 "You are in a long cave with a high roof. Passages lead east and north.",
 "You are in a winding tunnel and can go north or south.",
 "You are in a large cavern in which every sound makes an echo. Tunnels\
 lie to the north and east.",
 "You are in a tunnel which connects the cavern to the south with another\
 passage to the north. A cave lies to the east.",
 "You are in a short winding passage. Exits are west and south.",
 "You are in a small cave. The only exit is east.",
 "You are in a gloomy cave. Doorways lead east and west.",
 "You are in a narrow passage. Exits are north and west.",
 "You are in an evil-smelling tunnel. A huge ogre is squatting in the\
 corner surrounded by piles of old bones from previous adventurers. A leg of\
 some unidentifiable animal is lying in the corner, half-eaten. You can go\
 north or south.",
 "You are in one of a series of underground rooms. Doorways lead north\
 and east and a tunnel exits to the south.",
 "You are in an ancient banquet hall. A doorway leads south.",
 "You are in an ancient throne room, now sadly stripped of practically\
 everything of value. The ancient throne looms before you and behind is the\
 door to the west.",
 forest_long,forest_long,forest_long,forest_long,forest_long,forest_long,
 forest_long,forest_long,forest_long,forest_long,forest_long,forest_long,
 forest_long,forest_long,forest_long,forest_long,forest_long,forest_long,
 forest_long,forest_long,forest_long,forest_long,forest_long,forest_long,
 forest_long,forest_long,forest_long,forest_long,forest_long,forest_long,
 forest_long,forest_long,forest_long,forest_long,maze_long,maze_long,
 maze_long,maze_long,maze_long,maze_long,maze_long,maze_long,maze_long,
 maze_long,maze_long,maze_long,maze_long,maze_long,maze_long,maze_long,
 maze_long,maze_long,maze_long,maze_long,
 "You are in a narrow winding tunnel which connects a cave to the north\
 with a small round passageway to the west.",
  "You are in a gloomy cave with a low roof. The top part of a tall plant\
 is growing up through a large hole in the floor of the cave and a passage\
 leads off to the south."};

ubyte exits[][4]={{0,0,0,0},{98,100,99,2},{3,100,1,101},{4,2,123,101},
 {121,3,122,0},{91,100,0,6},{91,124,5,7},{116,105,6,105},{114,105,92,9},
 {113,106,8,10},{112,12,9,11},{108,118,10,118},{10,13,124,120},
 {12,15,106,14},{108,107,13,120},{13,105,16,120},{0,0,0,15},{18,117,121,115},
 {0,17,117,119},{0,0,0,0},{25,18,122,115},{0,0,22,0},{28,0,23,0},{0,0,24,22},
 {30,0,0,23},{31,20,26,0},{0,0,0,25},{32,0,0,0},{0,22,0,0},{0,0,30,0},
 {0,24,31,29},{51,25,0,30},{58,27,33,0},{0,0,34,32},{0,0,0,33},{37,0,0,0},
 {0,0,0,37},{38,35,36,0},{59,0,0,0},{59,34,0,0},{0,0,41,0},{0,0,42,40},
 {0,0,45,41},{0,45,0,0},{0,46,0,0},{43,47,0,42},{44,48,53,0},{45,50,0,0},
 {46,0,0,0},{0,0,50,0},{47,0,51,49},{0,31,0,50},{0,0,58,0},{0,0,55,46},
 {0,55,0,0},{54,57,56,53},{0,0,0,55},{55,58,0,0},{57,32,0,52},{60,0,38,39},
 {0,59,0,0},{63,0,0,0},{0,0,0,63},{64,61,62,0},{0,60,63,0},{0,0,66,0},
 {68,0,67,65},{0,64,70,66},{69,66,0,0},{0,68,0,0},{71,0,0,67},{73,70,72,0},
 {0,0,0,71},{74,71,0,0},{0,73,75,79},{77,0,76,74},{0,0,0,75},{0,75,78,0},
 {0,0,0,77},{80,0,74,0},{81,79,0,0},{82,0,80,0},{83,81,85,0},{0,82,0,84},
 {0,0,83,0},{0,0,86,82},{87,0,0,85},{88,86,0,0},{89,87,90,0},{0,88,0,0},
 {0,0,0,88},{117,6,122,116},{121,5,123,116},{122,98,123,92},{121,99,123,91},
 {117,98,99,93},{116,92,99,94},{122,4,123,96},{98,99,123,117},{98,100,123,3},
 {1,99,98,101},{5,100,2,102},{6,124,101,103},{7,106,102,104},
 {105,124,103,105},{8,124,7,106},{124,107,100,13},{108,106,14,120},
 {119,107,12,118},{110,108,107,120},{118,109,113,120},{112,110,11,118},
 {119,111,115,118},{115,112,114,119},{115,8,91,113},{119,114,17,112},
 {117,91,121,114},{121,92,122,116},{119,120,112,110},{115,111,113,118},
 {118,107,109,119},{117,92,122,116},{121,98,123,94},{122,97,98,117},
 {103,106,100,13},{126,126,145,125},{125,127,125,126},{125,126,128,126},
 {129,127,127,126},{0,128,127,130},{131,128,0,129},{130,129,129,132},
 {127,133,131,130},{132,132,134,131},{126,135,128,133},{0,128,136,134},
 {137,135,126,127},{136,127,128,138},{127,129,137,139},{134,138,140,137},
 {133,141,130,139},{140,142,0,131},{127,140,143,141},{144,142,136,129},
 {141,134,135,143},{146,0,0,125},{0,145,0,0}};

ubyte noun_syn_num[NUM_NOUN_SYN]={N_MATCHES,N_OIL,N_HACKSAW,
      N_WEEDKILLER,N_WEEDKILLER,N_WEEDS,N_WEREWOLF,N_AXE};

char *noun_syn[]={"box","can","saw","packet","pack","plants","wolf","ax"};

ubyte verb_syn_num[NUM_VERB_SYN]={V_LOOK,V_OPEN,V_CUT,V_CUT,V_LIGHT,V_EXAMINE,V_LOAD,
      V_OFF,V_GET,V_INV,V_INV,V_CLOSE,V_CLOSE,V_KILL,V_KILL,V_BREAK,V_FUCK,V_FUCK};

char *verb_syn[]={"l","unlock","chop","scratch","on","read","restore","extinguish",
     "take","i","inventory","shut","lock","hit","attack","smash","shit","bugger"};

int countobj(int); // Required prototypes
int listobj(int);
void ogre_death(void);
void init(void);
void get_command(void);

//-----------------------------------------------------------------------------
// Cybiko Specific:  clrln, Scroll, puts, Wrap, _getch and gets               |
//-----------------------------------------------------------------------------
struct MSequence mus; // Structures
struct FileInput f_in;
struct FileOutput f_out;
struct Message* ptr_msg;
struct module_t main_module;

void clrln(void)
{
  TGraph_set_color(main_module.m_gfx,CLR_WHITE);
  TGraph_fill_rect(main_module.m_gfx,0,91,160,9); // Erase bottom line
  textC(0,27,mini_bold_font," Cave Adventure                      "
                                           ,40,CLR_LTGRAY,CLR_BLACK);
  TGraph_set_color(main_module.m_gfx,CLR_BLACK);
  Graphics_set_font(main_module.m_gfx,mini_normal_font);
}

void Scroll(void)
{
  TGraph_scroll(main_module.m_gfx, 0, 27, 160, 73, 0, -9);
  clrln();
}

int puts(char *s)
{
  Scroll();
  Graphics_draw_text(main_module.m_gfx,s,0,90); // Print Text
  DisplayGraphics_show(main_module.m_gfx); // Update Display
}

void Wrap(char *s)
{
 char l[64]; int i; int lsp;
  while(DisplayGraphics_string_width(main_module.m_gfx,s)>155)
  {
    i=0; l[i]=0;
    do {
      if(*s==32)  lsp=i;   // Remember last space
      l[i++] = *s++; l[i]=0;
    }while(DisplayGraphics_string_width(main_module.m_gfx,l)<155&&(l[i-1]!='\n'));
    if(*(s-1)!='\n') {s=s-(i-lsp)+1; i=lsp;  l[i++]='\n'; l[i]=0;}
    puts(l);
  }
  puts(s);
}

int _getch(void)
{
 int key; bool pressed=FALSE;
  do{
    ptr_msg=cWinApp_get_message(main_module.m_process,0,1,MSG_USER);
    switch(ptr_msg->msgid)
    {
      case MSG_KEYDOWN:
        key=Message_get_key_param(ptr_msg)->scancode; // Allows spec keys
        switch(key)
        {
          case KEY_ENTER: case KEY_BACKSPACE: case KEY_RIGHT: case KEY_SELECT:
          case KEY_UP: case KEY_DOWN: case KEY_LEFT: case KEY_DEL: case KEY_TAB:
            pressed=TRUE;
          case KEY_SHIFT: case KEY_CONTROL: break;
          default: pressed=TRUE; key=Message_get_key_param(ptr_msg)->ch; break;
        }
        break;
      default:
      cWinApp_defproc(main_module.m_process,ptr_msg); // Process Remaining
    }
    Message_delete(ptr_msg); // Delete processed message
  }while(!pressed);
 return key;
}

void gets(char *lbuf)
{
int key,i=0; bool done=FALSE;
  Scroll();  // for(i=0; i<64; i++) chaEditLine[i]=0; i=0;
  lbuf[0]=0;
  do{
    key=_getch(); // Wait until a key is pressed
    if(key==264) {lbuf[0]='w';lbuf[1]=0;break;} // Controller pad hack
    if(key==265) {lbuf[0]='n';lbuf[1]=0;break;}
    if(key==266) {lbuf[0]='e';lbuf[1]=0;break;}
    if(key==267) {lbuf[0]='s';lbuf[1]=0;break;}
    switch(key)
    {
      case KEY_ENTER: lbuf[i]=0; done=TRUE; break;
      case KEY_BACKSPACE: if(i) lbuf[--i]=0; break;
      default: lbuf[i++]=(char)key; lbuf[i]=0; break;
    }
    clrln();
    Graphics_draw_text(main_module.m_gfx,lbuf,0,91);
    DisplayGraphics_show(main_module.m_gfx); // Update Display
  }while(!done);
//  Scroll();
}

void more(void)
{
  LED |= 8; // Turn Green LED ON
  _getch();
  LED &= 247; // Turn Green LED OFF 
}
//-----------------------------------------------------------------------------

void status(void)
{
  if(cp==L_WEREWOLF)
  {
    if(werewolf_dead==1)
    {
      beep(2);
      Wrap("The werewolf reaches you and rips your\
 throat out before gorging itself on your flesh and blood.");
      game_over=TRUE;
      return;
    }
    if(werewolf_dead==0)
    {
      Wrap("A werewolf rises from the corner and sees you. It starts\
 sprinting towards you at amazing speed, and very rapidly comes close\
 enough to provide a good view of a mouthful of slavering fangs.");
      werewolf_dead=1;
    }
  }
  if(cp==L_VAMPIRE && location[N_CRUCIFIX]!=CARRIED && location[N_CRUCIFIX]!=WORN)
  {
    Wrap("The vampire seizes you and sinks his fangs into your neck.\
 Your struggles are fruitless against the strength of the undead, not to\
 mention the fact that this vampire has been doing a lot of working out.");
    more();beep(2);
    Wrap("The slurping sound of your blood being sucked out sounds loud in your ears.\
 Eventually your heart stops from lack of blood, but the vampire gives you\
 cardio-pulmonary resuscitation to extract the last few drops. Finally, you die.");
    game_over=TRUE;
    return;
  }
  if(cp==L_DRAUGHTS)
  {
    if(random(4)) Wrap("Your torch flickers in the draught.");
    else
    {
      beep(3);
      Wrap("A particularly strong gust of wind blows out\
 your torch. You are instantly plunged into Stygian gloom.");
      location[N_TORCH_UNLIT]=location[N_TORCH_LIT];
      location[N_TORCH_LIT]=NOWHERE;
    }
  }
}

void desc_loc(void)
{
 int i;
  TGraph_set_color(main_module.m_gfx,CLR_LTGRAY);
  TGraph_fill_rect(main_module.m_gfx,0,0,160,27); // Erase gfx area
  TGraph_set_color(main_module.m_gfx,CLR_BLACK);
  Graphics_draw_text(main_module.m_gfx,"N",50,0);
  Graphics_draw_text(main_module.m_gfx,"W+E",44,9);
  Graphics_draw_text(main_module.m_gfx,"S",51,18);
  Graphics_draw_text(main_module.m_gfx,lshort[cp],64,9); // Print desc

/*  sprintf(t,"Current room: %d",cp);
  Graphics_draw_text(main_module.m_gfx,t,64,0);  // Print room number (Debug)
  sprintf(t,"0:%d 1:%d 2:%d 3:%d",exits[cp][0],exits[cp][1],exits[cp][2],exits[cp][3]);
  Graphics_draw_text(main_module.m_gfx,t,64,18); // Print room exits (Debug)*/

  if(cp==L_STREAM_WEST&&location[N_PLANK]==L_STREAM_EAST)
    location[N_PLANK]=L_STREAM_WEST;
  if(cp==L_STREAM_EAST&&location[N_PLANK]==L_STREAM_WEST)
    location[N_PLANK]=L_STREAM_EAST;
  if(look==0 && location[N_TORCH_LIT]!=CARRIED && location[N_TORCH_LIT]!=cp && \
                                  (random(5))==0 &&((cp>20 && cp<91) || cp>124))
  {
    Wrap("You have stumbled in the dark, fallen into a pot-hole and broken your neck.");
    game_over=TRUE;
    return;
  }
  if(location[N_TORCH_LIT]!=CARRIED && location[N_TORCH_LIT]!=cp &&((cp>20 && cp<91)||cp>124))
  {
    Wrap("It's too dark to see anything clearly.");
    goto SKIP_SCENERY;
  }
  draw_lib(0,6,0,0,BM_NORMAL);
  draw_lib(0,6,14,0,BM_NORMAL);
  draw_lib(0,6,28,0,BM_NORMAL);
  if(cp==15) draw_lib(0,19,28,0,BM_NORMAL); // Draw wellhouse entrance
  if(cp==20) draw_lib(0,18,14,0,BM_NORMAL); // Draw cave entrance
  if(cp==16) draw_lib(0,19,0,0,BM_FLIP_X);  // Draw wellhouse door
  if((cp>20 && cp<91)||cp>124||cp==16)      // Draw cave gfx & wellhouse
  {
    if(!exits[cp][3]) draw_lib(0,0,0,0,BM_NORMAL);  // West wall
    if(!exits[cp][0]) draw_lib(0,1,14,0,BM_NORMAL); // North wall
    if(!exits[cp][2]) draw_lib(0,2,28,0,BM_NORMAL); // East wall
  }
  if(location[N_TORCH_LIT]==CARRIED) draw_lib(0,7,148,0,BM_NORMAL);  // Draw torch icon
  if(cp>90 && cp<125||cp==18) draw_lib(0,8,14+2*(cp&3),0,BM_NORMAL); // Draw tree
  if(cp==L_WEREWOLF) draw_lib(0,11,17,0,BM_NORMAL); // Draw werewolf
  if(cp==L_VAMPIRE)  draw_lib(0,9,17,0,BM_NORMAL);  // Draw vampire

  Wrap(lshort[cp]); // A function of what description mode is active and have we been here before
  if(((char)mode-(char)visited[cp]>0)||look) Wrap(llong[cp]);
  for(i=1;i<=NUM_OBJ;i++)
    if(location[i]==cp && !moved[i]) Wrap(init_obj[i]);
  if(countobj(cp))
  {
    puts("You can also see:");
    listobj(cp);
  }
  if(cp<91||cp>144) visited[cp]=TRUE;  // Not in forest or maze
  if(cp==L_STREAM_WEST||cp==L_CHASM_WEST) draw_lib(0,13,28,0,BM_NORMAL); // Draw west side
  if(cp==L_STREAM_EAST||cp==L_CHASM_EAST) draw_lib(0,13,0,0,BM_FLIP_X);  // Draw east side
  if(location[N_PLANK]==cp)
  {
    if(cp==L_STREAM_WEST||cp==L_STREAM_EAST) Wrap("The plank is lying across the stream.");
    if(cp==L_CHASM_WEST||cp==L_CHASM_EAST) Wrap("The plank is bridging the chasm.");
  }
  if(cp==L_GLASS)
  {
    draw_lib(0,3,0,0,BM_NORMAL); // Draw glass
    if(glass_cut) Wrap("A few jagged glass fragments surround the passage to the west.");
    else Wrap("The passage to the west is sealed off by a large sheet of darkened glass.");
  }

  if(cp==L_GATE)
  {
    if(gate_oiled==2) Wrap("There is a passage to the north through an open gate.");
    else
    {
      draw_lib(0,5,14,0,BM_NORMAL); // Draw gate
      Wrap("A passage to the north is blocked off by a rusty old gate.");
    }
 }
  if(cp==L_WIRE)
  {
    if(wire_cut) Wrap("A passage leads south through some strands of barbed wire.");
    else
    {
      TGraph_draw_hline(main_module.m_gfx,0,21,42); // Draw barb wire line
      Wrap("A passage to the south is blocked by a tangle of barbed wire.");
    }
  }
  if(cp==L_BASILISK)
  {
    draw_lib(0,12,14,0,BM_NORMAL); // Draw basilisk
    if(basilisk_dead) Wrap("There is a stone statue of a basilisk here.");
    else
    {
      Wrap("You hear movement in the shadows. Suddenly\
 a basilisk comes rushing across the floor at you!");
      sleep(4000);
      if(location[N_MIRROR]==CARRIED)
      {
        Wrap("The basilisk's deadly gaze tracks up towards your face.\
 You are frozen with horror for a second, as if in anticipation of your fate.");
        more();
        Wrap("Before you can do anything, the creature looks into the mirror you\
 are holding. There is a single screech of horror, abruptly cut off. Its outline\
 appears to flicker for a moment, and its movement towards you comes to a halt.");
        more();
        Wrap("You sigh with relief as the ossified corpse obviously presents no further danger.");
        basilisk_dead=TRUE;
      }
      else
      {
        Wrap("Before you can react, the basilisk's deadly gaze tracks across your face.");
        more();
        Wrap("The last thought that flashes through your brain before it\
 stops thinking forever is that the thing looks almost cute from this angle.");
        game_over=TRUE;
      }
      more();
    }
  }
  if(cp==L_WEEDS)
  {
    if(weeds_dead)
    {
      draw_lib(0,17,14,0,BM_NORMAL); // Draw dead weeds
      Wrap("The blackened remains of some weeds\
 lie on the floor of the passage to the north.");
    }
    else
    {
      draw_lib(0,16,14,0,BM_NORMAL); // Draw weeds
      Wrap("The passage north is blocked by a dense growth of weeds.");
    }
  }
  if(cp==L_PLANT)
  {
    if(plant_watered)
    {
      draw_lib(0,15,18,0,BM_NORMAL); // Draw big plant
      Wrap("A tall plant is growing up through the hole.");
    }
    else
    {
      draw_lib(0,14,18,0,BM_NORMAL); // Draw small plant
      Wrap("A smallish plant is growing under the hole.");
    }
  }
  if(cp==L_DOOR)
  {
    if(door_open==1) puts("An open door leads north.");
    else
    {
      draw_lib(0,4,14,0,BM_NORMAL); // Draw door
      Wrap("The way north is blocked by a locked door.");
    }
  }
  SKIP_SCENERY:
  if(cp==L_OGRE)
  {
    draw_lib(0,10,17,0,BM_NORMAL); // Draw ogre
    if(location[N_RING]==WORN) Wrap("The ogre cannot\
 see you while you are wearing the ring of invisibility.");
    else
    {
      puts("The ogre sees you.");
      ogre_death();
      return;
    }
  }
  if(!exits[cp][1])  // Draw south wall line
  {
    TGraph_set_color(main_module.m_gfx,CLR_WHITE);
    TGraph_draw_hline(main_module.m_gfx,2,26,40);
    TGraph_set_color(main_module.m_gfx,CLR_BLACK);
  }
  if(cp==L_VAMPIRE &&(location[N_CRUCIFIX]==WORN || location[N_CRUCIFIX]==CARRIED))
    Wrap("The vampire glances back and forth between the crucifix you are carrying and your\
 jugular vein, but seems to be of the opinion that discretion is the better part of valour.");
  look=0;
}

void get(int o)
{
 int i,tot_weight;
  if(location[o]==CARRIED||location[o]==WORN)
  {
    puts("You already have it!");
    return;
  }
  if(weight[o]>MAXWEIGHT)
  {
    puts("It's too heavy to carry.");
    return;
  }
  tot_weight=0;
  for(i=1;i<=NUM_OBJ;i++)
    if(location[i]==CARRIED||location[i]==WORN) tot_weight+=weight[i];
  if(tot_weight+weight[o] > MAXWEIGHT)
  {
    puts("You're carrying too much already.");
    return;
  }
  location[o]=CARRIED;
  if(o==N_STONE&&moved[N_STONE]==FALSE)
  {
    Wrap("You pick up the stone and notice a key that had been hidden underneath it.");
    location[N_KEY]=cp;
    moved[N_STONE]=TRUE;
    return;
  }
  if(o==N_TOAD)
  {
    Wrap("This species of toad secretes a powerful nerve poison as a defence\
 against predators and acquisitive adventurers. As you touch its skin you\
 absorb some of the poison. It works very rapidly. You die within minutes.");
    game_over=TRUE;
    return;
  }
  puts("Taken.");
  moved[o]=TRUE;
}

void drop(int o)
{
  if(location[o]==WORN)
  {
    puts("You'll have to remove it first.");
    return;
  }
  if(location[o]!=CARRIED)
  {
    puts("You're not holding that.");
    return;
  }
  puts("Dropped.");
  location[o]=cp;
  if(o==N_PLANK)
  {
    if(cp==L_STREAM_WEST||cp==L_STREAM_EAST)
      Wrap("It just extends across the width of the stream.");
    if(cp==L_CHASM_WEST||cp==L_CHASM_EAST)
      Wrap("It just extends across the width of the chasm.");
  }
  if(o==N_RING&&cp==L_OGRE)
  {
    Wrap("Unfortunately, the ogre notices you now\
 that you are no longer wearing the magic ring.");
    ogre_death();
  }
}

void nogo(void)
{
  puts("You can't go that way.");
}

int countobj(int l)
{
 int i,objects;
  objects=0;
  for(i=1;i<=NUM_OBJ;i++)
    if(location[i]==l && moved[i])  objects++;
 return objects;
}

int listobj(int l)
{
 int i,objects,returnobjects;
  returnobjects=objects=countobj(l);
  for(i=1;i<=NUM_OBJ;i++)
  {
    if(location[i]==l && moved[i])
    {
      strcpy(buffer,obj[i]);
      objects--;
      if(objects>1)  strcat(buffer,", ");    // Using strcat and a single print to ensure
      if(objects==1) strcat(buffer," and "); // no splitting up of word and punctuation
      if(objects==0) strcat(buffer,".");
      Wrap(buffer);
    }
  }
 return returnobjects;
}

void spray_death(void)
{
  location[N_WEEDKILLER]=NOWHERE;
  location[N_PACKET]=CARRIED;
  if(location[N_MASK]==WORN)
    Wrap("Clouds of toxic chemical float around your head. You\
 sniff the air anxiously, but the gas mask filters it all out.");
  else
  {
    Wrap("You have been unconsciously holding your breath while the\
 weedkiller does its work, but some of the stuff gets into your lungs\
 anyway. You begin to feel dizzy and sick.");
    more();
    Wrap("Suddenly an invisible hand seems to clamp down on your chest. Your\
 muscles are paralyzed and you are unable to breathe. You die by slow suffocation.");
  game_over=TRUE;
    }
}

void ogre_death(void)
{
  beep(0);
  Wrap("The ogre leaps upon you with a bellow of rage. You are savagely butchered\
 in a manner far too hideous to be explicitly described in a family game. Your remains\
 are left for a couple of weeks to become nicely rotten, then eaten with relish.");
  game_over=TRUE;
}

int check_werewolf(void)
{
  if(cp==L_WEREWOLF && werewolf_dead==1)
  {
    beep(0);
    Wrap("You start to run for the exit, but the werewolf is much faster than you are.\
 It reaches you and rips your throat out, then gorges itself on your flesh and blood.");
    game_over=TRUE;
    return TRUE;
  }
 return FALSE;
}

int yesno(void) // Returns TRUE for Y input, FALSE for N
{
 int c;
  do
    c=_getch();
  while(c!='y' && c!='Y' && c!='n' && c!='N');
 return(c=='y' || c=='Y');
}

void do_command(void)
{
 int i,j,k;
  i=j=k=0;
  gametime++;
  switch(v)
  {
    case(V_NORTH):
      if(check_werewolf()) return;
      if(exits[cp][0])
      {
        cp=exits[cp][0];
        desc_loc();
        return;
      }
      if(cp==L_TREE)
      {
        if(location[N_TREE]==NOWHERE)
        {
          cp=20;
          desc_loc();
          return;
        }
        puts("The tree blocks your way.");
        return;
      }
      if(cp==L_WEEDS)
      {
        if(weeds_dead)
        {
          cp=67;
          desc_loc();
          return;
        }
        Wrap("The weeds form a tangle too dense to struggle through.");
        return;
      }
      if(cp==L_GATE)
      {
        if(gate_oiled==2)
        {
          cp=39;
          desc_loc();
          return;
        }
        Wrap("You can't walk through the closed gate.");
        return;
      }
      if(cp==L_DOOR)
      {
        if(door_open==1)
        {
          cp=64;
          desc_loc();
          return;
        }
        puts("The locked door bars your way.");
        return;
      }
      nogo();
      return;
    case(V_SOUTH):
      if(check_werewolf()) return;
      if(exits[cp][1])
      {
        cp=exits[cp][1];
        desc_loc();
        return;
      }
      if(cp==L_WIRE)
      {
        if(wire_cut)
        {
          cp=37;
          desc_loc();
          return;
        }
        puts("The barbed wire blocks your way.");
        return;
      }
      nogo();
      return;
    case(V_EAST):
EAST:
      if(exits[cp][2])
      {
        cp=exits[cp][2];
        desc_loc();
        return;
      }
      if(cp==L_STREAM_WEST)
      {
        if(location[N_PLANK]==L_STREAM_WEST)
        {
          cp=L_STREAM_EAST;
          desc_loc();
          return;
        }
        puts("The stream blocks your path.");
        return;
      }
      if(cp==L_CHASM_WEST)
      {
        if(location[N_PLANK]==L_CHASM_WEST)
        {
          location[N_PLANK]=cp=L_CHASM_EAST;
          desc_loc();
          return;
        }
        puts("The chasm blocks your way.");
        return;
      }
      nogo();
      return;
    case(V_WEST):
WEST:
      if(exits[cp][3])
      {
        cp=exits[cp][3];
        desc_loc();
        return;
      }
      if(cp==L_STREAM_EAST)
      {
        if(location[N_PLANK]==L_STREAM_EAST)
        {
          cp=L_STREAM_WEST;
          desc_loc();
          return;
        }
        puts("The stream blocks your path.");
        return;
      }
      if(cp==L_CHASM_EAST)
      {
        if(location[N_PLANK]==L_CHASM_EAST)
        {
          location[N_PLANK]=cp=L_CHASM_WEST;
          desc_loc();
          return;
        }
        puts("The chasm blocks your way.");
        return;
      }
      if(cp==L_GLASS)
      {
        if(glass_cut)
        {
          cp=L_BEYOND_GLASS;
          desc_loc();
          return;
        }
        puts("The glass blocks your way.");
        return;
      }
      nogo();
      return;
    case(V_LOOK): look=1; desc_loc(); return;
    case(V_SCORE):
      for(i=1;i<=NUM_OBJ;i++)
        if(location[i]==L_DROPZONE) j+=value[i];
      sprintf(t,"You have scored %d points in %d moves.",j,gametime);
      Wrap(t);
      if(j==100)
      {
        MSequence_play_background(&mus); // Play 'Morrowwind Theme' song
        Wrap("CONGRATULATIONS! You have scored maximum points and completed the game!");
        more();
        game_over=TRUE;
      }
      return;
    case(V_HELP): Wrap("Your only help is to examine everything. Moo-ha-ha-ha...");
      return;
    case(V_OPEN):
      if(n==N_SAFE_OPEN)
      {
        puts("It's already open.");
        return;
      }
      if(n==N_FOLDER) goto EXAMINE;
      if(n==N_GATE)
      {
        if(gate_oiled==2)
        {
          puts("It's already open.");
          return;
        }
        if(gate_oiled==0)
        {
          puts("It's too stiff to open.");
          return;
        }
        puts("The gate opens with a noisy squeal.");
        gate_oiled=2;
        return;
      }
      if(n==N_DOOR)
      {
        if(door_open==1)
        {
          puts("It's already open.");
          return;
        }
        if(location[N_KEY]!=CARRIED)
        {
          Wrap("It's locked and you haven't got the key.");
          return;
        }
        if(door_open==2)
        {
          Wrap("The door is quite badly damaged and\
 the keyhole is smashed. You can't open it now.");
          return;
        }
        Wrap("You insert the key in the lock and turn. Nothing happens. You jiggle\
 the key around and exert more pressure. Slowly it turns. The door creaks open.");
        door_open=TRUE;
        return;
        }
      if(n==N_SAFE_LOCKED)
      {
        puts("Enter combination number:");
        gets(buffer);
        if(strcmp(buffer,"56294"))
        {
          Wrap("You turn the dials to that number but hear no\
 click. You pull on the door anyway but it doesn't open.");
          return;
        }
        Wrap("You turn the dial to that number\
 and hear a loud click. The door swings open.");
        location[N_SAFE_LOCKED]=NOWHERE;
        location[N_SAFE_OPEN]=L_SAFE;
        if(moved[N_EMERALD]==FALSE)
        {
          location[N_EMERALD]=L_SAFE;
          puts("You see a beautiful emerald inside.");
        }
        if(moved[N_FOLDER]==FALSE)
        {
          location[N_FOLDER]=L_SAFE;
          puts("You see a plain brown folder inside.");
        }
        return;
      }
      Wrap("There's no point in trying to open that.");
      return;
    case(V_WAVE):
      if(waved)
      {
        Wrap("The damage has been done. There's no way you can undo it now.");
        return;
      }
      Wrap("You start to wave vigorously. No effect is immediately\
 apparent. However, you are generating waves of gravitational energy\
 which radiate in all directions at the speed of light.");
      more();
      Wrap("These waves are incredibly weak but as luck would have it they\
 happen to be at just the right frequency to resonate with the detector apparatus\
 of an alien interstellar probe ship on the edge of the Solar System.");
      more();
      Wrap("The ship immediately sends a message to its home planet to the effect\
 that intelligent life has been detected on Earth. Within days a mighty battle\
 fleet is on its way with the mission of utterly destroying this planet.");
      more();
      Wrap("It will arrive within a hundred years.\
 You have sealed the fate of the human race.");
      waved=TRUE;
      return;
    case(V_CUT):
CUT:
      if(n==N_FALLEN_TREE)
      {
        puts("I think your point has been made.");
        return;
      }
      if(n==N_TREE)
      {
        if(location[N_AXE]!=CARRIED)
        {
          Wrap("Now is the time to put all those hours playing\
 Karate Kid 2 to some good use! With a blood-curdling yell, you chop the base\
 of the tree with your hand. The tree infuriatingly fails to fall down.");
          return;
        }
        Wrap("You swing the axe at the base of the tree trunk again\
 and again, cutting deeper and deeper into the wood. Finally the tree\
 topples with a mighty roar. However, you can now go north.");
        location[N_TREE]=NOWHERE;
        location[N_FALLEN_TREE]=L_TREE;
        return;
      }
      if(n==N_GLASS)
      {
        if(glass_cut)
        {
          puts("There's no need to overdo it!");
          return;
        }
        if(location[N_DIAMOND]!=CARRIED)
        {
          if(location[N_HACKSAW]==CARRIED)
          {
            Wrap("You can't get any purchase on the glass with the hacksaw.");
            return;
          }
          if(location[N_AXE]==CARRIED)
          {
            Wrap("You swing the axe at the glass! It strikes with a dull thud but\
 the glass is a special shatterproof variety and the blade merely bounces off.");
            return;
          }
          if(location[N_EMERALD]==CARRIED)
          {
            Wrap("You try scraping the emerald against the glass, but it\
 doesn't seem to be quite hard and sharp enough.");
            return;
          }
          puts("You've nothing sharp enough.");
          return;
        }
        Wrap("You press the point of the diamond against the glass hard and cut a\
 long groove in it. You extend the groove until it forms a complete circle. A couple\
 of hard kicks suffice to smash the weakened glass out. The way west is now clear.");
        glass_cut=TRUE;
        return;
      }
      if(n==N_WIRE)
      {
        if(wire_cut)
        {
          puts("You've already done that.");
          return;
        }
        if(location[N_HACKSAW]!=CARRIED)
        {
          if(location[N_AXE]==CARRIED)
          {
            Wrap("You swing the axe at the tangle of wire but the wire bends\
 and the blade gets tangled in it. You spend half a minute removing it.");
            return;
          }
          puts("You've no suitable cutting implement.");
          return;
        }
        Wrap("You sit down and diligently start sawing away at the strands of wire.\
 A long time later, you cut through the last strand. Your way north is now clear.");
        wire_cut=TRUE;
        return;
      }
      if(n==N_DOOR)
      {
        if(door_open==1)
        {
          Wrap("The door no longer presents any obstacle.");
          return;
        }
        if(location[N_AXE]!=CARRIED)
        {
          if(location[N_HACKSAW]==CARRIED)
          {
            Wrap("You can't get the hacksaw blade into the door.");
            return;
          }
          Wrap("You've no tool capable of chopping down a door.");
          return;
        }
        if(door_open==2)
        {
          Wrap("You attack the door again with the axe.\
 Aftermuch effort you succeed in smashing it open.");
          door_open=1;
          return;
        }
        Wrap("You attack the door with the axe. You seem to have\
 done some damage, but the door still stands in your way.");
        door_open=2;
        return;
      }
      if(n==N_PLANT)
      {
        if(location[N_AXE]!=CARRIED)
        {
          Wrap("You're not carrying an axe to chop it down with.");
          return;
        }
        Wrap("You swing the axe at the plant. Surprisingly,\
 the blade merely bounces off the soft-looking stem.");
        return;
      }
      Wrap("There's no point in trying to damage that.");
      return;
    case(V_LIGHT):
      if(n==N_MATCHES)
      {
        Wrap("You light a match. It burns for a short time before going out.");
        return;
      }
      if(n==N_TORCH_LIT)
      {
        puts("It's already alight.");
        return;
      }
      if(location[N_MATCHES]!=CARRIED)
      {
        puts("You've no matches to light it with.");
        return;
      }
      if(n!=N_TORCH_UNLIT)
      {
        Wrap("There's no point in trying to light that.");
        return;
      }
      Wrap("You strike a match and set the torch\
 alight. It burns with a bright yellow flame.");
      location[N_TORCH_LIT]=location[N_TORCH_UNLIT];
      location[N_TORCH_UNLIT]=NOWHERE;
      return;
    case(V_OIL):
      if(location[N_CAN]==CARRIED)
      {
        puts("The oil's all been used up.");
        return;
      }
      if(location[N_OIL]!=CARRIED)
      {
        puts("You've nothing to oil it with.");
        return;
      }
      if(n!=N_GATE)
      {
        Wrap("There's no point in trying to lubricate that.");
        return;
      }
      Wrap("You apply the oil to the rusty hinges.\
 They ought to move more easily now.");
      gate_oiled=1;
      location[N_CAN]=CARRIED;
      location[N_OIL]=NOWHERE;
      return;
    case(V_EXAMINE):
EXAMINE:
      if(n==N_GLASS)
      {
        if(glass_cut)
        {
          Wrap("A few jagged shards of glass still line the corridor.");
          return;
        }
        Wrap("A solid sheet of glass blocks the corridor.");
        return;
      }
      if(n==N_WEEDS)
      {
        if(weeds_dead)
        {
          puts("Dead scraps of weed litter the floor.");
          return;
        }
        Wrap("The way north is blocked by a dense tangle of weeds.");
        return;
      }
      if(n==N_WIRE)
      {
        if(wire_cut)
        {
          Wrap("A gap opens to the south through the barbed wire.");
          return;
        }
        Wrap("Strands of barbed wire stretch\
 across the corridor, blocking the way south.");
        return;
      }
      if(n==N_GATE)
      {
        if(gate_oiled==2)
        {
          puts("The gate is open.");
          return;
        }
        puts("The gate is closed.");
        return;
      }
      if(n==N_PLANT)
      {
        if(plant_watered)
        {
          Wrap("The plant now grows up to the\
 ceiling and the tip extends through the hole.");
          return;
        }
        Wrap("The plant is small and nondescript-looking. It looks like\
 a generic plant rather than any particular species you are familiar with.");
        return;
      }
      if(n==N_DOOR)
      {
        if(door_open==0)
        {
          puts("The door is locked.");
          return;
        }
        if(door_open==1)
        {
          puts("The door is open.");
          return;
        }
        Wrap("The door is locked. It seems damaged,\
 as if some vandal had attacked it with an axe.");
        return;
      }
      Wrap(long_obj[n]);
      return;
    case(V_SAVE):/*
      Wrap("Please enter pathname(default is ");
      Wrap(filename);
      Wrap(") : ");
     gets(buffer);
     if(buffer[0])
      strcpy(filename,buffer);
      filehandle = open(filename,O_CREAT | O_TRUNC | O_RDWR | O_BINARY,0777);
      if(filehandle < 0)
        goto FILE_ERROR;
        write(filehandle,location+1,(long)NUM_OBJ);
        write(filehandle,moved+1,(long)NUM_OBJ);
        write(filehandle,visited+1,(long)NUM_LOC);
        write(filehandle,flag_base,(long)FLAGS_SIZE);
       write(filehandle,&gametime,sizeof(gametime));
      close(filehandle);*/
      return;
    case(V_LOAD):
      if(n==0)
      {/*
        Wrap("Please enter pathname(default is ");
        Wrap(filename);
    Wrap(") : ");
    gets(buffer);
    if(buffer[0])
        strcpy(filename,buffer);
    filehandle = open(filename,O_RDWR | O_BINARY);
    if(filehandle < 0)
        goto FILE_ERROR;
    read(filehandle,location+1,(long)NUM_OBJ);
    read(filehandle,moved+1,(long)NUM_OBJ);
    read(filehandle,visited+1,(long)NUM_LOC);
    read(filehandle,flag_base,(long)FLAGS_SIZE);
    read(filehandle,&gametime,sizeof(gametime));
    close(filehandle);*/
        desc_loc();
        return;
      }
      if(n==N_GUN_LOADED)
      {
        puts("It's already loaded.");
        return;
      }
      if(n!=N_GUN_UNLOADED)
      {
        puts("You can't load that.");
        return;
      }
      if(location[N_BULLET]!=CARRIED)
      {
        puts("You don't have any ammunition.");
        return;
      }
      puts("The gun is now loaded with one bullet.");
      location[N_GUN_LOADED]=location[N_GUN_UNLOADED];
      location[N_GUN_UNLOADED]=location[N_BULLET]=NOWHERE;
      return;
FILE_ERROR:
      puts("ERROR in accessing disk.");
      return;
    case(V_OFF):
      if(n!=N_TORCH_LIT)
      {
        puts("That's not alight!");
        return;
      }
      puts("You snuff out the torch.");
      location[N_TORCH_UNLIT]=location[N_TORCH_LIT];
      location[N_TORCH_LIT]=NOWHERE;
      return;
    case(V_GET):
      if(n==N_ALL)
      {
        for(i=1;i<=NUM_OBJ;i++)
        {
          if(location[i]==cp)
          {
            Wrap(obj[i]);
            get(i);
            k=TRUE;
          }
          if(game_over) return; // Trying to get some things is fatal
        }
        if(!k) puts("There's nothing here to get!");
        return;
      }
      if(n>33)
      {
        puts("You can't carry that.");
        return;
      }
      get(n);
      return;
    case(V_DROP):
      if(n==N_ALL)
      {
        for(i=1;i<=NUM_OBJ;i++)
        {
          if(location[i]==CARRIED)
          {
            Wrap(obj[i]);
            drop(i);
            k=TRUE;
          }
          if(game_over) return;
        }
        if(!k) puts("You have nothing to drop!");
        return;
      }
      drop(n);
      return;
    case(V_INV):
      puts("You are carrying");
      if(!listobj(CARRIED)) puts("nothing.");
      if(countobj(WORN))
      {
        puts("You are wearing");
        listobj(WORN);
      }
      return;
    case(V_QUIT):
      puts("Are you sure? (y/n)");
      game_over=yesno();
      return;
    case(V_CLOSE):
      if(n==N_SAFE_OPEN)
      {
        puts("You swing the door of the safe shut.");
        if(!moved[N_EMERALD]) location[N_EMERALD]=NOWHERE;
        if(!moved[N_FOLDER]) location[N_FOLDER]=NOWHERE;
        location[N_SAFE_LOCKED]=L_SAFE;
        location[N_SAFE_OPEN]=NOWHERE;
        return;
      }
      if(n==N_SAFE_LOCKED)
      {
        puts("It's already shut.");
        return;
      }
      if(n==N_GATE)
      {
        if(gate_oiled!=2)
        {
          puts("It's already closed.");
          return;
        }
        gate_oiled=1;
        puts("The gate swings shut.");
        return;
      }
      if(n==N_DOOR)
      {
        if(door_open!=1)
        {
          puts("It isn't open.");
          return;
        }
        puts("The door is stuck. It won't close.");
        return;
      }
      puts("You can't close that.");
      return;
    case(V_CLIMB):
      if(cp==L_TREE)
      {
        if(location[N_TREE]==NOWHERE)
        {
          puts("You can't climb a chopped-down tree!");
          return;
        }
        puts("You climb up the tree.");
        cp=L_TREETOP;
        desc_loc();
        return;
      }
      if(cp==L_TREETOP)
      {
        puts("You scramble back down the tree.");
        cp=L_TREE;
        desc_loc();
        return;
      }
      if(cp==L_PLANT)
      {
        if(!plant_watered)
        {
          puts("The plant's too small to climb.");
          return;
        }
        Wrap("You climb up the plant and through the hole in the ceiling.");
        cp=L_TOP_PLANT;
        desc_loc();
        return;
      }
      if(cp==L_TOP_PLANT)
      {
        puts("You slide down the plant stalk.");
        cp=L_PLANT;
        desc_loc();
        return;
      }
      Wrap("There's nothing around here worth climbing.");
      return;
    case(V_JUMP):
      if(cp==L_STREAM_WEST||cp==L_STREAM_EAST)
      {
        Wrap("You move back a few steps and take a running jump at\
 the stream. Despite your valiant attempt, you don't really come\
 anywhere near jumping across it and merely fall into the water.");
        more();beep(1);
        Wrap("This wouldn't matter so much were it not for the fact that the stream\
 is full of piranha fish (the brightly coloured fish you saw swimming in it). You\
 can probably imagine the rest. Anyway, suffice it to say that you end up fairly dead.");
        game_over=TRUE;
        return;
      }
      if(cp==L_CHASM_WEST||cp==L_CHASM_EAST)
      {
        Wrap("You walk back a reasonable distance and make a valiant attempt\
 to jump across the chasm from a running start. Unfortunately you don't quite\
 make it. Actually, I'm being charitable here.");
        more();beep(1);
        Wrap("To tell the truth, you don't come anywhere near making it. You plummet\
 into the depths. You forget to count the seconds as you fall and are thus unaware\
 of the precise depth of the chasm but it seems to be deep enough to kill you anyway.");
        game_over=TRUE;
        return;
      }
      if(cp==L_TREETOP)
      {
        Wrap("You close your eyes, spread your arms wide and leap  from the\
 branches of the tree. There is a glorious moment of free fall with the air\
 rushing past at a tremendous speed, then you strike the ground head first.");
        more();beep(1);
        Wrap("The impact bends your head back, breaking your neck\
 and severing your  spinal cord. Death is instant and painless.");
        game_over=TRUE;
        return;
      }
      puts("Whee! Such fun!");
      return;
    case(V_CROSS):
      if(cp==L_CHASM_WEST || cp==L_STREAM_WEST) goto EAST;
      if(cp==L_CHASM_EAST || cp==L_STREAM_EAST) goto WEST;
      puts("Just type a direction please.");
      return;
    case(V_SPRAY):
SPRAY:
      if(location[N_PACKET]==CARRIED)
      {
        puts("The weedkiller's all used up.");
        return;
      }
      if(location[N_WEEDKILLER]!=CARRIED)
      {
        puts("You've nothing to use on it.");
        return;
      }
      if(n==N_WEEDS)
      {
        Wrap("You aim the nozzle at the weeds and press the  trigger. A jet of\
 chemical squirts out, disperses into a mist of droplets  and settles over the plants.");
        more();
        Wrap("The effect is almost immediate. The plants turn  brown, shrivel up and die.\
 Only a few tattered remnants still lie in the  passage. Your way north is now clear.");
        spray_death();
        weeds_dead=TRUE;
        return;
      }
      Wrap("That isn't a weed! Why waste weedkiller on it?");
      return;
    case(V_WEAR):
      if(location[n]==WORN)
      {
        puts("You're already wearing it!");
        return;
      }
      if(location[n]!=CARRIED)
      {
        puts("You're not holding it.");
        return;
      }
      if(n!=N_MASK && n!=N_RING && n!=N_CRUCIFIX)
      {
        puts("That cannot be worn.");
        return;
      }
      location[n]=WORN;
      puts("Worn.");
      if(n==N_RING) Wrap("This is a magic ring, and confers a degree of\
 invisibility, at least to something with low intelligence and bad vision.");
      return;
  case(V_REMOVE):
      if(location[n]!=WORN)
      {
        puts("You're not wearing it.");
        return;
      }
      puts("Removed.");
      location[n]=CARRIED;
      if(n==N_RING && cp==L_OGRE)
      {
        Wrap("Unfortunately, the ogre notices you\
 now that you are no longer wearing the magic ring.");
        ogre_death();
      }
      return;
    case(V_WATER):
      if(location[N_WATER]!=CARRIED)
      {
        puts("You're not carrying any water.");
        return;
      }
      if(n!=N_PLANT)
      {
        puts("It isn't in need of moisture.");
        return;
      }
      Wrap("You pour the water over the leaves\
 of the plant and the ground at its base.");
      if(!plant_watered)
      {
        Wrap("Nothing seems to happen for a short time. Then, suddenly, the plant\
 starts to expand. Shrivelled leaves unfurl and the stem creeps higher and higher.");
        more();
        Wrap("New branches grow out from the stem and sprout more leaves. Finally\
 the growth stops but by now the plant has grown up through the hole in the roof.");
        plant_watered=TRUE;
      }
      else
        Wrap("Nothing happens. I think the plant already has enough water.");
        location[N_WATER]=NOWHERE;
        location[N_BUCKET]=CARRIED;
        return;
    case(V_FILL):
      if(location[n]!=CARRIED && location[n]!=WORN)
      {
        puts("You haven't got it.");
        return;
      }
      if(n==N_WATER||n==N_WEEDKILLER||n==N_OIL)
      {
        puts("It's already full.");
        return;
      }
      if(cp!=L_STREAM_WEST && cp!=L_STREAM_EAST)
      {
        Wrap("There's nothing around here to fill it with.");
        return;
      }
      if(n==N_PACKET||n==N_CAN)
      {
        Wrap("You dip it into the stream in an attempt to fill it but the\
 opening is too narrow and it's the wrong shape. Your attempts are unsuccessful.");
        return;
      }
      if(n!=N_BUCKET)
      {
        puts("You can't fill that!");
        return;
      }
      Wrap("You dip the bucket into the stream and fill it with water.");
      location[N_BUCKET]=NOWHERE;
      location[N_WATER]=CARRIED;
      return;
    case(V_EMPTY):
      if(location[n]!=CARRIED && location[n]!=WORN)
      {
        puts("You're not holding it.");
        return;
      }
      if(n==N_CAN||n==N_PACKET||n==N_BUCKET)
      {
        puts("It's already empty.");
        return;
      }
      if(n==N_OIL)
      {
        Wrap("You open the can and pour the oil out onto\
 the ground. It slowly trickles away in black rivulets.");
        location[N_OIL]=NOWHERE;
        location[N_CAN]=CARRIED;
        return;
      }
      if(n==N_WEEDKILLER)
      {
        Wrap("You unscrew the cap and tip the packet upside down. The\
 liquid inside pours out onto the ground and runs away in a long stream.");
        location[N_WEEDKILLER]=NOWHERE;
        location[N_PACKET]=CARRIED;
        return;
      }
      if(n==N_WATER)
      {
        Wrap("You tip over the bucket and pour the water onto the\
 ground. It makes a large damp patch which slowly evaporates dry.");
        location[N_WATER]=NOWHERE;
        location[N_BUCKET]=CARRIED;
      }
      puts("You can't empty that!");
      return;
    case(V_THROW):
      if(location[n]!=CARRIED)
      {
        puts("You're not holding it.");
        return;
      }
      if(cp==L_STREAM_WEST||cp==L_STREAM_EAST)
      {
        Wrap("It falls into the stream with a splash and is lost.");
        location[n]=NOWHERE;
        return;
      }
      if(cp==L_CHASM_WEST||cp==L_CHASM_EAST)
      {
        Wrap("It plummets into the depths of the earth and is lost forever.");
        location[n]=NOWHERE;
        return;
      }
      if(cp==L_TREETOP)
      {
        Wrap("You fling it from the branches of the tree. It lands on the ground below.");
        location[n]=L_TREE;
        return;
      }
      Wrap("You hurl it a short distance. It lands on\
 the ground. It doesn't seem damaged by the experience.");
      location[n]=cp;
      return;
    case(V_UNLOAD):
      if(location[n]!=CARRIED)
      {
        puts("You're not holding it.");
        return;
      }
      if(n==N_GUN_UNLOADED)
      {
        puts("It's not loaded.");
        return;
      }
      if(n==N_GUN_LOADED)
      {
        Wrap("You remove the bullet from the gun.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=location[N_BULLET]=CARRIED;
        return;
      }
      puts("You can't unload that!");
      return;
    case(V_FIRE):
FIRE:
      if(location[n]!=CARRIED)
      {
        puts("You're not holding it.");
        return;
      }
      if(n==N_GUN_UNLOADED)
      {
        Wrap("You pull the trigger of the gun.\
 There is a loud click but nothing else happens.");
        return;
      }
      if(n==N_GUN_LOADED)
      {
        Wrap("You pull the trigger of the gun. There is a\
 loud BANG. The bullet doesn't seem to have hit anything.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      Wrap("You can't fire that!");
      return;
    case(V_SHOOT):
      if(n==N_BULLET || n==N_GUN_LOADED || n==N_GUN_UNLOADED)
    goto FIRE;
      if(location[N_GUN_UNLOADED]!=CARRIED && location[N_GUN_LOADED]!=CARRIED)
      {
        puts("You don't seem to be armed.");
        return;
      }
      if(location[N_GUN_UNLOADED]==CARRIED)
      {
        puts("The gun isn't loaded.");
        return;
      }
      if(n==N_WEREWOLF)
      {
        Wrap("You aim quickly and fire. There is a loud BANG and the werewolf stops dead\
 in his tracks, a bloody hole in his chest and a look of surprise and indignation on his face.");
        more();
        Wrap("He slumps to the ground. You expect to see the body change back to human\
 form as in the movies but what actually happens is that it melts away into thin air.");
        werewolf_dead=2;
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      if(n==N_GLASS)
      {
        Wrap("You fire the gun at the pane of glass. The bullet smashes\
 through it, making a hole about an inch wide. Now all you need to\
 get past this obstacle is some way to make yourself an inch tall.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      if(n==N_OGRE)
      {
        Wrap("You aim the gun at the ogre and fire, blowing a hole clean through his\
 chest. This seems to make him a bit peeved, and the muzzle flash revealed your position.\
 With astonishing endurance, he manages to rip you apart before collapsing and dying.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      if(n==N_DOOR)
      {
        Wrap("You fire the gun at the door lock. Unfortunately, silver is not the\
 best material for an armour-piercing bullet; the mechanism is dented but not ruined.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      if(n==N_VAMPIRE)
      {
        Wrap("You fire the gun at the vampire. He staggers, but does not fall. He\
 treats you to a fangy grin and opens his cloak, showing you his bulletproof vest.");
        location[N_GUN_LOADED]=NOWHERE;
        location[N_GUN_UNLOADED]=CARRIED;
        return;
      }
      puts("There's no point in shooting at that.");
      return;
    case(V_KILL):
KILL:
      if(n==N_TREE || n==N_FALLEN_TREE) goto CUT;
      if(n==N_PLANT || n==N_WEEDS) goto SPRAY;
      if(n==N_OGRE)
      {
        Wrap("You launch a heroic attack on the monstrous\
 ogre. Unfortunately, your attack doesn't succeed.");
        ogre_death();
        return;
      }
      puts("What's the point in attacking that?");
      return;
    case(V_BREAK):
      if(n==N_GLASS)
      {
        if(glass_cut)
        {
          puts("That's already been done.");
          return;
        }
        Wrap("You attempt to smash the glass but it seems to\
 be a particularly tough variety. Your efforts are in vain.");
        return;
      }
      if(n==N_MIRROR)
      {
        Wrap("You smash the mirror into a thousand minute\
 shards of glass which scatter on the ground and are lost.");
        location[N_MIRROR]=NOWHERE;
        return;
      }
      Wrap("Senseless vandalism will get you nowhere.");
      return;
    case(V_KICK):
      if(n==N_OGRE) goto KILL;
      Wrap("Taking out your frustration on the objects around you is a good\
 way to lower your blood pressure, but it doesn't seem to be getting you anywhere.");
      return;
    case(V_FUCK):
      Wrap("It says something about human nature, doesn't it, that practically\
 everyone who writes an adventure game puts in a response to swear words.");
      return;
    case(V_BRIEF): puts("Brief descriptions now active."); mode=M_BRIEF; return;
    case(V_NORMAL): puts("Normal descriptions now active."); mode=M_NORMAL; return;
    case(V_VERBOSE): puts("Verbose descriptions now active."); mode=M_VERBOSE; return;
    case(V_SWIM):
      if(cp!=L_STREAM_WEST && cp!=L_STREAM_EAST)
      {
        Wrap("There doesn't seem to be a single\
 halfway decent swimming pool in this place.");
       return;
      }
      Wrap("You jump into the stream and start to swim across. This\
 would probably have been a more sensible thing to do were it not for\
 the inconvenient fact that the stream is full of piranha fish.");
      more();beep(0);
      Wrap("You can probably imagine the rest (teeth, screams, blood,\
 stripped bones etc). Anyway, suffice it to say that you end up fairly dead.");
      game_over=TRUE;
      return;
    }
}

ubyte oldn;    // Stores previous turn's noun for IT facility
ubyte noun_it; // Flags whether used IT this turn

//-----------------------------------------------------------------------------
// MAIN: Program entry point                                                  |
//-----------------------------------------------------------------------------
long main(int argc, char* argv[], bool start)
{
  init_module(&main_module); // Initialize module
  cWinApp_clear_screen();    // Clear Screen
  MSequence_ctor(&mus,"mw.mus");   // Create music object
  MSequence_play_background(&mus); // Play 'Morrowwind Theme'
  Graphics_set_font(main_module.m_gfx,mini_normal_font); // Set Font
  srand(clock());
  mode=M_NORMAL;  // Initialize for all games

  do{
    init();       // Initialize for this game
    puts("");
    desc_loc();   // Describe the first location to the player
    do{
      status();
      if(game_over) break;
      get_command();
      do_command();
    }while(!game_over);
    puts("Do you want to play again? (y/n)");
  }while(yesno());
  MSequence_dtor(&mus,LEAVE_MEMORY);
 return 0L;
}

void init(void)
{
 int i;
  cp=9; // Current Position (Starting room)
  glass_cut=0;
  gate_oiled=0;
  wire_cut=0;
  weeds_dead=0;
  plant_watered=0;
  werewolf_dead=0;
  vampire_gone=0;
  basilisk_dead=0;
  door_open=0;
  riddles_solved=0;
  waved=0;
  gametime=0;
  look=1; // Indicates that at start the player just wants to see the location
          // description; he hasn't moved into it from an adjoining location
  game_over=0;
  for(i=1;i<=NUM_LOC;i++) visited[i]=FALSE;
  for(i=1;i<=NUM_OBJ;i++) moved[i]=(*init_obj[i]==0);
   // If no initial description, mark it as moved from the start
  for(i=1;i<=NUM_OBJ;i++) location[i]=init_loc[i];

//  location[N_TORCH_LIT]=CARRIED; // Debug
//  location[N_PLANK]=CARRIED; // Debug

  Wrap("Welcome to Cave Adventure by Russell Wallace. Cave Adventure was originally\
 written in Basic on the Commodore 64 in the early eighties and rewritten\
 in C for the Amiga and MS-DOS computers.\nDo you want instructions? (y/n)");
  if(yesno())
  {
    Wrap("\nThe plot is simple: You start the game near an underground cave\
 system which is rumoured to have fabulous treasures. It is also rumoured to\
 contain a group of refugees from low grade horror movies who took up residence.");
    more();
    Wrap("Along with similar beings from the pages of Tolkien and suchlike.\
 Your mission is to become as rich as possible by collecting objects of the\
 first category while avoiding death at the hands of those of the second category.");
    more();
    Wrap("The scoring system is based on results, rather than getting points\
 for accomplishing tasks, you get points for collecting treasures and bringing\
 them to the designated collection point (which will be marked in the game).");
    more();
    Wrap("Input is verb-noun only (when the original version was written, that\
 was the state of the art of parser technology, and there wasn't much point in\
 writing a more advanced parser for this version.");
    more();
    Wrap("Since the puzzles are mostly the same as in the original and don't\
 require more than verb-noun). The advanced features available are GET ALL,\
 DROP ALL and IT.\nPress any key to start");
    more();
  }
}

void get_command(void)
{
 int i,j,length;
 char *p;  // Temporary storage for pointer to typed-in verb
 char *q;  // Similar for noun
LOOP:
  puts("What now?");
  gets(buffer);
  length = strlen(buffer);
  p=buffer;
  while(*p==' ')  p++;
  if(!*p) goto LOOP;  // Ignore null command
  for(i=0;p[i];i++) p[i]=tolower(p[i]);
  v=0;
  n=0;
  for(i=0;p[i] && p[i]!=' ';i++);
  p[i]=0;  // Put stop at end of verb for strcmp
  for(v=1;v<=NUM_VERB && strcmp(verb[v],p);v++);
  if(v>NUM_VERB)
  {
    for(j=0;j<NUM_VERB_SYN;j++)
      if(strcmp(verb_syn[j],p)==0)
      {
        v=verb_syn_num[j];
        goto FOUND_VERB_SYN;
      }
    sprintf(t,"I don't understand \"%s\".",p);
    Wrap(t);
    goto LOOP;
  }
FOUND_VERB_SYN:
  if(i!=length)  // If there was something after the verb(e.g. a noun)
  {
    for(q=p+i+1;*q==' ';q++); // Ignore spaces before noun
    if(*q==0) goto NO_NOUN;   // Have we ignored everything or was there some text as well as the spaces?
    i=0;                      // OK, now wipe out any spaces after the noun
    do{
      if(q[i]==' ') q[i]=0;
      i++;
    }while(q[i]);
    noun_it=FALSE;
    if(strcmp(q,"it")==0)
    {
      if(!oldn)
      {
        Wrap("I don't understand what you're referring to.");
        goto LOOP;
      }
      noun_it=TRUE;
      n=oldn;
      goto GOT_NOUN;
  }
  for(n=1;n<=NUM_NOUN && strcmp(noun[n],q);n++);
  if(n>NUM_NOUN)
  {
      for(j=0;j<NUM_NOUN_SYN;j++)
    if(strcmp(noun_syn[j],q)==0)
    {
        n=noun_syn_num[j];
        goto FOUND_NOUN_SYN;
    }
      sprintf(t,"I don't understand \"%s\".",q);
      Wrap(t);
      goto LOOP;
  }
FOUND_NOUN_SYN:
  oldn=n;
GOT_NOUN:
  if(location[n]==NOWHERE)  // Find out whether referring to the lit or
  {                         // or unlit torch, full or empty bucket etc.
    switch(n)
    {
      case(N_TORCH_UNLIT): n=N_TORCH_LIT; break;
      case(N_WEEDKILLER): n=N_PACKET; break;
      case(N_BUCKET): n=N_WATER; break;
      case(N_GUN_UNLOADED): n=N_GUN_LOADED; break;
      case(N_SAFE_LOCKED): n=N_SAFE_OPEN; break;
      case(N_TREE): n=N_FALLEN_TREE; break;
      case(N_OIL): n=N_CAN;
    }
  }  // End of condition if location[n]==NOWHERE
  if(n==N_ALL && v!=V_GET && v!=V_DROP)
  {
    sprintf(t,"You can't use the word ALL with the verb \"%s\".",p);
    Wrap(t);
    goto LOOP;
  }
  if((n==N_GLASS && cp!=L_GLASS) || (n==N_WEEDS && cp!=L_WEEDS) ||\
     (n==N_WIRE && cp!=L_WIRE) || (n==N_GATE && cp!=L_GATE) ||\
     (n==N_WEREWOLF &&(cp!=L_WEREWOLF || werewolf_dead==2)) ||\
     (n==N_SIGN && cp!=L_SIGN) ||\
     (n==N_PLANT && cp!=L_PLANT && cp!=L_TOP_PLANT) ||\
     (n==N_OGRE && cp!=L_OGRE) ||\
     (n==N_DOOR && cp!=L_DOOR) ||\
     (n==N_CHASM && cp!=L_CHASM_WEST && cp!=L_CHASM_EAST) ||\
     (n==N_STREAM && cp!=L_STREAM_WEST && cp!=L_STREAM_EAST) ||\
     (n==N_VAMPIRE && cp!=L_VAMPIRE) ||\
     (n==N_BASILISK && cp!=L_BASILISK) ||\
     (n<=NUM_OBJ && location[n]!=cp && location[n]!=CARRIED &&\
    location[n]!=WORN))
    {
      if(!noun_it)
      {
        sprintf(t,"I don't see any %s here.",q);
        puts(t);
      }
      else puts("I don't see any here.");
      goto LOOP;
    }
  } // End of condition if noun exists
NO_NOUN:
  if(n==0 && need_obj[v])
  { // Protest if the verb has to have a noun and none has been given
    sprintf(t,"I don't understand what you want to %s.",p);
    Wrap(t);
    goto LOOP;
  }
}

// Note: The reason for using puts on short sentences is it's faster than
// Wrap but of course only usable when you know for sure a sentence will
// fit on a line. Remember the Cybiko uses proportionally-spaced fonts.

