obj {
  nam = "vc_door",
  is_locked = true,
  disp = "Door",
  dsc = [[There is a {door} at the end of the hall. ]],
  act = function(s,w)
    if s.is_locked then
      p "The door is locked."
    else
      p "The door is opened."
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('vc_door');
      return
    elseif w.HIDDEN_name == name_of_key then
      p [[I turn the key in the lock and the door opens.]]
      s.is_locked = false
      enable 'vc_exit'
      return
    else
      p [[This door can only be opened with a key.]]
      return
    end
    return false
  end
}

obj {
  nam = 'vc_paper',
  HIDDEN_name = "Scrap of paper",
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = [[A {scrap of paper} is on the floor.]],
  act = function (s,w)
    p [[The typewritten scrap is part of a user manual:^
    "The DEBUGGER is designed to modify objects when the subject is located
    <...> object names can be renamed. However, the internal logic governing
    object behavior cannot be modified, because <...> add the capability
    to edit features of the location until Febr <...> ief of lab <...> tech <...>"
     ]]
    return true
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('vc_paper');
      return
    end
    return false
  end
}

room {
  nam = "loc_4f_corridor_b1",
  forcedsc = true,
  disp = "Corridor -- Block 4B",
  pic = "gfx/missing-img.gif",
  dsc = function(s, w)
    p [[^ Corridor block 4B. ]]
  end,
  way = {
    path { '#cabX1', "Computer lab", 'loc_4f_cabinetX1' },
    path { '#cabX2', "Chemical lab", 'loc_4f_cabinetX2' },
    path { '#corr_end', "The end of the corridor", 'loc_4f_corridor_b2' },
  }
}

room {
  nam = "loc_4f_cabinetX1",
  forcedsc = true,
  disp = "Computer Lab",
  pic = "gfx/missing-img.gif",
  dsc = [[ A facility full of server racks. ^
    <i>-- TODO: describe the interiors of CL. </i>
  ]],
  way = {
    path { 'vc_exit', "Exit to the corridor", 'loc_4f_corridor_b1' }:disable(),
  } 
}:with{
  'vc_door',
  'vc_paper'
}

room {
  nam = "loc_4f_cabinetX2",
  forcedsc = true,
  disp = "Chemical Lab",
  pic = "gfx/missing-img.gif",
  dsc = function(s, w)
    pn [[]]
    p [[ <i>-- TODO: write a description of this location.</i> ]]
  end,
  obj = {
    obj {
      nam = "cat_poster",
      dsc = "A {calendar} hung on the wall near the door.",
      act = "A 2018 calendar featuring a picture of a cute cat. May 30th was circled."
    }
  },
  way = {
    path { '#exit', "Exit to the corridor", 'loc_4f_corridor_b1' },
  }
}

room {
  nam = "loc_4f_corridor_b2",
  forcedsc = true,
  disp = "Corridor -- Block 4B",
  pic = "gfx/missing-img.gif",
  dsc = function(s, w)
    pn [[]]
    p [[ Corridor block 4B. At the end, you can see a stairway. ]]
  end,
  way = {
    path { '#corr1', "The beginning of the corridor", 'loc_4f_corridor_b1' },
    path { '#corr2', "Archive", 'loc_4f_cabinetX3' },
    path { '#corr3', "Restroom", 'loc_4f_toilet' },
    path { '#corr4', "Storage", 'loc_4f_storage' },
    path { '#corr5', "Stairway", 'loc_4f5f_stairs' },
  }
}

room {
  nam = "loc_4f_cabinetX3",
  forcedsc = true,
  disp = "Archive",
  pic = "gfx/missing-img.gif",
  dsc = function(s, w)
    pn [[]]
    p [[ <i>-- TODO: need to write a description here.</i> ]]
  end,
  obj = {
    obj {
      nam = "book_dear_esther",
      dsc = [[On the shelf of the closet, there is a {book} missing a cover. ]],
      act = [[
      I take the book from the shelf and became lost in its pages.^^
      "Dear Esther. I sometimes feel as if I’ve given birth to this island. Somewhere, between the longitude and latitude a split opened up and it beached remotely here. No matter how hard I correlate, it remains a singularity, an alpha point in my life that refuses all hypothesis…"^^
      Perplexed, I put the book back on the shelf.
      ]],
	  used = function(s,w)
	    if w^'DEBUGGER' then
		  p "No source code is available for this object."
		  return
	    end
	    return false
	  end
    }
  },
  way = {
    path { '#exit', "Exit to the corridor", 'loc_4f_corridor_b2' },
  },
}


obj {
  nam = "light_socket",
  disp = "Light socket",
  dsc = [[A {light socket} hangs from the wall by a wire.]],
  act = "It looks intact.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('light_socket');
      return
    elseif w.HIDDEN_name == name_of_lightbulb then
      if lookup 'broken_lightbulb' then
        p "First, you need to unscrew the burned-out light bulb."
      elseif w.is_ok then
        p "I screw the light bulb into the socket. It takes only one research institute employee to change a light bulb!"
        place(w)
        here().has_lightbulb = true
        check_storage_light()
      else
        p "I don’t see the point of replacing light bulb with the the burned-out one."
      end
      return
    elseif w.HIDDEN_name == name_of_brokenlightbulb then
      p "I don’t see the point of replacing light bulb with the the burned-out one."
      return
    end
    return false
  end
}


obj {
  nam = "broken_lightbulb",
  is_ok = false,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  HIDDEN_name = name_of_brokenlightbulb,
  dsc = [[In the light socket, there is a {burned-out light bulb}.]],
  act = "Too high!",
  inv = "A hundred watt incandescent bulb. Alas, it is useless now.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('broken_lightbulb');
      return
    elseif w.HIDDEN_name == name_of_ladder and not have 'broken_lightbulb' then
      p "I climb the ladder and unscrew the burned-out light bulb."
      take(s)
      return
    end
    return false
  end
}


obj {
  nam = "lightbulb",
  is_ok = true,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  HIDDEN_name = name_of_lightbulb,
  dsc = [[A lone {light bulb} hangs from the ceiling.]],
  act = "Too high!",
  inv = "A new incandescent light bulb.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('lightbulb');
      return
    elseif w.HIDDEN_name == name_of_ladder and not have 'lightbulb' then
      p "I climb the ladder and unscrew the light bulb."
      take(s)
      here().has_lightbulb = false
      return
    end
    return false
  end
}


room {
  nam = "loc_4f_toilet",
  forcedsc = true,
  has_electricity = true,
  has_lightbulb = true,
  disp = "Restroom",
  pic = "gfx/missing-img.gif",
  dsc = function(s, w)
    if s.has_electricity and s.has_lightbulb then
      p [[Nothing remarkable here. ]]
    else
      p [[It was too dark to see anything here. ]]
    end
  end,
  way = {
    path { '#exit', "Exit to the corridor", 'loc_4f_corridor_b2' },
  }
}:with {
  'lightbulb'
}


function check_storage_light()
  if have 'topor' then
    return
  end
  if _'loc_4f_storage'.has_lightbulb and _'loc_4f_storage'.has_electricity then
    _'topor':enable()
  else
    _'topor':disable()
  end
end


room {
  nam = "loc_4f_storage",
  has_lightbulb = false,
  has_electricity = false,
  disp = "Storage",
  pic = "gfx/missing-img.gif",
  decor = function(s, w)
    if s.has_lightbulb and s.has_electricity then
      p [[ Storage. Various things are on the shelves. ^
      <i> -- TODO: describe storage^
      -- TODO: fix axe source code </i>]]
    elseif s.has_electricity then
      p [[It was just as dark here as before.]]
    elseif s.has_lightbulb then
      p [[The light bulb still doesn’t work. It looks like there is no electricity. ]]
    else
      p [[It is too dark here to see anything.]]
    end
  end,
  enter = function(s)
    check_storage_light()
  end,
  way = {
    path { '#exit', "Exit to the corridor", 'loc_4f_corridor_b2' },
  }
}:with {
  _'topor':disable(),
  'light_socket',
  'broken_lightbulb'
}


obj {
  nam = "wood",
  disp = "Boards",
  dsc = [[The stairway to the roof is securely {boarded up}.]],
  act = "The boards are firmly fastened in place. I need to break them.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('wood');
      return
    elseif w.HIDDEN_name == name_of_topor then
      if w.is_working then
        p "With an axe, I quickly chop through the boards. The way is clear."
        s:disable()
        enable 'to_roof'
      else
        p "I can't cut the boards with a broken axe."
      end
      return
    end
    p "I can't break the boards in that manner."
  end
}


obj {
  nam = "electricity",
  is_fixed = false,
  disp = "Switch Box",
  dsc = [[Nearby you can see an open electrical {switch box}.]],
  act = function(s,w)
    if s.is_fixed then
      p "Everything looks okay."
    else
      p [[It looks like there was a short and the wire to the switch labelled "Storage" melted through. Some tape could help here, but where could I get it?]]
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('electricity');
      return
    elseif s.is_fixed then
      p "If it’s not broken, don’t fix it!"
      return
    elseif w.HIDDEN_name == name_of_tape then
      p "I de-energize the switch box, wind the tape around two ends of the melted wire and click the switch. That seemed to have done the job!"
      s.is_fixed = true
      _'loc_4f_storage'.has_electricity = true
      check_storage_light()
      return
    end
    p "That would not help here."
  end
}


room {
  nam = 'loc_4f5f_stairs',
  forcedsc = true,
  disp = "Stairway",
  pic = "gfx/missing-img.gif",
  dsc = [[ Stairway to the roof. ]],
  way = {
    path { '#to_floor_4', "To the fourth floor", 'loc_4f_corridor_b2' },
    path { 'to_roof', "To the roof", 'author_warning' }:disable(),
  }
}:with {
  'wood',
  'electricity'
}

room {
  nam = "author_warning";
  disp = "From the Author";
  noinv = true;
  decor = function(s,w)
  p([[
    ^
    We have to chat.
    ^ ^
    There can be only one ending for this game. Anton, the protagonist, must meet Ruslan
    and throw him off the roof -- because Ruslan is the one to blame for what happened
    to the main character. That's how I designed the ending of this game,
    and I won’t allow you to change it.^
    Sure, I’m well aware of the debugger. After all, without it you wouldn’t be able
    to get to that location … And you may be tempted to use it. But only one thing
    will trigger the endgame: Ruslan falling from the roof. So go ahead, to the final scene!^
    After all, the player in any game can do only what the author permits, no?
  ]])
  end;
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#agree",
    dsc = "- {I agree}",
    act = function(s)
      walk 'author_warning2'
    end
  },
  obj {
    nam = "#disagree",
    dsc = " ^- {I disagree}",
    act = function(s)
      walk 'author_warning2'
    end
  },
}


room {
  nam = "author_warning2";
  disp = "From the Author";
  noinv = true;
  decor = function(s,w)
  p([[Never mind. Your answer doesn’t matter. You can only choose among options that the author
  has provided, and the game will respond as the author envisioned.
  So click "Continue" and bring the author's idea to life. ]])
  end;
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#next",
    dsc = "{Continue}",
    act = function()
      theme_switch('game')
      walk('loc_roof')
    end
  }
}
