room {
  nam = "game_start";
  disp = "Street";
  pic = "gfx/loc_street.png",
  dsc = [[
    I like to come to work before anyone else. Maybe that's because I like to wake up early and walk the streets when there is hardly anyone on them.^
	Today is typical -- I was up at the crack of dawn and there is not a soul on the street; the noise of the city is barely audible. Beyond the bend a small plaza is visible -- that's where I have to go.
  ]];
  decor = [[
	I shiver from the morning cold and {#next|quicken my pace}.
  ]];
}:with {
  obj {
	nam = "#next",
	act = function() walk 'game_start_2' end,
    used = function(s,w)
      if w^'DEBUGGER' then
        p "No source code is available for this object."
        return
      end
      return false
    end
  }
}



room {
  nam = "game_start_2";
  disp = "Square";
  pic = "gfx/loc_square.png",
  dsc = [[
    In the daytime it's full of people -- students escape here from boring classes, young moms walk with strollers, retired people sit on benches and play chess. Perhaps it is only at such an early hour that you can walk in complete silence.
  ]];
  decor = [[
    I walk along the central path, absent-mindedly glancing around the {bench|benches}.
    Trees rustle quietly in the wind. The sun dips behind a cloud -- it looks like today will be {#weather|overcast}.
    ^
    My destination is that massive building {#next|straight ahead}.
  ]];
}:with {
  obj {
    nam = "bench";
    bench_seen = 0;
    act = function(s)
      if s.bench_seen == 0 then
        p [[The benches here were recently renovated, but vandals have already managed to spray paint graffiti all over them.]]
        s.bench_seen = 1
      else
        p [[Among all of the graffiti, the inscription "I.A.G." is repeated especially often. That sounds familiar -- is it a football club or something?]]
        s.bench_seen = 0
      end
    end;
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('bench');
        return
      end
      return false
    end
  },
  obj {
    nam = "#weather";
    act = function()
      p [[Oh not the rain again -- I'm not a big fan of rain. And I left the umbrella at home.]]
    end;
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('weather');
        return
      end
      return false
    end
  },
  obj {
	nam = "#next",
	act = function() walk 'loc_nii_entrance' end,
    used = function(s,w)
      if w^'DEBUGGER' then
        p "No source code is available for this object."
        return
      end
      return false
    end
  }
}





room {
  nam = "loc_nii_entrance";
  disp = "The Building";
  pic = "gfx/loc_prohodnaya.png";
  dsc = [[
    In Soviet times, this factory made spare parts for heavy machinery. Then the factory was closed and the building sold off bit by bit. We got several floors of the administrative building near the second entrance gate.^
    It's good that new owners are not interested in what their premises are used for -- as long as they get paid, they don't care. The company is more than happy with it.
  ]];
  decor = [[
    I stand at the entrance gate and look around. Since I quit smoking, there isn’t anything else to do here.^
	It looks like the {#parking|parking lot} on the right is never empty. The wall near the door is plastered with all sorts of {#adv|advertisements}.
	A peeling plaque is nailed to the massive {#door|entrance door}.^
  ]];
  way = {
    path {"#path_mainhall", "Entrance Gate", "author_note1"}:disable()
  }
}:with {
  obj {
    nam = "#parking",
    act = function()
      p [[There are no other parking lots nearby, so people park their cars here.]]
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('parking');
        return
      end
      return false
    end
  },
  obj {
    nam = "#adv",
    act = function()
      p [[I glance at the ads. A dozen of them offer loans on favorable terms (yeah, we know how that usually ends), there are a couple help wanted ads and one about selling a car. Nothing special.]]
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('adv');
      end
    end
  },
  obj {
    nam = "#door",
    act = function()
      enable '#path_mainhall'
      p [[The inscription on the plaque reads:^<b>Institute of Advanced Genomics "Alpha"^Entrance Gate #2</b>]]
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('door');
        return
      end
      return false
    end
  }
}





room {
  nam = "author_note1";
  disp = "From the Author";
  noinv = true;
  decor = [[
Well, it strikes me that the introduction is too long and since I don't want you to get bored, I'll tell you a bit about the plot.^
The game’s protagonist is Anton Golubev. He is a 23-year-old Senior Researcher, although I did not plan on revealing this to the player at the start of the game. While exploring the Institute facility, the player has to read entries in diaries and notebooks. Collecting information piece by piece, the player comes to understand the main character and puts together what was going on in the game.^
I wasn’t sure that I was experienced enough as a writer to pull this off.^
So, I put the diaries at the very beginning of the game, in the "Background" section -- you already read them, didn't you? Anyway, it doesn't matter. Originally, the text was twice as long -- but hey, we have got a game here, not a book! So I ruthlessly cut out Nikolai's pseudoscientific reflections on his research. I think this only improved the game.^
However, this game had one more problem, a much more difficult one to solve. I still have not decided which version of the plot will be final -- what are relationships between the protagonist, Ruslan, and Nikolai? Does he have a girlfriend named Marina? What should happen on the fourth floor of the Research Institute? And...^ ^
  ]] .. fmt.c("{#next|But let's not get ahead of ourselves: back to the game.}");
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#next",
    act = function()
      theme_switch('game')
      walk('loc_mainhall')
    end
  }
}

