/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;
import simplenlg.syntax.english.ClauseHelper;
import simplenlg.syntax.english.CoordinatedPhraseHelper;
import simplenlg.syntax.english.NounPhraseHelper;
import simplenlg.syntax.english.PhraseHelper;
import simplenlg.syntax.english.VerbPhraseHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxProcessor
extends NLGModule {
    @Override
    public void initialise() {
    }

    @Override
    public NLGElement realise(NLGElement element) {
        NLGElement realisedElement = null;
        if (element != null && !element.getFeatureAsBoolean("elided").booleanValue()) {
            if (element instanceof DocumentElement) {
                List<NLGElement> children = element.getChildren();
                ((DocumentElement)element).setComponents(this.realise(children));
                realisedElement = element;
            } else if (element instanceof PhraseElement) {
                realisedElement = this.realisePhraseElement((PhraseElement)element);
            } else if (element instanceof ListElement) {
                realisedElement = new ListElement();
                ((ListElement)realisedElement).addComponents(this.realise(element.getChildren()));
            } else if (element instanceof InflectedWordElement) {
                String baseForm = ((InflectedWordElement)element).getBaseForm();
                ElementCategory category = element.getCategory();
                if (this.lexicon != null && baseForm != null) {
                    WordElement word = ((InflectedWordElement)element).getBaseWord();
                    if (word == null) {
                        word = category instanceof LexicalCategory ? this.lexicon.lookupWord(baseForm, (LexicalCategory)category) : this.lexicon.lookupWord(baseForm);
                    }
                    if (word != null) {
                        ((InflectedWordElement)element).setBaseWord(word);
                    }
                }
                realisedElement = element;
            } else if (element instanceof WordElement) {
                InflectedWordElement infl = new InflectedWordElement((WordElement)element);
                for (String feature : element.getAllFeatureNames()) {
                    infl.setFeature(feature, element.getFeature(feature));
                }
                realisedElement = this.realise(infl);
            } else {
                realisedElement = element instanceof CoordinatedPhraseElement ? CoordinatedPhraseHelper.realise(this, (CoordinatedPhraseElement)element) : element;
            }
        }
        if (realisedElement instanceof ListElement && ((ListElement)realisedElement).size() == 1) {
            realisedElement = ((ListElement)realisedElement).getFirst();
        }
        return realisedElement;
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedList = new ArrayList<NLGElement>();
        NLGElement childRealisation = null;
        if (elements != null) {
            for (NLGElement eachElement : elements) {
                if (eachElement == null || (childRealisation = this.realise(eachElement)) == null) continue;
                if (childRealisation instanceof ListElement) {
                    realisedList.addAll(((ListElement)childRealisation).getChildren());
                    continue;
                }
                realisedList.add(childRealisation);
            }
        }
        return realisedList;
    }

    private NLGElement realisePhraseElement(PhraseElement phrase) {
        ElementCategory category;
        NLGElement realisedElement = null;
        if (phrase != null && (category = phrase.getCategory()) instanceof PhraseCategory) {
            switch ((PhraseCategory)category) {
                case CLAUSE: {
                    realisedElement = ClauseHelper.realise(this, phrase);
                    break;
                }
                case NOUN_PHRASE: {
                    realisedElement = NounPhraseHelper.realise(this, phrase);
                    break;
                }
                case VERB_PHRASE: {
                    realisedElement = VerbPhraseHelper.realise(this, phrase);
                    break;
                }
                case PREPOSITIONAL_PHRASE: 
                case ADJECTIVE_PHRASE: 
                case ADVERB_PHRASE: {
                    realisedElement = PhraseHelper.realise(this, phrase);
                    break;
                }
                default: {
                    realisedElement = phrase;
                }
            }
        }
        return realisedElement;
    }
}

