/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.phrasespec;

import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;

public class VPPhraseSpec
extends PhraseElement {
    public VPPhraseSpec(NLGFactory phraseFactory) {
        super(PhraseCategory.VERB_PHRASE);
        this.setFactory(phraseFactory);
        this.setFeature("perfect", false);
        this.setFeature("progressive", false);
        this.setFeature("passive", false);
        this.setFeature("negated", false);
        this.setFeature("tense", (Object)Tense.PRESENT);
        this.setFeature("person", (Object)Person.THIRD);
        this.setPlural(false);
        this.setFeature("form", (Object)Form.NORMAL);
        this.setFeature("realise_auxiliary", true);
    }

    public void setVerb(Object verb) {
        NLGElement verbElement;
        if (verb instanceof String) {
            int space = ((String)verb).indexOf(32);
            if (space == -1) {
                verbElement = this.getFactory().createWord(verb, LexicalCategory.VERB);
            } else {
                verbElement = this.getFactory().createWord(((String)verb).substring(0, space), LexicalCategory.VERB);
                this.setFeature("particle", ((String)verb).substring(space + 1, ((String)verb).length()));
            }
        } else {
            verbElement = this.getFactory().createNLGElement(verb, LexicalCategory.VERB);
        }
        this.setHead(verbElement);
    }

    public NLGElement getVerb() {
        return this.getHead();
    }

    public void setObject(Object object) {
        NLGElement objectPhrase = object instanceof PhraseElement || object instanceof CoordinatedPhraseElement ? (NLGElement)object : this.getFactory().createNounPhrase(object);
        objectPhrase.setFeature("discourse_function", (Object)DiscourseFunction.OBJECT);
        this.setComplement(objectPhrase);
    }

    public NLGElement getObject() {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        for (NLGElement complement : complements) {
            if (complement.getFeature("discourse_function") != DiscourseFunction.OBJECT) continue;
            return complement;
        }
        return null;
    }

    public void setIndirectObject(Object indirectObject) {
        NLGElement indirectObjectPhrase = indirectObject instanceof PhraseElement || indirectObject instanceof CoordinatedPhraseElement ? (NLGElement)indirectObject : this.getFactory().createNounPhrase(indirectObject);
        indirectObjectPhrase.setFeature("discourse_function", (Object)DiscourseFunction.INDIRECT_OBJECT);
        this.setComplement(indirectObjectPhrase);
    }

    public NLGElement getIndirectObject() {
        List<NLGElement> complements = this.getFeatureAsElementList("complements");
        for (NLGElement complement : complements) {
            if (complement.getFeature("discourse_function") != DiscourseFunction.INDIRECT_OBJECT) continue;
            return complement;
        }
        return null;
    }

    public void addModifier(Object modifier) {
        String modifierString;
        if (modifier == null) {
            return;
        }
        NLGElement modifierElement = null;
        if (modifier instanceof NLGElement) {
            modifierElement = (NLGElement)modifier;
        } else if (modifier instanceof String && (modifierString = (String)modifier).length() > 0 && !modifierString.contains(" ")) {
            modifierElement = this.getFactory().createWord(modifier, LexicalCategory.ANY);
        }
        if (modifierElement == null) {
            this.addPostModifier((String)modifier);
            return;
        }
        WordElement modifierWord = null;
        if (modifierElement != null && modifierElement instanceof WordElement) {
            modifierWord = (WordElement)modifierElement;
        } else if (modifierElement != null && modifierElement instanceof InflectedWordElement) {
            modifierWord = ((InflectedWordElement)modifierElement).getBaseWord();
        }
        if (modifierWord != null && modifierWord.getCategory() == LexicalCategory.ADVERB) {
            this.addPreModifier(modifierWord);
            return;
        }
        this.addPostModifier(modifierElement);
    }
}

