/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.morphology.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;
import simplenlg.framework.WordElement;
import simplenlg.morphology.english.DeterminerAgrHelper;
import simplenlg.morphology.english.MorphologyRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphologyProcessor
extends NLGModule {
    @Override
    public void initialise() {
    }

    @Override
    public NLGElement realise(NLGElement element) {
        NLGElement realisedElement = null;
        if (element instanceof InflectedWordElement) {
            realisedElement = this.doMorphology((InflectedWordElement)element);
        } else if (element instanceof StringElement) {
            realisedElement = element;
        } else if (element instanceof WordElement) {
            String defaultSpell = ((WordElement)element).getDefaultSpellingVariant();
            if (defaultSpell != null) {
                realisedElement = new StringElement(defaultSpell);
            }
        } else if (element instanceof DocumentElement) {
            List<NLGElement> children = element.getChildren();
            ((DocumentElement)element).setComponents(this.realise(children));
            realisedElement = element;
        } else if (element instanceof ListElement) {
            realisedElement = new ListElement();
            ((ListElement)realisedElement).addComponents(this.realise(element.getChildren()));
        } else if (element instanceof CoordinatedPhraseElement) {
            List<NLGElement> children = element.getChildren();
            ((CoordinatedPhraseElement)element).clearCoordinates();
            if (children != null && children.size() > 0) {
                ((CoordinatedPhraseElement)element).addCoordinate(this.realise(children.get(0)));
                for (int index = 1; index < children.size(); ++index) {
                    ((CoordinatedPhraseElement)element).addCoordinate(this.realise(children.get(index)));
                }
                realisedElement = element;
            }
        } else if (element != null) {
            realisedElement = element;
        }
        return realisedElement;
    }

    private NLGElement doMorphology(InflectedWordElement element) {
        NLGElement realisedElement = null;
        if (element.getFeatureAsBoolean("non_morph").booleanValue()) {
            realisedElement = new StringElement(element.getBaseForm());
            realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
        } else {
            ElementCategory category;
            NLGElement baseWord = element.getFeatureAsElement("base_word");
            if (baseWord == null && this.lexicon != null) {
                baseWord = this.lexicon.lookupWord(element.getBaseForm());
            }
            if ((category = element.getCategory()) instanceof LexicalCategory) {
                switch ((LexicalCategory)category) {
                    case PRONOUN: {
                        realisedElement = MorphologyRules.doPronounMorphology(element);
                        break;
                    }
                    case NOUN: {
                        realisedElement = MorphologyRules.doNounMorphology(element, (WordElement)baseWord);
                        break;
                    }
                    case VERB: {
                        realisedElement = MorphologyRules.doVerbMorphology(element, (WordElement)baseWord);
                        break;
                    }
                    case ADJECTIVE: {
                        realisedElement = MorphologyRules.doAdjectiveMorphology(element, (WordElement)baseWord);
                        break;
                    }
                    case ADVERB: {
                        realisedElement = MorphologyRules.doAdverbMorphology(element, (WordElement)baseWord);
                        break;
                    }
                    default: {
                        realisedElement = new StringElement(element.getBaseForm());
                        realisedElement.setFeature("discourse_function", element.getFeature("discourse_function"));
                    }
                }
            }
        }
        return realisedElement;
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedElements = new ArrayList<NLGElement>();
        NLGElement currentElement = null;
        NLGElement determiner = null;
        NLGElement prevElement = null;
        if (elements != null) {
            for (NLGElement eachElement : elements) {
                currentElement = this.realise(eachElement);
                if (currentElement != null) {
                    currentElement.setFeature("appositive", eachElement.getFeature("appositive"));
                    Object function = eachElement.getFeature("discourse_function");
                    if (function != null) {
                        currentElement.setFeature("discourse_function", function);
                    }
                    if (prevElement != null && prevElement instanceof StringElement && eachElement instanceof InflectedWordElement && ((InflectedWordElement)eachElement).getCategory().equals(LexicalCategory.NOUN)) {
                        String prevString = prevElement.getRealisation();
                        prevElement.setRealisation(DeterminerAgrHelper.checkEndsWithIndefiniteArticle(prevString, currentElement.getRealisation()));
                    }
                    realisedElements.add(currentElement);
                    if (determiner == null && DiscourseFunction.SPECIFIER.equals(currentElement.getFeature("discourse_function"))) {
                        determiner = currentElement;
                        determiner.setFeature("number", eachElement.getFeature("number"));
                    } else if (determiner != null) {
                        if (currentElement instanceof ListElement) {
                            NLGElement firstChild = ((ListElement)currentElement).getChildren().get(0);
                            if (firstChild != null) {
                                if (firstChild instanceof CoordinatedPhraseElement) {
                                    MorphologyRules.doDeterminerMorphology(determiner, firstChild.getChildren().get(0).getRealisation());
                                } else {
                                    MorphologyRules.doDeterminerMorphology(determiner, firstChild.getRealisation());
                                }
                            }
                        } else {
                            MorphologyRules.doDeterminerMorphology(determiner, currentElement.getRealisation());
                        }
                        determiner = null;
                    }
                }
                prevElement = eachElement;
            }
        }
        return realisedElements;
    }
}

