/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.List;
import simplenlg.aggregation.AggregationHelper;
import simplenlg.aggregation.FunctionalSet;
import simplenlg.aggregation.Periphery;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.NLGModule;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.syntax.english.SyntaxProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewAggregator
extends NLGModule {
    private SyntaxProcessor _syntax;
    private NLGFactory _factory;

    @Override
    public void initialise() {
        this._syntax = new SyntaxProcessor();
        this._factory = new NLGFactory();
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        return null;
    }

    @Override
    public NLGElement realise(NLGElement element) {
        return null;
    }

    public NLGElement realise(NLGElement phrase1, NLGElement phrase2) {
        CoordinatedPhraseElement result = null;
        if (phrase1 instanceof PhraseElement && phrase2 instanceof PhraseElement && phrase1.getCategory() == PhraseCategory.CLAUSE && phrase2.getCategory() == PhraseCategory.CLAUSE) {
            List<FunctionalSet> funcSets = AggregationHelper.collectFunctionalPairs(this._syntax.realise(phrase1), this._syntax.realise(phrase2));
            this.applyForwardConjunctionReduction(funcSets);
            this.applyBackwardConjunctionReduction(funcSets);
            result = this._factory.createCoordinatedPhrase(phrase1, phrase2);
        }
        return result;
    }

    private void applyForwardConjunctionReduction(List<FunctionalSet> funcSets) {
        for (FunctionalSet pair : funcSets) {
            if (pair.getPeriphery() != Periphery.LEFT || !pair.formIdentical()) continue;
            pair.elideRightMost();
        }
    }

    private void applyBackwardConjunctionReduction(List<FunctionalSet> funcSets) {
        for (FunctionalSet pair : funcSets) {
            if (pair.getPeriphery() != Periphery.RIGHT || !pair.formIdentical()) continue;
            pair.elideLeftMost();
        }
    }
}

