/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.util.HashSet;

public final class RWildCard {
    public static final char BEGIN = '^';
    public static final char END = '$';
    public static final char CHARACTER = 'C';
    public static final char DIGIT = 'D';
    public static final char LETTER = 'L';
    public static final char SPACE = 'S';
    public static final char PUNCTUATION = 'P';
    private static HashSet<String> wildCardSet_ = new HashSet();
    private static HashSet<String> punctuationSet_ = new HashSet();

    public static boolean IsMatchKey(char key, int index, char[] inCharArray) {
        boolean matchFlag = false;
        if (!Character.isLowerCase(key) && !RWildCard.IsWildCardKey(key)) {
            return false;
        }
        if (index < 0) {
            return key == '^';
        }
        char inChar = Character.toLowerCase(inCharArray[index]);
        String inStr = String.valueOf(inChar);
        if (key == inChar) {
            matchFlag = true;
        } else if (key == 'C' && inStr != null) {
            matchFlag = true;
        } else if (key == 'D' && Character.isDigit(inChar)) {
            matchFlag = true;
        } else if (key == 'L' && Character.isLetter(inChar)) {
            matchFlag = true;
        } else if (key == 'S' && inChar == ' ') {
            matchFlag = true;
        } else if (key == 'P' && punctuationSet_.contains(inStr)) {
            matchFlag = true;
        }
        return matchFlag;
    }

    private static boolean IsWildCardKey(char inChar) {
        String inStr = String.valueOf(inChar);
        return wildCardSet_.contains(inStr);
    }

    static {
        wildCardSet_.add(new Character('^').toString());
        wildCardSet_.add(new Character('$').toString());
        wildCardSet_.add(new Character('C').toString());
        wildCardSet_.add(new Character('D').toString());
        wildCardSet_.add(new Character('L').toString());
        wildCardSet_.add(new Character('S').toString());
        wildCardSet_.add(new Character('P').toString());
        punctuationSet_.add("-");
        punctuationSet_.add("(");
        punctuationSet_.add(",");
    }
}

