/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToCanonicalize;
import gov.nih.nlm.nls.lvg.Flows.ToLowerCase;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveGenitive;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToReplacePunctuationWithSpace;
import gov.nih.nlm.nls.lvg.Flows.ToSortWordsByOrder;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToUnicodeCoreNorm;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class ToLuiNormalize
extends Transformation
implements Cloneable {
    private static final int LUI_NORM_STEPS = 10;

    public static Vector<LexItem> Mutate(LexItem in, int maxTerm, Vector<String> stopWords, Connection conn, RamTrie trie, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, Hashtable<Character, String> nonStripMap, RTrieTree removeSTree, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        int i;
        Vector<LexItem> outList = new Vector<LexItem>();
        Vector<LexItem> inList = new Vector<LexItem>();
        inList.addElement(in);
        for (i = 0; i < 10; ++i) {
            outList = ToLuiNormalize.GetLuiNormBySteps(i, inList, maxTerm, stopWords, conn, trie, symbolMap, unicodeMap, ligatureMap, diacriticMap, nonStripMap, removeSTree, detailsFlag, mutateFlag);
            inList.removeAllElements();
            for (int j = 0; j < outList.size(); ++j) {
                LexItem out = outList.elementAt(j);
                LexItem temp = LexItem.TargetToSource(out);
                inList.addElement(temp);
            }
        }
        for (i = 0; i < outList.size(); ++i) {
            outList.elementAt(i).SetMutateInformation(Transformation.NO_MUTATE_INFO);
        }
        return outList;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToLuiNormalize.GetTestStr(args, "fingers");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int maxTerm = Integer.parseInt(conf.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        Vector<String> stopWords = ToStripStopWords.GetStopWordsFromFile(conf);
        Hashtable<Character, String> symbolMap = ToMapSymbolToAscii.GetSymbolMapFromFile(conf);
        Hashtable<Character, String> unicodeMap = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf);
        Hashtable<Character, String> ligatureMap = ToSplitLigatures.GetLigatureMapFromFile(conf);
        Hashtable<Character, Character> diacriticMap = ToStripDiacritics.GetDiacriticMapFromFile(conf);
        Hashtable<Character, String> nonStripMap = ToStripMapUnicode.GetNonStripMapFromFile(conf);
        RTrieTree removeSTree = ToRemoveS.GetRTrieTreeFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToLuiNormalize.Mutate(in, maxTerm, stopWords, conn, trie, symbolMap, unicodeMap, ligatureMap, diacriticMap, nonStripMap, removeSTree, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToLuiNormalize.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetLuiNormBySteps(int step, Vector<LexItem> ins, int maxTerm, Vector<String> stopWords, Connection conn, RamTrie trie, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, Hashtable<Character, String> nonStripMap, RTrieTree removeSTree, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> outs = new Vector<LexItem>();
        boolean index = false;
        for (int i = 0; i < ins.size(); ++i) {
            LexItem in = ins.elementAt(i);
            Vector<Object> tempOuts = new Vector();
            switch (step) {
                case 0: {
                    tempOuts = ToUnicodeCoreNorm.Mutate(in, symbolMap, unicodeMap, ligatureMap, diacriticMap, detailsFlag, mutateFlag);
                    break;
                }
                case 1: {
                    tempOuts = ToRemoveGenitive.Mutate(in, detailsFlag, mutateFlag);
                    break;
                }
                case 2: {
                    tempOuts = ToRemoveS.Mutate(in, removeSTree, detailsFlag, mutateFlag);
                    break;
                }
                case 3: {
                    tempOuts = ToReplacePunctuationWithSpace.Mutate(in, detailsFlag, mutateFlag);
                    break;
                }
                case 4: {
                    tempOuts = ToStripStopWords.Mutate(in, stopWords, detailsFlag, mutateFlag);
                    break;
                }
                case 5: {
                    tempOuts = ToLowerCase.Mutate(in, detailsFlag, mutateFlag);
                    break;
                }
                case 6: {
                    tempOuts = ToUninflectWords.Mutate(in, maxTerm, conn, trie, detailsFlag, mutateFlag);
                    break;
                }
                case 7: {
                    tempOuts = ToCanonicalize.Mutate(in, conn, detailsFlag, mutateFlag);
                    break;
                }
                case 8: {
                    tempOuts = ToStripMapUnicode.Mutate(in, nonStripMap, detailsFlag, mutateFlag);
                    break;
                }
                case 9: {
                    tempOuts = ToSortWordsByOrder.Mutate(in, detailsFlag, mutateFlag);
                }
            }
            outs.addAll(tempOuts);
            if (step == 7) break;
        }
        return outs;
    }
}

