/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.AcronymComparator;
import gov.nih.nlm.nls.lvg.Db.AcronymRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.ExpansionComparator;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbAcronym {
    public static boolean IsAcronym(String inStr, Connection conn) throws SQLException {
        boolean isAcronym = false;
        String query = "SELECT acr FROM Acronym WHERE acrNpLc= ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            isAcronym = true;
        }
        rs.close();
        ps.close();
        return isAcronym;
    }

    public static Vector<AcronymRecord> GetAcronyms(String inStr, Connection conn) throws SQLException {
        String query = "SELECT exp, aType, acr FROM Acronym WHERE expNpLc= ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        Vector<AcronymRecord> acronyms = new Vector<AcronymRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            AcronymRecord acronymRecord = new AcronymRecord();
            acronymRecord.SetExpansion(rs.getString(1));
            acronymRecord.SetType(rs.getString(2));
            acronymRecord.SetAcronym(rs.getString(3));
            acronyms.addElement(acronymRecord);
        }
        rs.close();
        ps.close();
        AcronymComparator ac = new AcronymComparator();
        Collections.sort(acronyms, ac);
        return acronyms;
    }

    public static Vector<AcronymRecord> GetExpansions(String inStr, Connection conn) throws SQLException {
        String query = "SELECT exp, aType, acr FROM Acronym WHERE acrNpLc= ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr);
        Vector<AcronymRecord> expansions = new Vector<AcronymRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            AcronymRecord acronymRecord = new AcronymRecord();
            acronymRecord.SetExpansion(rs.getString(1));
            acronymRecord.SetType(rs.getString(2));
            acronymRecord.SetAcronym(rs.getString(3));
            expansions.addElement(acronymRecord);
        }
        rs.close();
        ps.close();
        ExpansionComparator ec = new ExpansionComparator();
        Collections.sort(expansions, ec);
        return expansions;
    }

    public static void main(String[] args) {
        String testStr = "air conditioning";
        if (args.length == 1) {
            testStr = args[0];
        }
        System.out.println("--- TestStr:  " + testStr);
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<AcronymRecord> expansionList = DbAcronym.GetExpansions(testStr.toLowerCase(), conn);
                System.out.println("----- IsAcronym (" + testStr.toLowerCase() + "): " + DbAcronym.IsAcronym(testStr.toLowerCase(), conn));
                System.out.println("----- IsAcronym (AC): " + DbAcronym.IsAcronym("ac", conn));
                System.out.println("----- IsAcronym (A.C.): " + DbAcronym.IsAcronym("a.c.", conn));
                System.out.println("----- Total Expansions found: " + expansionList.size());
                for (int i = 0; i < expansionList.size(); ++i) {
                    AcronymRecord record = expansionList.elementAt(i);
                    System.out.println("=== Found Expansions ===");
                    System.out.println(record.GetAcronym() + "|" + record.GetType() + "|" + record.GetExpansion());
                }
                Vector<AcronymRecord> acronymList = DbAcronym.GetAcronyms(testStr, conn);
                System.out.println("----- Total Acronyms found: " + acronymList.size());
                for (int j = 0; j < acronymList.size(); ++j) {
                    AcronymRecord rec = acronymList.elementAt(j);
                    System.out.println("=== Found Acronyms ===");
                    System.out.println(rec.GetAcronym() + "|" + rec.GetType() + "|" + rec.GetExpansion());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

