/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import java.util.Vector;

public class OptionTest
extends SystemOption {
    public static void main(String[] args) {
        String optionStr = "-a:aa~123+45+1:Absolute~12:ac:ad~adb -B_Flag:bb:bc~bca:bd:be~bea_Full_Name~10.0 -C_Flag";
        Option io = new Option(optionStr);
        if (args.length > 0) {
            optionStr = "";
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            io = new Option(optionStr);
        }
        OptionTest optionTest = new OptionTest();
        System.out.println("---------- input: --------------");
        System.out.println(io.GetOptionStr());
        System.out.println("---------- System: --------------");
        System.out.println(optionTest.GetOption().GetOptionStr());
        System.out.println("---------- Result: --------------");
        SystemOption.CheckSyntax(io, optionTest.GetOption(), true, true);
        System.out.println("---------- ConvertName(name): --------------");
        System.out.println(OptionUtility.ConvertName(io.GetOptionStr(), optionTest.GetOption(), false));
        System.out.println("---------- ConvertName(fullName): --------------");
        System.out.println(OptionUtility.ConvertName(io.GetOptionStr(), optionTest.GetOption(), true));
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (OptionTest.CheckOption(nameItem, "-a:aa~INT+INT+INT")) {
            Vector<String> inList = OptionItem.GetArgumentList(nameItem.GetOptionArgument());
            int[] arguList = this.ToIntArray(inList);
            System.out.println("=> Call '-a:aa~INT+INT+INT' flag function (" + arguList[0] + ", " + arguList[1] + ", " + arguList[2] + ")");
        } else if (OptionTest.CheckOption(nameItem, "-a:ab~aba")) {
            System.out.println("=> Call '-a:ab~aba' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-a:ab~INT")) {
            int argu = Integer.parseInt(nameItem.GetOptionArgument());
            System.out.println("=> Call '-a:ab~INT' flag function (" + argu + ")");
        } else if (OptionTest.CheckOption(nameItem, "-a:ac")) {
            System.out.println("=> Call '-a:ac' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-a:ad:ada")) {
            System.out.println("=> Call '-a:ad:ada' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-a:ad~adb")) {
            System.out.println("=> Call '-a:ad~adb' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-a:ad~adc")) {
            System.out.println("=> Call '-a:ad~adc' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:bb")) {
            System.out.println("=> Call '-b:bb' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:bc~bca")) {
            System.out.println("=> Call '-b:bc~bca' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:bc~bcb")) {
            System.out.println("=> Call '-b:bc~bcb' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:bc~bcc")) {
            System.out.println("=> Call '-b:bc~bcc' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:bd")) {
            System.out.println("=> Call '-b:bd' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:be~INT")) {
            int argu = Integer.parseInt(nameItem.GetOptionArgument());
            System.out.println("=> Call '-b:be~INT' flag function (" + argu + ")");
        } else if (OptionTest.CheckOption(nameItem, "-b:be~bea")) {
            System.out.println("=> Call '-b:be~bea' flag function");
        } else if (OptionTest.CheckOption(nameItem, "-b:be~BLN")) {
            boolean argu = this.ToBoolean(nameItem.GetOptionArgument());
            System.out.println("=> Call '-b:be~BLN' flag function (" + argu + ")");
        } else if (OptionTest.CheckOption(nameItem, "-b:be~FLT")) {
            float argu = Float.parseFloat(nameItem.GetOptionArgument());
            System.out.println("=> Call '-b:be~FLT' flag function (" + argu + ")");
        } else if (OptionTest.CheckOption(nameItem, "-b:be~STR")) {
            String argu = nameItem.GetOptionArgument();
            System.out.println("=> Call '-b:be~STR' flag function (" + argu + ")");
        } else if (OptionTest.CheckOption(nameItem, "-c")) {
            System.out.println("=> call '-c' flag function");
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-a:aa~INT+INT+INT:ab~aba~INT:ac:ad~ada~adb~adc -b:bb:bc~bca~bcb~bcc:bd:be~INT~bea~BLN~FLT~STR -c";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-a:ab", "Absolute");
        this.systemOption_.SetFlagFullName("-a:ab~aba", "abaFullName");
        this.systemOption_.SetFlagFullName("-b", "B_Flag");
        this.systemOption_.SetFlagFullName("-b:be~bea", "bea_Full_Name");
        this.systemOption_.SetFlagFullName("-c", "C_Flag");
    }
}

