/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

public class Convert {
    public static final String UNIX_LINE_SEP = "\n";
    public static final String PC_LINE_SEP = "^M\n";
    private static final String[][] ENTITY_LIST = new String[][]{{"&#038;", "&amp;", "&"}, {"&#034;", "&quot;", "\""}, {"&#060;", "&lt;", "<"}, {"&#062;", "&gt;", ">"}, {"&#160;", "&nbsp;", "\u00a0"}};

    public static void main(String[] args) {
        String inStr = "ASCII: A-Z,a-z.\n&,<,>,\",  .\nSpace Test";
        if (args.length == 1) {
            inStr = args[0];
        }
        System.out.println("-- in: " + inStr);
        System.out.println("-- Name:" + Convert.ToNamedEntity(inStr));
        System.out.println("-- Numeric:" + Convert.ToNumericEntity(inStr));
        System.out.println("-- ToHtml:" + Convert.AsciiToHtml(inStr));
    }

    public static String ToNumericEntity(String ascii) {
        int curPos = 0;
        for (int i = 0; i < ENTITY_LIST.length; ++i) {
            int length = ENTITY_LIST[i][2].length();
            while ((curPos = ascii.indexOf(ENTITY_LIST[i][2], curPos + 1)) >= 0) {
                ascii = ascii.substring(0, curPos) + ENTITY_LIST[i][0] + ascii.substring(curPos + length);
            }
        }
        return ascii;
    }

    public static String ToNamedEntity(String ascii) {
        int curPos = 0;
        for (int i = 0; i < ENTITY_LIST.length; ++i) {
            int length = ENTITY_LIST[i][2].length();
            while ((curPos = ascii.indexOf(ENTITY_LIST[i][2], curPos + 1)) >= 0) {
                ascii = ascii.substring(0, curPos) + ENTITY_LIST[i][1] + ascii.substring(curPos + length);
            }
        }
        return ascii;
    }

    public static String AsciiToHtml(String ascii) {
        int curPos = 0;
        for (int i = 0; i < ENTITY_LIST.length; ++i) {
            int length = ENTITY_LIST[i][2].length();
            while ((curPos = ascii.indexOf(ENTITY_LIST[i][2], curPos + 1)) >= 0) {
                ascii = ascii.substring(0, curPos) + ENTITY_LIST[i][0] + ascii.substring(curPos + length);
            }
        }
        while ((curPos = ascii.indexOf(" ")) >= 0) {
            ascii = ascii.substring(0, curPos) + "&nbsp;" + ascii.substring(curPos + 1);
        }
        while ((curPos = ascii.indexOf(UNIX_LINE_SEP)) >= 0) {
            ascii = ascii.substring(0, curPos) + "&#010;" + ascii.substring(curPos + 1);
        }
        while ((curPos = ascii.indexOf("\t")) >= 0) {
            ascii = ascii.substring(0, curPos) + "&#009;" + ascii.substring(curPos + 1);
        }
        return ascii;
    }

    public static String HtmlToAscii(String html) {
        int curPos;
        int lastPos = 0;
        for (curPos = html.indexOf("&#"); curPos >= lastPos; curPos += html.substring(curPos).indexOf("&#")) {
            int offSet;
            for (offSet = curPos + 2; offSet < html.length() && Character.isDigit(html.charAt(offSet)); ++offSet) {
            }
            if (offSet >= html.length() || html.charAt(offSet) != ';') {
                curPos += 2;
            } else {
                int ascii = -1;
                try {
                    ascii = Integer.parseInt(html.substring(curPos + 2, offSet));
                }
                catch (Exception e) {
                    // empty catch block
                }
                html = html.substring(0, curPos) + (char)ascii + html.substring(offSet + 1);
            }
            lastPos = curPos;
        }
        for (int i = 0; i < ENTITY_LIST.length; ++i) {
            int length = ENTITY_LIST[i][0].length();
            while ((curPos = html.indexOf(ENTITY_LIST[i][0])) >= 0) {
                html = html.substring(0, curPos) + ENTITY_LIST[i][2] + html.substring(curPos + length);
            }
        }
        while ((curPos = html.indexOf(" ")) >= 0) {
            html = html.substring(0, curPos) + html.substring(curPos + 1);
        }
        return html;
    }

    public static String ToUnixLineSeparator(String inStr) {
        String outStr = inStr;
        String src = UNIX_LINE_SEP;
        String tar = UNIX_LINE_SEP;
        int tarSize = tar.length();
        int srcSize = src.length();
        int index = outStr.indexOf(src);
        while (index >= 0) {
            char mC = outStr.charAt(index - 1);
            if (Character.getType(mC) == 15) {
                outStr = outStr.substring(0, index - 1) + tar + outStr.substring(index + 1);
                index = outStr.indexOf(src, index);
                continue;
            }
            index = outStr.indexOf(src, index + 1);
        }
        return outStr;
    }

    public static String ToPcLineSeparator(String inStr) {
        String unixStr = Convert.ToUnixLineSeparator(inStr);
        String pcStr = Convert.Replace(unixStr, UNIX_LINE_SEP, PC_LINE_SEP);
        return pcStr;
    }

    public static String Replace(String inStr, String src, String tar) {
        String outStr = inStr;
        int tarSize = tar.length();
        int srcSize = src.length();
        int index = outStr.indexOf(src);
        while (index >= 0) {
            outStr = outStr.substring(0, index) + tar + outStr.substring(index + srcSize);
            index = outStr.indexOf(src, index + tarSize);
        }
        return outStr;
    }
}

