/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Configuration {
    public static final String LC_DIR = "LC_DIR";
    public static final String TEXT_INDENT = "TEXT_INDENT";
    public static final String XML_INDENT = "XML_INDENT";
    public static final String XML_HEADER = "XML_HEADER";
    private PropertyResourceBundle config_ = null;
    private static final String LS_STR = System.getProperty("line.separator").toString();

    public Configuration(String fName, boolean useClassPath) {
        this.SetConfiguration(fName, useClassPath);
    }

    public String GetConfiguration(String key) {
        String out = this.config_.getString(key);
        return out;
    }

    public static String OverWriteProperty(String key, Configuration conf, Hashtable properties) {
        String property = conf.GetConfiguration(key);
        String value = (String)properties.get(key);
        if (value != null) {
            property = value;
        }
        return property;
    }

    public String GetInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("LC_DIR: [" + this.GetConfiguration(LC_DIR) + "]");
        buffer.append(LS_STR);
        return buffer.toString();
    }

    private void SetConfiguration(String fName, boolean useClassPath) {
        try {
            if (useClassPath) {
                this.config_ = (PropertyResourceBundle)ResourceBundle.getBundle(fName);
            } else {
                FileInputStream file = new FileInputStream(fName);
                this.config_ = new PropertyResourceBundle(file);
                file.close();
            }
        }
        catch (Exception e) {
            System.err.println("** Configuration Error: " + e.getMessage());
            System.err.println("** Error: problem of opening/reading config file: '" + fName + "'. Use -x option to specify the config file path.");
        }
    }
}

