/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Det;

import gov.nih.nlm.nls.lexCheck.Cat.Det.CheckFormatDetVariants;
import gov.nih.nlm.nls.lexCheck.Cat.Det.UpdateDetDemonstrative;
import gov.nih.nlm.nls.lexCheck.Cat.Det.UpdateDetInterrogative;
import gov.nih.nlm.nls.lexCheck.Cat.Det.UpdateDetVariants;
import gov.nih.nlm.nls.lexCheck.CkLib.CheckCode;
import gov.nih.nlm.nls.lexCheck.CkLib.CheckObject;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.util.HashSet;

public class CheckDet {
    private static CheckObject checkVariants_ = null;
    private static CheckObject checkInterrogative_ = null;
    private static HashSet<String> interrogativeNextStartStrs_ = new HashSet(6);
    private static CheckObject checkDemonstrative_ = null;
    private static HashSet<String> demonstrativeNextStartStrs_ = new HashSet(5);

    public static boolean Check(LineObject lineObject, boolean printFlag, CheckSt catSt, LexRecord lexObj, boolean debugFlag) {
        boolean flag = true;
        int curSt = catSt.GetCurState();
        if (curSt == 40) {
            curSt = 151;
            catSt.SetCurState(curSt);
        }
        switch (curSt) {
            case 151: {
                flag = CheckCode.Check(lineObject, printFlag, catSt, lexObj, checkVariants_, new UpdateDetVariants(), 1, true);
                CheckDet.PrintStep(151, debugFlag, lineObject.GetLine());
                break;
            }
            case 152: {
                flag = CheckCode.Check(lineObject, printFlag, catSt, lexObj, checkInterrogative_, new UpdateDetInterrogative(), 6, false);
                CheckDet.PrintStep(152, debugFlag, lineObject.GetLine());
                break;
            }
            case 153: {
                flag = CheckCode.Check(lineObject, printFlag, catSt, lexObj, checkDemonstrative_, new UpdateDetDemonstrative(), 6, false);
                CheckDet.PrintStep(152, debugFlag, lineObject.GetLine());
            }
        }
        return flag;
    }

    private static void PrintStep(int state, boolean debugFlag, String line) {
        if (debugFlag) {
            switch (state) {
                case 151: {
                    System.out.println("-- Checked Det Variants: '" + line + "'");
                    break;
                }
                case 152: {
                    System.out.println("-- Checked Det Interrogative: '" + line + "'");
                    break;
                }
                case 153: {
                    System.out.println("-- Checked Det Demonstrative: '" + line + "'");
                }
            }
        }
    }

    static {
        checkVariants_ = new CheckObject("\tvariants=", 21, 22, 152, null, new CheckFormatDetVariants());
        interrogativeNextStartStrs_.add("\tdemonstrative");
        interrogativeNextStartStrs_.add("\tacronym_of=");
        interrogativeNextStartStrs_.add("\tabbreviation_of=");
        interrogativeNextStartStrs_.add("annotation=");
        interrogativeNextStartStrs_.add("signature=");
        interrogativeNextStartStrs_.add("}");
        checkInterrogative_ = new CheckObject("\tinterrogative", 23, -1, 153, interrogativeNextStartStrs_, null);
        demonstrativeNextStartStrs_.add("\tacronym_of=");
        demonstrativeNextStartStrs_.add("\tabbreviation_of=");
        demonstrativeNextStartStrs_.add("annotation=");
        demonstrativeNextStartStrs_.add("signature=");
        demonstrativeNextStartStrs_.add("}");
        checkDemonstrative_ = new CheckObject("\tdemonstrative", 24, -1, 91, demonstrativeNextStartStrs_, null);
    }
}

