/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Auxi;

import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;
import java.util.StringTokenizer;

public class CheckFormatAuxVariant
implements CheckFormat {
    private static final int LEGAL_TENSE_CODE_NUM = 5;
    private static final int LEGAL_AGREEMENT_FEATURE_NUM = 8;
    private static final String NEGATIVE_CODE = "negative";
    private static final String TC_PAST = "past";
    private static final String TC_PRES = "pres";
    private static final String TC_PAST_PART = "past_part";
    private static final String TC_PRES_PART = "pres_part";
    private static final String TC_INFINITIVE = "infinitive";
    private static final String AF_FST_SING = "fst_sing";
    private static final String AF_FST_PLUR = "fst_plur";
    private static final String AF_SECOND = "second";
    private static final String AF_SEC_SING = "sec_sing";
    private static final String AF_SEC_PLUR = "sec_plur";
    private static final String AF_THIRD = "third";
    private static final String AF_THR_SING = "thr_sing";
    private static final String AF_THR_PLUR = "thr_plur";
    private static HashSet<String> tenseCode_ = new HashSet(5);
    private static HashSet<String> agreementFeature_ = new HashSet(8);

    @Override
    public boolean IsLegalFormat(String filler) {
        boolean flag = false;
        StringTokenizer buf = new StringTokenizer(filler, ";(,):");
        String inflection = new String();
        if (!buf.hasMoreTokens()) {
            return false;
        }
        inflection = buf.nextToken();
        String tenseCode = new String();
        if (!buf.hasMoreTokens()) {
            return false;
        }
        tenseCode = buf.nextToken();
        if (tenseCode_.contains(tenseCode)) {
            if (tenseCode.startsWith(TC_INFINITIVE)) {
                flag = tenseCode.equals(TC_INFINITIVE);
            } else if (tenseCode.startsWith(TC_PAST_PART) || tenseCode.startsWith(TC_PRES_PART)) {
                String negative = new String();
                if (buf.hasMoreTokens()) {
                    negative = buf.nextToken();
                    flag = negative.equals(NEGATIVE_CODE);
                } else {
                    flag = true;
                }
            } else if (tenseCode.startsWith(TC_PAST) || tenseCode.startsWith(TC_PRES)) {
                String feature = new String();
                if (buf.hasMoreTokens()) {
                    feature = buf.nextToken();
                    if (feature.equals(NEGATIVE_CODE)) {
                        flag = true;
                    } else if (agreementFeature_.contains(feature)) {
                        flag = true;
                        while (buf.hasMoreTokens() && (flag = (feature = buf.nextToken()).equals(NEGATIVE_CODE) || agreementFeature_.contains(feature))) {
                        }
                    } else {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
            }
        } else {
            return false;
        }
        return flag;
    }

    static {
        tenseCode_.add(TC_PAST);
        tenseCode_.add(TC_PRES);
        tenseCode_.add(TC_PAST_PART);
        tenseCode_.add(TC_PRES_PART);
        tenseCode_.add(TC_INFINITIVE);
        agreementFeature_.add(AF_FST_SING);
        agreementFeature_.add(AF_FST_PLUR);
        agreementFeature_.add(AF_SECOND);
        agreementFeature_.add(AF_SEC_SING);
        agreementFeature_.add(AF_SEC_PLUR);
        agreementFeature_.add(AF_THIRD);
        agreementFeature_.add(AF_THR_SING);
        agreementFeature_.add(AF_THR_PLUR);
    }
}

