/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.OutputSourceDialog;
import java.io.File;
import javax.swing.JFileChooser;

public class OutputSourceOperations {
    private OutputSourceOperations() {
    }

    public static void SetOperation(LaFrame owner) {
        File outFile = new File(OutputSourceDialog.GetTextFromFileTextField());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Set the output file");
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setCurrentDirectory(outFile.getParentFile());
        fileChooser.setSelectedFile(outFile);
        if (fileChooser.showDialog(owner, "Set") == 0) {
            File selectFile = fileChooser.getSelectedFile();
            try {
                OutputSourceDialog.SetTextToFileTextField(selectFile.getCanonicalPath());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void OkOperation(LaFrame owner) {
        owner.GetLaObj().SetOutSource(OutputSourceDialog.GetStatusOnSourceRadioButton());
        File outFile = new File(OutputSourceDialog.GetTextFromFileTextField());
        owner.GetLaObj().SetOutFile(outFile);
        owner.GetLaObj().SetAppendToOutFile(OutputSourceDialog.GetStatusOnAppendCheckBox());
        OutputSourceOperations.CloseOperation(owner);
    }

    public static void CancelOperation(LaFrame owner) {
        OutputSourceOperations.CloseOperation(owner);
    }

    public static void ResetOperation(LaFrame owner) {
        OutputSourceDialog.SetStatusOnSourceRadioButton(owner.GetLaObj().GetOutSource());
        try {
            OutputSourceDialog.SetTextToFileTextField(owner.GetLaObj().GetOutFile().getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        OutputSourceOperations.UpdateFileTextFieldEditableOperation();
        OutputSourceDialog.SetStatusOnAppendCheckBox(owner.GetLaObj().GetAppendToOutFile());
    }

    public static void DefaultOperation(LaFrame owner) {
        OutputSourceDialog.SetStatusOnSourceRadioButton(0);
        try {
            OutputSourceDialog.SetTextToFileTextField(owner.GetLaObj().GetDefaultOutFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        OutputSourceOperations.UpdateFileTextFieldEditableOperation();
        OutputSourceDialog.SetStatusOnAppendCheckBox(false);
    }

    public static void ShowOperation(LaFrame owner) {
        OutputSourceDialog.SetStatusOnSourceRadioButton(owner.GetLaObj().GetOutSource());
        OutputSourceOperations.UpdateFileTextFieldEditableOperation();
        try {
            OutputSourceDialog.SetTextToFileTextField(owner.GetLaObj().GetOutFile().getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        OutputSourceDialog.SetStatusOnAppendCheckBox(owner.GetLaObj().GetAppendToOutFile());
        owner.GetOutputSourceDialog().setVisible(true);
    }

    public static void CloseOperation(LaFrame owner) {
        owner.GetOutputSourceDialog().setVisible(false);
    }

    public static void UpdateFileTextFieldEditableOperation() {
        OutputSourceDialog.UpdateFileTextFieldEditable();
    }
}

