/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.InputSourceDialogControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class InputSourceDialog
extends JDialog {
    private static final long serialVersionUID = 5L;
    private static int SOURCE_SIZE = 2;
    public static final String RB_SCREEN = "Screen";
    public static final String RB_FILE = "File";
    private static JRadioButton[] sourceRb_ = new JRadioButton[SOURCE_SIZE];
    private static ButtonGroup sourceBGroup_ = new ButtonGroup();
    private static JTextField fileTf_ = new JTextField(40);
    public static final String B_SET = "SET";
    public static final String B_OK = "OK";
    public static final String B_CANCEL = "CANCEL";
    public static final String B_RESET = "RESET";
    public static final String B_DEFAULT = "DEFAULT";
    private static JButton selectB_ = new JButton("Set");
    private static JButton okB_ = new JButton("Ok");
    private static JButton cancelB_ = new JButton("Cancel");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton defaultB_ = new JButton("Default");
    private InputSourceDialogControl inputSourceDialogControl_ = null;

    public InputSourceDialog(LaFrame owner) {
        this.InitGuiControllers(owner);
    }

    public static JDialog GetDialog(LaFrame owner) {
        JDialog inputSourceDialog = new JDialog();
        inputSourceDialog.setModal(true);
        inputSourceDialog.setLocationRelativeTo(owner);
        inputSourceDialog.setSize(600, 180);
        inputSourceDialog.add((Component)InputSourceDialog.CreateSourcePanel(), "Center");
        inputSourceDialog.add((Component)InputSourceDialog.CreateButtonPanel(), "South");
        return inputSourceDialog;
    }

    public static void SetFont(Font font, Font guiFont) {
        sourceRb_[0].setFont(guiFont);
        sourceRb_[1].setFont(guiFont);
        selectB_.setFont(guiFont);
        fileTf_.setFont(font);
        okB_.setFont(guiFont);
        cancelB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        defaultB_.setFont(guiFont);
    }

    public static int GetStatusOnSourceRadioButton() {
        int source = 0;
        if (sourceRb_[1].isSelected()) {
            source = 1;
        }
        return source;
    }

    public static void SetStatusOnSourceRadioButton(int source) {
        switch (source) {
            case 0: {
                sourceRb_[0].setSelected(true);
                break;
            }
            case 1: {
                sourceRb_[1].setSelected(true);
            }
        }
    }

    public static void UpdateFileTextFieldEditable() {
        fileTf_.setEditable(false);
        if (sourceRb_[1].isSelected()) {
            fileTf_.setEditable(true);
        }
    }

    public static String GetTextFromFileTextField() {
        return fileTf_.getText();
    }

    public static void SetTextToFileTextField(String file) {
        fileTf_.setText(file);
    }

    private static JPanel CreateSourcePanel() {
        JPanel sourceP = new JPanel();
        sourceP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Source: "));
        sourceP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 3, 1);
        sourceP.add((Component)sourceRb_[0], gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        sourceP.add((Component)sourceRb_[1], gbc);
        GridBag.SetPosSize(gbc, 1, 1, 1, 1);
        sourceP.add((Component)fileTf_, gbc);
        GridBag.SetPosSize(gbc, 2, 1, 1, 1);
        sourceP.add((Component)selectB_, gbc);
        return sourceP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.add(okB_);
        buttonP.add(cancelB_);
        buttonP.add(resetB_);
        buttonP.add(defaultB_);
        return buttonP;
    }

    private void InitGuiControllers(LaFrame owner) {
        this.inputSourceDialogControl_ = new InputSourceDialogControl(owner);
        for (int i = 0; i < SOURCE_SIZE; ++i) {
            sourceRb_[i].addActionListener(this.inputSourceDialogControl_);
        }
        selectB_.setActionCommand(B_SET);
        okB_.setActionCommand(B_OK);
        cancelB_.setActionCommand(B_CANCEL);
        resetB_.setActionCommand(B_RESET);
        defaultB_.setActionCommand(B_DEFAULT);
        selectB_.addActionListener(this.inputSourceDialogControl_);
        okB_.addActionListener(this.inputSourceDialogControl_);
        cancelB_.addActionListener(this.inputSourceDialogControl_);
        resetB_.addActionListener(this.inputSourceDialogControl_);
        defaultB_.addActionListener(this.inputSourceDialogControl_);
    }

    static {
        InputSourceDialog.sourceRb_[0] = new JRadioButton(RB_SCREEN);
        InputSourceDialog.sourceRb_[1] = new JRadioButton(RB_FILE);
        sourceRb_[0].setSelected(true);
        for (int i = 0; i < SOURCE_SIZE; ++i) {
            sourceBGroup_.add(sourceRb_[i]);
        }
    }
}

