/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Db;

import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class DbBase {
    private static Hashtable<Character, String> escapeCharacters_ = new Hashtable();

    public static Connection OpenConnection(Configuration config) throws SQLException {
        String driverName = DbBase.GetDbDriverFromConfig(config);
        String url = DbBase.GetDbUrlFromConfig(config);
        Connection conn = null;
        DbBase.LoadDbDriver(driverName);
        String userName = DbBase.GetDbUserNameFromConfig(config);
        String password = DbBase.GetDbPasswordFromConfig(config);
        conn = DriverManager.getConnection(url, userName, password);
        return conn;
    }

    public static Connection OpenConnection(String driverName, String url, String userName, String password) throws SQLException {
        Connection conn = null;
        DbBase.LoadDbDriver(driverName);
        conn = DriverManager.getConnection(url, userName, password);
        return conn;
    }

    public static void CloseConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public static void CloseConnection(Connection conn, Configuration config) throws SQLException {
        String dbStr = config.GetConfiguration("DB_TYPE");
        if (dbStr.equals("JAVADB")) {
            String connUrl = DbBase.GetDbUrlFromConfig(config);
            DbBase.ShutDownJavaDb(connUrl);
        }
        conn.close();
    }

    public static String FormatSqlStr(String inStr) {
        String newStr = DbBase.Replace(inStr, "'", "''");
        return newStr;
    }

    public static String ToSqlStr(String in) {
        String out = in;
        for (int curIndex = in.length() - 1; curIndex >= 0; --curIndex) {
            Character curChar = new Character(in.charAt(curIndex));
            if (!escapeCharacters_.containsKey(curChar)) continue;
            String before = out.substring(0, curIndex);
            String after = out.substring(curIndex + 1);
            String current = escapeCharacters_.get(curChar);
            out = before + current + after;
        }
        return out;
    }

    static void SubmitDML(String query, Configuration config) {
        Connection conn = null;
        String driverName = DbBase.GetDbDriverFromConfig(config);
        DbBase.LoadDbDriver(driverName);
        try {
            String url = DbBase.GetDbUrlFromConfig(config);
            String userName = DbBase.GetDbUserNameFromConfig(config);
            String password = DbBase.GetDbPasswordFromConfig(config);
            conn = DriverManager.getConnection(url, userName, password);
            Statement statement = conn.createStatement();
            statement.executeQuery(query);
            statement.close();
            conn.close();
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    System.err.println("SQLException: " + ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static void ShutDownJavaDb(String connUrl) {
        boolean suceessfulShutDown;
        block3: {
            suceessfulShutDown = false;
            try {
                DriverManager.getConnection(connUrl + ";shutdown=true");
            }
            catch (SQLException se) {
                if (!se.getSQLState().equals("XJ015") && !se.getSQLState().equals("08006")) break block3;
                suceessfulShutDown = true;
            }
        }
        if (!suceessfulShutDown) {
            System.err.println("JavaDb Database did not shut down normally");
        }
    }

    private static void LoadDbDriver(String driverName) {
        try {
            Class.forName(driverName).newInstance();
        }
        catch (Exception e) {
            System.err.println("** Error: Unable to load driver(" + driverName + ").");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static String GetDbUserNameFromConfig(Configuration config) {
        String userName = config.GetConfiguration("DB_USERNAME");
        return userName;
    }

    private static String GetDbPasswordFromConfig(Configuration config) {
        String password = config.GetConfiguration("DB_PASSWORD");
        return password;
    }

    private static String GetDbDriverFromConfig(Configuration config) {
        String driverName = config.GetConfiguration("DB_DRIVER");
        return driverName;
    }

    private static String GetDbUrlFromConfig(Configuration config) {
        String dbStr = config.GetConfiguration("DB_TYPE");
        String url = null;
        if (dbStr.equals("JAVADB")) {
            String laDir = config.GetConfiguration("LA_DIR");
            String dbHome = laDir + "/data/JavaDb/";
            String dbTemp = dbHome + "temp/laTemp";
            String dbLog = dbHome + "temp/laLog.LOG";
            Properties p = System.getProperties();
            p.put("derby.system.home", dbHome);
            p.put("derby.storage.tempDirectory", dbTemp);
            p.put("derby.stream.error.file", dbLog);
            url = "jdbc:derby:" + config.GetConfiguration("DB_NAME");
        } else if (dbStr.equals("HSQLDB")) {
            url = "jdbc:hsqldb:" + config.GetConfiguration("LA_DIR") + "data/HSqlDb/" + config.GetConfiguration("DB_NAME");
        } else if (dbStr.equals("JAVADB_SERVER")) {
            String dbHost = config.GetConfiguration("DB_HOST");
            String dbPortNum = config.GetConfiguration("DB_PORT_NUM");
            String dbName = config.GetConfiguration("DB_NAME");
            String userName = config.GetConfiguration("DB_USERNAME");
            String passwd = config.GetConfiguration("DB_PASSWORD");
            url = "jdbc:derby://" + dbHost + ":" + dbPortNum + "/" + dbName + ";user=" + userName + ";password=" + passwd;
        } else if (dbStr.equals("MYSQL")) {
            url = "jdbc:mysql://" + config.GetConfiguration("DB_HOST") + "/" + config.GetConfiguration("DB_NAME");
        } else if (dbStr.equals("OTHER")) {
            url = config.GetConfiguration("JDBC_URL");
        }
        return url;
    }

    private static String Replace(String source, String oldString, String newString) {
        int curIndex = 0;
        int lastIndex = 0;
        String target = source;
        curIndex = source.indexOf(oldString);
        while (curIndex > -1) {
            String before = source.substring(0, curIndex);
            String after = source.substring(curIndex + oldString.length(), source.length());
            source = target = before + newString + after;
            lastIndex = curIndex + newString.length();
            curIndex = source.indexOf(oldString, lastIndex);
        }
        return target;
    }

    static {
        char c = '\r';
        escapeCharacters_.put(new Character(c), "\\\r");
        c = '\"';
        escapeCharacters_.put(new Character(c), "\\\"");
        c = '\'';
        escapeCharacters_.put(new Character(c), "\\'");
        c = '\t';
        escapeCharacters_.put(new Character(c), "\t");
        c = '\\';
        escapeCharacters_.put(new Character(c), "\\\\");
    }
}

