/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.weather;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.weather.WeatherProvider;
import java.util.Arrays;

public class NaturalWeatherProvider
implements WeatherProvider {
    private static final PeriodicCurve[] RAIN_CURVES = new PeriodicCurve[]{new PeriodicCurve(0.0, 48.0, 100.0, 1.0)};

    @Override
    public boolean isRainingAtHours(double timeHours) {
        return NaturalWeatherProvider.getHumidityAtHours(timeHours) > 0.0;
    }

    @Override
    public FlexibleHeatUnit getAirTemperatureAt(Noun noun, Frame frame) {
        return FlexibleHeatUnit.createNeutral();
    }

    private static double getHumidityAtHours(double timeHours) {
        return Arrays.stream(RAIN_CURVES).mapToDouble(curve -> curve.getValue(timeHours)).sum();
    }

    private static class PeriodicCurve {
        private final double xOffset;
        private final double waveLength;
        private final double offset;
        private final double scale;

        private PeriodicCurve(double xOffset, double waveLength, double offset, double scale) {
            this.xOffset = xOffset;
            this.waveLength = waveLength;
            this.offset = offset;
            this.scale = scale;
        }

        public double getValue(double x) {
            return PeriodicCurve.getPeriodicCurve(x, this.xOffset, this.waveLength, this.offset, this.scale);
        }

        private static double getPeriodicCurve(double x, double xOffset, double waveLength, double offset, double scale) {
            return (Math.sin(xOffset + x * Math.PI / waveLength) + offset) * scale;
        }
    }
}

