/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.plains;

import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.RoomFactory;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.plains.Plains;

public class Rooms
extends Plains {
    private final RoomFactory roomFactory;

    public Rooms(Simulation simulation) {
        super(simulation);
        this.roomFactory = new RoomFactory(simulation);
    }

    public Noun startRoom() {
        Noun floor = this.prairieGrassFloor();
        Noun room = this.roomFactory.roomWithFloor("the open prairie", "A sea of dry, shoulder-high, prairie grass surrounds you.", "the wind blows across the prairie", "The constant prairie wind rustles the grass, brushing it up against you in waves.", floor);
        return room;
    }

    private Noun prairieGrassFloor() {
        SimpleNoun floor = new SimpleNounAutoBuilder().setDescription("A sea of dry, shoulder-high, prairie grass surrounds you.", "prairie grass", "grasses", "prairie", "prairies", "plain", "plains").visibleInDark().build();
        this.setTakeHandler(floor, new TakeHandler(){

            @Override
            public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
                return true;
            }

            @Override
            public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
                return new Dsl(simulation).plains().plants().prairieGrass();
            }
        });
        return floor;
    }
}

