/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.crater;

import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.RoomFactory;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.structure.RequireCapabilityPassageFilter;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.world.dsl.crater.Crater;

public class Rooms
extends Crater {
    private final RoomFactory roomFactory;

    public Rooms(Simulation simulation) {
        super(simulation);
        this.roomFactory = new RoomFactory(simulation);
    }

    public Noun craterCenter() {
        Noun ground = this.craterCenterGround();
        Noun room = this.roomFactory.roomWithFloor("the crater center", "A meter-wide knot of molten flerovium-298, originally the core of a meteor, solidified here at the center of the impact crater eons go.  The twisted, shiny depression is reminiscent of jam baked into a cookie. Of course, jam is not nearly so important to the future of physics.", "the unobstructed desert wind", "Fine sand crunches under foot occasionally whipping up to sting your face when the wind blows.", ground);
        return room;
    }

    private Noun craterCenterGround() {
        Noun obj = this.groundSand();
        this.setTakeHandler(obj, new TakeSandEndlessly());
        Noun fleroviumCore = this.fleroviumCore();
        this.put(fleroviumCore, Prepositions.in, obj);
        this.makeIntegral(fleroviumCore);
        return obj;
    }

    private Noun fleroviumCore() {
        SimpleNoun obj = SimpleNoun.auto("A meter-wide knot of molten flerovium-298, originally the core of a meteor, solidified here at the center of the impact crater.  ", "a meter-wide knot of molten flerovium-298", "flerovium-298", "a twisted shiny depression", "depressions", "a meter-wide knot of molten flerovium", "felvorium", "a core of a meteor", "metors", "core", "cores");
        this.makeUntakeable(obj, "This core of flerovium-298 is a cubic meter of metal weighing ~15 tons.  Even if you could pry it free from the earth you aren't strong enough to pick it up.");
        Noun entrance = this.makeEntrance((Noun)obj, Prepositions.in);
        this.setPassageFilter(entrance, new RequireCapabilityPassageFilter(ResourceCapabilities.FLEROVIUM));
        return obj;
    }

    private Noun groundSand() {
        SimpleNoun obj = SimpleNoun.auto("A patch of nondescript desert sand.", "endless desert sand", "sands", new String[0]);
        this.setTakeHandler(obj, new TakeSandEndlessly());
        return obj;
    }

    private final class TakeSandEndlessly
    implements TakeHandler {
        private TakeSandEndlessly() {
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            return Rooms.this.resources().sand();
        }
    }
}

