/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.crafts;

import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounMatchingSingularAndPlural;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithAlternatePlural;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithPrepositionalPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import java.util.List;
import java.util.stream.Collectors;

public class Clothes
extends Dsl {
    public Clothes(Simulation simulation) {
        super(simulation);
    }

    public Noun hat() {
        return this.hat(null, null);
    }

    public Noun hat(AdjectivePhrase adjective, List<Noun> resources) {
        Noun obj = this.createSimpleOneResourceNoun("hat", "hats", adjective, resources, true);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        this.makeWearable(obj, WearableCategory.HEADWEAR);
        this.makeProvidePartialShade(obj, 0.8);
        this.makeInsulatingClothing(obj, resources, WearableCategory.HEADWEAR);
        return obj;
    }

    public Noun bra() {
        return this.bra(null, null);
    }

    public Noun bra(AdjectivePhrase adjective, List<Noun> resources) {
        Noun obj = this.createSimpleOneResourceNoun("bra", "bras", adjective, resources, true);
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.makeWearable(obj, WearableCategory.TORSO);
        return obj;
    }

    public Noun belt() {
        return this.belt(null, null);
    }

    public Noun belt(AdjectivePhrase adjective, List<Noun> resources) {
        Noun obj = this.createSimpleOneResourceNoun("belt", "belts", adjective, resources, true);
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.makeWearable(obj, WearableCategory.BELT);
        return obj;
    }

    public Noun khakiShorts() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("A pair of beat up khaki shorts.  They're pretty much your uniform these days.", "a pair of khaki shorts", "shorts", new String[0]).build();
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        this.makeWearable(obj, WearableCategory.PANTS);
        this.addResourceCapability(obj, ResourceCapabilities.TINDER_MATERIAL);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_FABRIC_MATERIAL);
        this.setTemperatureFilter(obj, FlexibleHeatUnit.createFlexible(-0.5, 0.5));
        this.makeInsulatingPartialClothing((Noun)obj, WearableCategory.PANTS, 0.5, FlexibleHeatUnit.create(0.0, 1.0, -0.5));
        return obj;
    }

    public Noun mat() {
        return this.mat(null, null);
    }

    public Noun mat(AdjectivePhrase adjective, List<Noun> resources) {
        boolean includeMaterialInShortDescription = adjective == null;
        Noun obj = this.createSimpleOneResourceNoun("mat", "mats", adjective, resources, includeMaterialInShortDescription);
        this.setEncumbrance(obj, Encumbrances.LIGHT_AND_LONG);
        return obj;
    }

    public Noun prototypeWovenMaterial() {
        return this.wovenMaterial(null, null);
    }

    public Noun wovenMaterial(AdjectivePhrase adjective, List<Noun> resources) {
        SimpleNoun obj;
        String _adjective_;
        String string = _adjective_ = adjective == null ? " " : " " + adjective.toString() + " ";
        if (resources == null) {
            obj = new SimpleNounAutoBuilder().setDescription("A woven material.", "a woven material", "materials", new String[0]).build();
        } else {
            String materialDescription = resources.get(0).getContextFreeDescription().toString();
            String verboseDescription = "A" + _adjective_ + "patch of woven " + materialDescription + ".";
            NounPhrase singularDescription = Nlg.autoNounPhrase(_adjective_ + "woven " + materialDescription, "materials", "woven " + materialDescription + " material", "materials");
            NounPhrase pluralDescription = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(Nlg.autoNounPhrase("a" + _adjective_ + "patch", "patches", new String[0])).setPreposition(Prepositions.of).setObjectOfPreposition(Nlg.autoNounPhrase("woven " + materialDescription, materialDescription, new String[0])).setMatchAsObjectOfPreposition(false).build().as(Number.Plural);
            NounPhraseWithAlternatePlural description = new NounPhraseWithAlternatePlural(singularDescription, pluralDescription);
            obj = new SimpleNounAutoBuilder().setDescription(Nlg.literalSentences(verboseDescription), description).build();
        }
        this.setEncumbrance(obj, Encumbrances.LARGER_THAN_HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_FABRIC_MATERIAL);
        return obj;
    }

    public Noun prototypeCoat() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("A coat.", "a coat", "coats", new String[0]).build();
        return obj;
    }

    public Noun coat(AdjectivePhrase adjective, List<Noun> resources) {
        Noun obj = this.createSimpleOneResourceNoun("coat", "coats", adjective, resources, true);
        this.makeInsulatingClothing(obj, resources, WearableCategory.TORSO);
        this.setEncumbrance(obj, Encumbrances.LARGER_THAN_HAND_SIZED);
        return obj;
    }

    public Noun prototypePants() {
        return new NounMatchingSingularAndPlural(new SimpleNounAutoBuilder().setDescription("A pair of pants.", "a pair of pants", "pants", new String[0]).build());
    }

    public Noun pants(AdjectivePhrase adjective, List<Noun> resources) {
        Noun obj = this.createSimpleOneResourceNoun("pair of pants", "pants", adjective, resources, true);
        this.setEncumbrance(obj, Encumbrances.LARGER_THAN_HAND_SIZED);
        this.makeInsulatingClothing(obj, resources, WearableCategory.PANTS);
        return obj;
    }

    public Noun createSimpleOneResourceNoun(String nounName, String nounNamePlural, AdjectivePhrase adjective, List<Noun> resources, boolean includeMaterialInShortDescription) {
        SimpleNoun obj;
        String _adjective_;
        String string = _adjective_ = adjective == null ? " " : " " + adjective.toString() + " ";
        if (resources == null) {
            obj = new SimpleNounAutoBuilder().setDescription("A simple " + nounName + ".", "a " + nounName, nounNamePlural, new String[0]).build();
        } else {
            NounPhrase materialDescription = resources.get(0).getContextFreeDescription();
            String verboseDescription = "A" + _adjective_ + nounName + " made of " + materialDescription + ".";
            String autoString = includeMaterialInShortDescription ? "a" + _adjective_ + materialDescription + " " + nounName : "a" + _adjective_ + nounName;
            obj = new SimpleNounAutoBuilder().setDescription(verboseDescription, autoString, nounNamePlural, new String[0]).build();
        }
        return obj;
    }

    private FlexibleHeatUnit getInsulationFromUnitAndCategory(FlexibleHeatUnit unit, WearableCategory category) {
        double multiplier = 0.0;
        switch (category) {
            case HEADWEAR: {
                multiplier = 0.15;
                break;
            }
            case GLOVES: {
                multiplier = 0.1;
                break;
            }
            case TORSO: {
                multiplier = 0.3;
                break;
            }
            case PANTS: {
                multiplier = 0.3;
                break;
            }
            case SHOES: {
                multiplier = 0.15;
            }
        }
        return unit.times(multiplier);
    }

    private void makeInsulatingClothing(Noun obj, List<Noun> resources, WearableCategory category) {
        this.makeInsulatingPartialClothing(obj, resources, category, 1.0);
    }

    private void makeInsulatingPartialClothing(Noun obj, List<Noun> resources, WearableCategory category, double fraction) {
        Frame frame = this.simulation.getCurrentFrame();
        if (resources == null || resources.isEmpty()) {
            return;
        }
        Noun coatMaterialNoun = resources.get(0);
        List fabricInsulations = ResourceState.getSatisfyingInstances(coatMaterialNoun, ResourceCapabilities.FABRIC_MATERIAL, frame).stream().map(fabric -> fabric.getInsulationUnit()).collect(Collectors.toList());
        FlexibleHeatUnit minInsulationUnit = null;
        for (FlexibleHeatUnit insulation : fabricInsulations) {
            if (minInsulationUnit == null) {
                minInsulationUnit = insulation;
                continue;
            }
            minInsulationUnit = minInsulationUnit.combineNeutrally(insulation);
        }
        if (minInsulationUnit == null) {
            return;
        }
        this.makeInsulatingPartialClothing(obj, category, fraction, minInsulationUnit);
    }

    private void makeInsulatingPartialClothing(Noun obj, WearableCategory category, double fraction, FlexibleHeatUnit insulationUnit) {
        FlexibleHeatUnit insulation = this.getInsulationFromUnitAndCategory(insulationUnit, category).times(fraction);
        this.setTemperatureFilter(obj, insulation);
        this.makeWearable(obj, category);
    }
}

