/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.beach;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.events.position.PlayerLooksInDirectionEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.AbstractDelegatingNoun;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.states.goability.DefaultGoHandler;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.takeable.DefaultTakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.DelayedUpdateable;
import com.fabriziopolo.textcraft.states.updatable.NotifyAwakePlayerUpdateable;
import com.fabriziopolo.textcraft.states.updatable.OnceOnlyUpdateable;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import com.fabriziopolo.textcraft.states.updatable.Updateables;
import com.fabriziopolo.timecraft.alphaisland.commands.CreditsCommand;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;
import com.fabriziopolo.timecraft.world.map.alpha.AlphaMapPopulator;
import com.fabriziopolo.timecraft.world.map.alpha.AlphaWorldMapBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class Story
extends Beach {
    public static final boolean INCLUDE_CHEATS = false;
    public static final int EXPLOSION_EVENT_DAY = 1;
    public static final int EXPLOSION_EVENT_HOUR = 2;
    public static final int BIRD_EVENT_DAY = 2;
    public static final int TRILOBITE_EVENT_DAY = 3;
    public static final int TRILOBITE_EVENT_HOUR = 1;
    public static final int MUSHROOM_START_DAY = 4;
    public static final int GIANT_MUSHROOM_DAY = 6;
    public static final int DEBRIS_WAHSHUP_DAY = 5;
    public static final int STORM_START_DAY = 5;
    public static final int STORM_START_HOUR = 18;
    public static final int STORM_END_DAY = 6;
    public static final int STORM_END_HOUR = 6;
    public static final int ORANGE_ARRIVAL_DAY = 6;
    public static final int WIN_GAME_DAY = 6;
    public static final int LAST_DAY = 6;
    private final SimpleNoun babyMushroomDelegate = SimpleNoun.autoBuilder().setDescription("An adorable black mushroom about four inches tall.", "a small black mushroom", "mushrooms", new String[0]).build();
    private final SimpleNoun mediumMushroomDelegate = SimpleNoun.autoBuilder().setDescription("An impressive black mushroom about 18 inches in height.  The complex vein structure under the cap is a rather flat grey at first glance, but after staring at it for second a patchy variation of low-saturation hues emerges.", "a large black mushroom", "mushrooms", new String[0]).build();
    private final SimpleNoun giantMushroomDelegate = SimpleNoun.autoBuilder().setDescription("An imposing black mushroom towering over 6 feet tall.  The musty smelling veins are painted in a wild patchwork of pastels.", "a tree-sized black mushroom", "mushrooms", new String[0]).setDarkDescription("The musty smell of this giant mushroom is more notable than it's dark silhouette.", "a giant musty mushroom outline", "outlines", "mushroom", "mushrooms").build();

    public Story(Simulation simulation) {
        super(simulation);
    }

    public int getTimeLapseEventHourSinceDay0() {
        return 26;
    }

    public void createTimedEvents(Player player, AlphaMapPopulator mapPopulator) {
        this.createIntroEvents(player);
        this.createPlotWeatherEvents(player);
        this.createPlotGeoffAndChronocalcEvents(player);
        this.createPlotExplosionEvents(player);
        this.createPlotBirdEvents(player);
        this.createPlotPreOxygenAtmosphereEvents(player);
        this.createPlotDebrisWashupEvents(player);
        this.createPlotFriendPickupEvents(player);
        this.createStarRealignmentEvents(player);
    }

    private void createIntroEvents(Player player) {
        String prefaceText = "A billion years before reckless mammals poisoned the air, long before dense vegetation grew up and eventually fossilized into the mechanism of their downfall, the atmosphere was very different.  Carbon dioxide turned the sky rich orange.  Sunlight and CO2 fed photosynthetic organsims, which produced oxygen, transforming the planet and paving the way for an inland invasion of giant mushrooms.";
        String introductionText = "Your mouth got you into this.  In college you always claimed you could pull it off.  You've been bragging about your survival skills for years, but somehow no one ever made you prove it.  Last winter, after too many drinks with your old roommates the subject came up again.  They pooled $500 that says you can't survive for seven days on Alpha Island with no equipment.  So here you are, standing on a beach at 6am under wet dreary clouds putting a plan together.\n\nThere is no way you're going to lose to those jokers.  The money will be nice, but the best part will be seeing how annoyed Geoff will be when he has to pay out.  He pitched $300 of it himself!  We get it dude, you're making good money at your new gig.  Chrono... computo... bullshit... some name you can never remember.  We're allll impressed.\n\nWhatever.  You have way bigger problems to worry about right now.  To the east, your friend's mainland-bound motorboat has been reduced to a speck.  They will be back in seven days to pick you up.  For the laughs, they wanted to drop you off with no clothes.  To be fair, you did originally claim you could do it naked.  You talked them down to a pair of shorts for the sake of dignity and, a cell phone so you can call them and give up if you have to.  But that's not going to happen.\n\nThe day will only get hotter.  Priority one is crafting some shelter.  You won't last very long in the sun.";
        this.createUpdateable((noun, simulation) -> {
            Frame frame = simulation.getCurrentFrame();
            if (AwakeState.get(frame).isAwake(player).booleanValue()) {
                PlayerNotificationEvent.postAlwaysPerceivable(player, prefaceText, simulation);
                simulation.postEvent(PlayerNotificationEvent.builder().setPlayer(player).setAlwaysPerceivable(true).setMessage(prefaceText).setStyle(Event.Style.PROMINENT_PAGE).build());
                PlayerNotificationEvent.postPressEnterToContinue(player, simulation);
                simulation.postEvent(PlayerNotificationEvent.builder().setPlayer(player).setAlwaysPerceivable(true).setMessage(introductionText).setStyle(Event.Style.PROMINENT_PAGE).build());
                PlayerNotificationEvent.postPressEnterToContinue(player, simulation);
                PlayerNotificationEvent.postAlwaysPerceivable(player, StringUtils.repeat("\n", 50), simulation);
                this.createArrivalEvent(player);
                UpdateableState.requestRemoveUpdateable(noun, simulation);
            }
        });
    }

    private void createPlotWeatherEvents(Noun player) {
        this.createTimedMessageDeferIfSleeping(player, 1, 7, 0, "There isn't a cloud in the sky and the intense sun is already becoming uncomfortable.  Today is going to be hot.  Staying hydrated will be a challenge if it doesn't rain, but shelter will help.");
        this.createTimedMessageDeferIfSleeping(player, 2, 7, 0, "For the third day in a row the sun beats down relentlessly with no intervening clouds for protection.  ");
        this.createTimedMessageDeferIfSleeping(player, 3, 7, 0, "The weather has cooled off significantly since yesterday.  Today should be much more comfortable.  There is a little cloud cover and a breeze.  Hopefully it will stay pleasant and mild all week.");
        this.createTimedMessageDeferIfSleeping(player, 4, 7, 0, "Today is even colder than yesterday, which means tonight is going to be dangerous.  Hypothermia kills.  You need to build a fire to keep warm or it's going to be a rough night.");
        this.createTimedMessageDeferIfSleeping(player, 4, 9, 0, "A bitter wind is slowly building from the west.  The ocean waves have become tall and choppy.");
        this.createTimedMessageDeferIfSleeping(player, 4, 16, 0, "The whipping wind builds the ocean waves taller than you've seen all week, crashing hard against southern and western beaches of Alpha Island, bringing random bits of detritus with them.");
        this.createTimedMessageDeferIfSleeping(player, 5, 7, 0, "The cold weather trend has continued.  Even worse, dark rain clouds are blowing in from the west.  Ordinarily you'd look forward to rain as a source of fresh water but in this case the danger of hypothermia is very real.  You'd better collect as much fuel as you can and build a fire before the storm hits.");
        this.createTimedMessageDeferIfSleeping(player, 5, 12, 0, "The storm developing in the west looks worse than you expected.  No rain yet but the dark clouds are fast approaching.  They cover most of the sky and the wind has picked up.");
        this.createTimedMessageOnlyIfAwake(player, 5, 17, 0, "The wind blows hard across the ocean pushing huge black storm clouds.  They are now nearly overhead.  You are jealous of the birds flying east toward the mainland for shelter.  Tonight is going be interesting.");
        this.createTimedMessageOnlyIfAwake(player, 5, 18, 5, "The storm is not shy to demonstrate its strength.  The wind blows the freezing rain horizontally into stinging bullets.");
        int numStormHours = 12;
        int hoursBetweenGenericStormMessageRepeat = 2;
        for (int hour = 0; hour < numStormHours - 1; hour += hoursBetweenGenericStormMessageRepeat) {
            this.createTimedMessageOnlyIfAwake(player, 5, 18 + hour, 5, "Intense ocean storm winds blow freezing rain horizontally.");
        }
        this.createTimedMessageOnlyIfAwake(player, 6, 5, 15, "Thankfully the storm is beginning to abate.  The rain feels slightly warmer although that may be an illusion caused by the slowing of the wind.  Grey doom to the west is slowly giving way to orange doom.");
        this.createTimedMessageOnlyIfAwake(player, 6, 6, 15, "To your great relief the storm appears to be running its course.  It's still a bit cold but at least the rain is over and the wind has mostly abated.");
        this.createTimedMessageDeferIfSleeping(player, 6, 7, 15, "A front of warm air pushes the storm away to the east.  Your digits are still numb from the previous few days but the pride of having survived the worst this island has to offer makes that discomfort seem distant and irrelevant.");
    }

    private void createPlotGeoffAndChronocalcEvents(Player player) {
        this.createTimedMessageDeferIfSleeping(player, 0, 13, 0, "Chronocalc.  That's it.  That was the name of that lab Geoff works for.  You always get it confused and think it involves compute-something.  Weird how memory works: you fail to remember something and then hours later it comes to mind unbidden.\n\nThe details of their research dominated conversation the last time the crew got together.  You didn't follow too much of it, partly because you were drunk and partly because you probably wouldn't have understood it anyway being the only non-scientist in the group.  But they're nice people and broke it down for you pretty well.\n\nThe basic idea was actually really cool.  They're trying to build supercomputers with what they called \"chronological micro-offset\".  Some physicists discovered a phenomenon where they can peek into the future on a quantum scale.\n\nThe crazy layman's questions were unending when Geoff first explained this.  \"Can I bring back my dead grandmother?\", \"Will creepy-Steve ever get married?\", \"Will Cheryl Junker be reelected to a second presidential term in 2036?\".  Unfortunately, as explained in detail, nothing quite so exciting is possible.  According to \"Dr. Geoffrey\" (god that guy is getting smug as he gets older) this technology is nowhere near sci-fi imaginings.  It's more like a microscope that lets you look a few microseconds into the future of a few atoms.\n\nHmm.  What is that good for again?  What does that have to do with computers?  It's all pretty hazy now.  You'll have to ask him again next time you see him.");
        this.createTimedMessageDeferIfSleeping(player, 1, 13, 0, "Alcohol-soaked memories are beginning to come back to you.\n\nChronocalc is trying to use this chronological micro-offset trick to make fast computers.  They bought a few of the first generation research offset machines built by some physicists.  Chinese physicists maybe?  The thought is hazy but China sounds familiar.\n\nIt took you a while to get the concept the way they explained it to you, but in retrospect it's pretty simple.  You think about it this way: make a computer that fits in a tiny time bubble, run a program, distort time and cheat to see the answer before it happens.  They all objected to the term \"time bubble\" but, whatever, they're scientists.  Nitpickers.  It makes sense to you.\n\nGeoff was saying they're literally trying to compute 2 + 2 and get 4 as their first milestone. No joke.  Apparently they hadn't quite gotten it working yet.  This led to lots of great jokes about how Geoff is bad at math.  No idea how that guy can be such a successful scientist and be so bad at mental arithmetic, but he really is terrible.  Don't let him calculate the tip.  He'll accidentally stiff the waiter and embarrass you.");
    }

    private void createPlotExplosionEvents(Player player) {
        ZonedDateTime day0 = TimeState.getDay0(this.simulation.getCurrentFrame());
        ZonedDateTime timeLapseTime = day0.plusHours(this.getTimeLapseEventHourSinceDay0());
        this.createUpdateable(new DelayedUpdateable(timeLapseTime.toInstant(), (noun, simulation1) -> {
            WaitState.requestStopWaiting(player, simulation1);
            AwakeState.requestAwake(player, Nlg.literalClause("there is a massive explosion"), simulation1);
            UpdateableState.requestRemoveUpdateable(noun, simulation1);
        }));
        this.createUpdateable(new DelayedUpdateable(timeLapseTime.plusMinutes(5L).toInstant(), new OnceOnlyUpdateable((noun, simulation1) -> PlayerNotificationEvent.postProminent(player, simulation1, "An intense throb of white light saturates your vision and decays into a purple tint.  It's hard to tell if the purple is an after-effect of your own eyes or an actual phenomenon.  For a moment you think you've been hit by lightning, but a resounding boom arrives seconds later proving ground zero is some distance away.\n\nYou look east in the direction of the thunder to see the last of a plume of purple fire dissipating into the air hundreds of meters over the mainland.  Yours eyes slowly readapt to the darkness."))));
        this.createUpdateable(new DelayedUpdateable(timeLapseTime.plusMinutes(15L).toInstant(), new OnceOnlyUpdateable((noun, simulation1) -> PlayerLooksInDirectionEvent.post(Directions.get((Frame)simulation1.getCurrentFrame()).east, player, simulation1))));
        this.createTimedMessageDeferIfSleeping(player, 1, 4, 0, "Concern for your friends on the mainland distracts you from your immediate survival challenges.  From here it's hard to tell exactly where the explosion was relative to human-centric landmarks.  To be sure it was north of Chronocalc's main lab.  That area isn't really populated, which is somewhat reassuring.  ");
    }

    private void createPlotBirdEvents(Noun player) {
        this.createTimedMessageDeferIfSleeping(player, 2, 13, 0, "The ocean wind blows constantly.  Not in huffs and puffs but like a current, with everything living thing subtly fighting to maintain its position.  To the East, two large birds circle.  Their flight pattern is unfamiliar to you.  At a glance it's buzzard-like but these birds make larger, slower circles.  Maybe you're overthinking it.  It's hard to tell how far away they are making it difficult judge scale.");
        this.createTimedMessageDeferIfSleeping(player, 2, 15, 0, "The birds to the East have changed their behavior.  They're now diving, probably fishing for something.  The two take turns rapidly gaining altitude using free energy from the wind, and then rocketing down fully submerging themselves for a few seconds before returning to the surface and taking off again.  Definitely not buzzards.");
        this.createTimedMessageDeferIfSleeping(player, 2, 16, 0, "It's hard to tell if the birds are catching anything.  They're much closer than they were an hour ago and yet still so distant and inscrutable.  You would expect to have seen a fish by now.");
        this.createTimedMessageDeferIfSleeping(player, 2, 19, 0, "The birds are quite far away now.  It looks like they're flying East toward the mainland, presumably done fishing for the day.");
    }

    private void createPlotPreOxygenAtmosphereEvents(Noun player) {
        this.createTimedMessageDeferIfSleeping(player, 1, 9, 0, "You can't help but notice that the western sky is taking on a strangely orange cast.");
        this.createTimedMessageDeferIfSleeping(player, 2, 9, 0, "Is the western sky more orange than it was yesterday?  It's hard to say.  It certainly looks odd though.");
        this.createTimedMessageDeferIfSleeping(player, 3, 9, 0, "Relative to the position of the sun in the east, the western sky glows an entirely unjustified shade of orange.  ");
        this.createTimedMessageDeferIfSleeping(player, 3, 12, 20, "The sun is now overhead, and the orange western horizon doesn't seem to be affected at all.  The effect is too strange to ignore.  ");
        this.createTimedMessageDeferIfSleeping(player, 3, 19, 20, "As the sun sets it's lost behind illuminated tangerine haze.");
        this.createTimedMessageDeferIfSleeping(player, 4, 7, 0, "A vibrant spectrum of oranges reaches half way across the sky.  Where it meets blue the colors blend smoothly but the clouds are irregular and confused as if by the shearing force of a perpendicular wind.");
        this.createTimedMessageDeferIfSleeping(player, 5, 9, 0, "Foreboding as they may be, what is hidden behind the black storm clouds to the west is almost more concerning to you.  The air smells vaguely sulfurous in a way it did not even an hour ago.  You disingenuously try to frame it to yourself as a question: \"Does the smell have anything to do with the strange sky?\"\n\nYou were never good at playing dumb.");
        this.createTimedMessageDeferIfSleeping(player, 5, 14, 0, "Yuck.  The air stinks.  When you were younger your family would take vacations to visit your uncle in western Kansas.  Processing beets into sugar was the main industry of the town.  In the Spring and Summer the smokestacks would spew some noxious sugary-rotten concoction into the air.  The wind blew it into town drowning unaccustomed senses in the stink.  Then, the wind would shift and instantly the town would smell almost normal.  Overwhelming as it was, that beet processing plant was no match for a storm of this caliber.  The funk would have been rapidly diffused by gale force winds.\n\nBack then there was nowhere to run.  Here at least you could conceivably swim east.  Of course, you're not about to swim back yet.  You have a bet to win.");
        this.createTimedMessageDeferIfSleeping(player, 5, 18, 0, "Breathing the air is disgusting.  You'd do nearly anything for normal oxygen again.  What does it take to get east to avoid orange funk?  The mainland is a long ways to swim.  It's not impossibly far but you'd want to feel tip-top before you try it.  You certainly wouldn't be the first person to drown trying it.  Of course a lot of them were drunk.");
        this.createTimedMessageDeferIfSleeping(player, 6, 9, 0, "The wind shifts and the everpresent stink becomes painful without warning.  Breathing in burns and a dizzy headache follows, presumably causaly.");
        this.createTimedUpdateable(player, 6, 9, 5, (noun, simulation) -> CharacterBioEffect.dayTimeScaleBuilder(simulation).addEnergy(-0.01).build().apply(simulation, player, Nlg.literalClause("you breathe the poisonous atmosphere")));
        this.createTimedMessageDeferIfSleeping(player, 7, 9, 0, "The atmosphere has changed from unpleasant to unbearable.  You become seriousy concerned that continuing to breathe it will shorten your life expectancy.  Everything hurts.  Chain smoking cheap cigars would me more tolerable.");
        this.createTimedUpdateable(player, 7, 9, 0, (noun, simulation) -> CharacterBioEffect.dayTimeScaleBuilder(simulation).addEnergy(-0.5).addHealth(-1.5).addHydration(-0.5).build().apply(simulation, player, Nlg.literalClause("you breathe the poisonous atmosphere")));
    }

    private void createPlotFriendPickupEvents(Noun player) {
        this.createTimedMessageDeferIfSleeping(player, 4, 10, 0, "You keep thinking... just two more days to survive before your friends pick you up.");
        this.createTimedMessageDeferIfSleeping(player, 5, 10, 0, "Thank god this is the last day.  Just make it through today and your friends will pick you up.  They said they were coming at sunrise but knowing them it'll probably be a few hours afterward.");
        this.createTimedMessageDeferIfSleeping(player, 5, 18, 0, "Tonight is the last night.  You've made it this far.  One more night can't be that hard.  Geoff is going to be so annoyed with you for winning this bet.  Sure, he can afford the $300, but after so much trash talk his pride won't be able to take the hit.");
        this.createMessageIfNotSwimmingHome(player, 6, 6, 15, "Here we go!  Any minute now Geoff and the crew will show up.  There's no sign of his boat to the east but that doesn't mean much.  He's usually a little late and it's a fast boat.  You can't keep the smug smile from your face.  When you talk shit you deliver.  Pay up suckers!");
        this.createMessageIfNotSwimmingHome(player, 6, 7, 15, "No boat, no Geoff, no surprise.  Sunrise is over.  They'd better get here soon, you don't want to breathe this nasty air for one more second.");
        this.createMessageIfNotSwimmingHome(player, 6, 9, 15, "Ok guys.  Come on!  This is horrible.  You've tried to be patient with the escalating bizareness, but this nasty sulphurous air is the final straw.  If they don't come soon you're seriously considering swimming for the mainland.  It's a long way, but it's not impossible if your energy is up.");
        this.createMessageIfNotSwimmingHome(player, 6, 11, 15, "Your patience is running short.  It's nearly noon and no sign of the boat.  Your lungs burn from breathing putrid air and the optimism you had this morning about escaping is slowly replaced with nagging questions about trilobites, mushrooms, and orange skies.  If things had gone smoothly this week you'd just shake it off.  But thins have not gone smoothly.  On the contrary they're only getting stranger.  Get me out of here you jackasses!");
        this.createMessageIfNotSwimmingHome(player, 6, 13, 15, "Friendly time is over.  Panic is setting in.  \"DON'T PANIC\" echoes in your mind.  Something you read in a guide somewhere.  If you don't get out of here you might not make it at all.  The mountainous mainland to the east looks more inviting with every painful breath.  You'll have to swim.");
        this.createMessageIfNotSwimmingHome(player, 6, 15, 15, "Panic escalates.  You cannot breathe another second here.  You must swim west to avoid the atmosphere.  You've survived long enough.  You've proven your point.  It's time to go home.");
        String finalPromptToSwimHome = "What are you still doing here?  You won't live another day in this environment.  You have to swim east to the mainland to avoid the noxious atmosphere.";
        for (int hour = 16; hour < 39; ++hour) {
            this.createMessageIfNotSwimmingHome(player, 6, hour, 15, finalPromptToSwimHome);
        }
    }

    private void createPlotDebrisWashupEvents(Noun player) {
        this.createTimedUpdateable(player, 5, 0, 0, new OnceOnlyUpdateable((noun, simulation) -> {
            Frame frame = simulation.getCurrentFrame();
            CoordinateState coordinates = CoordinateState.get(frame);
            PositionState positionState = PositionState.get(frame);
            Dsl dsl = new Dsl(simulation);
            Noun roomA3 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX(), AlphaWorldMapBuilder.getSouthBeachY());
            Noun roomB3 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 1, AlphaWorldMapBuilder.getSouthBeachY());
            Noun roomC3 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 2, AlphaWorldMapBuilder.getSouthBeachY());
            Noun roomD3 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 3, AlphaWorldMapBuilder.getSouthBeachY());
            Noun roomE3 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 4, AlphaWorldMapBuilder.getSouthBeachY());
            Noun roomB4 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 1, AlphaWorldMapBuilder.getSouthBeachY() + 1);
            Noun roomC4 = coordinates.getRoomAt(AlphaWorldMapBuilder.getWestBeachX() + 2, AlphaWorldMapBuilder.getSouthBeachY() + 1);
            dsl.putInRoom(dsl.beach().resources().plasticBag("brown"), roomA3);
            dsl.putInRoom(dsl.beach().resources().driftwood(), roomA3);
            dsl.putInRoom(dsl.beach().resources().sixPackRings(), roomB3);
            dsl.putInRoom(dsl.beach().resources().sixPackRings(), roomB3);
            dsl.putInRoom(dsl.beach().tools().plasticBottle(), roomC3);
            dsl.putInRoom(dsl.beach().resources().plasticBag("clear"), roomD3);
            dsl.putInRoom(dsl.beach().resources().chunkOfRottenChipboard(), roomD3);
            dsl.putInRoom(dsl.beach().resources().chunkOfRottenChipboard(), roomD3);
            dsl.putInRoom(dsl.beach().resources().pieceOfStyrofoam(), roomE3);
            dsl.putInRoom(dsl.beach().resources().plasticBag("clear"), roomB4);
            dsl.putInRoom(dsl.beach().resources().pieceOfStyrofoam(), roomB4);
            dsl.putInRoom(dsl.beach().tools().plasticBottle(), roomB4);
            dsl.putInRoom(dsl.beach().tools().can(), roomC4);
            dsl.putInRoom(dsl.beach().resources().tangledFishingLine(), roomC4);
            dsl.putInRoom(dsl.beach().resources().sixPackRings(), roomC4);
        }));
        this.createTimedUpdateable(player, 5, 0, 0, (noun, simulation) -> {
            boolean isInReeds;
            Frame frame = simulation.getCurrentFrame();
            if (!AwakeState.get(frame).isAwake(player).booleanValue()) {
                return;
            }
            if (SunState.isNight(frame)) {
                return;
            }
            Coordinates playerCoord = CoordinateState.get(player, frame);
            boolean isOnSouthernBeach = playerCoord.y == (double)AlphaWorldMapBuilder.getSouthBeachY() && playerCoord.x >= (double)AlphaWorldMapBuilder.getWestBeachX() && playerCoord.x <= (double)AlphaWorldMapBuilder.getEastBeachX();
            boolean bl = isInReeds = playerCoord.y == (double)(AlphaWorldMapBuilder.getSouthBeachY() + 1) && playerCoord.x >= (double)(AlphaWorldMapBuilder.getWestBeachX() + 1) && playerCoord.x <= (double)(AlphaWorldMapBuilder.getWestBeachX() + 2);
            if (!isOnSouthernBeach && !isInReeds) {
                return;
            }
            simulation.postEvent(PlayerNotificationEvent.builder().setStyle(Event.Style.PROMINENT).setAlwaysPerceivable(true).setPlayer(player).setMessage("The previously pristine beach is now filthy.  Strong wind and high waves have washed up all sorts of random debris along the southern shore.  Tiny shreds of black seaweed cover the sand and some larger pieces of trash have also been stranded by the tide.").build());
            UpdateableState.requestRemoveUpdateable(noun, simulation);
        });
    }

    private void createStarRealignmentEvents(final Noun player) {
        this.createUpdateable(new Updateable(){
            int completedStage = -1;
            Instant lastCompletedStageTime = null;

            @Override
            public void update(Noun noun, Simulation simulation) {
                Frame frame = simulation.getCurrentFrame();
                Instant now = TimeState.getGameTimeInstant(frame);
                int day = TimeState.getDaySinceDay0(frame);
                int hour = TimeState.getHourOfDaySinceDay0(frame);
                int minute = TimeState.getMinuteOfDaySinceDay0(frame);
                if (!SunState.isPitchBlack(frame) || !AwakeState.get(frame).isAwake(player).booleanValue()) {
                    return;
                }
                if (this.lastCompletedStageTime == null) {
                    this.lastCompletedStageTime = now;
                }
                switch (this.completedStage) {
                    case -1: {
                        if (this.lastCompletedStageTime.plus(Duration.ofMinutes(30L)).isBefore(now) && (day < 1 || day > 1 || hour < 1 || hour > 3)) {
                            PlayerNotificationEvent.postProminent(player, simulation, "Looking up at the stars you find Ursa Major and trace the line between the two stars forming the end of \"The Big Dipper\" to find Polaris.  You learned that trick probably 30 years ago and you've been doing it habitually ever since.  It's not particularly useful but the value for you is nostalgic.  The memory of your father teaching you while camping in the Rocky mountains is still vivid.");
                            this.lastCompletedStageTime = now;
                            ++this.completedStage;
                        }
                        return;
                    }
                    case 0: {
                        if (day != 1 || hour <= 2 || !this.lastCompletedStageTime.plus(Duration.ofHours(4L)).isBefore(now)) break;
                        PlayerNotificationEvent.postProminent(player, simulation, "Again, you follow the line of Ursa Major in search of the pole star.  Polaris isn't quite where you expected.  You try again, and again you miss.  There is a star quite close and it must be the right one, but the geometry is off.  ");
                        this.lastCompletedStageTime = now;
                        ++this.completedStage;
                        break;
                    }
                    case 1: {
                        if (day != 1 || hour <= 3 || !this.lastCompletedStageTime.plus(Duration.ofHours(1L)).isBefore(now)) break;
                        PlayerNotificationEvent.postProminent(player, simulation, "Looking back at the odd sky, you search for an explanation for the misplaced star.  Your original observations were a bit off.  It's not just that Polaris is in the wrong spot.  Ursa Major itself doesn't have the right proportions.  It looks a little skewed.\n\nWhether the pole star has moved or whether the constellation no longer points at it is unclear.  Either or both could be true.  Either or both would be bizarre.");
                        this.lastCompletedStageTime = now;
                        ++this.completedStage;
                        break;
                    }
                    case 2: {
                        if (day != 2 || !this.lastCompletedStageTime.plus(Duration.ofHours(2L)).isBefore(now)) break;
                        PlayerNotificationEvent.postProminent(player, simulation, "The constellations are now totally unrecognizeable.  The stars that once formed Ursa Major are still identifiable by brightness and location but the shape is gone.  The distinctive rectangle is barely convex.  With no method to find it, whatever star you once thought was Polaris is lost among others of similar brightness.  Orion is still almost as it was but the distinctive three star belt no longer holds a straight line.");
                        this.lastCompletedStageTime = now;
                        ++this.completedStage;
                        break;
                    }
                    case 3: {
                        if (day != 3 || !this.lastCompletedStageTime.plus(Duration.ofHours(2L)).isBefore(now)) break;
                        PlayerNotificationEvent.postProminent(player, simulation, "A fairly regular zigzag pattern is beginning to emerge in a cluster of stars.  Three of them are  bright and evenly spaced.  Another three are dimmer stars, but their positions work out just right to make little sawteeth.  Below that is a triangle with another brighter star in the center.\n\nI guess every three stars makes a triangle, but still, it kind of looks like a face with spikey hair.  You've definitely never seen this arrangement before.  The sawteeth are too distinctive.  You would have remembered them.  You decide to call it \"Bart\".\n\nOn second thought, \"Lisa\" is a good name too and rolls off the tongue a little better.  Cool!  Your own constellation.  You laugh to yourself: undoubtedly generations will look up at the night sky and admire constellation Lisa.  The humor is somewhat spoiled by fear for the future of this bizarre changing world.");
                        this.lastCompletedStageTime = now;
                        ++this.completedStage;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
    }

    public List<Noun> createTrilobites(int numTrilobites) {
        final ArrayList<Noun> trilobites = new ArrayList<Noun>();
        for (int i = 0; i < numTrilobites; ++i) {
            Noun trilobite = this.trilobiteWithoutStoryLogic();
            trilobites.add(trilobite);
            this.setTakeHandler(trilobite, new TakeHandler(){

                @Override
                public void handleTake(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
                    PlayerNotificationEvent.postAlwaysPerceivable(player, "In an instant, your mind is scrambled by precognitive terror.\n\nThe trilobite fossil recoils, arching its back the moment your finger touches it's armor.  A fraction of a second later its legs explosively launch it into action, scrambling it across the sand at speed.  Once in the clear water it rockets away, faster, and disappears into bright reflections between patches of foamy surf.\n\nWhat is going on?\n\nYou think through every giant arachnid you've ever heard of, every crab, every crustacean.  Nothing fits", simulation);
                    trilobites.forEach(partialState::disconnect);
                    String secondThoughtAboutTrilobite = "You haven't stopped thinking about the \"fossil\".\n\nIt was definitely a live trilobite.";
                    Frame frame = simulation.getCurrentFrame();
                    Instant now = TimeState.get(frame).getGameTimeInstant();
                    UpdateableState.requestCreateUpdateable(simulation, new DelayedUpdateable(now.plus(Duration.ofHours(2L)), (noun, simulation1) -> {
                        if (AwakeState.get(simulation1.getCurrentFrame()).isAwake(player).booleanValue()) {
                            PlayerNotificationEvent.postAlwaysPerceivable(player, secondThoughtAboutTrilobite, Event.Style.PROMINENT, simulation1);
                            UpdateableState.requestRemoveUpdateable(noun, simulation1);
                        }
                    }));
                }
            });
        }
        return trilobites;
    }

    private Noun trilobiteWithoutStoryLogic() {
        return new SimpleNounAutoBuilder().setDescription("You've never seen a fossil this well preserved before.  It looks vaguely like a horsheoe crab but the pleated armor bands covering the whole body make it clear it's something different entirely.\n\nIt's a trilobite.\n\nIt's large like a horseshoe crab but viscerally disgusting like a silverfish.  At nearly 12 inches this thing is a truly nasty looking creature.  The way it's laying on its stomach, completely uncovered, shiny and wet from the ocean surf, it looks so alive.  ", "a shiny fossil", "fossils", "a shiny trilobite fossil", "fossils", "a shiny trilobite", "trilobites").build();
    }

    public Noun cellPhone() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("It's a Samsung Galaxy X12.  What an awful device.  You wrapped it up to keep it from getting wet.  But honestly, you'd be just as happy thowing this piece of bloat-ware ridden junk into the ocean.", "a cell phone", "phones", "a Samsung Glaxy X12 cell phone", "phones").build();
        this.setUse(obj, (object, context) -> {
            ArrayList<UserAction> uses = new ArrayList<UserAction>();
            uses.add(new CallFriendsAndGiveUp(context));
            uses.add(new DontGiveUp(context));
            return uses;
        });
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        return obj;
    }

    public Noun mushroom() {
        AbstractDelegatingNoun noun = new AbstractDelegatingNoun(){

            @Override
            protected Noun getDelegate(Noun object, PerceptionChannel channel, Frame frame) {
                SimpleNoun mushroom;
                if (frame == null) {
                    return Story.this.babyMushroomDelegate;
                }
                int day = TimeState.getDaySinceDay0(frame);
                day = Math.max(4, Math.min(6, day));
                switch (day) {
                    case 4: {
                        mushroom = Story.this.babyMushroomDelegate;
                        break;
                    }
                    case 5: {
                        mushroom = Story.this.mediumMushroomDelegate;
                        break;
                    }
                    case 6: {
                        mushroom = Story.this.giantMushroomDelegate;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return mushroom;
            }
        };
        this.setProminent(noun, (noun1, args, frame1) -> TimeState.getDaySinceDay0(frame1) >= 6);
        this.setTakeHandler(noun, new MushroomTakeHandler());
        return noun;
    }

    public static void launchEndGameSequence(Noun player, Simulation simulation) {
        String arriveOnBeachMessage = "With the last of your strength you pull yourself onto the beach.\n\nAs you rub the salt water from your eyes you realize there's much more going on here than was visible from your low angle among the tall waves.  Just beyond the first row of dunes where the vegetation begins you see an older man, 50s maybe, about 20 feet up a fig tree.  He's standing on a sturdy limb and doesn't appear to be in any danger of falling but is clearly panicking, looking at the ground with fear.  He must be desperate to have climbed all the way up there in a lab coat and leather dress shoes.\n\nThe situation is a bit odd and, at first, you think it would be wise to hang back and watch for a bit.  But, maybe he needs help.  As he wheels around wildly, looking at the ground all around him, you see the Y-shaped Chronocalc Labs emblem on the back of his coat.  You were always convinced it was an homage to the \"Flux Capacitor\" but Geoff insists it isn't, presumably for legal reasons.  Anyway, it's probably some coworker of his. After the ordeal you just survived, a crazy scientist in a tree is the least of your concerns.  You proceed up the beach.\n\nAs you climb the dunes the man finally notices you.  He looks up from his fixation on the ground and you lock eyes.   It IS Geoff.  His hair is far too grey and he's gained about thirty pounds since you saw him a week ago.  He appears easily 20 years older but it is unmistakably Geoff.\n\nHis eyes widen comically as he recognizes you, prior fears temporarily taking a backseat to surprise.  He closes his mouth and then begins to open it again as if to speak but instead just mouths your name.  \"Shannon?\".  You break the silence: \"Geoff?!\"  He shakes his head vigorously, puts his finger to his lips and points down.";
        String toBeContinuedMessage = "Cresting the first row of dunes you're finally able to see the source of his fear.  Beneath him, circling the tree is a pack of five sleek, scaled, bipedal creatures that cannot be mistaken.  Dinosaurs, a little under a meter tall and covered in purple and yellow stripes, strut bird-like, their heads shift back and forth in rhythm with their steps to maintain balance.  Ten year old you would know the species immediately but that wealth of apparently not-so-useless information faded a long time ago.  Tiny Tyranosaur will do.  Occasionally they make half-hearted attempts to scramble up the tree.  Given their oversized, hooked claws, you assume they could easily climb the tree if they ran out of patience.\n\nCalling out was a bad idea.  One looks your direction and shortly the others follow its cue.  They stand tall on their hind legs and co-orient, staring at you like murderous prairie dogs.   After a silent moment they move in sync.  Two return their attention to Geoff and the other three crouch down and begin to stalk, fanning out, slowly eliminating your escape options in all directions but toward the ocean.\n\nTO BE CONTINUED...\n";
        String inTheSequelMessage = "Expect a sequel \"TextCraft II: Time Lapse\".\n\nTo be notified of updates send an email to textcraft@fabriziopolo.com.\n";
        simulation.postEvent(PlayerNotificationEvent.builder().setMessage(arriveOnBeachMessage).setPlayer(player).setStyle(Event.Style.PROMINENT_PAGE).setAlwaysPerceivable(true).build());
        PlayerNotificationEvent.postPressEnterToContinue(player, simulation);
        simulation.postEvent(PlayerNotificationEvent.builder().setMessage(toBeContinuedMessage).setPlayer(player).setAlwaysPerceivable(true).setStyle(Event.Style.PROMINENT_PAGE).build());
        PlayerNotificationEvent.postPressEnterToContinue(player, simulation);
        simulation.postEvent(PlayerNotificationEvent.builder().setMessage(inTheSequelMessage).setPlayer(player).setAlwaysPerceivable(true).setStyle(Event.Style.PROMINENT_PAGE).build());
        PlayerNotificationEvent.postPressEnterToContinue(player, simulation);
        EndGameState.requestEndGamePage(simulation, CreditsCommand.getCredits());
    }

    private void createTimedUpdateable(Noun player, int day, int hour, int minute, Updateable updateable) {
        ZonedDateTime day0 = TimeState.getDay0(this.simulation.getCurrentFrame());
        this.setUpdateable(new EmptyNoun(), new DelayedUpdateable(day0.plusDays(day).plusHours(hour).plusMinutes(minute).toInstant(), updateable));
    }

    private void createTimedMessageDeferIfSleeping(Noun player, int day, int hour, int minute, String message) {
        this.createTimedUpdateable(player, day, hour, minute, new NotifyAwakePlayerUpdateable(player, message, true));
    }

    private void createTimedMessageOnlyIfAwake(Noun player, int day, int hour, int minute, String message) {
        this.createTimedUpdateable(player, day, hour, minute, new NotifyAwakePlayerUpdateable(player, message, false));
    }

    private void createMessageIfNotSwimmingHome(Noun player, int day, int hour, int minute, String message) {
        this.createTimedUpdateable(player, day, hour, minute, (noun, simulation) -> {
            Frame frame = simulation.getCurrentFrame();
            if (AwakeState.get(frame).isAwake(player).booleanValue() && !AlphaWorldMapBuilder.isEastOfIsland(CoordinateState.get(player, frame))) {
                PlayerNotificationEvent.postProminent(player, simulation, message);
            }
            UpdateableState.requestRemoveUpdateable(noun, simulation);
        });
    }

    public boolean isAfterTimeLapseEvent() {
        int timeLapseHours = this.getTimeLapseEventHourSinceDay0();
        double currentHours = TimeState.getGameTimeElapsedHoursSinceDay0(this.simulation.getCurrentFrame());
        return currentHours >= (double)timeLapseHours;
    }

    private void createArrivalEvent(Player player) {
        PlayerExaminesSurroundingsEvent.post(player, this.directions().east, this.simulation);
        PlayerNotificationEvent.post((Noun)player, this.simulation, "\nType 'help' for help, 'wiki' to launch the wiki, or 'menu' to visit the main menu.\n");
    }

    static final class EndGameRoomGoHandler
    extends DefaultGoHandler {
        EndGameRoomGoHandler() {
        }

        @Override
        public void handleGo(Noun goer, SpacialRelationship spacialRelationship, SpacialRelationship reverseSpacialRelationship, Simulation simulation, PositionStateBuilder partialState, Noun place) {
            Frame frame = simulation.getCurrentFrame();
            int dayNumber = TimeState.getDaySinceDay0(frame);
            if (dayNumber < 6) {
                String dayNumberLoseMessage = "";
                switch (dayNumber) {
                    case 0: {
                        dayNumberLoseMessage = "You didn't even make it one full day on Alpha Island before giving up and swimming home.  Pathetic.";
                        break;
                    }
                    case 1: {
                        dayNumberLoseMessage = "You gave up on day 2 and swam home.  Pitiful.";
                        break;
                    }
                    case 2: {
                        dayNumberLoseMessage = "After two easy days you gave up on day 3 and swam home.  Unimpressive.";
                        break;
                    }
                    case 3: {
                        dayNumberLoseMessage = "After three days you gave up on day 4 and swam home.";
                        break;
                    }
                    case 4: {
                        dayNumberLoseMessage = "After four challenging days you gave up on day 5 and swam home.  Good effort.";
                        break;
                    }
                    case 5: {
                        dayNumberLoseMessage = "After five difficult days you gave up on day 6 and swam home.  So close.  You just had to survive one more day to win.";
                    }
                }
                String loseMessage = "You stagger out of the water and lie down on the beach, exhausted.  " + dayNumberLoseMessage + "  Your friends will mock you mercilessly.\n" + "\n" + "You lose.";
                EndGameState.requestEndGame(simulation, loseMessage);
                return;
            }
            Story.launchEndGameSequence(goer, simulation);
        }
    }

    private static final class MushroomTakeHandler
    extends DefaultTakeHandler {
        private MushroomTakeHandler() {
        }

        @Override
        public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
            int day = TimeState.getDaySinceDay0(frame);
            if (day == 6) {
                return false;
            }
            return super.isProducible(player, nounToTake, tool, frame);
        }

        @Override
        public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            Frame frame = simulation.getCurrentFrame();
            int day = TimeState.getDaySinceDay0(frame);
            if (day == 6) {
                PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(player.getPerceptionOf(nounToTake, simulation.getCurrentFrame())) + ".  " + "It is too large.");
                this.launchAllMushroomTouchEffects(player, simulation);
                return;
            }
            super.isProducible(player, nounToTake, tool, frame);
        }

        @Override
        public void doProduce(Player player, Noun originalNounToTake, List<Noun> producedNouns, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            this.launchAllMushroomTouchEffects(player, simulation);
            super.doProduce(player, originalNounToTake, producedNouns, tool, simulation, partialState);
        }

        private void launchAllMushroomTouchEffects(Player player, Simulation simulation) {
            Updateables.createOneTimeDelayed(simulation, Duration.ofMinutes(10L), (noun, simulation2) -> {
                PlayerNotificationEvent.post((Noun)player, simulation2, "Your hand is beginning to turn red where you touched the mushroom.  It looks like an alergic reaction.");
                this.poisonPlayer(player, simulation2);
            });
        }

        private void poisonPlayer(Player player, Simulation simulation) {
            Updateables.create(simulation, (noun, simulation1) -> CharacterBioEffect.dayTimeScaleBuilder(simulation1).addHealth(-2.0).build().apply(simulation1, player, Nlg.literalClause("you touched the black mushroom")));
        }
    }

    private static final class DontGiveUp
    implements UserAction {
        private final Command.Context context;

        private DontGiveUp(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to put the phone away, check your gonadal fortitude, and get back to the business of surviving on this sandy rock";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerNotificationEvent.post(this.context, "That's what I thought.");
        }
    }

    private static final class CallFriendsAndGiveUp
    implements UserAction {
        private final Command.Context context;

        private CallFriendsAndGiveUp(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            Story story = new Dsl(this.context.simulation).beach().story();
            if (story.isAfterTimeLapseEvent()) {
                return "to call your friends and make sure they're safe after the explosion on the mainland";
            }
            return "to give up like a coward and call your friends to rescue you";
        }

        @Override
        public void execute(TextAppController controller) {
            Story story = new Dsl(this.context.simulation).beach().story();
            if (story.isAfterTimeLapseEvent()) {
                PlayerNotificationEvent.post(this.context, "You turn on the cell phone.  After taking too long to boot it fails to find a signal.  You waive it around in the air to no avail.  The battery is fully charged.  Very weird considering you tested it when you first stepped off the boat and the signal was strong.  Despite being a very, very long swim, the mainland is close enough to get good reception.\n\nWas a cell tower damaged by the explosion?  Maybe there is a power outage.  Cell phone or no, you can certainly survive for seven days.  When Geoff and them show up I'm sure they'll explain what's going on.");
                return;
            }
            EndGameState.requestEndGame(this.context.simulation, "You turn on the cell phone.  After taking too long to boot it finds a signal.  Navigating through your contacts you stumble across your ex-girlfriend Cindy.  Her family had a boat.  Maybe she could come get you.\n\nWow you've really become soft.  Not only are you bailing on the bet but you're considering doing it on the sly?  Lame.  You mentally slap yourself, continue to Geoff's number, and press call.\n\nHe answers laughing.  \"So, how's it going out there?  Need a ride buddy?\"  His smirk is audible.  You'll never live this down.\n\nYou lose.\n");
        }
    }
}

