/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.tools.liquidcontainer;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.timecraft.capabilities.ToolCapabilities;
import java.util.List;
import java.util.Set;

public class LiquidTakeHandler
implements TakeHandler {
    @Override
    public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
        if (!ToolState.toolSatisfiesCapability(tool, ToolCapabilities.LIQUID_CONTAINER, frame)) {
            return false;
        }
        return this.isContainerEmpty(player, nounToTake, tool, frame);
    }

    @Override
    public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        if (tool == null || !ToolState.toolSatisfiesCapability(tool, ToolCapabilities.LIQUID_CONTAINER, frame)) {
            PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(nounToTake.getDefaultPerception(simulation.getCurrentFrame())) + " " + "without a container.");
        } else {
            Noun content = this.getContainerContentRepresentative(player, nounToTake, tool, frame);
            PlayerNotificationEvent.post((Noun)player, simulation, "Your " + tool.getContextFreeDescription() + " is already full of " + content.getDefaultPerception(frame) + ".");
        }
    }

    @Override
    public void consume(Player player, List<Noun> nounsToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        for (Noun nounToTake : nounsToTake) {
            PositionState.requestPut(nounToTake, Prepositions.in, null, tool, simulation);
            PlayerNotificationEvent.post((Noun)player, simulation, "You take " + NounPhraseWithArticle.the(nounToTake.getDefaultPerception(frame)) + " with " + NounPhraseWithArticle.the(tool.getDefaultPerception(frame)));
        }
    }

    private boolean isContainerEmpty(Player player, Noun nounToTake, Noun tool, Frame frame) {
        return null == this.getContainerContentRepresentative(player, nounToTake, tool, frame);
    }

    private Noun getContainerContentRepresentative(Player player, Noun nounToTake, Noun tool, Frame frame) {
        Set<Noun> children = PositionState.get(frame).getChildren(tool);
        if (children == null) {
            return null;
        }
        for (Noun noun : children) {
            if (StructureState.get(frame).isIntegral(noun)) continue;
            return noun;
        }
        return null;
    }
}

