/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.capabilities;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.sun.SunState;
import java.util.Objects;

public class SunlightCapability
implements Capability {
    private final Capability delegate;
    private final double brightnessThreshold;

    public SunlightCapability(Capability delegate, double brightnessThreshold) {
        this.delegate = Objects.requireNonNull(delegate);
        this.brightnessThreshold = brightnessThreshold;
    }

    @Override
    public Capability.Result isSatisfiedBy(Noun noun, Capability tool, Frame frame) {
        Capability.Result satisfiedBy = this.delegate.isSatisfiedBy(noun, tool, frame);
        if (!satisfiedBy.isSatisfied) {
            return satisfiedBy;
        }
        if (SunState.get(frame).getIntensityAt(noun, frame) < this.brightnessThreshold) {
            return Capability.Result.createFailure("there isn't enough sunlight");
        }
        return satisfiedBy;
    }

    @Override
    public String getNounDescription() {
        return this.delegate.getNounDescription();
    }
}

